/*
 *  linux/init/main.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 *
 *  GK 2/5/95  -  Changed to support mounting root fs via NFS
 *  Added initrd & change_root: Werner Almesberger & Hans Lermen, Feb '96
 *  Moan early if gcc is old, avoiding bogus kernels - Paul Gortmaker, May '96
 *  Simplified starting of init:  Michael A. Griffith <grif@acm.org>
 */

#include "/source/RAGE/Current/src/linux/arch/parisc/kernel/constants.h"
#include "/source/RAGE/Current/src/linux/arch/parisc/kernel/declares.h"

#define __KERNEL_SYSCALLS__


#include <asm/system.h>
#define __KERNEL_SYSCALLS__

#include <linux/config.h>
#include <linux/proc_fs.h>
#include <linux/unistd.h>
#include <linux/ctype.h>
#include <linux/delay.h>
#include <linux/utsname.h>
#include <linux/ioport.h>
#include <linux/init.h>
#include <linux/smp_lock.h>
#include <linux/blk.h>
#include <linux/hdreg.h>

#include <asm/io.h>
#include <asm/bugs.h>

#include <linux/kernel.h>
extern char kernel_name[];
extern char version[];

struct task_struct *child_reaper = &init_task;

static unsigned long memory_start = 0;
static unsigned long memory_end = 0;
extern void setup_arch(char **, unsigned long *, unsigned long *);

int root_mountflags = MS_RDONLY;

void init_IRQ(void);
void time_init(void);
void sched_init(void);
static int init(void *);

/**************************************************/
/* RAGE Alteration:                               */
/* For loops_per_sec we know the target machines  */
/* we are interested in, have interval timers that*/
/* count at the processor frequency. So loops_per_sec */
/* is simply the 10msec pg zero value multiplied by */
/* a 1000. If the interval timer does not have a one */
/* to one relationship with the instruction rate, */
/* then, we will need to alter the loops_per_sec value */
/* start_kernel will initialize this value */
/**************************************************/
unsigned long loops_per_sec;

void start_kernel(void)
{
	char * command_line;
	unsigned int *pg0_ptr = (unsigned int *)0x38C;

	loops_per_sec = (unsigned long)(*pg0_ptr * 1000);

#ifdef __SMP__
        static int boot_cpu = 1;
        /* "current" has been set up, we need to load it now */
        if (!boot_cpu)
                initialize_secondary();
        boot_cpu = 0;
#endif

	/*** print kernel name & version ***/
        printk(kernel_name);
        printk(version);
	
	setup_arch(&command_line, &memory_start, &memory_end);
	printk("memory_start is -> %08x\n",memory_start);
	printk("memory_end is -> %09x\n",memory_end);
	sched_init();
	memory_start = paging_init(memory_start,memory_end);
        /* trap_init() not used for PA */
	init_IRQ();
	//sched_init();
        time_init();
	/* cause_eir_0(); */
	/* parse_options(command_line); */

	/*
	 * HACK ALERT! This is early. We're enabling the console before
	 * we've done PCI setups etc, and console_init() must be aware of
	 * this. But we do want output early, in case something goes wrong.
	 */
	/* memory_start = console_init(memory_start,memory_end); */
#ifdef OUT_ORG_LINUX
#ifdef CONFIG_MODULES
	init_modules();
#endif
#endif /*OUT_ORG_LINUX*/

	printk("(2) memory_start is -> %08x\n",memory_start);
	printk("(2) memory_end is -> %09x\n",memory_end);
	memory_start = kmem_cache_init(memory_start, memory_end);
	sti();
	printk("(3) memory_start is -> %08x\n",memory_start);
	printk("(3) memory_end is -> %09x\n",memory_end);

	mem_init(memory_start,memory_end);
	kmem_cache_sizes_init();
	uidcache_init();
	filescache_init();
	dcache_init();
	vma_init();
	buffer_init(memory_end-memory_start);
	signals_init();
	inode_init();
	file_table_init();
#if defined(CONFIG_SYSVIPC)
	ipc_init();
#endif
	
	kernel_thread(init, NULL, CLONE_FS | CLONE_FILES | CLONE_SIGHAND);
	current->need_resched = 1;
	cpu_idle();

}

/*******************************************************/
/* root_dev_setup                                      */
/*                                                     */
/* We have chosen to hard code our root device to 0x100*/
/*******************************************************/
static void __init root_dev_setup(void)
{
	ROOT_DEV = 0x100;
}


/*
 * Ok, the machine is now initialized. None of the devices
 * have been touched yet, but the CPU subsystem is up and
 * running, and memory and process management works.
 *
 * Now we can finally start doing some real work..
 */
static void __init do_basic_setup(void)
{
	char *buf;
        int fd;
        int retVal, i;
        /*
	 * Tell the world that we're going to be the grim
	 * reaper of innocent orphaned children.
	 *
	 * We don't want people to have to make incorrect
	 * assumptions about where in the task array this
	 * can be found.
	 */
	 child_reaper = current;

        printk("In do_basic_setup():setting up devices\n");
	/* Set up devices .. */
	device_setup();

	/* .. executable formats .. */
	printk("\nSeting up formats\n");
	binfmt_setup();

        printk("In do_basic_setup():setting up file system\n");
	 /* .. filesystems .. */
	filesystem_setup();

        printk("In do_basic_setup():setting up mount root\n");
	/* Mount the root filesystem.. */
	mount_root();


#ifdef OUT
        /* Test code to check if open works */
        fd = sys_open("/TESTFILE",O_RDONLY,0);
        printk("ISL open returned %d\n",fd);

	buf = kmalloc(1024, GFP_KERNEL);
        while ( ( retVal = sys_read(fd, buf, 100) ) != 0 )
        {
           printk("\nSys read returned %d\n",retVal);
           for(i=0; i<retVal; i++)
           {
              printk("%c",buf[i]);
           }
        }
        sys_close(fd);
        kfree(buf);
#endif /*OUT*/
       printk("\nAbout to run executable..............\n");
       execve("/TESTAPP",0,0);
        
}


static int init(void * unused)
{
        printk("In init()\n");
	root_dev_setup();

	lock_kernel();
	do_basic_setup();

	unlock_kernel();
}
