#ifndef STI_H_INCLUDED
#define STI_H_INCLUDED

#define STI_REGIONS 8
#define STI_NAMELEN 32

/*
 * Device region information.
 */
struct sti_region {
	u_int	offset  :14,
		sysonly :1,
                cache   :1,
	        btlb    :1,
                last    :1,
	        length  :14;
};

/*
 * Global configuration information. There is one per STI device.
 */
struct sti_config {
	int	text_planes;
	short	dwidth;
	short	dheight;
	short   owidth;
	short	oheight;
	short   fbwidth;
	short	fbheight;
	int     regions[STI_REGIONS];
	int	reentry_level;
	int	save_address;
	int	*future;
};

/*
 * per-STI device structure.
 */
struct sti_entries {
	void (*init_graph)(void*, void*, void*, struct sti_config*);
	void (*state_mgmt)(void*, void*, void*, struct sti_config*);
	void (*font_unpmv)(void*, void*, void*, struct sti_config*);
	void (*block_move)(void*, void*, void*, struct sti_config*);
	void (*self_test)(void*, void*, void*, struct sti_config*);
	void (*excep_hdlr)(void*, void*, void*, struct sti_config*);
	void (*inq_conf)(void*, void*, void*, struct sti_config*);
	void (*last)(void*, void*, void*, struct sti_config*); /* ?? */
};


#define WORDWISE_FLAG 3

/* ID bei s700, bytes: 0x13,0x17,0x1b,0x1f lt. nglescreen.c */
struct sti_wordwide {
	u_int	sti_devtype;	/* 0x00: device type (see below) */
	u_int	sti_revno;	/* 0x04: global ROM revision */
	u_int	sti_gid_hi;	/* 0x08: graphics ID (high word) */
	u_int	sti_gid_lo;	/* 0x0c: graphics ID (low byte) */
	u_int	sti_fontaddr;	/* 0x10: font start address */
	u_int	sti_mss;	/* 0x14: max state storage */
	u_int	sti_erom;	/* 0x18: last address of ROM */
	u_int	sti_mmap;	/* 0x1c: memory map information */
	u_int	sti_mstore;	/* 0x20: max re-entrant storage */
	u_int	sti_mtimo;	/* 0x24: max 1/10 secs for routines */
#ifdef hp300
	char	sti_p0[0x58];
#else
	char	sti_p0[0x18];
#endif
	void	*sti_routine[8]; /* 0x40: 8 stck. routines */
};



/*
 * Device initialization structures.
 */
struct sti_initflags {	/* Initialization flags */
	u_int	wait           :1,
	        hardreset      :1,
		texton         :1, /* ignored if no_change_text == 1 */
		graphon        :1, /* ignored if no_change_graph == 1 */
		clear          :1,
		cmap_black     :1, /* ignored if hardreset == 0 */
		bus_error_timer:1, /* ignored if no_change_bet == 1 */
		bus_error_int  :1, /* ignored if no_change_bei == 1 */
		no_change_text :1,
		no_change_graph:1,
		no_change_bet  :1,
		no_change_bei  :1,
		init_text_cmap :1,
		pad	    :19;
	int	*future;
};

struct sti_initin {	/* Initialization input args */
	int	text_planes;
	int	*future;
};

struct sti_initout {	/* Initialization output args */
	int	errno;
	int	text_planes;
	int	*future;
};

struct sti_init_parms {		/* init */
	struct sti_initflags flags;
	struct sti_initin    inputs;
	struct sti_initout   outputs;
};

/*
 * Inquire Configuration.
 */
struct sti_inquireflags {
	u_int	wait :1;
	u_int	pad  :31;
	int	*future;
};

struct sti_inquirein {
	int	*future;
};

struct sti_inquireout {
	int	errno;
	short	dwidth;
	short	dheight;
	short   owidth;
	short	oheight;
	short   fbwidth;
	short	fbheight;
	int	bpp;
	int	bits;
	int	planes;
	char	devname[STI_NAMELEN];
	u_int	attributes;
	int	*future;
};

struct sti_inquire_parms {	/* inquire */
	struct sti_inquireflags flags;
	struct sti_inquirein    inputs;
	struct sti_inquireout   outputs;
};


/*
 * Font Unpack/Move.
 */
struct sti_fontflags {
	u_int	wait :1;
	u_int	pad  :31;
	int	*future;
};

struct sti_fontin {
	int	startaddr;
	short	index;
	char	fg_color;
	char	bg_color;
	short	dest_x;
	short	dest_y;
	int	*future;
};

struct sti_fontout {
	int	errno;
	int	*future;
};

/*
 * Block Move.
 */
struct sti_moveflags {
	u_int	wait  :1;
	u_int	color :1;
	u_int	clear :1;
	u_int	pad   :29;
	int	*future;
};

struct sti_movein {
	char	fg_color;
	char	bg_color;
	short	src_x;
	short	src_y;
	short	dest_x;
	short	dest_y;
	short	wwidth;
	short	wheight;
	int	*future;
};

struct sti_moveout {
	int	errno;
	int	*future;
};

struct sti_move_parms {		/* move */
	struct sti_moveflags flags;
	struct sti_movein    inputs;
	struct sti_moveout   outputs;
};


/*
 * Error codes returned by STI ROM routines.
 */
#define NO_ERROR		0
#define BAD_REENTRY_LEVEL	1
#define NO_REGIONS_DEFINED	2
#define ILLEGAL_NUMBER_PLANES	3
#define INVALID_FONT_INDEX	4
#define INVALID_FONT_LOCATION	5
#define INVALID_COLOR		6
#define INVALID_BLKMOVE_SRC	7
#define INVALID_BLKMOVE_DST	8
#define INVALID_BLKMOVE_SIZE	9
#define NO_BUS_ERROR_INT	10
#define BUS_ERROR		11
#define HARDWARE_FAILURE	12

#endif // STI_H_INCLUDED
