#ifndef _PARISC_PTRACE_H
#define _PARISC_PTRACE_H

/* written by Philipp Rumpf, Copyright (C) 1999 SuSE GmbH Nuernberg */

#include <linux/types.h>

/* Holds the regiseter state for PARISC PROCESSORS 2.0 */

struct pt_regs {
        unsigned long gr[32];   
        unsigned int sr[ 8];
        unsigned long ipsw;
        unsigned long iasq[2];
        unsigned long iaoq[2];
        unsigned long sar;  
        unsigned long cr24;
        unsigned long cr25;
        unsigned long cr26;
        unsigned long cr27;
        unsigned long cr28;
        unsigned long cr29;
        unsigned long cr30;
        unsigned long cr31;
        unsigned long ior;
        unsigned long isr;
	unsigned long iir;
	unsigned long ksp;
	unsigned long kpc;
        unsigned long cr_pid[ 4];
};

struct shdw_regs {
        unsigned long gr1;
        unsigned long gr8;
        unsigned long gr9;
        unsigned long gr16;
        unsigned long gr17;
        unsigned long gr24;
        unsigned long gr25;
        unsigned long temp;
};




/* Arbitrarily choose the same ptrace numbers as used by the Sparc code. */
#define PTRACE_GETREGS            12
#define PTRACE_SETREGS            13
#define PTRACE_GETFPREGS          14
#define PTRACE_SETFPREGS          15

#ifdef __KERNEL__

/* XXX should we use iaoq[1] or iaoq[0] ? */
#define user_mode(regs)			((regs)->iaoq[0] &  3)
#define instruction_pointer(regs)	((regs)->iaoq[0] & ~3)
extern void show_regs(struct pt_regs *);
#endif

#endif
