#ifndef _PARISC_HP_MACHINES_H_ 
#define _PARISC_HP_MACHINES_H_ 

struct hp_hardware {
   unsigned short hw_type:4;		/* HPHW_xxx */
   unsigned long  sversion:28;
   unsigned short hversion;
   char *name; 
};


#define HPHW_NPROC    0 
#define HPHW_MEMORY   1       
#define HPHW_BRIDGE   2
#define HPHW_IOA      3
#define HPHW_BCPORT   4
#define HPHW_A_DIRECT 5
#define HPHW_A_DMA    6
#define HPHW_B_DMA    7
#define HPHW_CONSOLE  8
#define HPHW_CIO      9

extern struct hp_hardware hp_hardware_list[];

extern char *hw_type_name[HPHW_CIO+1]; 		// HPHW_xxxxx

char *parisc_getHWtype(	unsigned short hw_type );

/* Attention: first hversion, then sversion...! */
char *parisc_getHWdescription(	unsigned short hw_type,
                                unsigned long hversion,  /* have to be long ! */
				unsigned long sversion );


#endif

