/*
 *  linux/include/asm-parisc/keyboard.h
 *
 *  Original by Geert Uytterhoeven
 *  updates by Alex deVries <adevries@thepuffingroup.com>
 *  portions copyright (1999) The Puffin Group
 */

/*
 *  This file contains the PARISC architecture specific keyboard definitions
 */

#ifndef _PARISC_KEYBOARD_H
#define _PARISC_KEYBOARD_H

#ifdef __KERNEL__

#define KEYBOARD_IRQ			1
#define DISABLE_KBD_DURING_INTERRUPTS	0

#define PARISC_KEYB_CONTROLLER_NONE 0 
#define PARISC_KEYB_CONTROLLER_LASI 1

extern int pckbd_setkeycode(unsigned int scancode, unsigned int keycode);
extern int pckbd_getkeycode(unsigned int scancode);
extern int pckbd_pretranslate(unsigned char scancode, char raw_mode);
extern int pckbd_translate(unsigned char scancode, unsigned char *keycode,
			   char raw_mode);
extern char pckbd_unexpected_up(unsigned char keycode);
extern void pckbd_leds(unsigned char leds);
extern unsigned char pckbd_sysrq_xlate[128];
extern void parisckbd_init_hw(void);

extern void parisckbd_request_region(void);
int (*parisckbd_request_irq)(void (*handler)(int, void *, struct pt_regs*));
unsigned char (*parisckbd_read_input)(void);
unsigned char (*parisckbd_read_status)(void);
void (*parisckbd_write_output)(unsigned char val);
void (*parisckbd_write_command)(unsigned char val);
char *(*parisckbd_test)(void);
char *(*parisckbd_reset)(void);

#define kbd_setkeycode		pckbd_setkeycode
#define kbd_getkeycode		pckbd_getkeycode
#define kbd_pretranslate	pckbd_pretranslate
#define kbd_translate		pckbd_translate
#define kbd_unexpected_up	pckbd_unexpected_up
#define kbd_leds		pckbd_leds
#define kbd_init_hw		parisckbd_init_hw
#define kbd_test		parisckbd_test
#define kbd_reset		parisckbd_reset
#define kbd_sysrq_xlate		pckbd_sysrq_xlate

/* resource allocation */
#define kbd_request_region() 	parisckbd_request_region
#define kbd_request_irq(handler) parisckbd_request_irq(handler)

/* How to access the keyboard macros on this platform.  */
#define kbd_read_input  parisckbd_read_input
#define kbd_read_status  parisckbd_read_status
#define kbd_write_output(val)  parisckbd_write_output((val))
#define kbd_write_command(val) parisckbd_write_command((val))

#define kbd_enable() NULL
#define kbd_setrate() NULL

/* Some stoneage hardware needs delays after some operations.  */
#define kbd_pause() 

#define SYSRQ_KEY 0x54

#endif /* __KERNEL__ */

#endif /* __ASMPARISC_KEYBOARD_H */
