#ifndef _ASM_IRQ_H
#define _ASM_IRQ_H

#include <linux/string.h>
#include <asm/ptrace.h>
#include <linux/interrupt.h>

#include <asm/types.h>
/*
 *	linux/include/asm/irq.h
 *
 *	(C) 1992, 1993 Linus Torvalds, (C) 1997 Ingo Molnar,
 *		Copyright 1999 SuSE GmbH
 *
 *	IRQ/IPI changes taken from work by Thomas Radke
 *	<tomsoft@informatik.tu-chemnitz.de>
 */

#define TIMER_IRQ 0

#define NR_IRQS		1024
#define NR_IRQ_REGS	32

#define IRQ_REGION(irq) 	((irq)>>8)
#define IRQ_OFFSET(irq)		((irq)&255)
#define	IRQ_FROM_REGION(reg)	((reg)<<8)

#define IRQ_REG_DIS	   1	/* support disable_irq / enable_irq */
#define IRQ_REG_MASK	   2	/* require IRQs to be masked */

struct irq_region_ops {
	void (*disable_irq)(void *dev, int irq);
	void (* enable_irq)(void *dev, int irq);
	void (*   mask_irq)(void *dev, int irq);
	void (* unmask_irq)(void *dev, int irq);
};

struct irq_region_data {
	void *dev;
	const char *name;
	unsigned flags;
	int irqbase;
};

struct irq_region {
	struct irq_region_ops ops;
	struct irq_region_data data;

	struct irqaction *action;
};

#define irq_region_size(irqs) (sizeof(struct irq_region) + \
	sizeof(struct irqaction) * (irqs))

extern struct irq_region *irq_region[NR_IRQ_REGS];

static __inline__ int irq_cannonicalize(int irq)
{
	return irq;
}

extern void disable_irq(int);
extern void enable_irq(int);

extern void do_irq_mask(unsigned long mask, struct irq_region *region,
	struct pt_regs *regs);

extern struct irq_region *alloc_irq_region(int count, struct irq_region_ops *ops,
	unsigned long flags, const char *name, void *dev);
extern int txn_alloc_irq(void);
extern int txn_alloc_data(int);
extern unsigned long txn_alloc_addr(int);

#endif /* _ASM_IRQ_H */
