/*
 * include/asm-parisc/cache.h
 */

#ifndef __ARCH_PARISC_CACHE_H
#define __ARCH_PARISC_CACHE_H

#define L1_CACHE_BYTES 64

#define SMP_CACHE_BYTES L1_CACHE_BYTES

#define L1_CACHE_ALIGN(x)       (((x)+(L1_CACHE_BYTES-1))&~(L1_CACHE_BYTES-1))

/* Functions for flushing I/D-caches on parisc */
#define fdce(x) __asm__ __volatile__("fdce 0(0,%0)\n\tsync\n" : : "r" (x) )
#define fice(x) __asm__ __volatile__("fice 0(0,%0)\n\tsync\n" : : "r" (x) )

extern void cache_init(void);		/* initializes cache-flushing */
extern void flush_datacache(void);	/* flushes data-cache only */
extern void flush_codecache(void);	/* flushes code-cache only */
extern void flush_all_caches(void);	/* flushes code and data-cache */

#endif
