#ifndef __ARCH_PARISC_ATOMIC__
#define __ARCH_PARISC_ATOMIC__

/*
 * Atomic operations that C can't guarantee us.  Useful for
 * resource counting etc..
 */

/* Helge Deller: Coded in C, so first functionality is available 
    in parisc-kernel ! */
 

/* Always assuming that it is SMP */
typedef struct { 
		volatile int pad;
		volatile int counter;
		volatile int sema; 
} atomic_t  __attribute__ ((aligned(8)));

#define ATOMIC_INIT(i)	{ 0,(i),-1 }

extern unsigned int atomic_read(atomic_t *v);

extern unsigned int atomic_set(atomic_t *v, unsigned int i);

extern void atomic_add(int i, volatile atomic_t *v);

extern void atomic_sub(int i, volatile atomic_t *v);

extern void atomic_inc(volatile atomic_t *v);

extern void atomic_dec(volatile atomic_t *v);

extern int atomic_add_return(int i, volatile atomic_t *v);

extern int atomic_sub_return(int i, volatile atomic_t *v);

extern int atomic_inc_return(volatile atomic_t *v);

extern int atomic_dec_return(volatile atomic_t *v);

static __inline__ int atomic_dec_and_test(atomic_t *v)
{	
	/* should be rewritten in assembler */
	unsigned int c;

	atomic_read(v);		/* added this to make atomic */
	--v->counter;	/* is this correct ?? */
	c =v->counter;
	atomic_set(v,c);	/* added this to make atomic */
	return c == 0;
}

/* These are x86-specific, used by some header files */
/* do we need this in parisc ?? (deller) */
#define atomic_clear_mask(mask, addr) \
    { *(unsigned int *)(addr) &= (mask); }

#define atomic_set_mask(mask, addr)   \
    { *(unsigned int *)(addr) |= (mask); }

#endif
