#ifndef _PARISC_ASSEMBLY_H
#define _PARISC_ASSEMBLY_H

#include <asm/offset.h>
#include <asm/page.h>

#define INTR_PSW	0x4000a

	sp	=	30
	gp	=	27
	ipsw	=	22

#if __PAGE_OFFSET == 0xc0000000
	.macro	tophys	gr
	depi	0,1,2,\gr
	.endm
	
	.macro	tovirt	gr
	depi	3,1,2,\gr
	.endm
#else
#error	unknown __PAGE_OFFSET
#endif



	.macro delay value
	ldil	L%\value, 1
	ldo	R%\value(1), 1
	addib,UV,n -1,1,.
	addib,NUV,n -1,1,.+8
	nop
	.endm

	.macro	debug value
	.endm

	.macro	save_general	regs
	mfsp	 0, 1
	stw	 1, PT_SR0 (\regs)
	mfsp	 1, 1
	stw	 1, PT_SR1 (\regs)
	mfsp	 2, 1
	stw	 1, PT_SR2 (\regs)
	mfsp	 3, 1
	stw	 1, PT_SR3 (\regs)
	mfsp	 4, 1
	stw	 1, PT_SR4 (\regs)
	mfsp	 5, 1
	stw	 1, PT_SR5 (\regs)
	mfsp	 6, 1
	stw	 1, PT_SR6 (\regs)
	mfsp	 7, 1
	stw	 1, PT_SR7 (\regs)

	stw	 2, PT_GR2 (\regs)
	stw	 3, PT_GR3 (\regs)
	stw	 4, PT_GR4 (\regs)
	stw	 5, PT_GR5 (\regs)
	stw	 6, PT_GR6 (\regs)
	stw	 7, PT_GR7 (\regs)
	stw	 8, PT_GR8 (\regs)
	stw	 9, PT_GR9 (\regs)
	stw	10, PT_GR10(\regs)
	stw	11, PT_GR11(\regs)
	stw	12, PT_GR12(\regs)
	stw	13, PT_GR13(\regs)
	stw	14, PT_GR14(\regs)
	stw	15, PT_GR15(\regs)
	stw	16, PT_GR16(\regs)
	stw	17, PT_GR17(\regs)
	stw	18, PT_GR18(\regs)
	stw	19, PT_GR19(\regs)
	stw	20, PT_GR20(\regs)
	stw	21, PT_GR21(\regs)
	stw	22, PT_GR22(\regs)
	stw	23, PT_GR23(\regs)
	stw	24, PT_GR24(\regs)
	stw	25, PT_GR25(\regs)
	stw	27, PT_GR27(\regs)
	stw	28, PT_GR28(\regs)
	/* stack pointer saved in get_stack */	
	stw	31, PT_GR31(\regs)
	ldil	L%$global$, 27
	ldo	R%$global$(27), 27
	.endm

	.macro	rest_general	regs
	ldw	PT_SR0 (\regs),	 1
	mtsp	 1, 0
	ldw	PT_SR1 (\regs),  1
	mtsp	 1, 1
	ldw	PT_SR2 (\regs),  1
	mtsp	 1, 2
	ldw	PT_SR3 (\regs),  1
	mtsp	 1, 3
	ldw	PT_SR4 (\regs),	 1
	mtsp	 1, 4
	ldw	PT_SR5 (\regs),  1
	mtsp	 1, 5
	ldw	PT_SR6 (\regs),	 1
	mtsp	 1, 6
	ldw	PT_SR7 (\regs),	 1
	mtsp	 1, 7

	ldw	PT_GR2 (\regs),	 2
	ldw	PT_GR3 (\regs),	 3
	ldw	PT_GR4 (\regs),	 4
	ldw	PT_GR5 (\regs),	 5
	ldw	PT_GR6 (\regs),	 6
	ldw	PT_GR7 (\regs),	 7
	ldw	PT_GR8 (\regs),	 8
	ldw	PT_GR9 (\regs),	 9
	ldw	PT_GR10(\regs),	10
	ldw	PT_GR11(\regs),	11
	ldw	PT_GR12(\regs),	12
	ldw	PT_GR13(\regs),	13
	ldw	PT_GR14(\regs),	14
	ldw	PT_GR15(\regs),	15
	ldw	PT_GR16(\regs),	16
	ldw	PT_GR17(\regs),	17
	ldw	PT_GR18(\regs),	18
	ldw	PT_GR19(\regs),	19
	ldw	PT_GR20(\regs),	20
	ldw	PT_GR21(\regs),	21
	ldw	PT_GR22(\regs),	22
	ldw	PT_GR23(\regs),	23
	ldw	PT_GR24(\regs),	24
	ldw	PT_GR25(\regs),	25
	ldw	PT_GR26(\regs),	26
	ldw	PT_GR27(\regs),	27
	ldw	PT_GR28(\regs),	28
	/* stack pointer restored in rest_stack */
	ldw	PT_GR31(\regs),	31
	.endm

	.macro	save_specials	regs
	mfctl	18,	 1
	stw	 1,	PT_IAOQ0(\regs)
	mtctl	 0,	18
	mfctl	18,	 1
	stw	 1,	PT_IAOQ1(\regs)

	mfctl	11,	 1
	stw	 1,	PT_SAR	(\regs)

	mfctl	22,	 1
	stw	 1,	PT_PSW	(\regs)

	mfctl	19,	 1
	stw	 1,	PT_IIR	(\regs)

	mfctl	28,	 1
	stw	 1,	PT_GR1	(\regs)

	mfctl	31,	 1
	stw	 1,	PT_GR29	(\regs)

	stw	26,	PT_GR26	(\regs)
	mfctl	29,	26
	.endm

	.macro	rest_specials	regs
	ldw	PT_IAOQ0(\regs),	 1
	mtctl	 1,			18
	ldw	PT_IAOQ1(\regs),	 1
	mtctl	 1,			18

	ldw	PT_SAR  (\regs),	 1
	mtctl	 1,			11

	ldw	PT_PSW  (\regs),	 1
	mtctl	 1,			22
	.endm
#endif
