/* $Id: fault.c,v 1.5 1999/08/21 17:32:00 prumpf Exp $
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1995, 1996, 1997, 1998 by Ralf Baechle
 */

#ifdef OUT_ORG_LINUX
#include <linux/signal.h>
#endif /* OUT_ORG_LINUX */

#include <linux/sched.h>

#ifdef OUT_ORG_LINUX
#include <linux/interrupt.h>
#include <linux/kernel.h>
#include <linux/errno.h>
#include <linux/string.h>
#endif /* OUT_ORG_LINUX */

#include <linux/types.h>

#ifdef OUT_ORG_LINUX
#include <linux/ptrace.h>
#include <linux/mman.h>
#endif /* OUT_ORG_LINUX */

#include <linux/mm.h>

#ifdef OUT_ORG_LINUX
#include <linux/smp.h>
#include <linux/smp_lock.h>
#include <linux/version.h>

#include <asm/hardirq.h>
#endif /* OUT_ORG_LINUX */

#include <asm/pgtable.h>

#ifdef OUT_ORG_LINUX
#include <asm/mmu_context.h>
#include <asm/softirq.h>
#include <asm/system.h>
#include <asm/uaccess.h>

#define development_version (LINUX_VERSION_CODE & 0x100)

unsigned long asid_cache;

/*
 * Macro for exception fixup code to access integer registers.
 */
#define dpf_reg(r) (regs->regs[r])

void die(const char * str, struct pt_regs * regs, long err);

#endif /* OUT_ORG_LINUX */

/*
 * This routine handles page faults.  It determines the address,
 * and the problem, and then passes it off to one of the appropriate
 * routines.
 */
void do_page_fault(struct pt_regs *regs, unsigned long code,
			      unsigned long address)
{
	struct vm_area_struct * vma;
	struct task_struct *tsk = current;
	/* struct task_struct *tsk; */
	struct mm_struct *mm = tsk->mm;
	pgd_t *pgd;
	pmd_t *pmd;	/* added middle table */
	pte_t *ptep;
	unsigned long ra;
	unsigned long prot, acc_rights;
	unsigned long fixup;
	unsigned long *lptr;
	unsigned long prot_flag = 0;
	extern  unsigned long *linux_gateway_page;

	/* Determine if user process or not */
	if(regs->iaoq[0] & 0x3)
	{
		lptr = current->tss.pg_tables;
		prot_flag = 1;
		/* grab priv level from current process */
	 	acc_rights = (regs->iaoq[0] & 0x3);
		/* create access rights from current privlevel */
		acc_rights = acc_rights | (acc_rights << 2) | 0x30;
		acc_rights = acc_rights << 52;
		prot = (current->pid) << 1;
		prot = acc_rights | prot;
		while(*lptr)
		{
	    	   printk("\nlptr = %x, addr = %x \n",lptr,address);
		   if((address & PAGE_MASK) == *lptr)
		   {
			if((0xffffffffff & address & PAGE_MASK) == &linux_gateway_page)
			{
				acc_rights = 0x4c; /* promote to 0 */
				acc_rights = acc_rights << 52;
				prot = 0x1; /* no write allowed */
				prot = acc_rights | prot;
			}
			ra = *lptr;
			switch(code) {
			  case 6:
			  case 16:
			    set_itlb_page(ra, prot, regs, prot_flag);	
			    break;
			  case 15:
			  case 17:
			    set_dtlb_page(ra, prot, regs, 0, prot_flag);
			    break;
			}
			return;
		   }
		   else
		     lptr++;
		}

		goto bad_address;
	}

	/* find the corresponding mapping */
	/* 1st get global entry */
	pgd = (pgd_t *)(current->tss.pg_tables+(address >> 34));
	if(!(pgd_val(*pgd)&_PAGE_PRESENT)) {
		goto bad_address;
	}

	/* 2nd get middle entry */
	pmd = pgd_val(*pgd) & PAGE_MASK;
	pmd = ((address >> 22)&1023) + pmd;

	/* 3rd get the final page table entry */
	ptep = (pte_t *)(pmd_val(*pmd)&PAGE_MASK);
	ptep += ((address >> 12)&1023);
	
	if(!(pte_val(*ptep)&_PAGE_PRESENT)) {	
		goto bad_address;
	}

	prot = translate_pte(*ptep);

	ra = (pte_val(*ptep)&~4095);

	switch(code) {
		case 6:
		case 16:
			if(address < 0x4000000)
			  set_kernel_pages();
			else
			  set_itlb_page(ra, prot, regs, 0);	
		break;
		case 15:
		case 17:
			if(address < 0x4000000)
			  set_kernel_pages();
			else
			  set_dtlb_page(ra, prot, regs, 7, 0);
	}

	return;

bad_address:
	
	printk("bad address %08x\n", address);
	show_regs(regs);
	return;

#ifdef OUT_ORG_LINUX
	if(!user_mode(regs))
		goto no_context;


	/*
	 * If we're in an interrupt or have no user
	 * context, we must not take the fault..
	 */
	if (in_interrupt() || mm == &init_mm)
		goto no_context;
	down(&mm->mmap_sem);
	vma = find_vma(mm, address);
	if (!vma)
		goto bad_area;
	if (vma->vm_start <= address)
		goto good_area;
	if (!(vma->vm_flags & VM_GROWSDOWN))
		goto bad_area;
	if (expand_stack(vma, address))
		goto bad_area;
/*
 * Ok, we have a good vm_area for this memory access, so
 * we can handle it..
 */
good_area:
	up(&mm->mmap_sem);
	return;

/*
 * Something tried to access memory that isn't in our memory map..
 * Fix it, but check if it's kernel or user first..
 */
bad_area:
	up(&mm->mmap_sem);

	if (user_mode(regs)) {
		force_sig(SIGSEGV, tsk);
		return;
	}

no_context:
	/* Are we prepared to handle this kernel fault?  */

	/*
	 * Oops. The kernel tried to access some bad page. We'll have to
	 * terminate things with extreme prejudice.
	 */
	do_exit(SIGKILL);
#endif /* OUT_ORG_LINUX */
}
