/*
 *  linux/arch/i386/traps.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/*
 * 'Traps.c' handles hardware traps and faults after we have saved some
 * state in 'asm.s'.
 */

#include <linux/config.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/string.h>
#include <linux/errno.h>
#include <asm/ptrace.h>
#include <linux/timer.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#include <linux/init.h>
#include <linux/delay.h>

#ifdef CONFIG_MCA
#include <linux/mca.h>
#include <asm/processor.h>
#endif

#include <asm/system.h>
#include <asm/uaccess.h>
#include <asm/io.h>
#include <asm/spinlock.h>
#include <asm/atomic.h>
#ifdef OUT_ORG_LINUX
#include <asm/debugreg.h>
#endif /* OUT_ORG_LINUX */

#include <asm/smp.h>

#ifdef CONFIG_X86_VISWS_APIC
#include <asm/fixmap.h>
#include <asm/cobalt.h>
#include <asm/lithium.h>
#endif

#ifdef OUT_ORG_LINUX

asmlinkage int system_call(void);
asmlinkage void lcall7(void);

/*
 * The IDT has to be page-aligned to simplify the Pentium
 * F0 0F bug workaround.. We have a special link segment
 * for this.
 */

static inline void console_verbose(void)
{
	extern int console_loglevel;
	console_loglevel = 15;
}


void page_exception(void);

asmlinkage void divide_error(void);
asmlinkage void debug(void);
asmlinkage void nmi(void);
asmlinkage void int3(void);
asmlinkage void overflow(void);
asmlinkage void bounds(void);
asmlinkage void invalid_op(void);
asmlinkage void device_not_available(void);
asmlinkage void double_fault(void);
asmlinkage void coprocessor_segment_overrun(void);
asmlinkage void invalid_TSS(void);
asmlinkage void segment_not_present(void);
asmlinkage void stack_segment(void);
asmlinkage void general_protection(void);
asmlinkage void page_fault(void);
asmlinkage void coprocessor_error(void);
asmlinkage void reserved(void);
asmlinkage void alignment_check(void);
asmlinkage void spurious_interrupt_bug(void);

int kstack_depth_to_print = 24;

#endif /*OUT_ORG_LINUX*/
/*
 * These constants are for searching for possible module text
 * segments.  VMALLOC_OFFSET comes from mm/vmalloc.c; MODULE_RANGE is
 * a guess of how much space is likely to be vmalloced.
 */
#define VMALLOC_OFFSET (8*1024*1024)
#define MODULE_RANGE (8*1024*1024)

void show_regs(struct pt_regs *regs)
{
	int i;

	printk("\n"); /* don't want to have that pretty register dump messed up */

	printk("PSW  : %08x  ", regs->gr[0]);

	for(i=1; i<32; i++) {
		printk("GR%2d : %08x  ", i, regs->gr[i]);
		if((i & 3) == 3)
			printk("\n");
	}

	for(i=0; i<8; i++) {
		printk("SR%1d  : %08x  ", i, regs->sr[i]);
		if((i & 3) == 3)
			printk("\n");
	}


	printk("IAOQ : %08x %08x\n", regs->iaoq[0], regs->iaoq[1]);

	/* print the shadow registers if possible */

	/* XXX really should test if the CPU supports it */	

#ifdef OUT_ORG_LINUX
	{
		unsigned shr[32];
		unsigned shr_l[] = { 1, 8, 9, 16, 17, 24, 25, 0 };
		unsigned * shrp = shr_l;

		asm volatile("
			stw	1,   0(%0)
			sync
			sync
			.word 0x28001a00
			stw	 1,  4(%0)
			stw	 8, 32(%0)
			stw	 9, 36(%0)
			stw	16, 64(%0)
			stw	17, 68(%0)
			stw	24, 96(%0)
			stw	25,100(%0)
			ldw	  0(%0), 1 
		" : : "r" (shr) : "r8", "r9", "r16", "r17", "r24", "r25");

		for(i=0; *shrp; i++, shrp++) {
			printk("SHR%2d: %08x  ", *shrp, shr[*shrp]);
			if((i & 3) == 3)
				printk("\n");
		}
	}	
#endif /*OUT_ORG_LINUX*/
		
		

}	

#ifdef OUT_ORG_LINUX
spinlock_t die_lock;

void die(const char * str, struct pt_regs * regs, long err)
{
}

static inline void die_if_kernel(const char * str, struct pt_regs * regs, long err)
{
}

static void die_if_no_fixup(const char * str, struct pt_regs * regs, long err)
{
		die(str, regs, err);
}


asmlinkage void cache_flush_denied(struct pt_regs * regs, long error_code)
{
}

asmlinkage void do_general_protection(struct pt_regs * regs, long error_code)
{
}

static void mem_parity_error(unsigned char reason, struct pt_regs * regs)
{
}	

static void io_check_error(unsigned char reason, struct pt_regs * regs)
{
}

/*
 * Careful - we must not do a lock-kernel until we have checked that the
 * debug fault happened in user mode. Getting debug exceptions while
 * in the kernel has to be handled without locking, to avoid deadlocks..
 *
 * Being careful here means that we don't have to be as careful in a
 * lot of more complicated places (task switching can be a bit lazy
 * about restoring all the debug state, and ptrace doesn't have to
 * find every occurrence of the TF bit that could be saved away even
 * by user code - and we don't have to be careful about what values
 * can be written to the debug registers because there are no really
 * bad cases).
 */
asmlinkage void do_debug(struct pt_regs * regs, long error_code)
{
}

/*
 * Note that we play around with the 'TS' bit in an attempt to get
 * the correct behaviour even in the presence of the asynchronous
 * IRQ13 behaviour
 */
void math_error(void)
{
}

asmlinkage void do_coprocessor_error(struct pt_regs * regs, long error_code)
{
}

asmlinkage void do_spurious_interrupt_bug(struct pt_regs * regs,
					  long error_code)
{
}

/*
 *  'math_state_restore()' saves the current math information in the
 * old math state array, and gets the new ones from the current task
 *
 * Careful.. There are problems with IBM-designed IRQ13 behaviour.
 * Don't touch unless you *really* know how it works.
 */
asmlinkage void math_state_restore(struct pt_regs regs)
{
}

#ifndef CONFIG_MATH_EMULATION

asmlinkage void math_emulate(long arg)
{
}

#endif /* CONFIG_MATH_EMULATION */

__initfunc(void trap_init_f00f_bug(void))
{
}


/*
 * This needs to use 'idt_table' rather than 'idt', and
 * thus use the _nonmapped_ version of the IDT, as the
 * Pentium F0 0F bugfix can have resulted in the mapped
 * IDT being write-protected.
 */
void set_intr_gate(unsigned int n, void *addr)
{
}

static void __init set_trap_gate(unsigned int n, void *addr)
{
}

static void __init set_system_gate(unsigned int n, void *addr)
{
}

static void __init set_call_gate(void *a, void *addr)
{
}

void set_tss_desc(unsigned int n, void *addr)
{
}

void set_ldt_desc(unsigned int n, void *addr, unsigned int size)
{
}

void __init trap_init(void)
{
}
#endif /*OUT_ORG_LINUX*/
