/*
 *  linux/arch/arm/kernel/time.c
 *
 *  Copyright (C) 1991, 1992, 1995  Linus Torvalds
 *  Modifications for ARM (C) 1994, 1995, 1996,1997 Russell King
 *  Copyright (C) 1999 SuSE GmbH, (Philipp Rumpf, prumpf@suse.de)
 *
 * 1994-07-02  Alan Modra
 *             fixed set_rtc_mmss, fixed time.year for >= 2000, new mktime
 * 1998-12-20  Updated NTP code according to technical memorandum Jan '96
 *             "A Kernel Model for Precision Timekeeping" by Dave Mills
 */


#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/param.h>
#include <linux/string.h>
#include <linux/mm.h>
#include <linux/interrupt.h>
#include <linux/time.h>
#include <linux/delay.h>
#include <linux/init.h>
#include <linux/smp.h>
#include <linux/init.h>
#include <linux/delay.h>

#include <asm/uaccess.h>

#include <asm/io.h>
#include <asm/irq.h>

#include <asm/param.h>
#include <asm/pdc.h>

#include <linux/timex.h>

#ifdef OUT_ORG_LINUX
static int timer_value;
static int timer_delta;
#endif /* OUT_ORG_LINUX */

static long timer_value;
static long timer_delta;

#ifdef OUT

/* Dummy stub function now. Enable the actual timer code once interrupt
 * mechanisms are tested
 */
void timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{

}

#endif /* OUT */

void timer_interrupt(int irq, void *dev_id, struct pt_regs *regs)
{

       /* Code needs to be enabled once the interrupt mechanism works */
      

	int old;
	int lost = 0;
	int cr16;
	
	old = timer_value;

	cr16 = mfctl(16);
	while((timer_value - cr16) < (timer_delta / 2)) {
		timer_value += timer_delta;
		lost++;
	}

	mtctl(timer_value ,16);

	do_timer(regs);


}

void do_gettimeofday(struct timeval *tv)
{
}

void time_init(void)
{
        /* Note that proper computation for 1 second needs to be done here
         * for 64 bit. Also HZ needs to be defined properly */

        register long tmp;
        long dummy = 0x1122334455667788;

        printk("dummy = 0x%lx\n",dummy);

	timer_delta = (100 * PAGE0->mem_10msec) / HZ;

	/* make the first timer interrupt go off in one second */
	timer_value = mfctl(16) + (HZ * timer_delta);
	mtctl(timer_value, 16);



        printk("Finished with Timer init %x\n",timer_value);
}
