;------------------------------------------------------------------------------
;
; Linux/PARISC Project (http://www.thepuffingroup.com/parisc)
;
; System call entry code Copyright (c) Matthew Wilcox 1999 <willy@bofh.ai>
; Licensed under the GNU GPL.
; thanks to Philipp Rumpf, Mike Shaver and various others
; sorry about the wall, puffin..
;

#include <asm/offset.h>
#include <asm/unistd.h>
#include <asm/errno.h>

	.space          $TEXT$
	.subspa         $CODE$

	.import sys_call_table, data
	.import syscall_exit,code
	.IMPORT __gp, DATA
	.export linux_gateway_page

	.align 4096
linux_gateway_page
	nop
	b,GATE	.+8     			; become privileged
	nop
	nop					;leave this alone, its the target
	nop
	mfctl	%cr30,%r1			; get the kernel task ptr
	mtctl	%r0,%cr30			; zero it (flag)
	std	%r30,TASK_PT_GR30(%r1)		; preserve userspace sp
	std	%r2,TASK_PT_GR2(%r1)		; preserve rp
	std	%r27,TASK_PT_GR27(%r1)		; user dp
	std	%r31,TASK_PT_GR31(%r1)		; preserve syscall return ptr

	ldo	TASK_SZ_ALGN+64(%r1),%r30	; set up kernel stack
	;------------------------------------------
	;junmp to this page using kernel address view:
	;------------------------------------------
gstrick mfia	%r3		;form kernel addres of this page
	addil   L'gstb0-gstrick, %r3
	ldo	R'gstb0-gstrick(%r1), %r3
	depdi,Z -1,63,40,%r1
	and	%r1,%r3,%r3	;r3 has kernel addr of this page

	ldi	0x2,%r4		;create kernel access ID
	mtctl	%r4,%cr9	;setup kernel access ID temporarily

	nop
	be	0(%sr7,%r3)
	nop
	;------------------------------------------

gstb0	mfia    %r27
	addil   L'__gp-gstb0, %r27
	ldo     R'__gp-gstb0(%r1), %r27		; setup kernel dp

	;;;;ldo	TASK_SZ_ALGN+64(%r1),%r30	; set up kernel stack

gstbl	mfia    %r21
	addil   L'sys_call_table-gstbl, %r21
	ldo	R'sys_call_table-gstbl(%r1), %r21
	comiclr,>>=	__NR_Linux_syscalls, %r20, %r0
	b,n	syscall_nosys
	ldd,s	%r20(%r21), %r21
gstbl2	mfia    %r2
	addil	L'syscall_exit-gstbl2,%r2
	be	0(%sr7,%r21)
	ldo	R'syscall_exit-gstbl2(%r1),%r2

syscall_nosys
	mfia	%r28
	addil	L'syscall_exit-syscall_nosys,%r28
	ldo     R'syscall_exit-syscall_nosys(%r1),%r28
	copy	%r28,%r1
	be	(%sr7,%r1)
	ldo	-ENOSYS(%r0),%r28		   ; set errno

	;---------------------------------------------
        .export syscall_exit, entry

syscall_exit
        ; The execve system call uses r2 as a flag
        ; to determine whether or not to clear arg0-arg3
        ; (r26-r23).

        comib,=,n 0,%r2,no_clear
        copy    %r0, %r23
        copy    %r0, %r24
        copy    %r0, %r25
        copy    %r0, %r26

no_clear

        ;------------------------------------------
        ;junmp to this page using user's address view:
        ;------------------------------------------
trckof  mfia    %r3             ;form user addres of this page
        addil   L'trckdne-trckof, %r3
        ldo     R'trckdne-trckof(%r1), %r3
        mfctl   %cr28,%r1       ;grab current task ptr
        ldo     TASK_PID(%r1), %r1     ;pnt to pid
	ldw	(%r1),%r1
        depd,Z  %r1,23,24,%r1   ;shift pid in position
        or      %r1,%r3,%r3
        mtctl   %r0,%cr9        ;clear kernel ID
        nop
        be      0(%sr7,%r3)
        nop

trckdne
        ; NOTE: HP-UX syscalls also come through here
        ;       after hpux_syscall_exit fixes up return
        ;       values.
        ;
        ; check for bottom halves
        ; check for reschedule
        ; check for pending signals

        ldo     -TASK_SZ_ALGN-64(%r30),%r1         ; get task ptr
        ldd     TASK_PT_GR30(%r1),%r30             ; restore user sp
        ldd     TASK_PT_GR2(%r1),%r2               ; restore user rp
        ldd     TASK_PT_GR27(%r1),%r27             ; restore user dp
        ldd     TASK_PT_GR31(%r1),%r31             ; restore syscall rp
        copy    %r0, %r19
        copy    %r0, %r20
        copy    %r0, %r21
        mtctl   %r1,%cr30                          ; intrhandler okay.


        be      0(%sr3,%r31)                       ; return to user space
        nop

	.align 4096
	.export end_linux_gateway_page
end_linux_gateway_page

;********************************
; System call not available yet
;********************************
	.export sys_no_call, entry
sys_no_call
	bve	(%r2)
	ldo     -ENOSYS(%r0),%r28                  ; set errno
