/*
 *  linux/arch/parisc/kernel/process.c
 *	based on the work for i386
 */

/*
 * This file handles the architecture-dependent parts of process handling..
 */

#define __KERNEL_SYSCALLS__
#include <stdarg.h>

#include <linux/errno.h>
#include <linux/sched.h>
#include <linux/kernel.h>
#include <linux/mm.h>
#include <linux/smp.h>
#include <linux/smp_lock.h>
#include <linux/stddef.h>
#include <linux/unistd.h>
#include <linux/ptrace.h>
#include <linux/malloc.h>
#include <linux/vmalloc.h>
#include <linux/user.h>
#include <linux/a.out.h>
#include <linux/interrupt.h>
#include <linux/config.h>
#include <linux/unistd.h>
#include <linux/delay.h>
#include <linux/smp.h>
#include <linux/reboot.h>
#include <linux/init.h>
#if defined(CONFIG_APM) && defined(CONFIG_APM_POWER_OFF)
#include <linux/apm_bios.h>
#endif

#include <asm/uaccess.h>
#include <asm/pgtable.h>
#include <asm/system.h>
#include <asm/io.h>
#include <asm/processor.h>
#include <asm/offset.h>
#ifdef CONFIG_MATH_EMULATION
#include <asm/math_emu.h>
#endif

spinlock_t semaphore_wake_lock = SPIN_LOCK_UNLOCKED;

asmlinkage void ret_from_fork(void) __asm__("ret_from_fork");
asmlinkage void ret_from_kernel_thread(void) __asm__("ret_from_kernel_thread");

#ifdef CONFIG_APM
extern int  apm_do_idle(void);
extern void apm_do_busy(void);
#endif

static int hlt_counter=0;

void disable_hlt(void)
{
	hlt_counter++;
}

void enable_hlt(void)
{
	hlt_counter--;
}



asmlinkage int sys_idle(void)
{	
    return 1;
}

/*
 * The idle thread. There's no useful work to be
 * done, so just try to conserve power and have a
 * low exit latency (ie sit in a loop waiting for
 * somebody to say that they'd like to reschedule)
 */
void cpu_idle(void)
{
    /* endless idle loop with no priority at all */
     init_idle();
     current->priority = 0;
     current->counter = -100;

     while (1) {
	     while (!current->need_resched) {
	     }
	     schedule();
	     check_pgt_cache();
    }
}

__initfunc(void reboot_setup(char *str, int *ints))
{
}


void machine_restart(char * __unused)
{
}

void machine_halt(void)
{
}

void machine_power_off(void)
{
}


/*
 * Create a kernel thread
 */

extern pid_t __kernel_thread(int (*fn)(void *), void *arg, unsigned long flags); 
pid_t kernel_thread(int (*fn)(void *), void *arg, unsigned long flags)
{
	pid_t ret;

	printk("kernel_thread %p %p %08lx\n", fn, arg, flags);

	ret =__kernel_thread(fn, arg, flags);
	printk("after __k_t (%d)\n", ret);

	if(!ret) {
		fn(arg);
		for(;;);
	}

	return ret;
}

/*
 * Free current thread data structures etc..
 */
void exit_thread(void)
{
}

void flush_thread(void)
{
}

void release_thread(struct task_struct *dead_task)
{
}

#define  ROUND_UP(x,y)       ((((x) + ((y) - 1)) / (y)) * (y))

int copy_thread(int nr, unsigned long clone_flags, unsigned long usp,
                 struct task_struct * p, struct pt_regs * pregs)
{
	struct pt_regs * cregs = &(p->tss.regs);
	long ksp;

	/* Copy parent regs to child's task struc. JC */
	*cregs = *pregs;

	/* Set value of child's stack JC */
	ksp = (((unsigned long)(p)) + TASK_SZ_ALGN);	
	cregs->gr[28] = 0;	/* child */

	pregs->gr[28] = p->pid;	/* parent */

	/*!!!!!!!!!!!!!!!!!!!!!!!!!*/
	/* if the parent's stack is the kernel's, set child's cr30 to point to it */
	if(pregs->cr30 == 0 )
	{
		cregs->cr30 = pregs->cr28;
	}

	/* set access id: */
	cregs->cr_pid[0] = (p->pid) << 1;

	cregs->ksp = ksp;	/* always return to kernel */

	cregs->cr28 = ((unsigned long)(p));	/* setup child's task ptr */
	cregs->cr28 = PA(cregs->cr28);		/* force addr to real */

	if(user_mode(cregs))
		cregs->kpc = (unsigned long) ret_from_fork;
	else
		cregs->kpc = (unsigned long) ret_from_kernel_thread;

	return 0;
}

/*
 * fill in the FPU structure for a core dump.
 */
int dump_fpu (struct pt_regs * regs, struct user_i387_struct* fpu)
{
    return 1;
}

/*
 * fill in the user structure for a core dump..
 */
void dump_thread(struct pt_regs * regs, struct user * dump)
{
}


asmlinkage int sys_fork(struct pt_regs *regs)
{
	return 1;
}

asmlinkage int sys_clone(struct pt_regs regs)
{
    return 1;
}

/*
 * This is trivial, and on the face of it looks like it
 * could equally well be done in user mode.
 *
 * Not so, for quite unobvious reasons - register pressure.
 * In user mode vfork() cannot have a stack frame, and if
 * done by calling the "clone()" system call directly, you
 * do not have enough call-clobbered registers to hold all
 * the information you need.
 */
asmlinkage int sys_vfork(struct pt_regs regs)
{
    return 1;
}

/*
 * sys_execve() executes a new program.
 */
/*asmlinkage int sys_execve(struct pt_regs *regs)*/
asmlinkage int sys_execve(const char *filename, char * argv [],
        char * envp[])
{
        int error;
	struct pt_regs *reg;

        lock_kernel();

#ifdef OUT_ORG_LINUX
        char *filename;
        filename = getname((char *) regs->gr[26]);
        error = PTR_ERR(filename);
        if (IS_ERR(filename))
                goto out;
        error = do_execve(filename, (char **) regs->gr[25],
                (char **) regs->gr[24], regs);
#endif /*OUT_ORG_LINUX*/

	reg = (struct pt_regs *)&(current->tss.regs);

        error = do_execve((char *)filename, argv, envp, reg);
        if (error == 0)
                current->flags &= ~PF_DTRACE;

#ifdef OUT_ORG_LINUX
        putname(filename);
#endif /*OUT_ORG_LINUX*/

out:
        unlock_kernel();

        return error; 
}
