/* $Id: cache.c,v 1.6 1999/11/22 17:53:02 prumpf Exp $
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License.  See the file "COPYING" in the main directory of this archive
 * for more details.
 *
 * Copyright (C) 1999 Helge Deller (07-13-1999)
 * Copyright (C) 1999 SuSE GmbH Nuernberg
 *
 * based on the "PA-RISC 1.1 Firmware Architecture Reference Specification",
 * pages 1-19 and 1-20
 *
 */
 
#include <asm/pdc.h>
#include <asm/cache.h>
#include <linux/kernel.h>

static struct pdc_cache_info cache_info;

#define fdce(addr) asm volatile("fdce 0(%0)" : : "r" (addr))
#define fice(addr) asm volatile("fice 0(%0)" : : "r" (addr))

/* XXX: these functions may not access memory between f[di]ce instructions. */

void flush_data_cache(void)
{
	register unsigned base   = cache_info.dc_base;
	register unsigned count  = cache_info.dc_count;
	register unsigned loop   = cache_info.dc_loop;
	register unsigned stride = cache_info.dc_stride;
	register unsigned addr;
	register int i, j;

	for(i=0,addr=base; i<count; i++,addr+=stride)
		for(j=0; j<loop; j++)
			fdce(addr);
}
		
void flush_instruction_cache(void)
{
	register unsigned base   = cache_info.ic_base;
	register unsigned count  = cache_info.ic_count;
	register unsigned loop   = cache_info.ic_loop;
	register unsigned stride = cache_info.ic_stride;
	register unsigned addr;
	register int i, j;

	for(i=0,addr=base; i<count; i++,addr+=stride)
		for(j=0; j<loop; j++)
			fice(addr);
}

/* not yet ... fdc() needs to be implemented in cache.h !
void flush_datacache_range( unsigned int base, unsigned int end )
{
    register int offset,offset_add;
    offset_add = ( (1<<(cache_info.dc_conf.cc_block-1)) * 
		    cache_info.dc_conf.cc_line ) << 4;
    for (offset=base; offset<=end; offset+=offset_add)
	fdc(space,offset);
    fdc(space,end);
}
*/

/* flushes code and data-cache */
void flush_all_caches(void)
{
	flush_instruction_cache();
	flush_data_cache();
}

#ifdef OUT_ORG_LINUX
void cache_init(void)
{
	if(pdc_cache_info(&cache_info)<0)
		panic("cache_init: pdc_cache_info failed");
}
#endif /*OUT_ORG_LINUX*/
