;#############################################################################
; WIDE MODE CRT0 (for RAGE Linux Kernel)
;#############################################################################
#include <asm/offset.h>

	.SPACE $TEXT$
	.SUBSPA $TM_STACK$,ACCESS=0x2C
;Note, the label TM_STACK is ued to specify the stack area. Note, that the linker will
;merge subspaces that are specified by the same subspace label. The file stack.s has
;a TM_STACK subspace specified, along with an actual stack allocation (i.e. blockz).
;Therefore, even thogh the word 0 below would imply a stck of 1 word, the stack.s 
;specification will create a true stack. Having a seperate stack file (stack.s) allows
;the crt0 file to be distributed as a .o instead of an .s. Therefore, TM developers
;would each have their own stack.s file to specify the stack size.
$TM_STACK
 	.WORD 0
	.SUBSPA $CODE$
	.IMPORT start_parisc
	.IMPORT fault_vector
        .IMPORT __gp, DATA
	.IMPORT __text_start,DATA
	.IMPORT init_stack,DATA
	.IMPORT init_task_union,DATA
	.export _stext,code             ;puffin crap
         
$START$
_stext					;added this crap from puffin code
	break
	ssm	   0x208,r0		; turn on psw, w,and q bit
	bl         .+8,%r31
	addil	   L%__gp-$L1$,%r31	;Note: __gp == $global$
$L1$	ldo        R%__gp-$L1$(%r1),%dp

	;Note, save the return addr. of the guy that launched us
	addil      L%tcReturnPtr-$global$,%dp
        stw        %rp,R%tcReturnPtr-$global$(%r1)



$INIT_DONE$
	 
	;  Initialize SP
	;set stack pointer so that it will grow up from
	;the end of the initial task, that has been placed on the
	;stack.
	mtctl	   %sp,%tr2		;garb original stack
	bl         .+8,%r31
	addil      L%init_stack-$L2$,%r31
$L2$	ldo        R%init_stack-$L2$(%r1),%sp
	addi	   0x100,%sp,%sp	;bump stack, make room for at least a frame

        extru,=    %sp,31,4,%r0         ; Make sure sp is sixteen-byte aligned
        addi       16,%sp,%sp
      	depi	   0,31,4,%sp

	mfctl	   %tr2,%r1		 ;save original stack!!!!!!!!!!!!!!
	stw	   %r1,(%sp)		 ;!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!	
	ldo	   80(%sp),%sp           ; push frame maker 
	ldo	   -16(%sp),%r29	 ; setup outgoing parameter area

;------------------------------------------
; Initialize Space registers
;------------------------------------------
	mtsp	   %r0,%sr0
	mtsp	   %r0,%sr1
	mtsp	   %r0,%sr2
	mtsp	   %r0,%sr3
	mtsp	   %r0,%sr4
	mtsp	   %r0,%sr5
	mtsp	   %r0,%sr6
	mtsp	   %r0,%sr7

;------------------------------------------
; Initialize Protection registers
;------------------------------------------
	ldi	0x2,%r1		;kernel access id is 1
	mtctl	%r1,%cr8	;PD1 = 0 PD2 = 1
	mtctl	%r0,%cr9	;all other PD's set to 0
	mtctl	%r0,%cr12
	mtctl	%r0,%cr13

	;-----------------------------------------------------
	; Insert TLB Mappings:
	;
	; We must insert tlb mappings for the real addresses
	; starting from where we are in memory to at least the
	; 1st free address passed to us from the loader. Also,
	; we must map 0 to virtual address 0xC0000000 upto
	; the 1st free address passed to us from the loader.
	;-----------------------------------------------------
	bl	   .+8,%r31		;grab real addr of $START$
	addil	   L%$START$-vgrab,%r31 ;while Q bit on 
vgrab	ldo        R%$START$-vgrab(%r1),%r1
	copy	   %r1,%r28

	;get the number of pages in the kernel: (gr26 has next free addr)
	copy	   %r26,%r1	

	addil      L%lifVolDir-$global$,%dp
	std        %r25,R%lifVolDir-$global$(%r1)

	;determine proper encoding:
	ldi	7,%r3		;use maximum encoding of 64MB

	;turn off Q bit
	rsm	   8,%r0		; turn off q bit

;*******************************************************************
;DO INSTRUCTION SIDE:
;*******************************************************************

	;******First do 0x00000000 mapping of kernel real addresses
	;******real addr 0 == virt addr 0x00000000
	mtctl	   %r0,%cr17		;set back of IIASQ
	mtctl	   %r0,%cr17		;set front of IIASQ


	;;;;;;ldi	   0xC,%r31		;get virt addr of START
	;;;;;;depd,Z	   %r31,35,4,%r31	;set to 0xC0000000
	ldi	   0x0,%r31		;get virt addr of START
	mtctl	   %r31,%cr18		;set virt offset (back)
	addi	   4,%r31,%r31
	mtctl	   %r31,%cr18		;set virt offset (front)

	extrd,u    %r0,51,52,%r31      ;RPN into correct position
	depd,z	   %r31,58,52,%r31
	depd       %r3,63,4,%r31  	;set page size to (r3+1) * 4k

	ldil       L'0x03000000,%r28    ; set up protection
        depd,z     %r28,31,32,%r28 	;type= 011 pl1=pl2=0 access id=0
	depdi	   1,3,1,%r28		;set d-bit to turn off dirty trap
	depdi	   1,62,1,%r28		;set access id = 1, wd = 0

	iitlbt	   %r31,%r28		;insert entry


;*******************************************************************
;DO DATA SIDE:
;*******************************************************************

	;******Second do 1 to 1 mapping of kernel real addresses
	;******real addr 0 == virt addr 0
	;set space & offset values of translation
	mtctl	   %r0,%cr20		;set front of ISR

	ldi	   0,%r28		;get real addr target (addr 0)

	ldi	   0,%r31		;get virt addr of target
	mtctl	   %r31,%cr21		;set IOR

	extrd,u    %r28,51,52,%r31      ;RPN into correct position
	depd,z	   %r31,58,52,%r31
	depd       %r3,63,4,%r31  	;set page size to (r3+1) * 4k

	ldil       L'0x03000000,%r28    ; set up protection
        depd,z     %r28,31,32,%r28 	;type= 011 pl1=pl2=0 access id=0
	depdi	   1,3,1,%r28		;set d-bit to turn off dirty trap
	depdi	   1,62,1,%r28		;set access id = 1, wd = 0

	idtlbt	   %r31,%r28		;insert entry

	;turn on Q bit
	ssm	   0x208,r0		; turn on psw, w,and q bit

;flt_set mfia       %r10 			;get iaoq_front
;ldo	   fault_vector-flt_set-flt_set(%r10),%r10
	copy 	   %r0,%r10
	ldil	   L%fault_vector,%r10
	ldo	   R%fault_vector(%r10),%r10
	mtctl	   %r10,%cr14

	mtctl	   0,%cr30		;indicate the stack is the kernel's

	copy 	   %r0,%r10
	ldil	   L%init_task_union,%r10
	ldo	   R%init_task_union(%r10),%r10
	mtctl	   %r10,%cr28		;point to the initial task

	;-----------------------------------------------------
	; Jump virtually to start_parisc
	;
	; Below we must jump into virtual mode to the virtual
	; address of start_parisc so that our leveraged linux
	; code will function properly.
	;-----------------------------------------------------

	bl	   .+8,%r31
	addil	   L%$START_RTN$-$L3$,%r31   ;set rtn addr 
$L3$	ldo        R%$START_RTN$-$L3$(%r1),%r2

	;put virt address of start_parisc in Queue
	bl	   .+8,%r31			;get offset of start_parisc from top
	addil	   L%start_parisc-$L5$,%r31   ;set rtn addr 
$L5$	ldo        R%start_parisc-$L5$(%r1),%r1
	
	;turn off Q bit
	rsm	   8,%r0		; turn off q bit

	;;;;ldi	   0xC,%r28		;get virt addr of START
	;;;;depd,Z	   %r28,35,4,%r28	;set to 0xC0000000
	ldi	   0,%r28             ;get virt addr of START

	;setup offset queue
	add	   %r28,%r1,%r1		;form virt target addr
	mtctl	   %r1,%cr18		;front IIAOQ
	addi	   4,%r1,%r1
	mtctl	   %r1,%cr18		;back IIAOQ

	;setup space queue
	mtctl	   %r0,%cr17		;front IIASQ
	mtctl	   %r0,%cr17		;back IIASQ
	
	;load ipsw with Q,W,C,P, and D on
	ldil	   l%0x804000E,%r28
	ldo	   r%0x804000E(%r28),%r28
	mtctl	   %r28,%cr22


	;rfi to start_parisc
	ldi	   0,%r28
	rfi
	nop


$START_RTN$

 	addil      L%tcReturnPtr-$global$,%dp
 	ldw        R%tcReturnPtr-$global$(%r1),%rp
	ldo        -80(%sp),%sp          ; pop frame marker 
	ldw	   (%sp),%sp		;restore stack !!!!!!!!!!!!!!!!!!!!!!!
	extrd,u	   %ret0,31,32,%ret0      ;structures are returned in bits 0-31
					  ;see 64-bit runtime architecture
	bv         (%rp)
	rsm	   0x200,%r0

exit
	b 	   $START_RTN$
	copy	   %arg0,%ret0
	
	.EXPORT exit,ENTRY
	.EXPORT $START$,CODE
	.EXPORT $TM_STACK, CODE

; stack unwind descriptors--needed by the linker

	.SUBSPA $UNWIND_START$,QUAD=0,ALIGN=8,ACCESS=0x2c,SORT=56
        .SUBSPA $UNWIND$MILLICODE$,QUAD=0,ALIGN=8,ACCESS=0x2c,SORT=62
	.SUBSPA $UNWIND_START$
$UNWIND_START
	.EXPORT $UNWIND_START
	.SUBSPA $UNWIND_END$,QUAD=0,ALIGN=8,ACCESS=0x2c,SORT=72
$UNWIND_END
	.EXPORT $UNWIND_END
	.SUBSPA $RECOVER_START$,QUAD=0,ALIGN=4,ACCESS=0x2c,SORT=73
$RECOVER_START
	.EXPORT $RECOVER_START
	.SUBSPA $RECOVER$MILLICODE$,QUAD=0,ALIGN=4,ACCESS=0x2c,SORT=78
	.SUBSPA $RECOVER$,QUAD=0,ALIGN=4,ACCESS=0x2c,SORT=80
	.SUBSPA $RECOVER_END$,QUAD=0,ALIGN=4,ACCESS=0x2c,SORT=88
$RECOVER_END
	.EXPORT $RECOVER_END



; dynamic linkage table start/end (see linker command file)

        .SUBSPA $ODE_DLT_START$,ACCESS=0x2C
$ODE_DLT_START
        .SUBSPA $ODE_DLT_END$,ACCESS=0x2C
$ODE_DLT_END


	.SPACE $PRIVATE$
	.SUBSPA $DATA$

	.export _data_start,code
	.export lifVolDir,data

_data_start			;puffin crap
tcReturnPtr
	.WORD 0
PdcCall
	.DWORD 0
DltRelocated
        .WORD 0

lifVolDir       .ALIGN 16
	.BLOCKZ 8

	.ALIGN 4096
	.EXPORT swapper_pg_dir, DATA
swapper_pg_dir
	.BLOCKZ	8192

;--------------------------------
;This has been defined in stack.s
#ifdef OUT
	.ALIGN 4096
	.EXPORT init_task_union, DATA
init_task_union
	.BLOCKZ	TASK_SIZE
#endif 
;--------------------------------

	.EXPORT	PdcCall, DATA
	

	.SUBSPA $BSS$



        .SPACE $TEXT$
        .SUBSPA $CODE$


