/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Space records manipulation routines
 *
 */

extern struct space_dictionary_record *space_array;
extern struct space_misc_record *space_misc;
extern int     *sp_remap;
extern int     space_array_size;
extern int     cur_space_total;
extern int     load_spaces;

extern void		spaces_initialize();
extern void		spaces_add();
extern int		build_space();


struct space_misc_record {
    Boolean copyram_needed;        /* is there an address needed */
    Boolean no_compression;        /* should zeroes fixups be expanded? */
    Boolean relocatable;           /* is space relocatable? embed sys pic code*/
    Boolean start_addr_specified;        /* is there an address needed */
    Boolean embed_unloadable;        /* does space need previous origin ? */
    Boolean space_specified;        /* was space seen in command file? */
    unsigned int ram_location;          /* COPYRAM address */
    unsigned int start_virt_addr;          /* AT address */
    unsigned int space_align;           /* alignment requested for this space */
    Boolean bl_seen;		/* Were any BL's seen in this subspace? */
    Boolean is_doom_stripped;   /* space is stripped via objdebug link  */
    };

#define Sym_Space_Misc(i)   space_misc[Subsp_Dict(Sym_Subsp(i)).space_index]
#define Sub_Space_Misc(i)   space_misc[Subsp_Dict(i).space_index]

#define Sym_Space_Dict(i)   space_array[Subsp_Dict(Sym_Subsp(i)).space_index]
#define Sub_Space_Dict(i)   space_array[Subsp_Dict(i).space_index]

#define BAD_SPACE	(-1)
