/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Old-to-New Fixup Format Translation 
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Header: /home/cvs/cvsroot/linker/o2n_tally.c,v 1.1.1.1 1999/10/18 19:53:03 pschwan Exp $ 
 */

#include <stdio.h>
#ifdef Old2New
#include <assert.h>
#endif

#include "std.h"
#include "ldlimits.h"
#include "syms.h"
#include "symbols.h"

#ifdef Old2New
#include "opcodes.h"
#define FDMP_CANT_WRT "can\'t write to output file"
#define use_PUT_table   TRUE
#else
Boolean use_PUT_table;
#include "linker.h"
#include "util.h"
#include "errors.h"

#define error(x)        external_error(x, NULL, NULL, NULL, NULL)

#endif

#include "reloc.h"
#include "fixups.h"
#include "o2n_tally.h"

extern int dollar_global;
extern int milli_label;

Fixup static_fixup_area[MAX_NEW_FIXUP_LEN+1];

#ifdef Old2New
extern FILE *tmp;
#define emalloc malloc
#define efree   free

extern struct symbol_dictionary_record *symbols;

/* only do branch tables if we are doing Old2New */
/* BRANCH TABLE STATES */
unsigned int branch_table_counter;

#define make_data_override(x,y) (word = Make_Data_Override(word, x, y))
extern int fixup_subsp;

#else /* Old2New */

static void make_data_override();

#endif /* Old2New */

/* must be a power of 2 */
#define FIXUP_SIZE   512

struct fixup_chain {
    Fixup  fixups[FIXUP_SIZE];
    struct fixup_chain * next;
    } ;

static struct fixup_chain *first = NULL;
static struct fixup_chain *last = NULL;

#ifdef Old2New
static int last_fixup = -1;     /* not a valid fixup */
#endif

int new_fixup_size;
int override_mode;

close_runs() {
    add_run(-1);
    }

int old_run_type = -1;
int old_run_length = 0;

#ifdef Old2New
add_run(new_run_type)
int new_run_type;
    {
    int local_run_type;
    int local_run_length;

    if (new_run_type == old_run_type)
        old_run_length++;
    else {
        local_run_type = old_run_type;
        local_run_length = old_run_length;
        old_run_type = -1;              /* prevent infinite recursion */

        switch (local_run_type) {
            /* only do runs of zeroes if Old2New */
            case R_ZEROES :
                make_run_fixup(R_ZEROES, 4*(local_run_length+1));
                break;
            case R_NO_RELOCATION:
                /* In translation, we never have byte aligned stuff */
                make_no_reloc_fixup(4*(local_run_length+1));
                break;

            default:
                break;
            }
        old_run_type = new_run_type;
        /* 1 is implied by even being here */
        old_run_length = 0;
        }
    }
#endif

#ifdef Old2New
tally_with_fixup(word, fixup, exec_level)
int word;
#else
Tally_with_fixup(fixup, exec_level)
#endif
struct fixup_request_record *fixup;
int exec_level;
    {
    int fixup_type;
    int expected_prefix;
    int error_num = 0;
    struct symbol_dictionary_record *sym;

    fixup_type = -1;            /* undefined type     */
    expected_prefix = -1;       /* undefined selector */

    switch (fixup->fixup_format) {
        case i_exp11:
#ifdef Old2New
            /* only check data if Old2New */
            switch (GET_OP(word)) {
                case 0x24:  /* COMICLR      */
                case 0x25:  /* SUBI/SUBIO   */
                case 0x2c:  /* ADDIT/ADDITO */
                case 0x2d:  /* ADDI/ADDIO   */
                    break;
                default:
                    goto BAD_OPCODE;
                }
#endif
            expected_prefix = expected(R_RSEL);
           GOOD_OPCODE:
            if (fixup->fixup_field != expected_prefix) {
                if (fixup->fixup_field == e_fsel)
                    make_simple_fixup(R_FSEL);
                else
                    make_mode_change(fixup->fixup_field);
                }
            make_data_override(fixup->fixup_constant, fixup->fixup_format);

            if (fixup->expression_type == e_one)
                fixup_type = R_CODE_ONE_SYMBOL;
            else if (fixup->expression_type == e_plabel) {
                make_symbol_fixup(R_CODE_PLABEL, fixup->symbol_index_one);
                goto RETURN;
                }
            /* must be an e_two expression */
            else if (fixup->symbol_index_two == dollar_global ||
                match_dollar_global(fixup->symbol_index_two)
               ) {
                fixup_type = R_DP_RELATIVE;
                }
            else {
                symbol_minus_symbol(fixup->symbol_index_one,
                                    fixup->symbol_index_two);
                make_simple_fixup(R_CODE_EXPR);
                goto RETURN;
                }
            /* get here if: R_CODE_ONE_SYMBOL or        */
            /*              R_DP_RELATIVE               */
            make_code_reference(fixup_type, fixup->symbol_index_one);
            goto RETURN;

        case i_exp14:
#ifdef Old2New
            /* only check data if Old2New */
            switch (GET_OP(word)) {
                case 0x0d:  /* LDO    */
                case 0x10:  /* LDB    */
                case 0x11:  /* LDH    */
                case 0x12:  /* LDW    */
                case 0x13:  /* LDWM  */
                case 0x18:  /* STB    */
                case 0x19:  /* STH    */
                case 0x1a:  /* STW    */
                case 0x1b:  /* STWM  */
                    break;
                default:
                    goto BAD_OPCODE;
                }
#endif
#ifdef FDP_CODE
            /* This is a case where we need to change a fix_desc->type
             * because an fdp counting stub is being added. There is
             * a sequence of code that triggers a problem if this is not
             * changed. If we are at $START$ and want to add an fdp stub
             * between there and the branch to _start, there is an
             * $START$+1C:     ldil    1800,r1
             * $START$+20:     ldo     2E0(r1),r1
             * ...   to get the branch address into r1
             * $START$+2C:     bv,n    r0(r1)
             * The ldil is an R_ABS_CALL type and gets R' or 21 bits.
             * The ldo is an R_CODE_ONE_SYMBOL type and gets L' or 14 bits.
             * This sequence gets a full address from some literal value
             * and shoves it into a register. The reason this is never
             * a problem in the linker is that users are never able
             * to add stubs which have a symbol associated with them. The
             * problem appears as 2 separate symbols for the same address.
             * and an incorrect branch destination is used. 
             */

            /* if it is 1-symbol, and it is entry point, then it is call */
            if (fixup->expression_type == e_one) {
                sym = & SYMBOLS(fixup->symbol_index_one);
                if (sym->symbol_type == ST_ENTRY ||
                    sym->symbol_type == ST_PRI_PROG ||
                    sym->symbol_type == ST_SEC_PROG ||
                    (sym->symbol_type == ST_CODE &&
                                sym->symbol_scope == SS_UNSAT)
                   ) {
                    make_data_override(fixup->fixup_constant, i_exp14);

                    /* for LONG Calls we always expect R' prefix */
                    if (fixup->fixup_field != e_rsel)
                        make_mode_change(fixup->fixup_field);

                    make_call_fixup(R_ABS_CALL,
                                    fixup->arg_reloc,
                                    fixup->symbol_index_one
                                   );
                    goto RETURN;
                    }
                }
#endif
            expected_prefix = expected(R_RSEL);
            goto GOOD_OPCODE;

        case i_exp21:
#ifdef Old2New
            /* only check data if Old2New */
            switch (GET_OP(word)) {
                case 0x08:  /* LDIL  */
                case 0x0a:  /* ADDIL */
                    break;
                default:
                    goto BAD_OPCODE;
                }
#endif
            /* if it is 1-symbol, and it is entry point, then it is call */
            if (fixup->expression_type == e_one) {
		if (fixup->symbol_index_one == -1)  /* catch assembler bug */
		    external_error(INVALID_FIXUP, "-1", cur_name, 0);

                sym = & SYMBOLS(fixup->symbol_index_one);
                if (sym->symbol_type == ST_ENTRY ||
                    sym->symbol_type == ST_PRI_PROG ||
                    sym->symbol_type == ST_SEC_PROG ||
                    (sym->symbol_type == ST_CODE &&
                                sym->symbol_scope == SS_UNSAT)
                   ) {
                    make_data_override(fixup->fixup_constant, i_exp21);

                    /* for LONG Calls we always expect L' prefix */
                    if (fixup->fixup_field != e_lsel)
                        make_mode_change(fixup->fixup_field);

                    make_call_fixup(R_ABS_CALL,
                                    fixup->arg_reloc,
                                    fixup->symbol_index_one,
				    fixup->exec_level,
				    exec_level
                                   );
                    goto RETURN;
                    }
                }

            /* otherwise it is a DATA reference fixup */
            expected_prefix = expected(R_LSEL);
            goto GOOD_OPCODE;

        case i_rel17:
#ifdef Old2New
            /* only check data if Old2New */
            if (GET_OP(word) != 0x3a)
                goto BAD_OPCODE;
            if (GET_BR_OP(word) != 0 && GET_BR_OP(word) != 1)
                goto BAD_OPCODE;
#endif
            make_data_override(fixup->fixup_constant+8, i_rel17);

            make_call_fixup(R_PCREL_CALL,
                            fixup->arg_reloc,
                            fixup->symbol_index_one,
			    fixup->exec_level,
			    exec_level
                           );
            goto RETURN;

        case i_abs17:
        case i_milli:
#ifdef Old2New
            switch (GET_OP(word)) {
                case 0x38:  /* BE  */
                case 0x39:  /* BLE */
                    break;
                default:
                    goto BAD_OPCODE;
                }
#endif
            if (fixup->expression_type == e_two) {
                /* millicode relative reference? */

                make_data_override(fixup->fixup_constant, i_abs17);

                if (fixup->symbol_index_two == milli_label ||
                    match_milli_label(fixup->symbol_index_two)
                   ) {
                    /* the default for MILLI_REL is F' */
                    if (fixup->fixup_field != e_fsel) {
                        if (fixup->fixup_field != expected(R_RSEL))
                            make_mode_change(fixup->fixup_field);
                        make_simple_fixup(R_RSEL);
                        }
                    make_symbol_fixup(R_MILLI_REL, fixup->symbol_index_one);
                    }
                else {
                    /* the default for CODE_EXPR for BLE is R' */
                    if (fixup->fixup_field == e_fsel)
                        make_simple_fixup(R_FSEL);
                    else if (fixup->fixup_field != e_rsel)
                        make_mode_change(fixup->fixup_field);

                    symbol_minus_symbol(fixup->symbol_index_one,
                                        fixup->symbol_index_two);
                    make_simple_fixup(R_CODE_EXPR);
                    }
                goto RETURN;
                }


            /* the default for BLE is R' */
            if (fixup->fixup_field == e_fsel) {
                make_simple_fixup(R_FSEL);
                /* treat this as a REL17, since we need to know constant */
                /* value for long branch stubs                           */
                make_data_override(fixup->fixup_constant, i_rel17);
                }
            else {
                if (fixup->fixup_field != e_rsel)
                    make_mode_change(fixup->fixup_field);
                /* treat this as a ABS17, since we can not generate a    */
                /* long branch stub here                                 */
                make_data_override(fixup->fixup_constant, i_abs17);
                }

            make_call_fixup(R_ABS_CALL,
                            fixup->arg_reloc,
                            fixup->symbol_index_one,
			    fixup->exec_level,
			    exec_level
                           );
            goto RETURN;

        case i_break:
#ifdef Old2New
            if (word != 0x08000240)            /* check for NOP */
                goto BAD_OPCODE;
#endif
            make_data_override(fixup->fixup_constant, i_data);

            make_simple_fixup(R_BREAKPOINT);
            goto RETURN;

        case i_rel12:
#ifdef Old2New
            switch (GET_OP(word)) {
                /* COMB */ case 0x20: case 0x21: case 0x22: case 0x23:
                /* ADDB */ case 0x28: case 0x29: case 0x2a: case 0x2b:
                /* BB   */ case 0x30: case 0x31: case 0x32: case 0x33:
                    break;
                default:
                    goto BAD_OPCODE;
                }
#endif
            make_data_override(fixup->fixup_constant+8, i_rel12);

            make_code_reference(R_CODE_ONE_SYMBOL, fixup->symbol_index_one);
            goto RETURN;

        case i_data:
            switch (fixup->expression_type) {
                case e_one:
#ifdef Old2New
                    sym = & SYMBOLS(fixup->symbol_index_one);
                    if (sym->symbol_scope == SS_LOCAL ||
                        sym->symbol_type == SS_UNIVERSAL
                       ) {
                        if (sym->symbol_info == fixup_subsp) {
                            make_data_override(
                                sym->symbol_value + fixup->fixup_constant,
                                i_data
                                );
                            make_simple_fixup(R_RELOCATION);
                            break;
                            }
                        }
#endif
                    make_data_override(fixup->fixup_constant, i_data);
                    make_symbol_fixup(R_DATA_ONE_SYMBOL,
                                      fixup->symbol_index_one);
                    break;
                case e_two:
                    make_data_override(fixup->fixup_constant, i_data);
                    symbol_minus_symbol(fixup->symbol_index_one,
                                        fixup->symbol_index_two);
                    make_simple_fixup(R_DATA_EXPR);
                    break;
                case e_plabel:
                    make_data_override(fixup->fixup_constant, i_data);
                    make_symbol_fixup(R_DATA_PLABEL, fixup->symbol_index_one);
                    break;
                }
            goto RETURN;

        default:
           BAD_OPCODE:
#ifdef Old2New
            error(ld_gets(1, "opcode doesn't match format"));
#endif
            return;
        }

   RETURN: ;
#ifdef Old2New
    putw(word, tmp);
#endif

    }

#ifdef Old2New
tally_no_fixup(word, in_proc)
int word;
int in_proc;
    {
    int local_run_type;

    if (in_proc) {
        /* only check data if doing Old2New */
        if (GET_OP(word) == 0x3a && /* branch */
                GET_BR_OP(word) == 0x2) /* BLR */ {
            if (branch_table_counter != 0)
                error(ld_gets(1, 1158, "BLR within existing branch table"));
            make_simple_fixup(R_BEGIN_BRTAB);
            branch_table_counter = 1;
            }
        local_run_type = R_NO_RELOCATION;
        }
    else {
        /* only check data if doing Old2New */
        if (word == 0)
            local_run_type = R_ZEROES;
        else
            local_run_type = R_NO_RELOCATION;
        }
    add_run(local_run_type);
    /* only write new data if Old2New */
    if (local_run_type != R_ZEROES)
        putw(word, tmp);
    }
#endif

#ifdef Old2New
/* only concerned with branch tables in Old2New */
int found_branch_pair(ptr)
int * ptr;
    {
    register int op;

    op = GET_OP(*ptr);
    /* B branch (link = 0) as first instruction */
    if (op == 0x3a && GET_BR_OP(*ptr) == 0 && GET_R2(*ptr) == 0)
        return (TRUE);
    op = GET_OP(*++ptr);
    /* nullifying long branch as second instruction (e.g. LDIL/BE,N) */
    if (op >= 0x38 && op <= 0x39 && (*ptr & 2))
        return (TRUE);
    return (FALSE);
    }
#endif

make_no_reloc_fixup(length)
int length;
    {
    int temp;

    if ((length & 03) == 0 &&
        (length>>2) <= (3<<16)
       ) {
        /* word aligned */
        length >>= 2;
        /* zero-base */
        length--;
        start_fixup();
        if (length < 24)
            PUT_8(R_NO_RELOCATION+length);
        else if (length < (4<<8)) {
            PUT_8(R_NO_RELOCATION+24+(length>>8));
            PUT_8(length);
            }
        else if (length < (3<<16)) {
            PUT_8(R_NO_RELOCATION+28+(length>>16));
            PUT_16(length);
            }
        }
    else {
        /* byte aligned, or too long */
        while (length > 0) {
            temp = 1<<24;
            if (length < temp)
                temp = length;
            length -= temp;
            start_fixup();
            PUT_8(R_NO_RELOCATION+31);
            PUT_24(temp-1);
            }
        }
    }

make_repeat_fixup(replen, total)
int replen, total;
    {
    if ((replen & 0x3) == 0 &&          /* replen is in words */
        (total & 0x3) == 0 &&           /* total is in words */
        (replen >> 2) <= 256 &&         /* replen fits in 8 bits */
        (total >> 2) <= (1<<24)         /* total fits in 24 bits */
       ) {
        /* word lengths */
        total  >>= 2;
        replen >>= 2;
        if (replen == 1 && total <= 256) {
            /* replen is 1 word, total is in words */
            start_fixup();
            PUT_8(R_REPEATED_INIT);
            PUT_8(total-1);
            }
        else if (total <= 256*replen && (total % replen == 0)) {
            /* total is a multiple of replen */
            start_fixup();
            PUT_8(R_REPEATED_INIT+1);
            PUT_8(replen-1);
            PUT_8(total/replen-1);
            }
        else {
            /* total is BIG or not a multiple of replen */
            start_fixup();
            PUT_8(R_REPEATED_INIT+2);
            PUT_8(replen-1);
            PUT_24(total-1);
            }
        }
    else {
        /* byte lengths */
        start_fixup();
        PUT_8(R_REPEATED_INIT+3);
#ifdef Old2New
        assert(replen <= (1<<24));
#else
        if (replen > (1<<24))
    	    external_error(REPLEN_TOO_BIG, cur_name, 0);
#endif
        PUT_24(replen-1);
        PUT_32(total-1);
        }
    }

make_run_fixup(fixup_type, length)
int fixup_type, length;
/* length is in BYTES */
    {
    int temp;

    if ((length & 03) == 0 && length <= 256) {
        /* word based length */
        length = (length >> 2)-1;
        start_fixup();
        PUT_8(fixup_type);
        PUT_8(length);
        }
    else {
        /* byte based length */
        while (length > 0) {
            temp = 1<<24;
            if (length < temp)
                temp = length;
            length -= temp;
            start_fixup();
            PUT_8(fixup_type+1);
            PUT_24(temp-1);
            }
        }
    }

make_simple_fixup(fixup_type)
int fixup_type;
    {
#ifdef Old2New
    /* only interested in these savings if Old2New */
    if (fixup_type == R_EXIT && last_fixup == R_EXIT)
        return;
    if (fixup_type == R_ALT_ENTRY)
        if (last_fixup == R_ALT_ENTRY ||
            last_fixup == R_ENTRY  ||
            last_fixup == R_ENTRY+1
           )
            return;
#endif

    start_fixup();
    PUT_8(fixup_type);
    }

make_symbol24_fixup(base, sym)
int base, sym;
    {
    start_fixup();
    PUT_8(base);
    PUT_24(sym);
    }

make_symbol_fixup(base, sym)
int base, sym;
    {
    start_fixup();
    if (sym < 256) {
        PUT_8(base);
        PUT_8(sym);
        }
    else {
        PUT_8(base+1);
        PUT_24(sym);
        }
    }

Fixup * build_symbol_fixup(base, sym)
int base, sym;
    {
    Fixup *fixup;
    fixup = static_fixup_area;
    if (sym < 256) {
        *++fixup = base;
        *++fixup = sym;
        }
    else {
        *++fixup = base+1;
        *++fixup = sym >> 16;   /* storing a byte gets rid of upper bits */
        *++fixup = sym >> 8;    /* storing a byte gets rid of upper bits */
        *++fixup = sym;         /* storing a byte gets rid of upper bits */
        }
    static_fixup_area[0] = fixup - static_fixup_area;
    return (static_fixup_area);
    }

Fixup * build_compsym_fixup(base, subbase, sym)
int base, subbase, sym;
    {
    Fixup *fixup;
    fixup = static_fixup_area;
    *++fixup = base;
    if (sym < 256) {
        *++fixup = subbase;
        *++fixup = sym;
        }
    else {
        *++fixup = subbase+1;
        *++fixup = sym >> 16;   /* storing a byte gets rid of upper bits */
        *++fixup = sym >> 8;    /* storing a byte gets rid of upper bits */
        *++fixup = sym;         /* storing a byte gets rid of upper bits */
        }
    static_fixup_area[0] = fixup - static_fixup_area;
    return (static_fixup_area);
    }

make_code_reference(fixup_type, sym)
int fixup_type, sym;
    {
    start_fixup();
    if (sym < 32)
        PUT_8(fixup_type + sym);
    else if (sym < 256) {
        PUT_8(fixup_type + 32);
        PUT_8(sym);
        }
    else {
        PUT_8(fixup_type + 33);
        PUT_24(sym);
        }
    }

/* Parameter relocation descriptors */
#define	NO_CHECK        0
#define	ARG             1
#define	FARG            2
#define	FARGU           3

make_call_fixup(fixup_type, arg_reloc, sym_index, fix_exec_level, exec_level)
int fixup_type, arg_reloc, sym_index, fix_exec_level, exec_level;
    {
    extern Fixup *build_call_fixup();
    Fixup *fixup;
    int i;

    if (fix_exec_level != exec_level) {
	start_fixup();
	PUT_8(R_EXEC_LEVEL);
	PUT_8(fix_exec_level);
	}
    fixup = build_call_fixup(fixup_type, arg_reloc, sym_index);
    start_fixup();
    for (i = *fixup++; i > 0; i--)
        {
        PUT_8(*fixup++);
        }
    }

Fixup *build_call_fixup(fixup_type, arg_reloc, sym_index)
int fixup_type, arg_reloc, sym_index;
    {
    unsigned char args[4], ret;
    int i, arg_knt, ret_knt, composite;
    Fixup *fixup;

    fixup = static_fixup_area+1;

    args[0] = (arg_reloc >> 8) & 03;
    args[1] = (arg_reloc >> 6) & 03;
    args[2] = (arg_reloc >> 4) & 03;
    args[3] = (arg_reloc >> 2) & 03;
    ret     = arg_reloc & 03;

    if (sym_index >= 256)
        goto FULL_ARG_RELOC;

    for (arg_knt = 0; arg_knt < 4; arg_knt++)
        if (args[arg_knt] != ARG)
            break;

    for (i = arg_knt; i < 4; i++)
        if (args[i] != NO_CHECK)
            goto FULL_ARG_RELOC;

    if (ret == ARG)
        ret_knt = 5;
    else if (ret != NO_CHECK)
        goto FULL_ARG_RELOC;
    else
        ret_knt = 0;

    *fixup++ = fixup_type + arg_knt + ret_knt;
    *fixup++ = sym_index;
    goto RETURN;

   FULL_ARG_RELOC:

    if (args[0] == FARGU || args[1] == FARGU)
        composite = 9;
    else
        composite = args[0]*3 + args[1];

    composite *= 10;

    if (args[2] == FARGU || args[3] == FARGU)
        composite += 9;
    else
        composite += args[2]*3 + args[3];

    composite *= 4;

    composite += ret;

    if (sym_index < 256) {
        *fixup++ = fixup_type + 10 + (composite >> 8);
        *fixup++ = composite;
        *fixup++ = sym_index;
        }
    else {
        *fixup++ = fixup_type + 12 + (composite >> 8);
        *fixup++ = composite;
        *fixup++ = sym_index >> 16;
        *fixup++ = sym_index >> 8;
        *fixup++ = sym_index;
        }
   RETURN:
    static_fixup_area[0] = fixup - static_fixup_area - 1;
    return (static_fixup_area);
    }

make_proc_fixup(unwind_bits, frame_size, frame_symbol, exec_level)
int unwind_bits, frame_size, frame_symbol, exec_level;
    {
#ifdef Old2New
    /* only interested in these savings if Old2New */
    if (last_fixup == R_ALT_ENTRY) {
        /* back out the last fixup! */
        zap_one_byte_fixup();
        }
#endif

    unwind_bits = (unwind_bits &~ REGION_MASK) |
                  ((exec_level & 03) << REGION_SHIFT);

    if (frame_symbol == BAD_SYM) {
        /* constant size fixup */
        start_fixup();
        PUT_8(R_ENTRY);
        PUT_32(unwind_bits);
        PUT_32(frame_size);
        }
    else {
        /* put frame size on expression stack */
        push_symbol(frame_symbol);
        start_fixup();
        PUT_8(R_ENTRY+1);
        PUT_32(unwind_bits);
        PUT_8(frame_size >> 24);
        }
    }

make_end_try_fixup(distance)
int distance;
    {
    start_fixup();

    /* distance should always be a multiple of 4 */
    distance >>= 2;

    if (distance == 0)
        PUT_8(R_END_TRY);
    else if (0 <= distance && distance < 256) {
        PUT_8(R_END_TRY+1);
        PUT_8(distance);
        }
    else {
        PUT_8(R_END_TRY+2);
        PUT_24(distance);
        }
    }

make_mode_change(prefix)
int prefix;
    {
    int new_mode;

    switch (prefix)
        {
        case e_lsel:
        case e_rsel:
            new_mode = R_N_MODE;
            break;
        case e_ldsel:
        case e_rdsel:
            new_mode = R_D_MODE;
            break;
        case e_lssel:
        case e_rssel:
            new_mode = R_S_MODE;
            break;
        case e_lrsel:
        case e_rrsel:
            new_mode = R_R_MODE;
            break;
        }
    start_fixup();
    PUT_8(override_mode = new_mode);
    }

int expected(field)
int field;
{
    int ret_val;

    switch (override_mode) {
        case R_N_MODE:
            return((field == R_RSEL) ? e_rsel : e_lsel);
        case R_S_MODE:
            return((field == R_RSEL) ? e_rssel : e_lssel);
        case R_D_MODE:
            return((field == R_RSEL) ? e_rdsel : e_ldsel);
        case R_R_MODE:
            return((field == R_RSEL) ? e_rrsel : e_lrsel);
        }
    /* NOT REACHED */
    return 0;
}

#ifdef Old2New
Make_Data_Override(word, constant, length)
int word;
#else
static void make_data_override(constant, length)
#endif
int constant, length;
{
#ifdef Old2New
    switch (length) {
        case i_exp14:
            if (OFL(constant, 14))
                goto TOO_BIG;
            word = word &~ EXP14(-1) | EXP14(constant);
            break;
        case i_exp21:
            if (OFL(constant, 21))
                goto TOO_BIG;
            word = word &~ EXP21(-1) | EXP21(constant);
            break;
        case i_exp11:
            if (OFL(constant, 11))
                goto TOO_BIG;
            word = word &~ EXP11(-1) | EXP11(constant);
            break;
        case i_rel17:
            /* WE COME HERE FOR F' ABSOLUTE BRANCHES AS WELL */
            /* we must know in advance whether branches will reach or not */
            /* so we can not put any constant into the data word          */
            if (constant != 0)
                goto TOO_BIG;
            word = word &~ REL17(-1);   /* constant known to be zero */
            break;
        case i_abs17:
            /* ONLY COME HERE FOR R' ABSOLUTE BRANCHES */
            /* use REL17 macro since not interested in space register */
            if (OFL(constant, 19))
                goto TOO_BIG;
            word = word &~ REL17(-1) | REL17(constant);
            break;
        case i_rel12:
            if (OFL(constant, 14))
                goto TOO_BIG;
            word = word &~ REL12(-1) | REL12(constant);
            break;
        case i_data:
            word = constant;
            break;
        default:
            fprintf(stderr, ld_gets(1, 1159, "should never get here!\n"));
        }
    return(word);
#else
    if (constant == 0)
        return;
#endif
   TOO_BIG:
    start_fixup();
    if (constant == 0)
        PUT_8(R_DATA_OVERRIDE);
    else if (! OFL(constant, 8)) {
        PUT_8(R_DATA_OVERRIDE+1);
        PUT_8(constant);
    } else if (! OFL(constant, 16)) {
        PUT_8(R_DATA_OVERRIDE+2);
        PUT_16(constant);
    } else if (! OFL(constant, 24)) {
        PUT_8(R_DATA_OVERRIDE+3);
        PUT_24(constant);
    } else {
        PUT_8(R_DATA_OVERRIDE+4);
        PUT_32(constant);
    }
#ifdef Old2New
    return (word);
#endif
}

int symbol_minus_symbol(s1, s2) 
int s1;
int s2;
{
    push_symbol(s1);
    push_symbol(s2);
    start_fixup();
    PUT_8(R_COMP1);
    PUT_8(R_SUB);
}

int push_symbol(sym)
int sym;
{
    start_fixup();
    PUT_8(R_COMP2);
    PUT_8(R_PUSH_SYM);
    PUT_24(sym);
}

#ifndef Old2New
reset_new_fixups() 
{
    last = NULL;
    new_fixup_size = 0;
}

transfer_fixups(s)
char *s;
{
    int size, len;
    register struct fixup_chain *z;

    size = new_fixup_size;
    z = first;

    while (size > 0) {
        if (size < FIXUP_SIZE)
            len = size;
        else
            len = FIXUP_SIZE;
        size -= len;

        memcpy(s, z->fixups, len);
        s += len;

        z = z->next;
    }
}
#endif

write_fixups(f, loc)
#ifdef Old2New
FILE *f;
#define fdump(f,o,b,l,c) \
	    fseek(f,o,0); \
	    if (fwrite(b,c,l,f) != (l)*(c)) \
		error(FDMP_CANT_WRT);
#else
int f;
#endif
int loc;
{
    int size, len;
    register struct fixup_chain *z;

    size = new_fixup_size;
    z = first;

    while (size > 0) {
        if (size < FIXUP_SIZE)
            len = size;
        else
            len = FIXUP_SIZE;
        size -= len;
	fdump(f, loc, z->fixups, len, 1);
	loc += len;
        z = z->next;
    }
}

PUT_16(i)
int i;
{
    PUT_8(i >> 8);
    PUT_8(i);
}

PUT_24(i)
int i;
{
    PUT_8(i >> 16);
    PUT_8(i >> 8);
    PUT_8(i);
}

PUT_32(i)
int i;
{
    PUT_8(i >> 24);
    PUT_8(i >> 16);
    PUT_8(i >> 8);
    PUT_8(i);
}

static struct {
    Fixup bytes [MAX_NEW_FIXUP_LEN];
    int len;
} PUT_table[PSZ], curr;

static int order[PSZ];

clear_PUT_table() 
{
    int i;
    for (i = 0; i < PSZ; i++) {
        PUT_table[i].len = 0;
        order[i] = i;
        }
    curr.len = 0;
}

PUT_8(i)
int i;
{
#ifdef Old2New
    if (curr.len == 0)
        last_fixup = i;
#endif
    curr.bytes[curr.len++] = i;
}

start_fixup() 
{
    int lru;
    int i, j;
    unsigned char *s1, *s2, *stop;

    close_runs();

    if (curr.len == 1) {
        /* single byte fixup... just output it */
        OUTPUT_byte(curr.bytes[0]);
    } else if (curr.len != 0) {
        /* search existing entries for a match */
        if (use_PUT_table) {
            for (i = 0; i < PSZ; i++) {
                j = order[i];
                if (PUT_table[j].len != curr.len)
                    continue;

                s1 = PUT_table[j].bytes;
                s2 = curr.bytes;
                stop = & curr.bytes[curr.len];
                for ( ; s2 < stop; )
                    if (*s1++ != *s2++)
                        goto CONTINUE;

                /* FOUND.  output byte and rearrange list */
                OUTPUT_byte(R_PREV_FIXUP+i);
                for ( ; i > 0; i--)
                    order[i] = order[i-1];
                order[0] = j;
                goto RETURN;
              CONTINUE: ;
            }
        }

        /* NOT FOUND in PUT TABLE (or PUT_table unused) */

        /* output him */
        for (i = 0; i < curr.len; i++)
            OUTPUT_byte(curr.bytes[i]);

        if (use_PUT_table) {
            /* enter this guy into the list */
            j = order[PSZ-1];
            for (i = PSZ-1; i > 0; i--)
                order[i] = order[i-1];
            order[0] = j;
            PUT_table[j] = curr;
        }
   }
   RETURN:
    curr.len = 0;
} /* end start_fixup */

OUTPUT_byte(i)
int i;
{ 
    register int x;
    register struct fixup_chain ** z;

    x = new_fixup_size++ & (FIXUP_SIZE-1);
    if (x == 0) {
        if (last == NULL)
            z = & first;
        else
            z = & last->next;

        if (*z == NULL) {
            *z = (struct fixup_chain *) emalloc(sizeof(** z));
            (*z)->next = NULL;
        }

        last = *z;
    }
    last->fixups[x] = i;
} /* end OUTPUT_byte */

#ifdef Old2New
/* only want to save space if in Old2New */
zap_one_byte_fixup() 
{
    register int x;
    register struct fixup_chain * z;

    x = --new_fixup_size & (FIXUP_SIZE-1);
    if (x == 0) {
        /* aargh! we JUST started a new block, and now we have to find prev */
        if (first == last) {
            /* ok, start over */
            efree(last);
            first = last = NULL;
            return;
        }
        z = first;
        while (z->next != last)
            z = z->next;
        last = z;
    }
} /* end zap_one_byte_fixup */
#endif
