/* A set of helper utilities to patch deficiencies in the Linux build
 * environment (ex: libc).
 *
 * Copyright (c) 1999 the Puffin Group, pschwan@thepuffingroup.com
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* These are obviously not threadsafe nor efficient--someone else is
 * encouraged to write better ones if the need is there.
 * --pschwan@thepuffingroup.com */

#include <stdio.h>
#include <string.h>

char * ltoa(n)
long n;
{
	static char buffer[21];

	snprintf(buffer, sizeof(buffer) - 1, "%ld", n);

	return buffer;
}

char * ltostr(n, base)
long n;
int base;
{
	static char buffer[21];

	if (base == 8)
		snprintf(buffer, sizeof(buffer) - 1, "%lo", n);
	else if (base == 10)
		snprintf(buffer, sizeof(buffer) - 1, "%ld", n);
	else if (base == 16)
		snprintf(buffer, sizeof(buffer) - 1, "%lx", n);
	else
		abort();

	return buffer;
}

char * strrstr(s1, s2)
const char *s1;
const char *s2;
{
	int l1 = strlen(s1), l2 = strlen(s2);
	char *p = (char *)s1 + (l1 - l2), *r;

	while (p >= s1) {
		if ((r = strstr(p, s2)))
			return r;
		p--;
	}
	return NULL;
}

char * pad_string(is_left_just, output_width, input_width, input_str)
int is_left_just;
int output_width;
int input_width;
const char *input_str;
{
	abort();
}
