/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
** ldnls.h - include file for linker nls routines.
** $Header: /home/cvs/cvsroot/linker/ldnls.h,v 1.2 1999/10/18 22:29:43 pschwan Exp $
*/

#ifndef LDNLS
#define LDNLS

#include <stdio.h>
#include <nl_types.h>


/* Defines */

#define INIT_BUF_SIZE	1024


/* Typedefs */


/* External storage */

extern int mb_errno;

#ifdef _PROTOTYPES

#    ifndef HPE
	/* Function prototypes. */

	extern char * mb_strncat(char *s1, char *s2, size_t n);

	extern char * mb_strchr(const char *sp, int c);

	extern size_t mb_strcspn(const char *string, const char *charset);

	extern char * mb_strncpy(char *s1, const char *s2, size_t n);

	extern char * mb_strpbrk(const char *string, const char *brkset);

	extern char *mb_strrchr(const char *s, int c);

	extern char *mb_strrstr(const char *s1, const char *s2);

	extern char *mb_strstr(const char *s1, const char *s2);

	extern char *mb_strtok(char *s1, const char *s2);

	extern int mb_width(const char * mbstr);

	extern nl_catd nls_initialize(char *cmd_name);

	extern char *pad_string(int    		is_left_just,
				int   		output_width,
				int   		input_width,
				const char  	*input_str);
#   else /* HPE */
#       define  mb_strncat strncat
#       define  mb_strchr strchr
#       define  mb_strcspn strcspn
#       define  mb_strncpy strncpy
#       define  mb_strpbrk strpbrk
#       define mb_strrchr strrchr
#       define mb_strrstr strrstr
#       define mb_strstr strstr
#       define mb_strtok strtok
#       define mb_width mb_width not allowd on HPE
#       define nls_initialize nls_initialize not allowed on HPE
#       define pad_string pad_string not allowed on HPE
#   endif

#else /* _PROTOTYPES */

    /* K&R C Function declarations. */

    extern char * mb_strncat();

    extern char * mb_strchr();

    extern size_t mb_strcspn();

    extern char * mb_strncpy();

    extern char * mb_strpbrk();

    extern char *mb_strrchr();

    extern char *mb_strrstr();

    extern char *mb_strstr();

    extern char *mb_strtok();

    extern int mb_width();

    extern nl_catd nls_initialize();

    extern char *pad_string();

#endif /* _PROTOTYPES */

/* This will go away soon, I swear. --pschwan@thepuffingroup.com */
#ifdef LINUX
#  define mb_strrchr strrchr
#  define mb_strncpy strncpy
#  define mb_strtok strtok
#  define mb_strrstr strrstr
#  define mb_strchr strchr
#  define mb_errno errno
#endif

#endif /* LDNLS */
