/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Table Size Limits
 *
 */

/* Internal table sizes for segmented tables */
/* The "max" sizes listed are the default size for each segment */

#define		MAX_SEGS	256	/* initial size of segment lists */

#define		SYM_DICT_LOG	    12
#define		SUBSP_DICT_LOG	    9 
#define		STUBS_LOG	    10

#define		SYM_DICT_MAX	    (1 << SYM_DICT_LOG)
#define		SUBSP_DICT_MAX	    (1 << SUBSP_DICT_LOG)
#define		STUBS_MAX	    (1 << STUBS_LOG)

#ifdef VARIABLE_SIZES
extern int sym_dict_max;
extern int log_sym_dict_max;
extern int mask_sym_dict_max;
extern int subsp_dict_max;
extern int log_subsp_dict_max;
extern int mask_subsp_dict_max;
extern int stubs_dict_max;
extern int log_stubs_dict_max;
extern int mask_stubs_dict_max;
#else
#define sym_dict_max            SYM_DICT_MAX
#define log_sym_dict_max        SYM_DICT_LOG
#define mask_sym_dict_max       (SYM_DICT_MAX-1)
#define subsp_dict_max          SUBSP_DICT_MAX
#define log_subsp_dict_max      SUBSP_DICT_LOG
#define mask_subsp_dict_max     (SUBSP_DICT_MAX-1)
#define stubs_dict_max          STUBS_DICT_MAX
#define log_stubs_dict_max      STUBS_DICT_LOG
#define mask_stubs_dict_max     (STUBS_DICT_MAX-1)
#endif

/* Default sizes for other internal tables */

#define		NODE_MAX	          4096
#define		MAX_SP_INDEX		    16
#define		SUBSP_AREA_MAX		500000
#define		SUBSP_FIXUP_AREA_MAX	250000
#define		STUB_AREA_MAX		  4000
#define		LIB_AREA_MAX		 60000
#define		SOM_AREA_MAX		 10000
#define		SOM_STR_AREA_MAX	 10000
#define		MAX_ARGC		  1000
#define		MAX_SOM_LIST		  1000
#define		MAX_TRACE_LIST		    20
#define		MAX_UNDEF_LIST		    20
#define		MAX_HIDE_LIST		  1000
#define		MAX_DIR_LIST		    20
#define         MAX_SUBPROG_LIST	    20
#define         MAX_FORGET_LIST		    20
#define         MAX_SHLIBEXP_LIST	  1000
#define         MAX_PROMOTION_LIST          20
#define         MAX_ABSOLUTE_LIST           20
#define		SPACE_STRINGS_MAX         1024
#ifndef NO_MULTIPLE_INITIALIZERS
#define		MAX_INITIALIZER_LIST	    20
#endif 

#define         QUAD_1_BASE     0x40000000


