/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  External Definitions for String Manipulation Routines
 *
 */

# if 0
#pragma NO_SIDE_EFFECTS lib_hash_string, hash_string
# endif
extern unsigned int	lib_hash_string();

extern void		strings_initialize();
extern void		gen_string_table();
extern void		purge_string_table();
extern void		purge_string_table_hash();
extern void		strings_read();
extern char            *add_string();
extern int              out_string_table();
extern int              sizeof_string_table();
extern char            *string_ptr_linear();
extern int              string_offset_linear();
extern void             build_string_sort();
extern int 		string_offset_sorted();

/* Buffers for hold ing raw strings for one .o as we read them from disk */
extern struct str_seg sym_str_buffer;
extern struct str_seg space_str_buffer;

/* String table to hold strings from all input files */
extern struct string_table sym_strings;
extern struct string_table tmp_strings;
extern struct string_table space_strings;

#define STRDUPHASHSIZE           1103   /* size of string hash table          */
#define SYMBOL_STRING_HASH_SIZE  52009  /* size of symbol string hash table   */

#define MIN_STRBLK_ALLOCATION    0x20000 /*  128k, space for storing string data */
#define MIN_STRREAD_ALLOCATION   0x20000 /*  128k, space for reading in data     */
#define STRSEG_ALLOCATION        100     /* growth inc for string seg array    */
#define STR_HASHNODE_ALLOCATION  0x30000  /* 192k, 16k hash records             */

struct stringnode {                 /* string table hash node                */
    char *str_ptr;                  /* pointer to string                     */
    unsigned hashval;               /* hash value of string                  */
    struct stringnode *next;        /* next hash node                        */
};

struct str_seg {
    char *block_ptr;                /* ptr to string data                    */ 
    int size;                       /* bytes used in this block              */
};

struct string_table {

    struct stringnode **hash_table; /* optional hash table                   */
    int hash_bucket_size;           /* number of hash buckets                */
    char *free_hnode_blk;           /* block of free hash nodes              */
    int free_hnode_offset;          /* offset into block of next free node   */ 

    int strblk_allocation_hint;     /* hint for allocating string space      */ 
    struct str_seg *seg_array;      /* array of string segments              */
    int total_segments;             /* total segment size available          */
    int open_segment;               /* segment we are currently filling      */
    int open_segment_bytes_free;    /* bytes free in segment we are filling  */

    struct str_seg *sort_array;     /* optional sort array for ptr lookup    */
    struct str_seg *inorder_array;  /* optional array for ptr lookup         */
    int cur_srch_segment;           /* current seg searched for ptr lookup   */ 
};


/* FUNCTION PROTOTYPES */

unsigned int hash_string(const char *s);
