/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  
 *  Linkmap-related operations
 *
 */

/*
 * Internal interfaces to the linkmap functionality
 */

/* hash table/min allocation definitions*/
#define LM_HASHTBL_SIZE			1003
#define LM_STRNODE_ALLOC		100
#define LM_OBJFTBL_ALLOC		100
#define LM_ISCONTR_ALLOC		20
#define LM_BSYMTBL_ALLOC		20
#define LM_BSUBTBL_ALLOC		100

#define LM_READBUF_SIZE			8192
#define LM_WRITEBUF_SIZE		8192

#define LM_ALIGN_2(x) (((x)+1)&(~1))
#define LM_ALIGN_4(x) (((x)+3)&(~3))
#define LM_ALIGN_8(x) (((x)+7)&(~7))

/* string table 			*/
typedef struct linkmap_str_node {
  unsigned int 				offset;
  unsigned int 				hashval;
  struct linkmap_str_node		*next;
} lm_stn;

typedef struct linkmap_str_table {
  char 					*data;
  unsigned int				data_size;
  unsigned int				cur_offset;
  struct linkmap_str_node		*hash_table[LM_HASHTBL_SIZE];
} lm_st;

/* object file table 			*/
typedef struct object_file_table_entry {
  LM_file_entry_info 			file_entry;
  unsigned int 				compsize;
  unsigned int 				file_index;
  unsigned int                          subsp_bias;
} lm_ofte;

typedef struct object_file_table {
  unsigned int 				num_entries;
  struct object_file_table_entry 	*entries;
} lm_oft;

/* bss symbols 				*/
typedef struct bss_symbol_table_entry {
  unsigned int 				sym_index;
  unsigned int 				length;
} lm_bste;

typedef struct bss_symbol_table {
  unsigned int 				num_entries;
  struct bss_symbol_table_entry		*entries;
} lm_bst;

/* map symbol index -> output address  	*/
typedef struct bss_symaddr_entry {
  unsigned int				subsp_index;
  unsigned int				out_addr;
  unsigned int				bst_index;
} lm_bsae;

/* bss subspaces 			*/
typedef struct bss_subspace_table_entry {
  unsigned int 				subsp_index;
  unsigned int                          out_addr;
  unsigned int				length;
  unsigned int				in_subsp_index;
} lm_bsste;

typedef struct bss_subspace_table {
  unsigned int				num_entries;
  struct bss_subspace_table_entry	*entries;
} lm_bsst;

/* linkmap input contribs 		*/
typedef struct input_subsp_contrib {
  LM_mapping_info			map;
  struct input_subsp_contrib		*next;
} lm_isc;


/* mode flags 				*/
enum lm_mode {
	DEFAULT, 
	CREATE, 
	SUPPRESS
};

/* useful macros			*/
#define lmi_string_at(offset) (st_in.data+(offset))
#define lmi_set_subspace_length(idx, length) {\
  Subsp_Dict(idx).subspace_length = (length);\
  Subsp_Dict(idx).initialization_length = (length);\
}
#define lmi_strip_subspace(idx) {\
  Subsp_Misc(idx).is_doom_stripped = TRUE;\
  lmi_set_subspace_length((idx), 0);\
}
#define lmi_init_subspace(idx) {\
  space_array[Subsp_Dict(idx).space_index].is_loadable = FALSE;\
  space_array[Subsp_Dict(idx).space_index].is_private  = 1;\
  Subsp_Dict(idx).is_loadable = FALSE;\
  Subsp_Dict(idx).fixup_request_quantity = 0;\
  Subsp_Misc(idx).is_undefined_region = TRUE;\
  Subsp_Misc(idx).is_linkmap_entry = FALSE;\
  Subsp_Misc(idx).data_file_offset = IN_MEMORY;\
  /* \
   * assign to 4, so that assign_file_locations() would\
   * provide an initial starting address of the subspace\
   */\
  lmi_set_subspace_length(idx, 4);\
}                 
#define lmi_init_contrib(c) {\
  c->map.file_index = LM_INVALID_IDX;\
  c->map.size = 0;\
  c->map.offset = 0;\
  c->next = NULL;\
}


