
/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  $Header: /home/cvs/cvsroot/linker/get_text_off.c,v 1.1.1.1 1999/10/18 19:53:02 pschwan Exp $
 */

/* When used in dld.sl, we don't want to include header files because they
** are already included in dld.c
*/

#ifndef IS_DLD
#include "get_text_off.h"
#include <scnhdr.h>
#endif

/*********************************************************************** 
   DEFINES
      CLEANUP_RETURN		Free any buffers that were malloc'ed.
				The pointers may be NULL.
				For dld.sl, we need to use dld_free and
				dld_malloc instead of free and malloc.
      MALLOC			The malloc routine to use.
***********************************************************************/

#ifdef IS_DLD
#define CLEANUP_RETURN(status)				\
			dld_free(string_table);		\
			dld_free(dictionary_table);	\
			return (status);

#define MALLOC		dld_malloc
#else /* else not IS_DLD */
#define CLEANUP_RETURN(status)				\
			free(string_table);		\
			free(dictionary_table);		\
			return (status);
#define MALLOC		malloc
#endif /* else not IS_DLD */


 
/*********************************************************************** 
   get_text_offset - return the offset from the where text is mapped in
	to where the actual contents are.  In a shared library or
	shared bound program, the dl_header will be there.

	The subspace dictionary is searched for "$SHLIB_INFO$".  The difference
	between its file_loc_init_value and the value of exec_tfile in
	the SOM aux header is the offset which is returned.

   Return value:	The offset from the start of text in the file 
			(exec_tfile) to where the contents actually start.
			exec_tfile is on a page boundary but with 
			+mindisk, the actual contents may start at  a later
			point.

			-1 is returned if an error is encountered.

   Arguments:
	file_id		The file descriptor of the object file.
	somheader_p	NULL or a pointer to the file header which has
			already been read in.
	auxheader_p	NULL or a pointer to the SOM aux header which
			has already been read in.
***********************************************************************/

int get_text_offset(int 		file_id, 
		    struct header* 	somheader_p, 
		    AOUTHDR* 		auxheader_p)
{
   AOUTHDR				auxheader;
   int					count;
   struct subspace_dictionary_record*	dictionary_entry_p;
   struct subspace_dictionary_record*	dictionary_table;
   int					dictionary_size;
   struct header			somheader;
   char*				string_table;

   /* dictionary_table and string_table are NULL until we malloc space 
   ** for them 
   */
   dictionary_table  = NULL;
   string_table = NULL;

   /* If necessary, read in the somheader */

   if (!somheader_p) {
      somheader_p = &somheader;
      if (lseek(file_id, 0, SEEK_SET) == -1) { return -1; }
      if (   read(file_id, (void*) &somheader, sizeof (struct header))
	  != sizeof (struct header)) {
	   
	 return -1;
      }
   }

   /* If necessary, read in the auxheader */

   if (!auxheader_p) {
      auxheader_p = &auxheader;
      if (lseek(file_id, somheader_p->aux_header_location, SEEK_SET) == -1) { 
	  return -1; 
      }
      if (   read (file_id, (void*) &auxheader, sizeof (AOUTHDR)) 
	  != sizeof (AOUTHDR)) {
	 return -1;
      }
   }

   /* Read in the string table */

   string_table = (char*) MALLOC(somheader_p->space_strings_size);
   if (!string_table) {
      return -1;
   }
   if (lseek(file_id, somheader_p->space_strings_location, SEEK_SET) == -1) {
      CLEANUP_RETURN(-1);
   }
   if (   read (file_id, string_table, somheader_p->space_strings_size) 
       != somheader_p->space_strings_size) {
      CLEANUP_RETURN(-1);
   }

   /* Read in the subspace dictionary */

   dictionary_size =   somheader_p->subspace_total 
		     * sizeof(struct subspace_dictionary_record);
   dictionary_table = (struct subspace_dictionary_record*) 
			MALLOC(dictionary_size);
   if (lseek(file_id, somheader_p->subspace_location, SEEK_SET) == -1) {
      CLEANUP_RETURN(-1);
   }
   if (   read(file_id, (void*) dictionary_table, dictionary_size) 
       != dictionary_size) {
      CLEANUP_RETURN(-1);
   }

   /* Search the subspace dictionary for $SHLIB_INFO$.  If not found, return
   ** zero.
   */


   dictionary_entry_p = dictionary_table;
   for (count = 0;  count < somheader_p->subspace_total;  count++) {
       if (   strcmp(string_table + dictionary_entry_p->name.n_strx, 
                     "$SHLIB_INFO$")
	   == 0) {
	 /* If we find "$SHLIB_INFO$", return the offset */
	  return(  dictionary_entry_p->file_loc_init_value 
		 - auxheader_p->exec_tfile);
       } /* If we find "$SHLIB_INFO$", return the offset */
       dictionary_entry_p++;
   }  /* for each subspace, look for $SHLIB_INFO$ */
   CLEANUP_RETURN(0);
   return 0;
} /* end get_text_offset */
