/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Fixup Definitions and Typedefs
 */

/* Linker-only fixup expression types */

#define e_pc_subsp_rel		16	/* for pc-rel branches to stubs */
#define e_pcrel_stub		17	/* for pc-rel branches from stubs */

/* Linker-only fixup formats */

#define i_ble_stub		32	/* to change ble into bl to stub */
#define i_new_ble		33	/* to change bl into ble */

/* check for overflow beyond given range of bits  */

#define OFL(a, bits)	(((int)(a)>(1<<((bits)-1))-1) || \
((int)(a)<((-1)<<((bits)-1))))

/* extracts quadrant bits from a space offset */
#define GET_QUAD(x) (((x) >> 30) & 03)

#define NOT_ALIGNED(x)  (((int)(x) & 03) != 0)
#define ALIGNED(x)      (((int)(x) & 03) == 0)

#define NULLIFY_BIT     2

typedef unsigned char Fixup;

/* Local Fixup related defines */

#define REGION_SHIFT    27
#define REGION_MASK     (3<<REGION_SHIFT)
#define NOT_ENTRY       (2<<REGION_SHIFT)
#define NOT_EXIT        (1<<REGION_SHIFT)

/* max, mins and sizes for line table entries */
#define LINE_DIFF_MAX   127  
#define LINE_DIFF_MIN  -128 
#define CODE_DIFF_MAX   250 

/* the following size are in bytes */
#define LINE_ENT_SZ       2  
#define SEC_ENT_SZ        4 
#define ABS_ENT_SZ        6 
#define ABS_ENT           253 
#define INIT_LINE_ENT_SZ 14 

#define NO_OVERRIDE     -1

/* Used in calls to fix_format where the sr field  */
/* (for i_abs17 formats) is known a priori         */
#define SR_IS_VALID	-1
#define SR_IS_SOURCE	-2

/* Defines for fix_instruction() to tell it what value you want returned */
#define RET_CONSTANT 	1
#define RET_EXPRESSION 	2
#define RET_WORD 	3

/* special rounding formula for e_lrsel and e_rrsel fixup_fields */
#define HALF_FIXUP_ROUND_VALUE  0x1000
#define FIXUP_ROUND(c)  (((c) + 0x1000) & ~0x1fff)

/* Globals */

extern struct loader_fixup *loader_fixup_array;
extern int		loader_fixup_size;
extern int		loader_fixup_index;
extern int		fixup_file_offset;
extern int		fixup_area_first;
extern int   fixup_area_count;
extern int   fixup_fildes;
extern int   subsp_fixup_area_max;
extern Fixup *subsp_fixup_area;
extern int   old_fixup_area_max;
extern struct fixup_request_record      *old_fixup_area;
extern char  *fixup_file;
extern int   unwind_count;
extern int   recover_count;
extern int   aux_unwind_count;
extern int   fru_unwind_count;
extern int   fru_recover_count;
extern int   fru_stub_unwind_count;
extern int   line_table_size;
extern int   copyram_count;
extern int   copyram_space_count;

#ifdef TSD /* TSD */
extern int    tpoff;
#endif /* TSD */

extern struct aux_udesc curr_aux_unwind;
extern int unwind_subsp;
extern int unwind_end_subsp;
extern int recover_subsp;
extern int recover_end_subsp;

extern Boolean generate_aux_unwind;
extern Boolean old_format_file;
extern int field_sel;
extern int default_mode;
#ifdef PA_2_0
extern Boolean is_pcrel_short;
#endif /* ifdef PA_2_0 */
extern int branch_dot;
extern int original_branch_dot;
extern Boolean new_ble_flag;
extern Boolean data_override;
extern int data_override_value;
extern Boolean sec_stmt_override;
extern int exec_level_override;
extern int sym_bias;
extern int fixup_subsp;
extern Boolean initial_fixup_pass;
extern Boolean new_ble_flag;
extern int dollar_global_addr; /* virtual address of $global$, 
				  cached for opt decisions */
extern Boolean dyncall_external_used;

# if 0
/* optimization pragmas to enhance optimization */
#pragma NO_SIDE_EFFECTS fix_field, fix_format, fix_instruction, get_prefix
#pragma NO_SIDE_EFFECTS get_constant, indx_of_code_plab_DLT_entry
#pragma NO_SIDE_EFFECTS PLT_index_of_sym, decode_arg_reloc
#pragma NO_SIDE_EFFECTS find_export_stub_sym, find_orig_sym, same_quadrant
# endif

extern void		do_fixups();
extern int		fix_field();
extern int		fix_format();
extern void             fixups_initialize();
extern void             fixups_read();
extern void		diagnose_fixup();
extern struct stub_record *find_stub_at_offset();

extern int get_prefix(int expected, int override);

/* New fixup info */

#define MAX_NEW_FIXUP_LEN	12
#define PSZ     4       /* number of previous fixups to maintain */

extern Fixup static_fixup_area[];

/* Special fixups for the linker */

#define R_ANNOTATE      (R_RESERVED+0x00)
#define R_NOP           (R_RESERVED+0x01)
#define R_NEW_BLE       (R_RESERVED+0x02)
      /* Old R_PCREL_TO_STUB, (R_RESERVED+0x03) no longer used */
#define R_ABS_DATA	(R_RESERVED+0x04) /* Visible to SAS, don't change*/
#define R_ABS_CODE	(R_RESERVED+0x05) /* Visible to SAS, don't change*/
#ifndef R_EXEC_LEVEL
#define R_EXEC_LEVEL	(R_RESERVED+0x06)
#endif
#define R_NOP_CLR_OVERRDS (R_RESERVED+0x07) /* and (R_RESERVED+0x08) */
#define R_PCREL_TO_STUB (R_RESERVED+0x09) /* and (R_RESERVED+0x0A) */
#define R_ANNOTATE_PREV (R_RESERVED+0x0B)

struct fix_desc {
    unsigned char type  ;     /* must be at least 8 bits */
    unsigned char knt   ;     /* must be at least 8 bits */
    unsigned char len   ;     /* must be at least 4 bits */
    unsigned char arg0  ;     /* must be at least 5 bits */
    unsigned char arg1  ;     /* must be at least 5 bits */
    unsigned char arg2  ;     /* must be at least 5 bits */
    } ;

#define GET_OP(x)   (((x) >> 26) & 0x0000003f)	/* get opcode */
#define GET_LINK(x) (((x) >> 21) & 31)	/* get link register */
#define GET_EXT3(x) (((x) >> 13) & 7)	/* get "ext3" field - to distinguish
					   between BL/BLR/BV/GATE insts */
#define GET_BIT29(x) (((x) >> 2) & 1)   /* distinguish FLDW/STWMC  FSTW/LDWMC */
#define GET_BIT30(x) (((x) >> 1) & 1)   /* distinguish LDD/FLDD, STD/FSTD  */

#define EXT_DEP(val,es,ed,len)   \
    ((unsigned int)(val) >> (31-es) << (32-len) >> (32-len) << (31-ed))

#define S_EXT_DEP(val,es,ed,len) \
    ((int)(val) >> (31-es) << (32-len) >> (32-len) << (31-ed))

#define EXP14(x)         (EXT_DEP(x,18,31,1)    \
                        | EXT_DEP(x,31,30,13))

#ifdef PA_2_0
#define EXP14LONGDISP(x) (EXT_DEP(x,18,31,1)    \
                        | EXT_DEP(x,29,28,11))
#define EXP14LONGDISPDBL(x) (EXT_DEP(x,18,31,1)    \
                        | EXT_DEP(x,28,27,10))
#endif /* ifdef PA_2_0 */

#define EXP21(x)         (EXT_DEP(x,11,31,1)    \
        		| EXT_DEP(x,22,30,11)   \
        		| EXT_DEP(x,24,17,2)    \
        		| EXT_DEP(x,29,15,5)    \
        		| EXT_DEP(x,31,19,2))
#define EXP11(x)         (EXT_DEP(x,21,31,1)    \
        		| EXT_DEP(x,31,30,10))
#define REL17(x)         (EXT_DEP(x,13,31,1)    \
        		| EXT_DEP(x,18,15,5)    \
        		| EXT_DEP(x,19,29,1)    \
        		| EXT_DEP(x,29,28,10))
#ifdef PA_2_0
#define REL22(x)         (EXT_DEP(x, 8,31,1)    \
        		| EXT_DEP(x,13,10,5)    \
        		| EXT_DEP(x,18,15,5)    \
        		| EXT_DEP(x,19,29,1)    \
        		| EXT_DEP(x,29,28,10))
#endif /* ifdef PA_2_0 */

#define ABS17   REL17
#define REL12(x)         (EXT_DEP(x,18,31,1)    \
        		| EXT_DEP(x,19,29,1)    \
        		| EXT_DEP(x,29,28,10))

#define GET14(x)         (S_EXT_DEP(x,31,18,1)  \
                        | EXT_DEP(x,30,31,13))

#ifdef PA_2_0
#define GET14LONGDISP(x) ((S_EXT_DEP(x,31,18,1)  \
                        | EXT_DEP(x,28,29,11)))
#define GET14LONGDISPDBL(x) ((S_EXT_DEP(x,31,18,1)  \
                        | EXT_DEP(x,27,28,10)))
#endif /* ifdef PA_2_0 */

#define GET21(x)         (S_EXT_DEP(x,31,11,1)  \
        	        | EXT_DEP(x,30,22,11)   \
        	        | EXT_DEP(x,17,24,2)    \
        	        | EXT_DEP(x,15,29,5)    \
        	        | EXT_DEP(x,19,31,2))
#define GET11(x)         (S_EXT_DEP(x,31,21,1)  \
        	        | EXT_DEP(x,30,31,10))
#define GET17(x)         (S_EXT_DEP(x,31,13,1)  \
        	        | EXT_DEP(x,15,18,5)    \
        	        | EXT_DEP(x,29,19,1)    \
        	        | EXT_DEP(x,28,29,10))
#ifdef PA_2_0
#define GET22(x)         (S_EXT_DEP(x,31,8,1)   \
                        | EXT_DEP(x,10,13,5)    \
        	        | EXT_DEP(x,15,18,5)    \
        	        | EXT_DEP(x,29,19,1)    \
        	        | EXT_DEP(x,28,29,10))
#endif /* ifdef PA_2_0 */
#define GET12(x)         (S_EXT_DEP(x,31,18,1)  \
        	        | EXT_DEP(x,29,19,1)    \
        	        | EXT_DEP(x,28,29,10))

/* ANNOTATE RECORD */

struct annotate_record {
    struct annotate_record *next;
    Fixup *location;
/* THIS IS A PLACE WHERE THE BYTES WILL BE STORED */
    } ;

/* UNWIND DESCRIPTION */
struct udesc {
    unsigned int start;
    unsigned int end;
    unsigned int flags;
    unsigned int fsize;
    };

/* AUX UNWIND ENTRY DESCRIPTION */
struct aux_udesc {
    char *cu_name;
    char *scope_name;
    int scope_kind;
    char *line_number_tbl;
    };

/* RECOVER DESCRIPTION */
struct rdesc {
    unsigned int start;
    unsigned int end;
    unsigned int recover;
    };


/* COPYRAM ENTRY DESCRIPTION */
/* It is either a space entry of a size entry */
/* old style - union copyram_desc {
    struct {
        unsigned int from_addr;
        unsigned int to_addr;
        } space_entry;
    struct {
        unsigned int size;
        unsigned int initialize:1;
        unsigned int end_space:1;
        unsigned int end_table:1;
        unsigned int reserved:29;
        } size_entry;
    };

*/


/* COPYRAM ENTRY DESCRIPTION */
/* It is either a space entry of a size entry */
union copyram_desc {
    struct {
        unsigned int addr;
        } space_entry;
    struct {
        unsigned int initialize:1;
        unsigned int reserved:7;
        unsigned int size:24;
        } size_entry;
    };


#define REG_MASK  (~0x03e00000)  /* mask to zero ADDIL/LDW reg field */
#define R27_MASK    0x03600000   /* mask to set reg = DP in ADDIL/LDW */

#ifdef FDP_CODE
#define branch_counter_string "_LB_COUNT"
#endif

#define IS_BAD_SYM(sym_idx) (sym_idx < 0 || sym_idx + sym_bias >= sym_dict_size)

#define CHECK_SUBSP_SYM(sym_idx) if (IS_BAD_SYM(sym_idx)) {		\
				     check_subsp_sym(sym_idx);		\
				 }

void check_subsp_sym(int sym_idx);

/* Enum for calling a subroutine from recursive_fixups */
typedef enum { 	CHECK_FOR_ABS_FIXUP,
		DEAD_PROC_PASS,
		UNWIND_AND_RECOVER_FIXUPS,
		OPTIMIZE_PASS,
		DELETE_INSTRUCTIONS,
		ADJUST_INSTRUCTIONS,
		APPLY_FIXUPS,
		RELOCATE_FIXUPS,
		CHECK_FOR_STUBS } fixup_routine; 
