/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *  Fixup Manipulation Routines
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define _SVID_SOURCE /* tempnam() --pschwan@thepuffingroup.com */
#include <stdio.h>
#undef _SVID_SOURCE

#include <string.h>
#include <sys/param.h>

#ifndef DEBUG
#define NDEBUG
#endif 
#include <assert.h>
#include <stdlib.h>

#include "filehdr.h"
#include "aouthdr.h"
#include "spacehdr.h"
#include "scnhdr.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "driver.h"
#include "errors.h"
#include "fixups.h"
#include "libraries.h"
#include "ldlimits.h"
#include "linker.h"
#include "output.h"
#include "shl.h"
#include "spaces.h"
#include "ld_strings.h"
#include "stubs.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#include "o2n_tally.h"
#include "stub_inst.h"
#include "bv_dense.h"
#include "opt.h"
#include "embed.h"

#include "linuxutil.h" /* --pschwan@thepuffingroup.com */

#ifdef WW_ANNOTATIONS
#include "annotate.h"
#endif /* WW_ANNOTATIONS */

#include "debug_opt.h"

/* the following masks are used to set to zero the old value in the various
   fields before oring in the new values */

#define mask_exp14  ~EXP14(-1)

#ifdef PA_2_0
#define mask_exp14longdisp	~EXP14LONGDISP(-1)
#define mask_exp14longdispdbl	~EXP14LONGDISPDBL(-1)
#endif /* PA_2_0 */

#define mask_exp21  ~EXP21(-1)
#define mask_exp11  ~EXP11(-1)
#define mask_rel12  ~REL12(-1)
#define mask_rel17  ~REL17(-1)

#ifdef PA_2_0
#define mask_rel22  ~REL22(-1)
#endif /* PA_2_0 */

#define mask_abs17  ~ABS17(-1)

#define ABSOLUTE    0
#define RELOCATABLE 1
#define BUFF_BYTE_SIZE  8192

#define IS_EXPORT(index) (Sym_Dict(index).symbol_type==ST_STUB_ENTRY || \
			  Sym_Dict(index).symbol_type==ST_STUB_PRI_PROG || \
			  Sym_Dict(index).symbol_type==ST_STUB_SEC_PROG)

#define IS_DATA(index) (Sym_Dict(index).symbol_type==ST_DATA || \
		 	Sym_Dict(index).symbol_type==ST_STORAGE)

#define IS_LOADABLE(subsp_index) \
		 (space_array[Subsp_Dict(subsp_index).space_index].is_loadable)

#define IS_PRIVATE(subsp_index) \
		 (space_array[Subsp_Dict(subsp_index).space_index].is_private)

#define output_flush(buff, loc, size)  \
    fdump(out_som_fd, (loc), (buff), 1, (size))    

/* Globals */

struct loader_fixup *loader_fixup_array = NULL;
int		loader_fixup_size;
int		loader_fixup_index;
int		fixup_file_offset = 0;
int		fixup_area_first;
int		fixup_area_count;
int		fixup_fildes = -1;
int		subsp_fixup_area_max = SUBSP_FIXUP_AREA_MAX;
Fixup	        *subsp_fixup_area = NULL;
char		*fixup_file;
int             old_fixup_area_max = 0;
struct fixup_request_record         *old_fixup_area = NULL;
struct aux_udesc curr_aux_unwind;

/* HP-UX shared library support */
int code_plab_DLT_entry_count = 0;
        /* number of symbols seen in R_CODE_PLABEL fixups */
        /* global for use in output.c */

#define UNSET	(-2)
int unwind_subsp = UNSET;
int unwind_end_subsp = UNSET;
int recover_subsp = UNSET;
int recover_end_subsp = UNSET;

/* variables associated with a pass over the fixups */

int     branch_dot;
int     original_branch_dot;
int     sym_bias;
int     fixup_subsp;
Boolean generate_aux_unwind = FALSE;
int     use_opt_sym_values = 0;

/* overrides and modes for fixups */

Boolean old_format_file;
int     field_sel;
int     default_mode;

#ifdef PA_2_0
Boolean is_pcrel_short;
#endif /* ifdef PA_2_0 */

Boolean new_ble_flag;
Boolean data_override;
Boolean rnd_mode_override;   /* missing code from 2.27 LE */
int     data_override_value;
Boolean sec_stmt_override;
int     exec_level_override;
static Boolean ltp_override;

#ifdef TSD /* TSD */
static Boolean tp_override;
extern int tsd_addr;
extern Boolean seen_tls;
#endif /* TSD */

Boolean initial_fixup_pass;

int     unwind_branch_dot;
int     recover_branch_dot;

int     copyram_entry_start;

/* Assume "safe" values for default.  They will be set properly,
   but just in case...  */
Boolean bl_seen_in_subspace = TRUE;
Boolean bl_seen_in_aout = TRUE;
Boolean truncate_fixups = FALSE;
Boolean uninit_seen = FALSE;

#define NO_ENTRY_STATE  0
#define ENTRY_STATE     1
#define INITIAL_STATE   2

int unwind_bits;
int frame_size;

extern int elaborator_index;

extern Boolean do_procedure_fdp;
extern Boolean dyncall_external_off;
extern Boolean mixed_mode_off;

int unwind_count;
int recover_count;
int aux_unwind_count;
int line_table_size;
int fru_unwind_count;
int fru_recover_count;
int fru_stub_unwind_count;
int fru_line_table_size;
int copyram_count;          /* the number of copyram entries needed */
int copyram_space_count;    /* the number of copyram entries needed */
Boolean last_was_uninit;

/* virtual addr of $global$, cached for opt decisions */
int dollar_global_addr;	    
int dollar_global_space;    /* space index where $global$ resides */
Boolean in_branch_table;    /* Are we currently in a branch table? used to 
			       disable optimization. */
int last_seen_brtab_end;    /* instruction number offset of the end of the 
			       last seen branch table */

/* $$dyncal_external millicode for OGL support */
int    dyncall_external;
char   dyncall_external_string[] = "$$dyncall_external";
char   dyncall_external_20_string[] = "$$dyncall_external_20";
Boolean dyncall_external_used = FALSE;
/* WILL BE IN stub_inst.s */
extern int  dollar_global;
extern int  dollar_global_space;
extern int  milli_label;
extern int  sr4export_sym;
extern char unw_start[];
extern char unw_end[];
extern char rcv_start[];
extern char rcv_end[];
extern char dollar_global_string[];
extern char milli_label_string[];
extern char sr4export_string[];
extern int  abs_fix_base;
extern Boolean use_PUT_table;
extern int branch_counter_sym;

/* Locals and FORWARD declarations */

void diagnose_fixup();
struct annotate_record *find_annotation();
Fixup *apply_fixups();
static unsigned char *out_buffer;  /* ptr to buffer on stack, 
					used in various routines */
static unsigned char *buff_ptr;
static unsigned char *subsp_data;
static unsigned char	*current_subspace_start_p;

static Boolean first_time_this_subspace;

/* static */  Boolean doing_pcrel = FALSE;
static Boolean aux_unwind_seen = FALSE;
static Boolean new_line_table = TRUE;
static int     state_diagram;
static int     out_location;
static int     out_limit;
static int     TRY_COUNT = 0;

static int     full_expression;   /* used in fix_instruction and fix_format */
                                  /* for external millicode */

static Boolean N0_fixup_seen = FALSE; /* NO_DATA_COPY */
static int rewrite_shared_global_inst (int instruction, int sym); 

/* HP-UX shared library support */

static Boolean processing_DLT_REL = FALSE;  /* ugly kludge for right err msg */
 
struct c_plabel *code_plab_DLT_entry_list = NULL;

static struct import_entry NULL_IMPORT_REC = {-1,-1,ST_PLABEL,0,0,0}; 

struct PLT_hash_entry {
    char *name;	/* symbol table name string for this sym */
    unsigned int hashval;
    int PLT_index;	/* index into PLT */
    int sym_index;	/* original symbol index in PLT - 
				for use after PLT relocated */
    struct PLT_hash_entry *next;  /* direct chain link */
};

#define PLT_HASH_SIZE UNIVHASHSIZE
static struct PLT_hash_entry *PLT_hash_tbl[UNIVHASHSIZE];
				/* hash table for fast lookup of PLT offsets */
static struct PLT_hash_entry *get_PLT_hash_node(char *name,
						unsigned int hashval,
						int PLT_index,
						int sym_index);
static struct PLT_hash_entry *free_PLT_nodes = NULL; /* node pool */

#define TRY_STACK_SIZE 10

static struct TR_stack {
    int *values;
    int top;
    int size; /* size of stack (# of value entries) */
} try_stack = {0, -1, 0};

static Boolean applying_fixups = FALSE;

#define MIN_ANNOTATION_LEN	6

static Fixup *current_annotation = NULL;

/************************************************************************/

/* LOOKUP TABLE for fixup handling                                      */

#define NONE    0       /* no argument                                  */
#define D       1       /* use diff                                     */
#define LDx4    2       /* length = (diff+1) * 4                        */
#define LD_10x4 3       /* length = ((diff-24)*2^8+(8 bits)+1) * 4      */
#define LD_18x4 4       /* length = ((diff-28)*2^16+(8 bits)+1) * 4     */
#define L_4     5       /* length = 4                                   */
#define L_8x4   6       /* length = ((8 bits)+1) * 4                    */
#define L_8xD   7       /* length = ((8 bits)+1) * ARG0                 */
#define L_24    8       /* length = (24 bits)+1                         */
#define L_24x4  9       /* length = ((24 bits)+1) * 4                   */
#define L_32    10      /* length = (32 bits)+1                         */
#define U_8     11      /*  8 bits (unsigned)                           */
#define U_16    12      /* 16 bits (unsigned)                           */
#define U_24    13      /* 24 bits (unsigned)                           */
#define S_8     14      /*  8 bits (sign extended)                      */
#define S_16    15      /* 16 bits (sign extended)                      */
#define S_24    16      /* 24 bits (sign extended)                      */
#define X_32    17      /* 32 bits (sign extended or unsigned are same) */
#define AR_D    18      /* arg reloc (short form from diff)             */
#define AR_9    19      /* arg reloc (1 bit from diff and (8 bits))     */
#define FRAME   20      /* 8 bits for unwind, get frame from expression */
#define EXPR_V  21      /* get expression                               */
#define EXPR_T  22      /* get expression                               */

static struct fix_desc new_fix_table[] = {

    /*  type              ,knt, len,      arg0,   arg1,  arg2  */

    {   R_NO_RELOCATION   , 24,   1,      LDx4,   NONE,  NONE   },
    {   0                 ,  4,   2,      LD_10x4,NONE,  NONE   },
    {   0                 ,  3,   3,      LD_18x4,NONE,  NONE   },
    {   0                 ,  1,   4,      L_24,   NONE,  NONE   },
    {   R_ZEROES          ,  1,   2,      L_8x4,  NONE,  NONE   },
    {   0                 ,  1,   4,      L_24,   NONE,  NONE   },
    {   R_UNINIT          ,  1,   2,      L_8x4,  NONE,  NONE   },
    {   0                 ,  1,   4,      L_24,   NONE,  NONE   },
    {   R_RELOCATION      ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_DATA_ONE_SYMBOL ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_DATA_PLABEL     ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_SPACE_REF       ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_REPEATED_INIT   ,  1,   2,      L_4,    L_8x4, NONE   },
    {   0                 ,  1,   3,      L_8x4,  L_8xD, NONE   },
    {   0                 ,  1,   5,      L_8x4,  L_24x4,NONE   },
    {   0                 ,  1,   8,      L_24,   L_32,  NONE   },
    {   R_PCREL_CALL      , 10,   2,      AR_D,   U_8,   NONE   },
    {   0                 ,  2,   3,      AR_9,   U_8,   NONE   },
    {   0                 ,  2,   5,      AR_9,   U_24,  NONE   },
#ifdef PA_2_0
    /*  PA2.0 instructions */
    {   R_SHORT_PCREL_MODE,  1,   1,      NONE,   NONE,  NONE   },
    {   R_LONG_PCREL_MODE,   1,   1,      NONE,   NONE,  NONE   },
#endif /* ifdef PA_2_0 */
    {   R_ABS_CALL        , 10,   2,      AR_D,   U_8,   NONE   },
    {   0                 ,  2,   3,      AR_9,   U_8,   NONE   },
    {   0                 ,  2,   5,      AR_9,   U_24,  NONE   },
    {   R_DP_RELATIVE     , 32,   1,      D,      NONE,  NONE   },
    {   0                 ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    /* R_DATA_GPREL aCC support  */
    {   R_DATA_GPREL      ,  1,   4,      U_24,   NONE,  NONE   }, 
    {   R_INDIRECT_CALL   ,  1,   1,      NONE,   NONE,  NONE   }, /* OGL new */
    {   R_PLT_REL         ,  1,   4,      U_24,   NONE,  NONE   }, /* OGL new */
    {   R_DLT_REL         ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_CODE_ONE_SYMBOL , 32,   1,      D,      NONE,  NONE   },
    {   0                 ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_R19_LDST        ,  1,   1,      NONE,   NONE,  NONE   }, /* -B symb */
    {   R_MILLI_REL       ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_CODE_PLABEL     ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_BREAKPOINT      ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_ENTRY           ,  1,   9,      X_32,   X_32,  NONE   },
    {   0                 ,  1,   6,      X_32,   FRAME, NONE   },
    {   R_ALT_ENTRY       ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_EXIT            ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_BEGIN_TRY       ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_END_TRY         ,  1,   1,      NONE,   NONE,  NONE   },
    {   0                 ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   4,      S_24,   NONE,  NONE   },
    {   R_BEGIN_BRTAB     ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_END_BRTAB       ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_STATEMENT       ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   3,      U_16,   NONE,  NONE   },
    {   0                 ,  1,   4,      U_24,   NONE,  NONE   },
    {   R_DATA_EXPR       ,  1,   1,      EXPR_V, EXPR_T,NONE   },
    {   R_CODE_EXPR       ,  1,   1,      EXPR_V, EXPR_T,NONE   },
    {   R_FSEL            ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_LSEL            ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_RSEL            ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_N_MODE          ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_S_MODE          ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_D_MODE          ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_R_MODE          ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_DATA_OVERRIDE   ,  1,   1,      NONE,   NONE,  NONE   },
    {   0                 ,  1,   2,      S_8,    NONE,  NONE   },
    {   0                 ,  1,   3,      S_16,   NONE,  NONE   },
    {   0                 ,  1,   4,      S_24,   NONE,  NONE   },
    {   0                 ,  1,   5,      X_32,   NONE,  NONE   },
    {   R_TRANSLATED      ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_AUX_UNWIND      ,  1,   12,     U_24,   X_32,  X_32   },
    {   R_COMP1           ,  1,   2,      U_8,    NONE,  NONE   },
    {   R_COMP2           ,  1,   5,      U_8,    U_24,  NONE   },
    {   R_COMP3           ,  1,   6,      U_8,    X_32,  NONE   },
    {   R_PREV_FIXUP      ,PSZ,   1,      D,      NONE,  NONE   },
    {   R_SEC_STMT        ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_N0SEL           ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_N1SEL           ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_LINETAB         ,  1,   9,      U_8,    U_24,  X_32   },
    {   R_LINETAB_ESC     ,  1,   3,      U_8,     U_8,  NONE   },
    {   R_LTP_OVERRIDE    ,  1,   1,      NONE,   NONE,  NONE   },
    /* This is to support WW_ANNOTATIONS */
    {   R_COMMENT         ,  1,   6,      U_8,    X_32,  NONE   },
#ifdef TSD /* TSD */
    {   R_TP_OVERRIDE     ,  1,   1,      NONE,   NONE,  NONE   },
#endif /* TSD */

      /* INTERNAL */
    {   R_ANNOTATE        ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_NOP             ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_NEW_BLE         ,  1,   1,      NONE,   NONE,  NONE   },
    {   R_EXEC_LEVEL      ,  1,   2,      U_8,    NONE,  NONE   },
    {   R_NOP_CLR_OVERRDS ,  1,   1,      NONE,   NONE,  NONE   },
    {   0                 ,  1,   2,      U_8,    NONE,  NONE   },
    {   R_PCREL_TO_STUB   ,  1,   2,      U_8,    NONE,  NONE   },
    {   0                 ,  1,   3,      U_16,   NONE,  NONE   },
    {   R_ANNOTATE_PREV   ,PSZ,   1,      D,      NONE,  NONE   },
    } ;

#define NEW_FIX_TAB_SIZE sizeof(new_fix_table)/sizeof(struct fix_desc)

/* map first byte of fixup into index into new_fix_table */
static unsigned char fixup_index[256];

/************************************************************************/

/* 
** multi-byte fixups that are ever annotated - i.e., that can be the
** subject of R_PREV fixups that will need to be expanded into their
** full original form in case the base fixup is annotated(changed). 
**
** Allow R_END_TRY fixup to be annotated for the purpose of ADDIL
** elimination. 
*/
#define IS_ANNOTATABLE(opcode)  ((opcode == R_DATA_PLABEL ||  \
				  opcode == R_DATA_PLABEL+1) || \
				 (eliminating_addils && \
				  (opcode >= R_DP_RELATIVE &&  \
				   opcode <= R_DP_RELATIVE+33)) || \
				 (opcode == R_CODE_PLABEL ||  \
				  opcode == R_CODE_PLABEL+1) || \
				 (opcode == R_COMP2) ||  \
				 (opcode >= R_PCREL_CALL &&  \
				  opcode <= R_PCREL_CALL+13) || \
				 (opcode >= R_ABS_CALL &&  \
				  opcode <= R_ABS_CALL+13) || \
				 (opcode >= R_END_TRY &&  \
				  opcode <= R_END_TRY+2) \
				)

/* move fixup "arg0" to head of R_PREV_FIXUP queue as most recently used */
#define MOVE_ARG0_TO_HEAD_OF_PREV_QUEUE \
                i = arg0; \
                order_index = order[i]; \
                for ( ; i != 0; i--) \
                    order[i] = order[i-1]; \
                order[0] = order_index

    /* PUT TABLE (for PREV fixup handling) */

static struct {
    Fixup *fixup;
    int len;
    } PUT_table[PSZ];  /* table of last PSZ (4) fixups used > 1 byte long */

static int order[PSZ];  /* implements priority queue for R_PREV fixups */
		     	/* contains indices into the PUT_table, in queue order.
		     	   order[0] holds the index in the PUT_table of 
			   the most recently used fixup */

void fixups_read(fil_ofs, nfixups)
int fil_ofs, nfixups;
{

    if (nfixups <= 0)
        return;

    if (save_fixups) {
        if (nfixups > subsp_fixup_area_max) {
            efree(subsp_fixup_area);
            subsp_fixup_area_max = nfixups + nfixups/4;
            subsp_fixup_area =
                (Fixup *) emalloc(subsp_fixup_area_max * sizeof(Fixup));
        }
    } else {
        subsp_fixup_area = (Fixup *) emalloc(nfixups);
    }

    ffetch(cur_fildes, fil_ofs, subsp_fixup_area, sizeof(Fixup), nfixups);

    /* dump fixups */
    if (save_fixups) {
        fdump(fixup_fildes, fixup_file_offset, subsp_fixup_area,
              sizeof(Fixup), nfixups);
        fixup_area_first = fixup_file_offset;
        fixup_area_count = nfixups;
        fixup_file_offset += nfixups * sizeof(Fixup);
    } else {
        /* relies on valid type coercion between int and pointer types */
        fixup_area_first = (int) subsp_fixup_area;
        fixup_area_count = 0;
    }

    /*
    ** so, after this routine, change the current header's
    ** fixup_request_index to be fixup_area_first
    */
} /* fixups_read */

void old_fixups_read(fil_ofs, nfixups)
int fil_ofs, nfixups;
{

    if (nfixups > 0) {
        if (nfixups > old_fixup_area_max) {
            if (old_fixup_area != NULL)
                efree(old_fixup_area);
            old_fixup_area_max = nfixups + nfixups/4;
            old_fixup_area = (struct fixup_request_record *)
                emalloc(old_fixup_area_max *
                        sizeof(struct fixup_request_record));
        }
        ffetch(cur_fildes,
               fil_ofs,
               old_fixup_area,
               sizeof(struct fixup_request_record),
               nfixups);
    }

    /* use_PUT_table is whether to emit PREV fixups or not. */
    /* The only time the linker emits PREV fixups is during */
    /* a relocatable link.  There is no point in doing it   */
    /* during this first translation phase, since they will */
    /* just be expanded again later.                        */
    use_PUT_table = FALSE;
    translate_fixups();

    if (save_fixups) {
        fixup_area_first = fixup_file_offset;
        fixup_file_offset += new_fixup_size * sizeof(Fixup);
        write_fixups(fixup_fildes, fixup_area_first);
    } else {
        if (new_fixup_size != 0) {
            subsp_fixup_area = (Fixup *) emalloc(new_fixup_size * 
						 sizeof(Fixup));
            transfer_fixups(subsp_fixup_area);
        } else
            subsp_fixup_area = NULL;
        fixup_area_first = (int) subsp_fixup_area;
    }

    fixup_area_count = 0;
} /* old_fixups_read */

/************************************************************************/
/*                      PASS OVER the FIXUPS                            */

/* FORWARD DECLARARATION */
Boolean recursive_fixups();

void traverse_fixups(subsp_index, routine)
int subsp_index;
fixup_routine routine;
{
    struct subspace_dictionary_record *subsp;
    int nfixups;
    Fixup *fixup;

    fixup_subsp = subsp_index;
    subsp = &Subsp_Dict(subsp_index);

    nfixups = subsp->fixup_request_quantity;
    if (nfixups <= 0)
        return;

    if (save_fixups) {
	ffetch(fixup_fildes,subsp->fixup_request_index,subsp_fixup_area,
		    sizeof(Fixup),
		    nfixups);
	fixup_area_first = subsp->fixup_request_index;
	fixup_area_count = nfixups;
        fixup = subsp_fixup_area;
    } else {
	fixup = (Fixup *) subsp->fixup_request_index;
    }

    old_format_file = FALSE;
    field_sel = NO_OVERRIDE;
    default_mode = R_N_MODE;
#ifdef PA_2_0
    is_pcrel_short = TRUE;  /* default mode for each new subspace */
#endif /* ifdef PA_2_0 */
    branch_dot = Subspace_Virtual_Offset(subsp_index) +
                 Subsp_Stubs_Size(subsp_index) + 2*WORDSIZE;
    original_branch_dot = branch_dot;
    data_override = FALSE;
    new_ble_flag = FALSE;
    sec_stmt_override = FALSE;
    exec_level_override = -1;
    rnd_mode_override = FALSE;  /* missing code from 2.27 LE */
    ltp_override = FALSE;
#ifdef TSD /* TSD */
    tp_override = FALSE;
#endif /* TSD */
    sym_bias = Subsp_Misc(subsp_index).symbol_index_bias;
    current_annotation = NULL;
    dyncall_external_used = FALSE;

    if (recursive_fixups(fixup, nfixups, &Subsp_Misc(subsp_index), routine) &&
        save_fixups) {
        /* recursive fixups is TRUE, if fixups have been altered */
	fdump(fixup_fildes,subsp->fixup_request_index,
	      subsp_fixup_area,
	      sizeof(Fixup),
	      nfixups);
    }

    /* simulate R_ZEROES fixup for remainder of subspace not covered by
       the fixups, to avoid leaving unexecable holes in the a.out */
    if (applying_fixups && (nfixups > 0) && subsp->is_common &&
	(branch_dot - original_branch_dot < Subspace_Length(subsp_index))) {
	struct fix_desc fix_info;
	fix_info.type = R_ZEROES;
	apply_fixups(&fix_info, 
		     NULL, 
		     Subspace_Length(subsp_index) -
				(branch_dot-original_branch_dot), 
		     0, 
		     0);
    }

    if (TRY_COUNT != 0)
       external_error(TRY_BLOCK_MISMATCH,
			Subsp_Misc(subsp_index).file_name, 0);
} /* end traverse_fixups */

/* defines for "recursive_fixups" */

#define GET_NO_ARGS	/* no args used, all entries must be NONE */	\
	assert( (fix_info->arg0 == NONE) && (fix_info->arg1 == NONE) && \
        	(fix_info->arg2 == NONE) )

#define GET_ONE_ARG	/* one arg used, arg1 and arg2 must be NONE */      \
    assert( (fix_info->arg1 == NONE) && (fix_info->arg2 == NONE) );         \
    arg0 = get_fix_arg(&memory_copy, fix_info->arg0, *fixup - fix_info->type)

#define GET_ONE_ARG_D	/* one unsigned arg used, from displacement */  \
    assert( (fix_info->arg1 == NONE) && (fix_info->arg2 == NONE) ); 	\
			/* arg1 and arg2 must be NONE */ 		\
    assert( fix_info->arg0 == D ); /* arg0 must be Displacement */ 	\
    arg0 = *fixup - fix_info->type;					\

#define GET_ONE_ARG_NO_RELOC	/* one arg for R_NO_RELOCATION */ 	\
    do { /* make a block to include declaration */			\
    register unsigned int diff = (*fixup - fix_info->type);		\
    assert( (fix_info->arg1 == NONE) && (fix_info->arg2 == NONE) ); 	\
			/* arg1 and arg2 must be NONE */ 		\
    switch (fix_info->arg0) {						\
        case LDx4:							\
   	    arg0 = diff+1;						\
            arg0 *= WORDSIZE;						\
   	    break;							\
        case LD_10x4:							\
     	    arg0 = ((diff-24) << 8) + *++memory_copy + 1;		\
            arg0 *= WORDSIZE;						\
   	    break;							\
        case LD_18x4:							\
   	    arg0 = ((diff & 3) << 8) + *++memory_copy;			\
   	    arg0 = (arg0 << 8) + *++memory_copy + 1;			\
            arg0 *= WORDSIZE;						\
   	    break;							\
        case L_24:							\
   	    arg0 =  *++memory_copy;					\
   	    arg0 = (arg0 << 8) + *++memory_copy;			\
   	    arg0 = (arg0 << 8) + *++memory_copy + 1;			\
            break;							\
        default:							\
            assert(FIXUP_ARG_WRONG == 0); /* FALSE */			\
        }								\
    } while (FALSE); /* close block */

#define GET_ONE_ARG_UNINIT	/* one unsigned arg used */ 		\
    assert( (fix_info->arg1 == NONE) && (fix_info->arg2 == NONE) ); 	\
			/* arg1 and arg2 must be NONE */ 		\
    assert( (fix_info->arg0 == L_8x4) || (fix_info->arg0 == L_24) ); 	\
    if (fix_info->arg0 == L_8x4) {					\
        arg0 = *++memory_copy + 1;					\
        arg0 *= WORDSIZE;						\
    } else { /* L_24 */							\
   	arg0 =  *++memory_copy;						\
   	arg0 = (arg0 << 8) + *++memory_copy;				\
   	arg0 = (arg0 << 8) + *++memory_copy + 1;			\
    }

#define GET_ONE_ARG_U	/* one unsigned arg used */ 			\
    assert( (fix_info->arg1 == NONE) && (fix_info->arg2 == NONE) ); 	\
			/* arg1 and arg2 must be NONE */ 		\
    switch (fix_info->arg0) {						\
        case D:								\
   	    arg0 = *fixup - fix_info->type;				\
   	    break;							\
        case U_8: /* changed from fall-through for better code gen */	\
   	    arg0 = *++memory_copy;					\
            break;							\
        case U_16: /* changed from fall-though for better code gen */	\
   	    arg0 = *++memory_copy;					\
   	    arg0 = (arg0 << 8) + *++memory_copy;			\
            break;							\
        case U_24: /* changed from fall-though for better code gen */	\
   	    arg0 = *++memory_copy;					\
   	    arg0 = (arg0 << 8) + *++memory_copy;			\
   	    arg0 = (arg0 << 8) + *++memory_copy;			\
            break;							\
        default:							\
            assert(FIXUP_ARG_WRONG == 0); /* FALSE */			\
        }

#define GET_TWO_ARGS	/* two args used, arg2 must be NONE */      	      \
    assert( (fix_info->arg2 == NONE) );     				      \
    arg0 = get_fix_arg(&memory_copy, fix_info->arg0, *fixup - fix_info->type);\
    arg1 = get_fix_arg(&memory_copy, fix_info->arg1, arg0)

#define GET_ALL_ARGS	/* all args used */				      \
    arg0 = get_fix_arg(&memory_copy, fix_info->arg0, *fixup - fix_info->type);\
    arg1 = get_fix_arg(&memory_copy, fix_info->arg1, arg0);	    	      \
    arg2 = get_fix_arg(&memory_copy, fix_info->arg2, arg1)


/*
**	have_PIC_long_call()
**
**	  Used to peek ahead in the fixup stream
**	to see if the next fixup after an R_PCREL_CALL is the same type,
**	for the same symbol.  If so, we can set R_LSEL/R_RSEL field
**	selectors for the fixups even if they haven't been already.
**
**  Now also look at ANNOTATE_PREV fixups following this
**	one, to see if it's for the same PCREL_CALL fixup.  Make this
**	recursive for this reason.
*/

static Boolean have_PIC_long_call(Fixup *fixup,
                                  struct subsp_misc_record *misc,
				  int cur_arg0,
				  int cur_arg1)
{
    Fixup *memory_copy = fixup;
    Fixup *temp_fixup;
    int i = fixup_index[*fixup];
    struct fix_desc *fix_info = &new_fix_table[i];
    struct annotate_record *annot;
    int arg0, arg1, arg2;

    switch (fix_info->type) {
	default:
	    return FALSE;

	case R_PCREL_CALL:
    	    GET_TWO_ARGS;
    	    if (cur_arg0 == arg0 && cur_arg1 == arg1)
		return TRUE;

    	    return FALSE;
	    break;

        case R_ANNOTATE_PREV:

            annot = find_annotation(fixup, misc);
                /* just using temp_fixup as a temporary */
            temp_fixup = (Fixup *) & annot[1];

	    return have_PIC_long_call(&temp_fixup[1],
				      misc,
				      cur_arg0,
				      cur_arg1);
            break;
    }
}  /* have_PIC_long_call */


Fixup *check_for_abs_fixup();
Fixup *dead_proc_pass();
Fixup *unwind_and_recover_fixups();
Fixup *optimize_pass();
Fixup *delete_instructions();
Fixup *adjust_instructions();
Fixup *relocate_fixups();
Fixup *check_for_stubs();

Boolean recursive_fixups(fixup, nfixups, misc, routine)
Fixup * fixup;
int nfixups;
struct subsp_misc_record *misc;
fixup_routine routine;
{

    struct annotate_record *annot;
    Fixup *memory_copy, *temp_fixup, *save_annotation;
    struct fix_desc *fix_info;
    int i, info_type;
    int arg0 = 0, arg1 = 0, arg2 = 0;
    int t0, t1;                 /* reference parameters to pop_expr() */
    Boolean ret_val, clear_overrides;
    int dot_movement, order_index;

    static just_expanded_prev_fixup = FALSE;

    static Boolean implicit_long_call = FALSE;

    ret_val = FALSE;

    for ( ; nfixups > 0; ) {
        i = fixup_index[*fixup];

        if (i == NEW_FIX_TAB_SIZE)
            external_error_hex(INVALID_FIXUP, *fixup,
	    			Subsp_Misc(fixup_subsp).file_name);

        fix_info = & new_fix_table[i];

	/* put fixups > one byte in R_PREV queue as most recently used */
        if ( fix_info->len > 1 && !just_expanded_prev_fixup) {
            /* don't put a newly expanded guy into the table */
            order_index = order[PSZ-1];
            for (i = PSZ-1; i != 0; i--)
                order[i] = order[i-1];
            order[0] = order_index;
            PUT_table[order_index].fixup = fixup;
            PUT_table[order_index].len = fix_info->len;
            }

        memory_copy = fixup;

        temp_fixup = NULL;
        dot_movement = 0;
        clear_overrides = FALSE;

        switch (fix_info->type) {

            /* OVERRIDES (handle these here) *********/

            case R_FSEL:
            case R_LSEL:
            case R_RSEL:
            case R_N1SEL:
		GET_NO_ARGS;
                field_sel = fix_info->type;
                break;

            case R_N0SEL:
            case R_R19_LDST:
		GET_NO_ARGS;
                break;

#ifdef TSD /* TSD */
	    case R_TP_OVERRIDE:
                GET_NO_ARGS;
                tp_override = TRUE;
                break;
#endif /* TSD */

	    case R_LTP_OVERRIDE:
		GET_NO_ARGS;
		ltp_override = TRUE;
		break;

            case R_N_MODE:
            case R_S_MODE:
            case R_D_MODE:
            case R_R_MODE:
		GET_NO_ARGS;
                default_mode = fix_info->type;
                rnd_mode_override = TRUE;  /* missing code from 2.27 LE */
                break;

	    /* OGL support $$dyncall_external for $$dyncall. */
            case R_INDIRECT_CALL:
		GET_NO_ARGS;
		if (!dyncall_external_off)  /* to support -Fz internal option */
		    dyncall_external_used = TRUE;
		break;

            case R_DATA_OVERRIDE:
		GET_ONE_ARG;
                data_override = TRUE;
                data_override_value = arg0;
                break;

            case R_SEC_STMT:
		GET_NO_ARGS;
                sec_stmt_override = TRUE;
                break;

	    case R_EXEC_LEVEL:
		GET_ONE_ARG;
		exec_level_override = arg0;
		break;

            case R_TRANSLATED:
                /* normally we will get only one R_TRANSLATED per subspace */
                /* but if we use the improved -r functionality, we might   */
                /* have more than one type of original file (TRANSLATED or */
                /* not TRANSLATED).                                        */
		GET_NO_ARGS;
                old_format_file = !old_format_file;
                break;

            case R_COMP1:
		GET_ONE_ARG;
                switch (arg0) {
                    case R_SUB:  /* put first - the only one ever used -  */
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */
                        /* TRICK: rely on RELOCATABLE == 1, ABSOlUTE == 0 */
                        if (t1 < t0) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        if (t1 == RELOCATABLE) {
                            if (t0 == RELOCATABLE) {

                                if (! same_quadrant(arg0, arg1) &&
                                    applying_fixups) {

                                   warning(QUADRANT_CHANGE, Subsp_Dict(
                                      fixup_subsp).NAME_PT, subsp_data -
                                      current_subspace_start_p,
                                      misc->file_name);
				}
                            } else { /* RELOCATABLE - ABSOLUTE */
                                if (! same_quadrant(arg1, arg1-arg0) &&
                                    applying_fixups)

                                   warning(QUADRANT_CHANGE, Subsp_Dict(
                                      fixup_subsp).NAME_PT, subsp_data
                                      - current_subspace_start_p,
                                      misc->file_name);
                            }
                        }
                        push_expr(arg1 - arg0, t1-t0);
                        break;
                    case R_PUSH_DOT:
                        push_expr(branch_dot-2*WORDSIZE, RELOCATABLE);
                        break;
                    case R_MAX:
                        arg0 = pop_expr(&t0);
                        arg1 = pop_expr(&t1);
                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg0),
					   Sym_Name(arg1),
					   0);
			}
                        push_expr(max(arg0, arg1), ABSOLUTE);
                        break;
                    case R_MIN:
                        arg0 = pop_expr(&t0);
                        arg1 = pop_expr(&t1);
                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg0),
					   Sym_Name(arg1),
					   0);
			}
                        push_expr(min(arg0, arg1), ABSOLUTE);
                        break;
                    case R_ADD:
                        arg0 = pop_expr(&t0);
                        arg1 = pop_expr(&t1);
                        /* TRICK: rely on RELOCATABLE == 1, ABSOlUTE == 0 */
                        if (t0+t1 > RELOCATABLE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg0),
					   Sym_Name(arg1),
					   0);
			}
                        if ((t0 == RELOCATABLE &&
                                 !same_quadrant(arg0, arg0+arg1)) ||
                            (t1 == RELOCATABLE &&
                                 !same_quadrant(arg1, arg0+arg1)))
                            if (applying_fixups) {

                               warning(QUADRANT_CHANGE, Subsp_Dict(
                                  fixup_subsp).NAME_PT, subsp_data
                                  - current_subspace_start_p,
                                  misc->file_name);
			    }
                        push_expr(arg0 + arg1, t0+t1);
                        break;
                    case R_MULT:
                        /* order of the POP's not defined... doesn't matter */
                        arg0 = pop_expr(&t0);
                        arg1 = pop_expr(&t1);
                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg0),
					   Sym_Name(arg1),
					   0);
			}
                        push_expr(arg0 * arg1, ABSOLUTE);
                        break;
                    case R_DIV:
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */
                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        if (arg0 == 0)
                            user_error(DIV_BY_0, 0);
                        push_expr(arg1 / arg0, ABSOLUTE);
                        break;
                    case R_MOD:
                        /* first pop must be done before second */
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */

                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        if (arg0 == 0)
                            user_error(DIV_BY_0, 0);
                        push_expr(arg1 % arg0, ABSOLUTE);
                        break;
                    case R_AND:
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */

                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        push_expr(arg0 & arg1, ABSOLUTE);
                        break;
                    case R_OR:
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */
                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        push_expr(arg0 | arg1, ABSOLUTE);
                        break;
                    case R_XOR:
                        /* order of the POP's not defined... doesn't matter */
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */

                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        push_expr(arg0 ^ arg1, ABSOLUTE);
                        break;
                    case R_NOT:
                        arg0 = pop_expr(&t0);
                        if (t0 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg0),
					   "",
					   0);
			}
                        push_expr(~arg0, ABSOLUTE);
                        break;
                    case R_LSHIFT:
                        /* first pop must be done before second */
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */

                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        push_expr(arg1 << arg0, ABSOLUTE);
                        break;
                    case R_ARITH_RSHIFT:
                        /* first pop must be done before second */
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */

                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        push_expr((int)arg1 >> arg0, ABSOLUTE);
                        break;
                    case R_LOGIC_RSHIFT:
                        /* first pop must be done before second */
                        arg0 = pop_expr(&t0);   /* second symbol */
                        arg1 = pop_expr(&t1);   /* first symbol  */

                        if (t0 != ABSOLUTE || t1 != ABSOLUTE) {
                            external_error(ILL_COMB_RELOC_SYMS, 
					   Sym_Name(arg1),
					   Sym_Name(arg0),
					   0);
			}
                        push_expr((unsigned int)arg1 >> arg0, ABSOLUTE);
                        break;
                    default:
                        if (arg0 >= R_PUSH_PCON1 && arg0 < R_PUSH_PCON1+64)
                            push_expr(arg0, ABSOLUTE);
                        else if (arg0 >= R_PUSH_NCON1 &&
                                 arg0 < R_PUSH_NCON1+64)
                            push_expr(arg0-(R_PUSH_NCON1+64), ABSOLUTE);
                        else if (arg0 > R_LSHIFT && arg0 < R_LSHIFT+32) {
                            arg1 = pop_expr(&t1);
                            if (t1 != ABSOLUTE) {
                                external_error(ILL_COMB_RELOC_SYMS, 
					       Sym_Name(arg0),
					       Sym_Name(arg1),
					       0);
			    }
                            push_expr(arg1 << (arg0-R_LSHIFT), ABSOLUTE);
                        } else if (arg0 > R_ARITH_RSHIFT &&
                                 arg0 < R_ARITH_RSHIFT+32) {
                            arg1 = pop_expr(&t1);
                            if (t1 != ABSOLUTE) {
                                external_error(ILL_COMB_RELOC_SYMS, 
					       Sym_Name(arg0),
					       Sym_Name(arg1),
					       0);
			    }
                            push_expr((int)arg1 >> (arg0-R_ARITH_RSHIFT),
                                        ABSOLUTE);
                        } else if (arg0 > R_LOGIC_RSHIFT &&
                                 arg0 < R_LOGIC_RSHIFT+32) {
                            arg1 = pop_expr(&t1);
                            if (t1 != ABSOLUTE) {
                                external_error(ILL_COMB_RELOC_SYMS, 
					       Sym_Name(arg0),
					       Sym_Name(arg1),
					       0);
			    }
                            push_expr((unsigned int)arg1 >>
                                             (arg0-R_LOGIC_RSHIFT),
                                        ABSOLUTE);
                        } else {
                            info_type = (fix_info->type << 8) + arg0;
                            goto UNRECOGNIZED;
                        }
                        break;
                    }
                break;

            case R_COMP2:
		GET_TWO_ARGS;
                if (arg0 == R_PUSH_SYM) {
                    arg1 += sym_bias;
                    t1 = Sym_Remap_Type(arg1);
                    if (t1 == ST_ABSOLUTE || t1 == ST_MILLI_EXT)
                        t1 = ABSOLUTE;
                    else
                        t1 = RELOCATABLE;
                    push_expr(symbol_value(arg1), t1);
		    arg1 -= sym_bias;
                } else if (arg0 == R_PUSH_PLABEL || arg0 == R_PUSH_PLABEL+1) {
                    arg1 += sym_bias;
                    push_expr(extern_plabels ?
                                  Sym_Remap_Info(arg1) + XRT_PLABEL_BITS :
                                  symbol_value(arg1), 
			     RELOCATABLE);
		    arg1 -= sym_bias;
                } else if (arg0 < R_PUSH_PCON2+0x80 || arg0 >= R_PUSH_NCON2)
                    /* since we left shift by 24, don't worry about sign */
                    push_expr((arg0 << 24)+arg1, ABSOLUTE);
                else {
                    info_type = (fix_info->type << 8) + arg0;
                    goto UNRECOGNIZED;
                }
                break;

            case R_COMP3:
		GET_TWO_ARGS;
                if (arg0 == R_PUSH_PROC || arg0 == R_PUSH_PROC+1) {
#ifdef Karl
                    arg0 = ((arg0-R_PUSH_PROC) << 8) +
                           ((arg1 >> 24) & 0xff);
                    arg0 = decode_arg_reloc(arg0);
                    arg1 = (arg1 & 0xffffff) + sym_bias;
#endif
                    external_error(INVALID_FIXUP, "R_PUSH_PROC",
					misc->file_name, 0);
                } else if (arg0 == R_PUSH_CONST)
                    push_expr(arg1, ABSOLUTE);
                else {
                    info_type = (fix_info->type << 8) + arg0;
                    goto UNRECOGNIZED;
                }
                break;

            /* NON-OVERRIDES (call routine) ************/

#ifndef WW_ANNOTATIONS
	    /* In HP-UX, if this is a zap ld (i.e. a linker that ignores
	       annotations that we put in the BE), ignore this fixup except
	       when doing_relocatable_fixups is true */
            case R_COMMENT:
              if (doing_relocatable_fixups) {
                GET_TWO_ARGS;
                break;
              } else {
                goto SKIP_ROUTINE;
              }
#else /* WW_ANNOTATIONS */
	    /* In HP-UX, a fully annotating linker must always process this
	       fixup */
	    case R_COMMENT:
		GET_TWO_ARGS;
		break;
#endif /* WW_ANNOTATIONS */

            /* computed length, clear overrides */
            case R_NO_RELOCATION:
		GET_ONE_ARG_NO_RELOC;
                dot_movement = arg0;
                clear_overrides = TRUE;
                break;

            /* computed length, clear overrides */
            case R_ZEROES:
            case R_UNINIT:
		GET_ONE_ARG_UNINIT;
                dot_movement = arg0;
                clear_overrides = TRUE;
                break;

            case R_REPEATED_INIT:
		GET_TWO_ARGS;
                dot_movement = arg1;
                clear_overrides = TRUE;
                break;

            /* one word, clear overrides */
            case R_RELOCATION:
            case R_SPACE_REF:
            case R_BREAKPOINT:
		GET_NO_ARGS;
                dot_movement = WORDSIZE;
                clear_overrides = TRUE;
                break;

            /* one word, clear overrides */
	    case R_DATA_PLABEL:
            case R_DATA_ONE_SYMBOL:
            case R_DP_RELATIVE:
            case R_CODE_ONE_SYMBOL:
            case R_MILLI_REL:
            case R_CODE_PLABEL:
            case R_DLT_REL:
	    case R_PLT_REL:	
	    case R_DATA_GPREL:
		GET_ONE_ARG_U;
                dot_movement = WORDSIZE;
                clear_overrides = TRUE;
		break;

            /* one word, clear overrides */
            case R_PCREL_CALL:
		GET_TWO_ARGS;
                dot_movement = WORDSIZE;
                clear_overrides = TRUE;

#if 0  
		if (NO_OVERRIDE == field_sel) {
		    if (implicit_long_call) {  /* LDO of PIC long call */
			field_sel = R_RSEL;
			implicit_long_call = FALSE;   /* clear for next */
		    } else {
			if (      (nfixups - fix_info->len) > 0
			      &&  have_PIC_long_call(fixup + fix_info->len,
						     misc,
						     arg0,
						     arg1)) {

				/* ADDIL of PIC long call sequence */
			    field_sel = R_LSEL;
			    implicit_long_call = TRUE;
			}
		    }
		}
#endif /* 0 */
                break;

            case R_ABS_CALL:
            case R_DATA_EXPR:
            case R_CODE_EXPR:
		GET_TWO_ARGS;
                dot_movement = WORDSIZE;
                clear_overrides = TRUE;
                break;

#ifdef PA_2_0
	    case R_SHORT_PCREL_MODE:
		GET_NO_ARGS;
		is_pcrel_short = TRUE;
		break;

	    case R_LONG_PCREL_MODE:
		GET_NO_ARGS;
		is_pcrel_short = FALSE;
		break;
#endif /* ifdef PA_2_0 */

            /* zero length, clear overrides */
            case R_ALT_ENTRY:
            case R_EXIT:
            case R_BEGIN_TRY:
            case R_BEGIN_BRTAB:
            case R_END_BRTAB:
		GET_NO_ARGS;
                clear_overrides = TRUE;
                break;

            /* zero length, clear overrides */
            case R_END_TRY:
            case R_STATEMENT:
		GET_ONE_ARG;
                clear_overrides = TRUE;
                break;

            /* zero length, clear overrides */
            case R_LINETAB_ESC:
            case R_ENTRY:
		GET_TWO_ARGS;
                clear_overrides = TRUE;
                break;

            /* zero length, clear overrides */
            case R_LINETAB:
            case R_AUX_UNWIND:
		GET_ALL_ARGS;
                clear_overrides = TRUE;
                break;

            case R_PREV_FIXUP:
		GET_ONE_ARG_D;
		/* backwards ptr into the fixup stream, by way of a priority
		   queue.  "arg0" is the index into the current queue. */

	        /* move the referenced fixup to the head of the R_PREV_FIXUP
		   queue as most recently used */
		MOVE_ARG0_TO_HEAD_OF_PREV_QUEUE;

		/* annotate the R_PREV_FIXUP if it points to a fixup that can
		   itself be annotated, otherwise just emulate inline below. */
                if (!relocatable && 
		    (IS_ANNOTATABLE(*(PUT_table[order_index].fixup)))) {
                    annotate_fixup(fixup,                       /* original */
                                   1,                           /*    & len */
                                   PUT_table[order_index].fixup,/* new guy  */
                                   PUT_table[order_index].len,  /*    & len */
                                   misc);
        	    assert(*fixup == R_ANNOTATE);  /* annotation correct? */
                    /*
		    ** record that this is from an R_PREV, so won't be
		    ** entered again in queue
		    */
        	    *fixup = R_ANNOTATE_PREV+arg0;  
                    ret_val = TRUE;
                }

                /* to call recursive fixups here requires a knowledge  */
                /* that PREV-Fixup annotations will ONLY be done       */
                /* during the first pass...                            */
                /* since we won't be annotating this fixup, ignore the */
                /* return value from recursive_fixups                  */

		/* Don't insert a fixup off an R_PREV, as wasn't       */
		/* counted as a multi-byte fixup at compile time.      */
                just_expanded_prev_fixup = TRUE;
                recursive_fixups(PUT_table[order_index].fixup,
                                 PUT_table[order_index].len,
                                 misc, routine);
                just_expanded_prev_fixup = FALSE;
                goto SKIP_ROUTINE;


            /* INTERNAL (handle specially) *************/


            case R_ANNOTATE_PREV:
		GET_ONE_ARG_D;
	        /* move the referenced fixup ("arg0") to the head of the 
		   R_PREV_FIXUP queue as most recently used */
		MOVE_ARG0_TO_HEAD_OF_PREV_QUEUE;
                just_expanded_prev_fixup = TRUE;
		/* fall through to R_ANNOTATE case */
            case R_ANNOTATE:
		/* would be GET_NO_ARGS; except for fall through from above */

                if (initial_fixup_pass)
                    /* PROC_ELIM */
     	            goto BAD_INPUT_FIXUP;

                annot = find_annotation(fixup, misc);
                /* just using temp_fixup as a temporary */
                temp_fixup = (Fixup *) & annot[1];
                /* don't need to write out fixups again if we annotate */
                /* an annotation, so ignore the return value from      */
                /* recursive_fixups                                    */
		save_annotation = current_annotation;
		current_annotation = temp_fixup;
                recursive_fixups(& temp_fixup[1],
                                 temp_fixup[0],
                                 misc,
                                 routine);
                just_expanded_prev_fixup = FALSE;
		current_annotation = save_annotation;
                goto SKIP_ROUTINE;
                break;

            case R_NOP_CLR_OVERRDS:
		GET_ONE_ARG; /* would be GET_NO_ARGS, but two byte form 
				requires one even if unused to parse right. */
                if (initial_fixup_pass)
                    /* PROC_ELIM */
		    goto BAD_INPUT_FIXUP;

                field_sel = NO_OVERRIDE;
                data_override = FALSE;
                new_ble_flag = FALSE;
                sec_stmt_override = FALSE;
		ltp_override = FALSE;
#ifdef TSD /* TSD */
                /* allow to be cleared */
                tp_override = FALSE; 
#endif /* TSD */
	        exec_level_override = -1;

                goto SKIP_ROUTINE;

            case R_NOP:
		GET_NO_ARGS;
                if (initial_fixup_pass)
                    /* PROC_ELIM */
		    goto BAD_INPUT_FIXUP;

                goto SKIP_ROUTINE;

            /* new format override */
            case R_NEW_BLE:
		GET_NO_ARGS;
                if (initial_fixup_pass)
                    /* PROC_ELIM */
		    goto BAD_INPUT_FIXUP;
                new_ble_flag = TRUE;
                break;

            /* new format replacement */
            case R_PCREL_TO_STUB:
		GET_ONE_ARG;
                if (initial_fixup_pass)
                    /* PROC_ELIM */
		    goto BAD_INPUT_FIXUP;
                dot_movement = WORDSIZE;
                break;

            default:
                /* PROC_ELIM */
	        BAD_INPUT_FIXUP:        
	        info_type = fix_info->type;
 	        UNRECOGNIZED:
		    external_error_hex(INVALID_FIXUP, info_type,
				       Subsp_Misc(fixup_subsp).file_name);
                 break;
            }

#ifdef DEBUG
        if (memory_copy+1 != fixup+fix_info->len)
            internal_error(FIXUP_ARG_WRONG, 0);
#endif /* DEBUG */

        switch (routine) {
	   case CHECK_FOR_ABS_FIXUP:
		temp_fixup = check_for_abs_fixup(fix_info, fixup, arg0, arg1);
                break;
           case DEAD_PROC_PASS:
                temp_fixup = dead_proc_pass(fix_info, fixup, arg0, arg1);
		break;
           case UNWIND_AND_RECOVER_FIXUPS: 
 		temp_fixup = unwind_and_recover_fixups(fix_info, fixup, arg0, arg1);
                break;
           case OPTIMIZE_PASS: 
		temp_fixup = optimize_pass(fix_info, fixup, arg0, arg1);
                break;
           case DELETE_INSTRUCTIONS: 
		temp_fixup = delete_instructions(fix_info, fixup, arg0, arg1);
                break;
           case ADJUST_INSTRUCTIONS: 
		temp_fixup = adjust_instructions(fix_info, fixup, arg0, arg1);
                break;
           case APPLY_FIXUPS: 
		temp_fixup = apply_fixups(fix_info, fixup, arg0, arg1, arg2);
                break;
           case RELOCATE_FIXUPS: 
		temp_fixup = relocate_fixups(fix_info, fixup, arg0, arg1, arg2);
                break;
           case CHECK_FOR_STUBS: 
		temp_fixup = check_for_stubs(fix_info, fixup, arg0, arg1);
                break;
	}
        branch_dot += dot_movement;
        if (clear_overrides) {
            field_sel = NO_OVERRIDE;
            data_override = FALSE;
            new_ble_flag = FALSE;
            sec_stmt_override = FALSE;
	    ltp_override = FALSE;
#ifdef TSD /* TSD */
	    tp_override = FALSE;
#endif /* TSD */
	    exec_level_override = -1;
            rnd_mode_override = FALSE;  /* missing code from 2.27 LE */
        }

        if (temp_fixup != NULL) {
            /* ANNOTATE THIS FIXUP */
            /* first byte is length, second byte and following is fixup */
            ret_val = TRUE;
	    if (annotate_fixup(fixup, fix_info->len,
                           &temp_fixup[1], temp_fixup[0], misc))
		break;  /* we break out of the loop if we overwrote */
			/* the "current annotation" (not the main fixup */
			/* stream), since an annotation has */
			/* only one non-R_NOP fixup, this means we're done. */
         }

       SKIP_ROUTINE:
        fixup   += fix_info->len;
        nfixups -= fix_info->len;
    }
    return (ret_val);
} /* end recursive_fixups */

get_fix_arg(buf, argtype, diff)
unsigned char **buf;
unsigned int argtype;
unsigned int diff;
/* the diff argument is either the difference between the first byte */
/* in the fixup and its class, (for ARG0 computation) or             */
/* it is ARG0 (for ARG1 computation)                                 */

/* invariant : "argtype" is left pointing at LAST byte of data word */

{
    int arg, i, j;
    static int t;       /* used for a reference parameter to pop_expr() */

    arg = 0;

    switch (argtype) {
        case NONE:
            break;

        case D:
   	    arg = diff;
   	    break;

        /* LENGTHS */

        case LDx4:
   	    arg = diff+1;
            arg *= WORDSIZE;
   	    break;
        case LD_10x4:
     	    arg = ((diff-24) << 8) + *++*buf + 1;
            arg *= WORDSIZE;
   	    break;
        case LD_18x4:
   	    arg = ((diff & 3) << 8) + *++*buf;
   	    arg = (arg << 8) + *++*buf + 1;
            arg *= WORDSIZE;
   	    break;
        case L_4:
            arg = WORDSIZE;
            break;
        case L_24x4:
   	    arg = *++*buf;
   	    arg = (arg << 8) + *++*buf;
            /* fall through */
        case L_8x4:
   	    arg = (arg << 8) + *++*buf + 1;
            arg *= WORDSIZE;
            break;
        case L_8xD:
   	    arg = diff * (*++*buf + 1);
            break;
        case L_32:
   	    arg = *++*buf;
            /* fall through */
        case L_24:
   	    arg = (arg << 8) + *++*buf;
   	    arg = (arg << 8) + *++*buf;
   	    arg = (arg << 8) + *++*buf + 1;
            break;

        /* UNSIGNED VALUES */

        case X_32:
   	    arg = *++*buf;
            /* fall through */
        case U_24:
   	    arg = (arg << 8) + *++*buf;
            /* fall through */
        case U_16:
   	    arg = (arg << 8) + *++*buf;
            /* fall through */
        case U_8:
   	    arg = (arg << 8) + *++*buf;
            break;

        /* SIGN EXTENSION */

        case S_24:
   	    arg = (char) *++*buf;
   	    arg = (arg << 8) + *++*buf;
   	    arg = (arg << 8) + *++*buf;
            break;
        case S_16:
   	    arg = (char) *++*buf;
   	    arg = (arg << 8) + *++*buf;
            break;
        case S_8:
   	    arg = (char) *++*buf;
            break;

        /* ARGUMENT RELOCATION */

        case AR_D:
            if (diff >= 5)
                j = diff - 5;
            else
                j = diff;
            for (i = 0; i < 4; i++)
                arg = (arg << 2) + (i < j);
            arg = (arg << 2) + (diff >= 5);
            break;
        case AR_9:
            i = ((diff & 1) << 8) + *++*buf;
            arg = decode_arg_reloc(i);
            break;

        /* VARIABLE FRAME SIZE */

        case FRAME:
            /* get frame expression */
            i = pop_expr(&t);
            /* Print symbols in error message */
            if (t != ABSOLUTE) {
                external_error(ILL_COMB_RELOC_SYMS, 
			       Sym_Name(i),
			       "",
			       0);
            }
            if (i < 0 || i >= (1<<27))
                external_error_n(INVALID_FRAME_SIZE, i);
            arg = (*++*buf << 24) + i;
            break;

        /* GENERAL EXPRESSIONS */

        case EXPR_V:
            arg = pop_expr(&t);
            break;

        case EXPR_T:
            /* rely on EXPR_V happening just previously */
            arg = t;
            break;

        default:
            internal_error(FIXUP_ARG_WRONG, 0);
        }
    return (arg);
}

int decode_arg_reloc(i)
int i;
{
    int j, k, ret_val;

    ret_val = i & 03;                           /* return reloc? */
    i >>= 2;
    j = i / 10;
    i -= 10*j;
    if (j == 9)
        ret_val += (03 << 6);                   /* FARGU */
    else {
        k = j / 3;
        j -= 3*k;
        ret_val += (k << 8) + (j << 6);
        }
    if (i == 9)
        ret_val += (03 << 2);                   /* FARGU */
    else {
        k = i / 3;
        i -= 3*k;
        ret_val += (k << 4) + (i << 2);
        }
    return (ret_val);
}

/************************************************************************/
/*                      ANNOTATION of FIXUPS                            */

/*
   IT IS VERY IMPORTANT that once we start annotating fixups, that
   the area pointed to by
        subsp_fixup_area
   not be reallocated.  This is because the fixup pointer which is the
   key to finding the annotation is contiained in this area WHEN
        save_fixups
   is TRUE.
   Given the way that this works, it is also true that the annotations
   themselves may not be reallocated (for an annotation may be annotated).
 */

/* FORWARD DECLARATION */
struct annotate_record *get_new_annotation();

/* used to remember where we last were so we don't have to keep looking */
static struct subsp_misc_record *annotate_last_misc = NULL;
static struct annotate_record   *annotate_last_annot = NULL;

annotate_fixup(old_fixup, old_len, new_fixup, new_len, misc)
Fixup *old_fixup, *new_fixup;
int old_len, new_len;
struct subsp_misc_record *misc;
{

    struct annotate_record *annotate, *prev, *curr;
    Fixup *d;
    int i;
    int old_annot_len, new_len_padded;

    /* 
    ** check that the IS_ANNOTATABLE macro is defined correctly - if not,
    ** this assert will fail when we try to annotate something unplanned. 
    */
    assert(((*old_fixup >= R_PREV_FIXUP) && (*old_fixup < R_PREV_FIXUP+PSZ)) || 
        (new_fix_table[fixup_index[(*old_fixup)]].type == R_NO_RELOCATION)   ||
	IS_ANNOTATABLE(*old_fixup));

    /* If we're annotating an annotation, adjust old_len to include */
    /* the padding that we deliberately add to small annotations,   */
    /* so that annotations of annotations will always fit in place. */
    if (current_annotation != NULL) {
	old_annot_len = *current_annotation;
	if (old_fixup > current_annotation &&
		old_fixup <= current_annotation+1+old_annot_len)
	    old_len = current_annotation+1+old_annot_len - old_fixup;
    }

    if (new_len <= old_len) {
        /* new fixup fits in old place... */
        /* replace fixup in place */
        memcpy(old_fixup, new_fixup, new_len);
        for (i = new_len; i < old_len; i++)
            old_fixup[i] = R_NOP;
	if (current_annotation != NULL)
	    return (TRUE); /* indicates that we overwrote an annotation */
    } else {
        /* alter fixup by dropping down R_ANNOTATE */

	if (new_len > MIN_ANNOTATION_LEN)
	    new_len_padded = new_len;
	else
	    new_len_padded = MIN_ANNOTATION_LEN;
        annotate = get_new_annotation(new_len_padded+1);
        annotate->location = old_fixup;
        d = (Fixup *) & annotate[1];
        *d++ = new_len_padded;
        memcpy(d, new_fixup, new_len);
	d += new_len;
	for (i = new_len; i < new_len_padded; i++)
	    *d++ = R_NOP;
        if (misc == annotate_last_misc && 
	    annotate_last_annot->location<old_fixup)
            curr = annotate_last_annot;
        else {
            annotate_last_misc = misc;
            curr = (struct annotate_record *) misc->annotate_list;
            prev = NULL;
        }

        while (curr != NULL && curr->location < old_fixup) {
            prev = curr;
            curr = curr->next;
        }

        if (prev == NULL)
            misc->annotate_list = (struct annotate_record *) annotate;
        else
            prev->next = annotate;

        annotate->next = curr;
        annotate_last_annot = annotate;

        *old_fixup = R_ANNOTATE;
        for (i = old_len; --i != 0; )
            old_fixup[i] = R_NOP;
    }
    return (FALSE);
} /* annotate_fixup */

/* remember where we last were so we don't have to keep looking */
static struct subsp_misc_record *find_last_misc = NULL;
static struct annotate_record   *find_last_annot = NULL;

struct annotate_record * find_annotation(fixup, misc)
Fixup *fixup;
struct subsp_misc_record *misc;
{

    struct annotate_record *curr;

    if (misc == NULL) {
        /* reset local variables */
        find_last_misc = NULL;
        find_last_annot = NULL;
        return(NULL);
    }

    if (misc == find_last_misc && find_last_annot->location < fixup)
        /* pick up where we left off last time */
        curr = find_last_annot;
    else
        curr = (struct annotate_record *) misc->annotate_list;

    while (curr != NULL && curr->location < fixup)
        curr = curr->next;

    if (curr == NULL || curr->location != fixup)
        internal_error(ANNOTATE_ERROR, 0);

    find_last_misc = misc;
    find_last_annot = curr;
    return (curr);
}

/* remember some information across calls to this routine */
static char *latest_one = NULL;
static int size_left = 0;

struct annotate_record *get_new_annotation(len)
int len;
{
    int total_size;
    struct annotate_record * ret_val;

#define MALLOC_OVERHEAD 16

    /* to the requested length, add the overhead and round up to a word */
    total_size = (sizeof(struct annotate_record) + len + 3) &~ 3;

    if (size_left < total_size) {
        size_left = 65536-MALLOC_OVERHEAD;
        latest_one = (char *) emalloc(size_left);
    }

    ret_val = (struct annotate_record *) latest_one;
    latest_one += total_size;
    size_left  -= total_size;
    return (ret_val);
}

/************************************************************************/

/*                           EXPRESSION HANDLING                        */

struct expr_stack {
    struct expr_stack * next;
    int val;
    int type;
};

static struct expr_stack *TOS = NULL;
static struct expr_stack *free_exprs = NULL;

pop_expr(type)
int *type;
{
    int i;
    struct expr_stack *old_TOS;

    if (TOS == NULL)
        external_error(STACK_UNDERFLOW, 0);

    old_TOS = TOS;
    i = old_TOS->val;
    *type = old_TOS->type;

    TOS = old_TOS->next;

    old_TOS->next = free_exprs;
    free_exprs = old_TOS;

    return (i);
}

push_expr(i, type)
int i;
int type;
{
    struct expr_stack *new_TOS;

    if (free_exprs != NULL) {
        new_TOS = free_exprs;
        free_exprs = free_exprs->next;
    } else
        new_TOS = (struct expr_stack *) emalloc(sizeof(struct expr_stack));

    new_TOS->next = TOS;
    new_TOS->val = i;
    new_TOS->type = type;
    TOS = new_TOS;
}


/* HP-UX shared library */

static struct PLT_hash_entry *get_PLT_hash_node(char *name,
						unsigned int hashval,
						int PLT_index,
						int sym_index)
{
    struct PLT_hash_entry *tmp;

    if (!free_PLT_nodes) {
	int i;
	free_PLT_nodes = 
	    (struct PLT_hash_entry *)ecalloc(NODE_MAX,
					     sizeof(struct PLT_hash_entry));
	for(i = 0; i < NODE_MAX-1; i++)
	    free_PLT_nodes[i].next = free_PLT_nodes+i+1;
	free_PLT_nodes[NODE_MAX-1].next = NULL;
    }

    tmp = free_PLT_nodes;
    free_PLT_nodes = tmp->next;
    tmp->name = name;
    tmp->hashval = hashval;
    tmp->PLT_index = PLT_index;
    tmp->sym_index = sym_index;
    tmp->next = NULL;
    return(tmp);
}

static Boolean PLT_hash_tbl_built = FALSE;

static void bld_PLT_hash_tbl()
    /* build hash table index of PLT entry indices */
{
    int i; /* loop counter */
    struct PLT_hash_entry *new;

    for (i = 0; i < PLT_entry_count; i++) {
	char *s = Sym_Dict(out_PLT_list[i].proc_addr).NAME_PT;
	unsigned int hashval = hash_string(s);
	unsigned int hashkey = hashval % PLT_HASH_SIZE;

	new = get_PLT_hash_node(s, hashval, i, out_PLT_list[i].proc_addr);
	new->next = PLT_hash_tbl[hashkey]; /* insert ahead on chain */
	PLT_hash_tbl[hashkey] = new;
    }  /* end for each PLT entry loop */
    PLT_hash_tbl_built = TRUE;
} /* END "bld_PLT_hash_tbl" */

static void add_PLT_hash_tbl_entry(new_name, new_PLT_index, new_sym_index)
char *new_name;			    /* name to be added */
int  new_PLT_index, new_sym_index;  /* PLT and sym tbl indices of new sym */

    /* add one sym to hash table index of PLT entry indices */

{
    struct PLT_hash_entry *tmp_hash_node;
    unsigned int hashval, hashkey;
    
    if (!PLT_hash_tbl_built) {
	bld_PLT_hash_tbl();  /* should only be allocated once */
	return; /* initial build handles the current sym as well */
    }

    hashval = hash_string(new_name);
    hashkey = hashval % PLT_HASH_SIZE;

    tmp_hash_node = get_PLT_hash_node(new_name, hashval,
				      new_PLT_index, new_sym_index);
	/* node to hang off the hash table */

    tmp_hash_node->next = PLT_hash_tbl[hashkey]; /* insert ahead on chain */
    PLT_hash_tbl[hashkey] = tmp_hash_node;

} /* END "add_PLT_hash_tbl_entry" */

int PLT_index_of_sym(target_sym_index)
int target_sym_index;  /* symbol dict index of symbol being searched for */
    /* Find index of PLT entry for target symbol. */
{
    char *s = Sym_Dict(target_sym_index).NAME_PT;
    unsigned int hashval, hashkey;  
    struct PLT_hash_entry *curr_hash_node;  /* current node on hash chain */
    int sym_index, sym_index1;

    if (!PLT_hash_tbl_built)
	bld_PLT_hash_tbl();  /* should only be allocated once */

    hashval = hash_string(s);
    hashkey = hashval % PLT_HASH_SIZE;

    curr_hash_node = PLT_hash_tbl[hashkey];

    while (curr_hash_node != NULL) {

	if (hashval == curr_hash_node->hashval &&
	    strcmp(curr_hash_node->name,s) == 0) { /* if name match found */
	    int PLT_sym_index = curr_hash_node->sym_index;
		/* index of symbol currently being considered for a match */

	    /* in usual linker style, we are unsure of where in the 
	       symbol chain the pointers "target_sym_index" and 
	       "PLT_sym_index" point. We want to return the PLT index
	       if both of these point to some part of the same symbol
	       chain. To do this we run down each chain (or the same 
	       chain) trying to get a match. 
	    */
    	    for ( sym_index = target_sym_index;
		  sym_index != BAD_SYM;
	          sym_index = Sym_Related_Stub(sym_index)) {
		for ( sym_index1 = PLT_sym_index;
		      sym_index1 != BAD_SYM;
		      sym_index1 = Sym_Related_Stub(sym_index1)) {

		    if (&Sym_Dict(sym_index1) == &Sym_Dict(sym_index))
			return(curr_hash_node->PLT_index);
		}
	    }
	} /* end if name match */

	curr_hash_node = curr_hash_node->next;  /* advance down hash chain */

    }
    return (BAD_SYM);
}	/* END PLT_index_of_sym */

/*
**  map_secondary_to_primary().  Given
**	a symbol index to a secondary def code symbol, return the index
**	of its primary symbol.
*/

int map_secondary_to_primary (int sec_ind)
{
    static char *buf = 0;
    static int buf_len = 0;
    int prim_ind;
    char *sec_name = Sym_Name (sec_ind);
    int sec_name_len = strlen (sec_name);
    struct symnode *symnode_p;
    unsigned int hashval;

    assert (Sym_Dict (sec_ind).secondary_def == 1);

    if (sec_name_len + 2 > buf_len) {
	buf = erealloc (buf, buf_len = (sec_name_len + 2));
    }

    buf[0] = '_';
    strcpy (&buf[1], sec_name);

    /* 
    ** Find the primary symbol definition with the same version number.
    ** Can't use univ_find because it doesn't look at version numbers.
    **
    ** Added a check to verify that the symbols originate from the same 
    ** subspace.  This new check supercedes the shlib_version check on the
    ** subspace misc records. 
    */

    hashval = hash_string (buf);
    symnode_p = univ_hash_table[hashval % UNIVHASHSIZE];
    while (symnode_p != NULL) {
	if (   symnode_p->hashval==hashval 
	    && symnode_match(symnode_p, buf, 0, 0, ST_CODE) 
	    && (Sym_Subsp(symnode_p->index) == Sym_Subsp(sec_ind))
	    && (Sym_Value(symnode_p->index) == Sym_Value(sec_ind))
	   )
	    return(symnode_p->index);
	symnode_p = symnode_p->next;
    }
    return sec_ind;  /* Didn't find primary symbol */
}

int find_export_stub_sym(sym_index)
int sym_index;  /* symbol dict index to start search for export stub sym */
{
    while ((sym_index != BAD_SYM) && !IS_EXPORT(sym_index))
        sym_index = Sym_Related_Stub(sym_index);
    return (sym_index);
}

static void new_PLT_offset(sym_ind)
int sym_ind;  /* index to record in new PLT entry */

/*  builds one new PLT entry "on the fly" for symbols seen with no import
    stubs in PLABEL fixups.  This only happens in incomplete a.outs due to
    shared libraries generating imports for everything (their exports 
    included).  If this turns out to be a performance problem, a list
    could be kept and all the new entries made at one time as is done for
    the shlib PLABEL entries in the DLT. */

{
    int new_PLT_entry_index = PLT_entry_count++;

    allocate_PLT();  /* "PLT_entry_count" bumped above. */
    out_PLT_list[new_PLT_entry_index].proc_addr = sym_ind;
    out_PLT_list[new_PLT_entry_index].ltptr_value = 0;
				/* keep garbage out of object file */

    add_PLT_hash_tbl_entry(Sym_Dict(sym_ind).NAME_PT, new_PLT_entry_index,
			   sym_ind);
	/* add to auxilary hash table for fast lookup in "PLT_index_of_sym" */

    /* expand the Import List to match the new PLT entry */
    out_import_list = (struct import_entry *) erealloc((char *) 
						       out_import_list,
			(import_entry_count+1) * sizeof(struct import_entry) );

    out_import_list[import_entry_count++] = NULL_IMPORT_REC;
    
}

static void bld_new_import_PLT_entry(orig_sym, PLT_sym)
int orig_sym; /* original symbol */
int PLT_sym;  /* symbol dict index of symbol being entered in import/PLT */
{
    struct import_entry *cur_import_node; /* new entry ptr*/
    int exp_index;
    	        
    /* build new import/PLT entry for symbol referred to in
       PLABEL fixup that wouldn't normally have one.
       Necessary for the CODE_PLABEL DLT entry or inited location
       in a DATA_PLABEL fixup to have a PLT entry to point at. */ 

    Sym_ShlImp_Indx(orig_sym) = import_entry_count;

    new_PLT_offset(PLT_sym); 	/* bumps import list and PLT by one */

    cur_import_node = &out_import_list[import_entry_count-1];

    /* fill in new entry */
    cur_import_node->name = shlib_string_add(Sym_Name(PLT_sym));
    cur_import_node->reserved2 = -1; /* not from shlib */ /* lib_index */
    cur_import_node->reserved1 = 0; /* init for future use */
#ifdef TSD /* TSD */
    cur_import_node->is_tp_relative = 0;
#endif /* TSD */
    cur_import_node->bypassable = 0;

    if (Sym_Scope(orig_sym) == SS_LOCAL) {
	exp_index = BAD_SYM;
    } else {	
	/* if symbol is not local, may or may not be exported based */
	/* on whether -h or +e was used.                            */
        exp_index = shlib_match(out_hash_tbl, 
				out_hash_tbl_len, 
				out_export_list,
			        out_shlstr_table, 
				Sym_Name(PLT_sym), 
			        ST_CODE);
    }

    /* only have ST_CODE import if we are exporting THIS symbol.	*/
    /* Remember, we could have multiple instances of the same 		*/
    /* code symbol, some local, zero or more universal. Must		*/ 
    /* make sure we know which one we are dealing with.           	*/ 
        /*   We will now only mark the import type
        ** as ST_CODE if we're building a shared lib.  For a.outs, if the
        ** symbol is defined, we don't need to import it.
        **  */
    if (      (building_shlib || Sym_Dict(orig_sym).secondary_def)
           && exp_index != BAD_SYM)
	cur_import_node->type = ST_CODE; /* flatten the sym space */
    else
	cur_import_node->type = ST_NULL;

} /* bld_new_import_PLT_entry */

/************************************************************************/
/*                                                                      */
/*                      COUNT UNWIND, RECOVER                           */
/*                      COUNT LOADER FIXUPS                             */
/*                      EXPAND PREV_FIXUP                               */

/* FORWARD DECLARATION */
Fixup *unwind_and_recover_fixups();

count_unwind_recover_size()
{
    int new_sp_index, sp_index;
    int old_index, subsp_index, num_subsp;
    int sym_ind;
    int hashval;
    struct subspace_dictionary_record *subsp;

    if (relocatable) {
        recover_end_subsp = BAD_SUBSP;
        recover_subsp = BAD_SUBSP;
        unwind_end_subsp = BAD_SUBSP;
        unwind_subsp = BAD_SUBSP;
	dollar_global = BAD_SYM;
	milli_label = BAD_SYM;
	sr4export_sym = BAD_SYM;
	return;
    }

    if (!building_shlib) {  /* if FRU relink or -A dynamic link */
        hashval = hash_string(unw_start);
        sym_ind = univ_find(unw_start, 0, 0, hashval, ST_NULL);

        if (!suppress_unwind && sym_ind != BAD_SYM)  
            unwind_subsp = Sym_Subsp(sym_ind);
        else
            unwind_subsp = BAD_SUBSP;

        hashval = hash_string(unw_end);
        sym_ind = univ_find(unw_end, 0, 0, hashval, ST_NULL);

        if (!suppress_unwind && sym_ind != BAD_SYM)
            unwind_end_subsp = Sym_Subsp(sym_ind);
        else
            unwind_end_subsp = BAD_SUBSP;

        hashval = hash_string(rcv_start);
        sym_ind = univ_find(rcv_start, 0, 0, hashval, ST_NULL);

        if (!suppress_unwind && sym_ind != BAD_SYM)
            recover_subsp = Sym_Subsp(sym_ind);
        else
            recover_subsp = BAD_SUBSP;

        hashval = hash_string(rcv_end);

        sym_ind = univ_find(rcv_end, 0, 0, hashval, ST_NULL);
        if (!suppress_unwind && sym_ind != BAD_SYM)
            recover_end_subsp = Sym_Subsp(sym_ind);
        else
            recover_end_subsp = BAD_SUBSP;

        hashval = hash_string(COPYRAM_SYMBOL);
        sym_ind = univ_find(COPYRAM_SYMBOL, 0, 0, hashval, ST_NULL);

        if (sym_ind != BAD_SYM)
            copyram_subsp = Sym_Subsp(sym_ind);
        else
            copyram_subsp = BAD_SUBSP;
    }

    /* at this point, the unwind/recover subspaces must be set either by the
       code above or by having been built in "collect_soms". */
    assert( recover_end_subsp != UNSET );
    assert( recover_subsp != UNSET );
    assert( unwind_end_subsp != UNSET );
    assert( unwind_subsp != UNSET );

    /* MISCELLANEOUS assignment of dollar_global and milli_label */

    hashval = hash_string(dollar_global_string);
    dollar_global = univ_find(dollar_global_string, 0, 0, hashval, ST_NULL);

    dollar_global_space = ((dollar_global != BAD_SYM) ? 
			   Subsp_Dict(Sym_Subsp(dollar_global)).space_index :
			   -1);

    if ((building_incomp_exec || (count_calls && !building_shlib) /*FDP*/ ) &&
				 dollar_global == BAD_SYM) {
	warning (UNSATS, 0);
	warning_continue (UNSAT_DATA, dollar_global_string, 0);
	longjmp (drive, 1);
    }

    hashval = hash_string(milli_label_string);
    milli_label = univ_find(milli_label_string, 0, 0, hashval, ST_DATA);

    dyncall_external = -1;
    if (pcx_u_pa2_0) {
      hashval = hash_string(dyncall_external_20_string);
      dyncall_external = univ_find(dyncall_external_20_string,
				 0, 0, hashval, ST_CODE);
    }
    /* For the pcx_u_pa2_0 case, if dyncall_external_string_20
       is not found, may be using an older but compatible milli.a
       so look for the slower dyncall_external instead. For
       the non-pcx_u_pa2_0 case, just look for dyncall-external. 
    */
    if (dyncall_external == -1) {
      hashval = hash_string(dyncall_external_string);
      dyncall_external = univ_find(dyncall_external_string,
				 0, 0, hashval, ST_CODE);
    }

    hashval = hash_string(sr4export_string);
    sr4export_sym = univ_find(sr4export_string, 0, 0, hashval, ST_CODE);

    hashval = hash_string(branch_counter_string);
    branch_counter_sym =
        univ_find(branch_counter_string, 0, 0, hashval, ST_DATA);

    use_opt_sym_values = 0; /* Make sure we use original sym values */

    copyram_space_count = 0;      /* Init number of copyram entries */
    copyram_count = 0;      /* Init number of copyram entries */
    last_was_uninit = FALSE;      /* keep track of type of last entry */

    fru_unwind_count = 0;
    fru_stub_unwind_count = 0;
    fru_recover_count = 0;
    fru_line_table_size = 0;

    if (fru_subsp_count != 0) {
    	/* FRU RELINK... pre-count unwind and recover */
    	fru_unwind_count = Subspace_Length(unwind_subsp) / 
	  				sizeof(struct udesc);
    	fru_stub_unwind_count =
            Subspace_Length(unwind_end_subsp) / sizeof(struct stub_desc);
    	fru_recover_count = Subspace_Length(recover_subsp) / 
							sizeof(struct rdesc);
    	fru_line_table_size = Subspace_Length(recover_end_subsp) 
                             - (fru_unwind_count/sizeof(struct udesc));
    }

    unwind_count = fru_unwind_count;
    recover_count = fru_recover_count;
    aux_unwind_count = fru_unwind_count;
    line_table_size = fru_line_table_size;

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];

    /* Embedded systems code */
	if (space_misc[sp_index].copyram_needed) {
	    /* Need a source and target for space entry (count is words) */
	    copyram_count += 2;
        }

	/* for all subspaces, whether loadable or not */
	subsp_index = space_array[sp_index].subspace_index;
	num_subsp = space_array[sp_index].subspace_quantity;

	/* Set bl_seen in space_misc to 0 */
	space_misc[sp_index].bl_seen = FALSE;

	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;

            if (old_index < fru_subsp_count) {
                Subsp_Misc(old_index).unwind_index = -1;
                Subsp_Misc(old_index).recover_index = -1;
                Subsp_Misc(old_index).copyram_index = -1;
                Subsp_Misc(old_index).copyram_count = -1;
                continue;
            }

            Subsp_Misc(old_index).unwind_index = unwind_count;
            Subsp_Misc(old_index).recover_index = recover_count;
            Subsp_Misc(old_index).copyram_index = copyram_count;
            Subsp_Misc(old_index).copyram_count = 0;
            Subsp_Misc(old_index).line_tbl_offset = line_table_size;
            state_diagram = INITIAL_STATE;

            /* Embedded systems code */
	    if (space_misc[sp_index].copyram_needed) {
		/* length is same to start */
		Subsp_Misc(old_index).rom_subsp_length = 
			                Subsp_Dict(old_index).subspace_length;
            }
	    /* Have we seen any BL's? */
	    bl_seen_in_subspace = FALSE;
	    truncate_fixups = FALSE;
	    uninit_seen = FALSE;

	    N0_fixup_seen = FALSE; /* Clear this for each subspace */

            if (Subspace_Length(old_index) != 0) /* prevent useless call */
                traverse_fixups(old_index, UNWIND_AND_RECOVER_FIXUPS);

	    /* Remember if we have seen BL's */
	    space_misc[sp_index].bl_seen |= bl_seen_in_subspace;
	    bl_seen_in_aout |= bl_seen_in_subspace;

	    /* If only NO_RELOCATION fixups, we can truncate the fixups
	       in this subspace and never visit them again */
	    if (truncate_fixups) {
		Subsp_Dict(old_index).fixup_request_index = 0;
		Subsp_Dict(old_index).fixup_request_quantity = 0;
    	    }

            /* check if any unwind stuff in this subspace */
            if (Subsp_Misc(old_index).unwind_index == unwind_count) {
                /* no, zap unwind_index field, and line_tbl_offset field  */
                Subsp_Misc(old_index).unwind_index = -1;
                Subsp_Misc(old_index).line_tbl_offset = -1;
            } else if (Subsp_Misc(old_index).line_tbl_offset == 
		       line_table_size){ 
                 /* no line_tables so reset line_tbl_offset field */
                Subsp_Misc(old_index).line_tbl_offset = -1;
            }
            /* check if any recover stuff in this subspace */
            if (Subsp_Misc(old_index).recover_index == recover_count)
                /* no, zap recover_index field */
                Subsp_Misc(old_index).recover_index = -1;

            /* embedded systems code */
            if (Subsp_Misc(old_index).copyram_index == copyram_count) {
		/* Check if this subsp is like BSS */
		/* If it is we make a single entry in the table for it */
		if ((space_misc[sp_index].copyram_needed) &&
		   (Subspace_Length(old_index) > 0) &&
		   (Subsp_Dict(old_index).initialization_length == 0)) {
		       if (!last_was_uninit)
		          copyram_count += 1; /* entry for bss */
		    last_was_uninit = TRUE;
		}
                /* no, zap copyram_index field */
                Subsp_Misc(old_index).copyram_index = -1;
                Subsp_Misc(old_index).copyram_count = 0;
      	    } else { /* compression was needed */
		/* Need an entry to end this subsp */
	        copyram_count++;  

                /* entry is no longer uninit */
                last_was_uninit = FALSE;

		/* Need an entry to end this subsp */
		/* copyram_index has start of this subspaces entries */
		/* yes, put in number of entries for this subspace */
                Subsp_Misc(old_index).copyram_count = copyram_count -
                                           Subsp_Misc(old_index).copyram_index;

	    }

	    if (space_misc[sp_index].copyram_needed && 
		           Subsp_Dict(old_index).initialization_length == 0) {
	        /* if subsp length is zero we don't need any rom_length */
	        Subsp_Misc(old_index).rom_subsp_length = 0;
            }

            /*
	    ** Support for debug of optimized code.
	    **
	    ** If a doc line table has not been terminated then count the 
	    ** line table end escape.  
	    **
	    ** A doc line table is terminated with either another R_LINETAB 
	    ** fixup or the end of the subspace is encountered.
	    */
	    if (doc_enabled) {
		doc_count_end();
	    }

        } /* loop over subspaces */
        /* Add in end marker for copyram */
        if (space_misc[sp_index].copyram_needed)
	    copyram_count += 2;     /* 1 for end and 1 to start new space */
    } /* loop over spaces */
    if (building_incomp_exec && DLT_entry_count > 0) {
	do_shared_globals (&NULL_IMPORT_REC);   /* Now in libraries.c */

    } /* DLT in a.out */

    /* now that the first pass over the fixups done, can do final builds */
    if (building_incomp_exec || building_shlib) { 

	if (code_plab_DLT_entry_count > 0) {

	    /* add in late DLT entries for syms seen in CODE_PLABEL fixups */
	    build_code_plab_DLT_entries();
	}

  	build_shlib_subspace(shlib_info_subsp_index);
    }

    if (DLT_subsp_index != BAD_SUBSP)
  	build_DLT_subspace(DLT_subsp_index);
    if (PLT_subsp_index != BAD_SUBSP)
	build_PLT_subspace(PLT_subsp_index);

    initial_fixup_pass = FALSE;

    if (unwind_subsp != BAD_SUBSP) {
        subsp = & Subsp_Dict(unwind_subsp);
        subsp->subspace_length = unwind_count * sizeof(struct udesc);
    }

    if (recover_subsp != BAD_SUBSP) {
        subsp = & Subsp_Dict(recover_subsp);
        subsp->subspace_length = recover_count * sizeof(struct rdesc);
    }

    /* Embedded systems code */
    if (copyram_subsp != BAD_SUBSP) {
        subsp = & Subsp_Dict(copyram_subsp);
        subsp->subspace_length = (copyram_count) * sizeof(union copyram_desc);
    }

    if (recover_end_subsp != BAD_SUBSP) {
        subsp = & Subsp_Dict(recover_end_subsp);
        if (generate_aux_unwind) {
            subsp->subspace_length = line_table_size + WORDSIZE 
                                     + (unwind_count*sizeof(struct udesc));
        } else { /* to account for the len word (first word of recover_end) */
            subsp->subspace_length = WORDSIZE;
        }
    }

    /*
    ** determine if line table fixups have been seen. If they have then
    ** set the subspace length. Disable DOC if any incompatible options
    ** were seen.
    ** We will call doc_post_pass1() if DOC hasn't been disabled.
    ** doc_post_pass1() will check for bad DOC states in the routine.
    */
    if (!doc_disabled)
        doc_post_pass1();
} /* end count_unwind_recover_size */

/* HP-UX shared library fixups processing */
static int add_SHLIB_CODE_export();

int build_code_plab_DLT_entries()
{
    /* add in late DLT entries for syms seen in CODE_PLABEL fixups */

    struct import_entry *cur_import_node;     /* current import list record */
    int i,j; 
    int sym_index;
    int stub_sym_index;  
    int corresp_PLT_index;
    int new_offset_of_PLT;
    struct symnode *n;

    /* count export and import entries needed */
    for (i = 0; i < code_plab_DLT_entry_count; i++) {
    	sym_index = code_plab_DLT_entry_list[i].sym_index;

	add_SHLIB_CODE_export(sym_index);
	add_SHLIB_PLABEL_export(sym_index);   

        if (PLT_index_of_sym(sym_index) == BAD_SYM)
	    bld_new_import_PLT_entry(sym_index, sym_index);

	}  /* END for all code_plab_DLT_entries */

    /* expand the DLT */
    out_DLT_list = (DLT_ENTRY *) erealloc((char *) out_DLT_list, 
					  (code_plab_DLT_entry_count + 
					   DLT_entry_count) * 
					  sizeof(DLT_ENTRY) );

    /* expand the Import List */
    out_import_list = (struct import_entry *) 
      			erealloc((char *) out_import_list,
					   (code_plab_DLT_entry_count + 
					    import_entry_count) * 
					   sizeof(struct import_entry) );

    /* move down trailing part of import list - make room for new entries.
       Also adjust symbols for shift in PLT imports */
    j = 0; 
    for (i = import_entry_count-1; i >= DLT_entry_count; i--) {
	out_import_list[i + code_plab_DLT_entry_count] = out_import_list[i];
	sym_index = Sym_Remap(out_PLT_list[j].proc_addr);
	while (sym_index != BAD_SYM) {
	    if (Sym_ShlImp_Indx(sym_index) != BAD_SYM) 
		Sym_ShlImp_Indx(sym_index) += code_plab_DLT_entry_count;
	    sym_index = Sym_Related_Stub(sym_index);
	}
	j++;
    }

    import_entry_count += code_plab_DLT_entry_count;

    cur_import_node = &out_import_list[DLT_entry_count];
    new_offset_of_PLT = DLT_entry_count + code_plab_DLT_entry_count;

    /* number of DLT entries */
    j = DLT_entry_count + code_plab_DLT_entry_count;

    /* build new import list entries */
    for (i = 0; i < code_plab_DLT_entry_count; i++) {

	sym_index = code_plab_DLT_entry_list[i].sym_index;
	corresp_PLT_index = PLT_index_of_sym(sym_index);

	/* signal that the symbol was referenced via code plabel */
	Sym_Misc(sym_index).code_plabel = TRUE; 
	for (n = Sym_Back_Ptr(sym_index); n != NULL; n = n->same) 
	    Sym_Misc(n->index).code_plabel = TRUE;

	code_plab_DLT_entry_list[i].dlt_index = i + DLT_entry_count;

	assert (corresp_PLT_index != BAD_SYM);  /* is always found */
	cur_import_node[i] = 
			out_import_list[new_offset_of_PLT + corresp_PLT_index];

                /*  Now we will make imports for
                ** code plabels NULL (not PLABEL) if we're building an a.out,
                ** and the symbol is defined; and it's not a secondary def... */
        if (       (building_incomp_exec &&
                    Sym_Scope(sym_index) == SS_UNIVERSAL &&
                    ! Sym_Dict (sym_index).secondary_def)
                                             ||
	    Sym_Scope(sym_index) == SS_LOCAL || 
	    Sym_ShlHideExp(sym_index)        ||
	    Sym_Type(sym_index) == ST_CODE) {
	    cur_import_node[i].type = ST_NULL;
	    out_import_list[new_offset_of_PLT + corresp_PLT_index].type = 
	      							ST_NULL;
	} else {
	    cur_import_node[i].type = ST_PLABEL;
        }

	/* find export stub sym index and update the PLT so the addr
	   of the export stub (instead of the import) will go in the 
	   export record "value" field */
	stub_sym_index = out_PLT_list[corresp_PLT_index].proc_addr;

	if (Sym_Scope(sym_index) != SS_UNSAT &&
	    Sym_Scope(sym_index) != SS_EXTERNAL) {
	    /* no exports for imports, PLT addr is garbage */
	    stub_sym_index = find_export_stub_sym(sym_index);

	    /* should always be an export on the list somewhere */
	    assert (stub_sym_index != BAD_SYM);
        }

	out_PLT_list[corresp_PLT_index].proc_addr = stub_sym_index;

        /* Import index of the export stubs PLT entry. */
    	out_DLT_list[DLT_entry_count + i] = corresp_PLT_index + j; 
    }

    /* update so subspace builds below and relocations in output.c correctly */
    DLT_entry_count = j;

} /* end build_code_plab_DLT_entries() */

static int indx_of_code_plab_DLT_entry(sym_index)
int sym_index;  /* symbol index referenced by the current 
		   R_CODE_PLABEL fixup */

/* 
   Returns index in the local (code plabel syms seen) table of the 
   match if any, possibly for conversion to a DLT slot index (by addition 
   of the DLT_entry_count).  Checks all related stub symbols, too - to fix 
   cases like parameter relocation stubs where the fixups get munged by
   "check_for_stubs" before "apply_fixups" is called.  
   Returns BAD_SYM if not found. 
*/
{
        int i;  /* loop counter */
	void *sym_addr;

	sym_addr=&Sym_Dict(sym_index);

	for (i = 0; i < code_plab_DLT_entry_count; i++) {
	    int curr_sym = Sym_Remap(code_plab_DLT_entry_list[i].sym_index);
						/* current candidate sym */
	    do {
		/* Compare the addresses where the sym is stored, not
		   just the index! */
	        if (&Sym_Dict(curr_sym) == sym_addr)
		    return (i);
		curr_sym = Sym_Related_Stub(curr_sym);
	    } while (curr_sym != BAD_SYM);
	}

	return (BAD_SYM);  /* not found */
} /* END indx_of_code_plab_DLT_entry */

#define CODE_PLAB_DLT_ENTRY_INC 500

static int add_code_plab_DLT_entry(sym_index)
int sym_index;  /* sym index referenced by the current R_CODE_PLABEL fixup */

    /* adds entry to code_plab_DLT_entry table if not there previously      */
    /* returns index in the local table of the match if any, for conversion */
    /* to a DLT slot index (by addition of the DLT_entry_count)             */

{
    static int code_plab_DLT_entry_max = 0;

    if (code_plab_DLT_entry_max == 0) {  /* first entry, initialize table */
	code_plab_DLT_entry_max = CODE_PLAB_DLT_ENTRY_INC;
	code_plab_DLT_entry_list =
		   (struct c_plabel *) emalloc(code_plab_DLT_entry_max * 
					   sizeof(struct c_plabel));
    } else {  /* table already initialized, look sym up */

	int result = indx_of_code_plab_DLT_entry(sym_index);

	if (result != BAD_SYM)
	    return (result);

	/* not found, insert */
	if (code_plab_DLT_entry_count >= code_plab_DLT_entry_max) {
	    code_plab_DLT_entry_max += CODE_PLAB_DLT_ENTRY_INC;
	    code_plab_DLT_entry_list =
		   (struct c_plabel *) 
		       erealloc ((char *) code_plab_DLT_entry_list, 
		            code_plab_DLT_entry_max * sizeof(struct c_plabel));
	}
    }
    code_plab_DLT_entry_list[code_plab_DLT_entry_count].sym_index = sym_index;
    return (code_plab_DLT_entry_count++);
}  /* end add_code_plab_DLT_entry */

#define  DEFAULT_ARG_RELOC	0x155	/* default value to say "don't know" */

add_SHLIB_PLABEL_export(sym_index)
int sym_index;  /* symbol to build off of */
{

    /* ensures that code and data plabels have an ST_PLABEL export record
       to help dld.sl make plabel comparisons work. Returns TRUE if 
       a the symbol is externally visible, else FALSE */ 

    struct export_entry *cur_export_node; 
    int cur_export_index;    
    unsigned int hashkey; 	
    char *name = Sym_Dict(sym_index).NAME_PT;

    if (Sym_Scope(sym_index) == SS_LOCAL ||
	Sym_ShlHideExp(sym_index)        ||
	Sym_Type(sym_index) == ST_CODE)
	return(FALSE);

    /* return if an entry already exists in the export list */
    cur_export_index = shlib_match(out_hash_tbl, out_hash_tbl_len,
			     	   out_export_list, 
			     	   out_shlstr_table, name, ST_PLABEL);
    if (cur_export_index != BAD_SYM)
	return(TRUE);
    
    /* No appropriate entry exists, so build one. */

    /* Expand the Export List */
    allocate_export_list(export_entry_count+1);

    if (building_shlib) {
        /* Init the expanded Export List Extension */
	out_export_ext[export_entry_count].size = -1;
        out_export_ext[export_entry_count].dreloc = -1;
    }

    /* Fill in the new export rec */
    cur_export_node = &out_export_list[export_entry_count];
    cur_export_node->type = ST_PLABEL;
    cur_export_node->info.size = 0;       /* zero entire word */
    cur_export_node->EXPORT_VERSION = 0;  /* init for now - ok? */
    cur_export_node->EXPORT_ARG_RELOC = DEFAULT_ARG_RELOC;
    cur_export_node->name = shlib_string_add(name);
#ifdef TSD /* TSD */
    cur_export_node->is_tp_relative = 0;
#endif /* TSD */
    cur_export_node->value = sym_index;  /* addr */
    out_explist_subsp[export_entry_count] = 
      Sym_Subsp(find_orig_sym(sym_index));
    cur_export_node->reserved1 = 0; /* init for future use */
    hashkey = hash_string(name) % out_hash_tbl_len;
    cur_export_node->next = out_hash_tbl[hashkey];
    out_hash_tbl[hashkey] = export_entry_count++;

    return(TRUE);
} /* add_SHLIB_PLABEL_export */

static int add_SHLIB_CODE_export(sym_index)
int sym_index;  /* symbol to build off of */
{

    /* builds an ST_CODE shared library export if called for.
       Returns the index of the export stub for the given symbol */

    struct export_entry *cur_export_node; 
    unsigned int hashkey; 
    int export_index;
    int orig_sym;

    export_index = BAD_SYM;
    
    /*
     * 
     * Made a slight change to the way symbols with the no relocation
     * and long return bits set are handled. We now allocate a dummy
     * export stub (really just a new symbol that points back to the
     * original code) and treat it just like normal.
     */

    if (Sym_has_long_return(sym_index) && Sym_no_relocation(sym_index)) {
       export_index = add_null_export_stub(sym_index);
    }


	/*   add_export_stub() will now return the
	** stub index, and will query to see if one is built already */
    if (Sym_Subsp (sym_index) != BAD_SUBSP)
	export_index = add_export_stub (sym_index);

    orig_sym = find_orig_sym(sym_index);

    /* if told to hide the symbol, or no definition can be found, return */
    if ( orig_sym == BAD_SYM || 
	 Sym_Scope(orig_sym) != SS_UNIVERSAL ||
	 Sym_ShlHideExp(orig_sym)            ||
	 Sym_Type(orig_sym) == ST_CODE )  
        return(export_index);
    
    /* return if an entry already exists in the export list */
    if (shlib_match(out_hash_tbl, out_hash_tbl_len,
		    out_export_list, out_shlstr_table, 
		    Sym_Name(sym_index), ST_CODE) != BAD_SYM) 
	return(export_index);
    

    /* Expand the Export List */
    allocate_export_list(export_entry_count+1);

    if (building_shlib) {
        /* Init the expanded Export List Extension */
	out_export_ext[export_entry_count].size = -1;
        out_export_ext[export_entry_count].dreloc = -1;
    }

    /* fill in export rec */
    cur_export_node = &out_export_list[export_entry_count];
    cur_export_node->type = ST_CODE;  /* flatten type space */
    cur_export_node->info.size = 0;   /* zero entire word */
    cur_export_node->EXPORT_VERSION =
    	Subsp_Misc(Sym_Subsp(sym_index)).shlib_version;
    cur_export_node->EXPORT_ARG_RELOC = DEFAULT_ARG_RELOC;
    cur_export_node->name = shlib_string_add(Sym_Dict(sym_index).NAME_PT);
    cur_export_node->value = sym_index;  /* addr */
#ifdef TSD /* TSD */
    cur_export_node->is_tp_relative = 0;
#endif /* TSD */
    out_explist_subsp[export_entry_count] = 
      Sym_Subsp(find_orig_sym(sym_index));
    cur_export_node->reserved1 = 0; /* init for future use */
    hashkey = hash_string(Sym_Dict(sym_index).NAME_PT) % out_hash_tbl_len;
    cur_export_node->next = out_hash_tbl[hashkey];
    out_hash_tbl[hashkey] = export_entry_count++;

    return(export_index);
}

/*************************************************************
** FUNCTION:	check_subsp_sym
**
** DESCRIPTION:	Verify that the unbiased symbol index is legal for
**		fixup_subsp.  If not, print an error message and abort.
**		The sym_index is the symbol index before it has been 
**		adjusted by sym_bias.
**
** MOTIVATION:	Added when C++ generated improper fixups for +T -g.
**
** PARAMETERS	sym_idx		unbiased symbol index.
**
** NOTES:	To minimize the performance impact, the check_subsp_sym 
**		routine is called through a macro which duplicates
**		the test logic so that we only call the routine when it
**		will print an error message and abort.
**
**		A better test of the symbol index would be possible if
**		we saved in each subspace the symbol_total field
**		of the .o header.
**
**		We perform the checks in unwind_and_recover_fixups so
**		that they will only be done once.  Unfortunately this means
**		that the checks are not performed in a relocatable (-r)
**		link.
**
*************************************************************/

#define IS_BAD_SYM(sym_idx) (sym_idx < 0 || \
			     sym_idx + sym_bias >= sym_dict_size)

#define CHECK_SUBSP_SYM(sym_idx) if (IS_BAD_SYM(sym_idx)) {		\
				     check_subsp_sym(sym_idx);		\
				 }

void check_subsp_sym(int sym_idx)
{
    long offset;
    char sym_idx_txt[20];

    if (IS_BAD_SYM(sym_idx)) {
	strcpy(sym_idx_txt, ltoa((long) sym_idx));
	offset =   branch_dot 
		 - original_branch_dot 
		 + Subspace_Virtual_Offset(fixup_subsp);
	user_error(BAD_FIXUP_SYM,
		     sym_idx_txt,
		     ltostr(offset,16 ),
		     Subsp_Misc(fixup_subsp).file_name,
		     0);

    }
} /* end check_subsp_sym */

/* unwind_and_recover_fixups is is the first pass over the fixups! */

Fixup *unwind_and_recover_fixups(fix_info, fixup, arg0, arg1)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1;
{
    int line_num_delta, line_addr_delta;
    int overflow;
    static int cur_line_number, cur_line_addr;
    static Boolean prev_was_secondary;
    int Import_Indx;  /* temp to hold import index of current sym */

    struct symnode *n, *m;  		/* symbols used in PCREL_CALL fixup */
    int sym_type;           		/* symbol type for PCREL_CALL fixup */
    int PLT_offset, import_index;  	/* local working indices */
    int last_stub;			/* index of last import stub seen */
    int tmp, i;
    Boolean found;
    int copy_sym;
    static Boolean emit_code_plabel_warn = TRUE;

    switch (fix_info->type) {

	case R_COMP2:
	    if (arg0 == R_PUSH_SYM) {
		CHECK_SUBSP_SYM(arg1);
	    }
	    break;

	case R_N0SEL:
	    N0_fixup_seen = TRUE;
	    break;

        case R_PLT_REL: 
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
#if 0
            found = FALSE;
            for (i = import_entry_count-1; i >= DLT_entry_count; i--) {
               tmp = out_import_list[i].name;
               if((tmp != -1)&& !(strcmp(tmp+out_shlstr_table,Sym_Name(arg0)))){
                   found = TRUE;
               }
            }
            if(!found)
#endif /* 0 */
		/*  Fixed the statement below
		 * to, yes, set the type to ST_CODE; also use a
		 * different -- correct -- test for whether this symbol
		 * has a PLT entry for it or not! */
	    if (PLT_index_of_sym(arg0) == BAD_SYM) {
               bld_new_import_PLT_entry(arg0,arg0);
               out_import_list[import_entry_count-1].type=ST_CODE;
            }
            break;

        case R_DLT_REL:
	/* not really unwind-related, just first pass over the fixups */
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    CHECK_SUBSP_SYM(arg0);
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);

		/* Now only do this when
		** building a shared lib.  For standalone PIC, drop
		** down below */
	    if (Sym_Scope(arg0) == SS_LOCAL &&
	        Sym_Dict(arg0).symbol_type == ST_CODE && building_shlib) {
		/* DLT fixup for code symbol implies a PIC code long branch 
		   from within a branch table. Build a NULL PLT entry for
		   the local symbol */
	    	
	    	if ( (PLT_offset = PLT_index_of_sym(arg0)) == BAD_SYM ) {
	            new_PLT_offset(arg0);
		    import_index = import_entry_count -1;
		} else { 
		    out_PLT_list[PLT_offset].proc_addr = arg0;
		    out_PLT_list[PLT_offset].ltptr_value = 0;
	 	    import_index = DLT_entry_count + PLT_offset;
	        }

		/* lib_index */
            	out_import_list[import_index].reserved2 = EMPTY; 
		/* init for future */
            	out_import_list[import_index].reserved1 = 0; 
		out_import_list[import_index].bypassable = 0;
#ifdef TSD /* TSD */
		out_import_list[import_index].is_tp_relative = 0;
#endif /* TSD */
            	out_import_list[import_index].name = 
				shlib_string_add(Sym_Dict(arg0).NAME_PT);
            	out_import_list[import_index].type = ST_NULL;
	    } else if (!building_shlib) {
		/*
                ** STANDALONE PIC - PIC seen outside shlib. PIC code is
	        ** found in /lib/milli.a so this is not such a special case.
		** Get import table index from symbol, check if used before.
                **
                ** This is a slick way of hoisting code... 
                ** NO_DATA_COPY 
                */
   ADD_DLT_SLOT:
                Import_Indx = Sym_ShlImp_Indx(arg0);
		if (Import_Indx == -1) { 
		    /* DLT entry not previously allocated for this symbol */
		    if (out_DLT_list != NULL) {  
			/* not first DLT_REL, inits done */
		        out_DLT_list = (int *) erealloc((char *) out_DLT_list, 
				   (DLT_entry_count+1) * sizeof(DLT_ENTRY));
		    } else {  /* first DLT_REL seen, do inits */
		        out_DLT_list = (DLT_ENTRY *) emalloc
			  			(sizeof(DLT_ENTRY));
		    }
		    Import_Indx = Sym_ShlImp_Indx(arg0) = DLT_entry_count;

		    if(Sym_Back_Ptr(arg0) == NULL)
		       /**************************************************
		       ** ---------------------
		       ** Instead of always setting out_DLT_list[] to arg0
		       ** check if Sym_Back_Ptr is not set: i.e, 1 unsat 
		       ** only in the hash chain then set out_DLT_list[] to
		       ** arg0, else set out_DLT_list[] to the head of the
		       ** chain.
		       ***************************************************/
		       out_DLT_list[Import_Indx] = arg0;
		    else
		       out_DLT_list[Import_Indx] = (Sym_Back_Ptr(arg0))->index;

		    DLT_entry_count++;
		} /* DLT entry not previously allocated */
	    }  /* not building shlib => standalone PIC */
#ifdef TSD /* TSD */
	    tp_override = FALSE; /* reset */
#endif /* TSD */
            break;

        case R_DP_RELATIVE:
	    CHECK_SUBSP_SYM(arg0);
	    /* no DP-rel code allowed in shared libraries */
	    if (building_shlib) {
                user_error (NON_PIC_IN_SHLIB, 
	                    Subsp_Misc (fixup_subsp).file_name,0);
	    }
#ifdef TSD /* TSD */
	    tp_override = FALSE; /* reset */
#endif /* TSD */

		/*   We may have a CODE_ONE_SYM fixup applied
		** to an instruction that references an imported shared
		** global symbol from $LIT$.  In this case, we need to do
		** the same stuff as for a DP_REL instruction, so just
		** fall through: */

	case R_CODE_ONE_SYMBOL:
                /*
		** ifdef this out for HPE for now; until
		** the code for R_DLT_REL is available 
                */
	    if (!do_data_copy) {
	    	arg0 += sym_bias;
            	arg0 = Sym_Remap(arg0);

	    	if (building_incomp_exec && Sym_SharedGlobal (arg0)) {
		    if (!N0_fixup_seen)
			Sym_Sort_Short (arg0) = TRUE;
			/*   Don't add multiple slot for small
			** data_override_values; can get these from old fixup
			** format files */
		    if (data_override && FIXUP_ROUND (data_override_value))
		    	add_shared_global_multiple_slot (arg0,
							 data_override_value);
		    if (-1 == Sym_ShlImp_Indx (arg0)) {
#ifdef DEBUG
		    	if (verbose & V_NO_DATA_COPY) {
		            printf("first_pass: (DP_REL) need DLT entry for ");
		            printf("shared global \"%s\"\n", Sym_Name (arg0));
			}
#endif /* DEBUG */
			/* Just go up above to add the slot... */
			goto ADD_DLT_SLOT;
		    }
		}
	    }

            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex (DATA_ALIGNMENT_WRONG,fix_info->type,
				    Subsp_Misc(fixup_subsp).file_name, 0);

	    break;

        /* HP-UX Shared Libraries */
	case R_CODE_PLABEL:
	    /* issue a compat warning - code plabel fixups are
	       going to be obsoleted */
	    if (verbose & V_CHANGE_WARN) {
		found_change_warn = TRUE;
		    
		if ((verbose & V_DETAIL_CHANGE_WARN) &&
		    emit_code_plabel_warn) {
		    emit_code_plabel_warn = FALSE;
		    warning(CODE_PLABEL_OBSOLETED, 
			    Subsp_Misc(fixup_subsp).file_name, 0);
		}
	    }

            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    CHECK_SUBSP_SYM(arg0);
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
		/*  Don't do this for abs symbols */
            if ((building_incomp_exec || building_shlib) &&
		                         Sym_Type (arg0) != ST_ABSOLUTE) {
                if ((Sym_Dict(arg0).symbol_type == ST_MILLICODE) ||
		    (Sym_Dict(arg0).symbol_type == ST_MILLI_EXT)) {
		    /* Millicode get this if value is taken without P' fixup */
		    user_error(MILLICODE_SYM_FOR_PLAB, 
			 	Subsp_Misc(fixup_subsp).file_name, 
			  	Sym_Dict(arg0).NAME_PT, 0);
		}
                add_code_plab_DLT_entry(arg0);

		/* 
		 * 
		 * We now have null export stubs for symbols that have
		 * long return and no relocation. Therefore, we do the
		 * exact same processing as for normal symbols.
		 *
		 */

		{
		   struct symnode *back_sym;

		    if ((back_sym = Sym_Back_Ptr(arg0))) {
		        Sym_addr_taken(back_sym->index) = 1;
		    } else {
			Sym_addr_taken(arg0) = 1;
		    }
		}

		/*  Make sure the primary is
		** exported if we've got a secondary symbol: */
		if (Sym_Dict (arg0).secondary_def) {
		    if ((arg1 = map_secondary_to_primary (arg0)) != arg0) {
			/* ssable set
			** incorrectly */
			/* Set the addr_taken bit on the back_sym symbol */
			/*                      */
			/* Don't need export stub if has_long_return and */
			/* no_relocation are both set.                   */

			struct symnode *back_sym;
			add_code_plab_DLT_entry(arg1);

			/* 
			 * 
			 * We now have null export stubs for symbols 
			 * that have long return and no relocation. 
			 * Therefore, we do the exact same processing 
			 * as for normal symbols.
			 *
			 */

			if ((back_sym = Sym_Back_Ptr(arg1))) {
			   Sym_addr_taken(back_sym->index) = 1;
			} else {
			   Sym_addr_taken(arg1) = 1;
			}
		    }
		}
	    }
            break;
	
        case R_PCREL_CALL:
	/* Not really unwind-related, just first pass over the fixups */
	/* Here we add import and PLT entries for routines that are   */
	/* called within a shared library and are universal - since   */
	/* export stubs are built for all universal entry points.     */
	/* General Note: import stubs for all code unsats will	      */
	/*               be built in shlib_build_tables()             */

            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    CHECK_SUBSP_SYM(arg1);
	    arg1 += sym_bias;
	    arg1 = Sym_Remap(arg1); 
	    sym_type = Sym_Dict(arg1).symbol_type;

	    bl_seen_in_subspace = TRUE;

	    if ( !building_shlib || 
		 Sym_Scope(arg1) != SS_UNIVERSAL ||
		 !(sym_type == ST_ENTRY     ||
		   sym_type == ST_PRI_PROG  ||
		   sym_type == ST_SEC_PROG) ||
		 (Sym_ShlHideExp((arg1)))  )
		break;

            /* If building shlib and -B symbolic then suppress import stubs */
            if (building_shlib && inter_binding) break;
	    n = Sym_Back_Ptr(arg1);

	    save_orig_sym_for_exp_stub(arg1);
	    add_import_stub(arg1);

	    Sym_Subsp(arg1) = BAD_SUBSP;
	    if ( (PLT_offset = PLT_index_of_sym(arg1)) == BAD_SYM ) {
	         new_PLT_offset(arg1);
		 import_index = import_entry_count -1;
 	    } else { 
		 out_PLT_list[PLT_offset].proc_addr = arg1;
		 out_PLT_list[PLT_offset].ltptr_value = 0;
	 	 import_index = DLT_entry_count + PLT_offset;
	    }

            out_import_list[import_index].reserved2 = EMPTY; /* lib_index */
            out_import_list[import_index].reserved1 = 0;  /* init for future */
	    out_import_list[import_index].bypassable = 0;
#ifdef TSD /* TSD */
	    out_import_list[import_index].is_tp_relative = 0;
#endif /* TSD */	    
            out_import_list[import_index].name = shlib_string_add(n->name);
            out_import_list[import_index].type = n->type;

	    last_stub = n->index;
	    for (m = n->same; m != NULL; m = m->same) {
	    	/* share import stubs in each subspace */
		add_import_stub(m->index);
		Sym_Subsp(m->index) = BAD_SUBSP;
		Sym_Back_Ptr(m->index) = n;
		Sym_Related_Stub(m->index)=Sym_Related_Stub(last_stub);
		Sym_Related_Stub(last_stub) = m->index;
		last_stub = m->index;
	    } /* END for */

	    break;

	case R_MILLI_REL:
	    /* R_MILLI_REL has a symbol index in arg0 which we check.
	    ** This case was moved out of the next case which just checks
	    ** alignment.
	    */
	    CHECK_SUBSP_SYM(arg0);
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            break;

        case R_SPACE_REF:
        case R_BREAKPOINT:
        case R_CODE_EXPR:
        case R_BEGIN_BRTAB:
        case R_END_BRTAB:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            break;
        case R_BEGIN_TRY:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            TRY_COUNT++;
            recover_count++;
            break;
        case R_END_TRY:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            if (TRY_COUNT < 1)
               external_error(TRY_BLOCK_MISMATCH,
					Subsp_Misc(fixup_subsp).file_name, 0);
            TRY_COUNT--;
            break;
        case R_ENTRY:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            if (state_diagram == NO_ENTRY_STATE ||
                state_diagram == INITIAL_STATE) {
                /* this output region is a hole */
            } else {
                /* output non-null region (ENTRY, NO EXIT) */
                unwind_count += (branch_dot != unwind_branch_dot);
                new_line_table = TRUE; /* generate new line table */
            }
            state_diagram = ENTRY_STATE;
            unwind_branch_dot = branch_dot;
            aux_unwind_seen = FALSE;
            break;
        case R_ALT_ENTRY:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            if (state_diagram == INITIAL_STATE)
                external_error(INVALID_FIXUP, "R_ALT_ENTRY",
				Subsp_Misc(fixup_subsp).file_name, 0);
            /* output non-null region (NO EXIT) */
            unwind_count += (branch_dot != unwind_branch_dot);
            state_diagram = ENTRY_STATE;
            unwind_branch_dot = branch_dot;
            new_line_table = TRUE; /* generate new line table */
            break;
        case R_AUX_UNWIND:
            /* check alignment for some fixups */
	    CHECK_SUBSP_SYM(arg0);
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            /* set flag for future line_table processing */
            generate_aux_unwind = TRUE;
            aux_unwind_seen = TRUE;
            break;
        case R_EXIT:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            if (state_diagram == INITIAL_STATE)
                external_error(INVALID_FIXUP, "R_EXIT",
				Subsp_Misc(fixup_subsp).file_name, 0);
            /* output non-null region (EXIT) */
            unwind_count += (branch_dot != unwind_branch_dot);
            state_diagram = NO_ENTRY_STATE;
            unwind_branch_dot = branch_dot;
            new_line_table = TRUE; /* generate new line table */
            break;
	case R_LINETAB:
	    CHECK_SUBSP_SYM(arg1);
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    if (doc_initialized || doc_enabled) {
	        doc_count_new();  
            }
	    break;
	case R_LINETAB_ESC:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    if (doc_enabled) {
                doc_count_escape((unsigned int) arg1);
            }
	    break;
        case R_STATEMENT:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    if (doc_enabled) {
		doc_count_entry((unsigned int) ((branch_dot-8)/WORDSIZE), 
				(unsigned int) arg0);
	    } else if (aux_unwind_seen) {
                if (new_line_table) {
                    /* round up to a word boundary */
                    line_table_size = (line_table_size + WORDSIZE -1)
		      			&~(WORDSIZE-1);
                    line_table_size += 14;
                    new_line_table = FALSE;
                    prev_was_secondary = FALSE;
                } else {
                    if (sec_stmt_override) {
			arg0 = cur_line_number; /* Use previous line number */
                    }

                    line_num_delta = arg0 - cur_line_number;
                    line_addr_delta = (branch_dot-8)/WORDSIZE - cur_line_addr;

                    overflow = 0;   /* reset overflow */

                    if(line_addr_delta > CODE_DIFF_MAX) {
                        /* need to account for overflow entries */
			overflow = ((line_addr_delta-1)/CODE_DIFF_MAX)
					 * LINE_ENT_SZ;

			line_table_size += overflow + LINE_ENT_SZ;

                        if (prev_was_secondary) {
                           /* output one sec. stmt for each overflow entry */
                           line_table_size += ((line_addr_delta -1) /
					       CODE_DIFF_MAX) * SEC_ENT_SZ;
                        }
			line_addr_delta = 0;
                    }
                    if (line_num_delta > LINE_DIFF_MAX) {
                        /* 
			** need to account for overflow entries 
			** use abs entry if takes more bytes than an abs entry
			** If Code_diff had overflow the last entry holds 
                        ** some line_diff info so subtract that off 
			*/
                        if (overflow) line_num_delta -= LINE_DIFF_MAX;

                        overflow = ((line_num_delta-1)/LINE_DIFF_MAX)
                                                                 * LINE_ENT_SZ;
                        line_table_size += (overflow > ABS_ENT_SZ)
                                           ? ABS_ENT_SZ
                                           : (overflow + LINE_ENT_SZ);

                        if (prev_was_secondary) {
                            /* output one sec. stmt for each overflow entry */
                            line_table_size += (overflow > ABS_ENT_SZ)
                                           ? SEC_ENT_SZ
                                           : ((line_num_delta-1)/LINE_DIFF_MAX)
                                                * SEC_ENT_SZ;

                        }
                    } else if(line_num_delta < LINE_DIFF_MIN) {
                        /* need to account for overflow entries */
			/* Note here that both line_num_delta and 
			   LINE_DIFF_MIN are negative numbers! We are
			   actually adding a positive number to the size */

                        /* If Code_diff had overflow the last entry holds */
                        /* some line_diff info so add that in */
                        if (overflow) line_num_delta -= LINE_DIFF_MIN;

                        overflow = ((-line_num_delta-1)/LINE_DIFF_MIN)
                                                                 * LINE_ENT_SZ;
                        line_table_size -= (overflow >= -ABS_ENT_SZ)
                                           ? (overflow - LINE_ENT_SZ)
                                           : -ABS_ENT_SZ ;

                        if (prev_was_secondary) {
                           /* output one sec. stmt for each overflow entry */
                           line_table_size -= (overflow >= -ABS_ENT_SZ)
                                          ? ((-line_num_delta-1)/LINE_DIFF_MIN)
                                                         * SEC_ENT_SZ
                                          : -SEC_ENT_SZ;

                        }
                    }
                    if (!overflow &&
                         ((line_addr_delta != 0) || (line_num_delta != 0))) {
                        /* account for normal entry if no overflow appeared */
                        line_table_size += LINE_ENT_SZ;
                    }
                }
                cur_line_number = arg0;
                cur_line_addr = (branch_dot-8)/WORDSIZE;
                if (sec_stmt_override) {
                    /* add in secondary entry */
                    line_table_size += SEC_ENT_SZ;
                    prev_was_secondary = TRUE;
		} else if(prev_was_secondary)
                    prev_was_secondary = FALSE;
            }
            break;
        case R_RELOCATION:
            /* initialized pointer into DATA */
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
            if (!relocatable && gen_ldr_fixups &&
                IS_LOADABLE(fixup_subsp) && IS_PRIVATE(fixup_subsp)) {
                loader_fixup_size++;
		Subsp_Misc(fixup_subsp).subsp_has_dreloc = TRUE;
	    }
            break;
        case R_DATA_ONE_SYMBOL:
            /* initialized pointer into DATA? */
 	    /* no align check - might not be if using 300 alignment rules */
	    CHECK_SUBSP_SYM(arg0);

#ifdef TSD /* TSD */   
	    if ((!tp_override) &&
		((!relocatable && gen_ldr_fixups) ||
		 (building_incomp_exec && !do_data_copy))) {
#else	  
            if ((!relocatable && gen_ldr_fixups) ||
                (building_incomp_exec && !do_data_copy)) {
#endif /* TSD */
                arg0 += sym_bias;
                arg0 = Sym_Remap (arg0);
		/* Bump the loader_fixup_size unless:
		**  -- building a.out -- && -- arg0 not shared global -- */
		if (!building_incomp_exec || Sym_SharedGlobal (arg0)) {
                    /* use arg1 as a temporary here */
                    arg1 = Sym_Subsp(arg0);

		/* check to see DATA ONE SYM does not refer to a CODE symbol */
                    if (arg1 == BAD_SUBSP && !building_shlib && 
					 !building_incomp_exec)
	                external_error (DATA_ONE_FIXUP_TO_CODE,
	                           Sym_Dict(arg0).name.n_name,
	                           Subsp_Misc(fixup_subsp).file_name,0,0);

                        /*
			** Now with shared globals, can have a loader fixup
			** from $LIT$ to $DATA$; so we don't know that
			** arg1 is PRIVATE 
                        **
                        **  On MPE, if we don't link for shared
                        ** global data, we must check to see if arg1 is in
                        ** $PRIVATE$ else we bump up the loader fixup size
                        ** when we don't want to (because we don't build a
                        ** loader fixup).
                        **
                        ** We need to check for $PRIVATE$ arg1 since
                        ** we cannot have $LIT$ to $DATA$ on MPE.
                        **
                        ** For $DEBUG$, we need to fixup 
                        ** data symbols and allocate DXRT slots for debug
                        ** symbols.  But we do not want to generate a loader
                        ** fixup in this case.  If ;nodebug or '-s' specified,
                        ** then even if dealing with $DEBUG$, do not create
                        ** a DXRT slot.
                        */
                    if (IS_LOADABLE(fixup_subsp) &&
			!ltp_override &&
		        (building_shlib ||
                         (IS_LOADABLE(arg1) /* && IS_PRIVATE(arg1) */ ))) {
                        if (!IS_PRIVATE(fixup_subsp))
                            external_error (INVALID_LOADER_FIX_SYM, 
					    Sym_Name(arg0),
				            Subsp_Misc(fixup_subsp).file_name,
					    0);

                        loader_fixup_size++;

		        Subsp_Misc(fixup_subsp).subsp_has_dreloc = TRUE;
			/* If there's been no DLT slot reserved for
			** the symbol, do so.  */
			if (-1 == Sym_ShlImp_Indx (arg0)) {
#ifdef DEBUG
			    if (verbose & V_NO_DATA_COPY) {
			        printf("first_pass: adding DLT entry for ");
			        printf("shared global \"%s\"\n",
				       Sym_Name(arg0));
			    }
#endif /* DEBUG */
			      /* Just go up to DLT_REL to add the slot... */
			    goto ADD_DLT_SLOT;
			}
		    }  /* if (IS_LOADABLE(fixup_subsp) ... */
		}  /* Bump the loader_fixup_size unless ... */
            }  /* if ((!relocatable && gen_ldr_fixups) ... */
#ifdef TSD /* TSD */
	    tp_override = FALSE;  /* reset */
#endif
            break;

        case R_DATA_PLABEL:
            /* initialized DATA plabel */
 	    /* no align check - might not be if using 300 alignment rules */
	    CHECK_SUBSP_SYM(arg0);
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);

            if (!relocatable && (gen_ldr_fixups
                /* NM: allocate space even if building incomplete exec */
                || (!mixed_mode_off && building_incomp_exec && 
                    Sym_Type (arg0) != ST_ABSOLUTE &&
                    /* not text */
                    (IS_LOADABLE(fixup_subsp) && IS_PRIVATE(fixup_subsp))  ))
		&& extern_plabels) {
                if (!IS_LOADABLE(fixup_subsp) || !IS_PRIVATE(fixup_subsp))
                    external_error(INVALID_LOADER_FIX_SYM, 
				   Sym_Name(arg0),
				   Subsp_Misc(fixup_subsp).file_name,
				   0);
                loader_fixup_size++;
		Subsp_Misc(fixup_subsp).subsp_has_dreloc = TRUE;
            }

            /* HP-UX shared library or executable */
		/*  Don't do this for abs symbols */
            if ((building_incomp_exec || building_shlib) &&
		                         Sym_Type (arg0) != ST_ABSOLUTE) {
                if ((Sym_Dict(arg0).symbol_type == ST_MILLICODE) ||
		    (Sym_Dict(arg0).symbol_type == ST_MILLI_EXT)) {
		    /* Millicode get this if value is taken without P' fixup */
		    user_error(MILLICODE_SYM_FOR_PLAB, 
			 	Subsp_Misc(fixup_subsp).file_name, 
			  	Sym_Dict(arg0).NAME_PT, 0);
		}
		arg1 = add_SHLIB_CODE_export(arg0);
		add_SHLIB_PLABEL_export(arg0);
		if ( arg1 != BAD_SYM &&
		     PLT_index_of_sym(arg0) == BAD_SYM) {
		    bld_new_import_PLT_entry(arg0, arg1);
                    /* Bsymbolic support */
                    if (building_shlib && inter_binding) {
                       out_import_list[import_entry_count-1].name = EMPTY;
                       out_import_list[import_entry_count-1].type = ST_NULL;
                    }
                }

		/* Set addr_taken bit in the misc record for this 
		   symbol and its related stubs. This bit is used 
		   to set the bypassable bit in the import_entry 
		   in shared libraries to control bypassing export
		   stubs in dld. */
		/* Set the addr_taken bit on the back_sym symbol */
		/* Don't need export stub if has_long_return and */
		/* no_relocation are both set.                   */

		/* 
		 * 
		 * We now have null export stubs for symbols with long
		 * return and no relocation, so we no longer treat this
		 * case specially.
		 *
		 */

	        {
		    struct symnode *back_sym;

		    if ((back_sym = Sym_Back_Ptr(arg0))) {
			Sym_addr_taken(back_sym->index) = 1;
		    } else {
			Sym_addr_taken(arg0) = 1;
		    }
		} 


		/*  Make sure the primary is
		** exported if we've got a secondary symbol: */
		if (Sym_Dict (arg0).secondary_def) {
		    if ((arg1 = map_secondary_to_primary (arg0)) != arg0) {
		        int i = arg0;
			int arg2 = add_SHLIB_CODE_export(arg1);

			add_SHLIB_PLABEL_export(arg1);
			if ( arg2 != BAD_SYM &&
		                          PLT_index_of_sym(arg1) == BAD_SYM) 
		    	    bld_new_import_PLT_entry(arg1, arg2);

			/* Don't need export stub if has_long_return and */
			/* no_relocation are both set.                   */

			/*
			 * 
			 * We now have null export stubs for symbols with long
			 * return and no relocation, so we no longer treat this
			 * case specially.
			 *
			 */

			{			    
			     struct symnode *back_sym;

			     if ((back_sym = Sym_Back_Ptr(arg1))) {
				 Sym_addr_taken(back_sym->index) = 1;
			     } else {
				 Sym_addr_taken(arg1) = 1;
			     }
			}
		    }
		}
	    }
            break;
        case R_DATA_EXPR:
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex (DATA_ALIGNMENT_WRONG,fix_info->type,
				    Subsp_Misc(fixup_subsp).file_name, 0);
            if (!relocatable &&
                gen_ldr_fixups &&
                arg1 == RELOCATABLE &&
                ! same_quadrant(0, arg0)) {
                if (!IS_LOADABLE(fixup_subsp) || !IS_PRIVATE(fixup_subsp)) {
                    external_error(INVALID_LOADER_FIXUP, 
				   Subsp_Misc(fixup_subsp).file_name,
				   0);
		}
                loader_fixup_size++;
		Subsp_Misc(fixup_subsp).subsp_has_dreloc = TRUE;
            }
            break;
        case R_ZEROES:
	    /*
	    ** Need copyram entries for the region covered by the zeroes 
	    ** fixup and the region started by the next fixup (ie. 2) 
	    ** Only count if we indeed need this space copyram'd 
	    */
            /* Embedded systems code */
            if (space_misc[Subsp_Dict(fixup_subsp).space_index].copyram_needed
	        && !space_misc[Subsp_Dict(fixup_subsp).space_index].no_compression) {

                if (last_was_uninit) 
	          copyram_count += 2 ;  /* init and uninit entry */
         	else
	          copyram_count += 1 ; /*  uninit entry only */

		last_was_uninit = TRUE;  /* zeroes entry is uninit */
		/* Make sure subsp length does not include the zero fixups */
	        Subsp_Misc(fixup_subsp).rom_subsp_length -= arg0;
	    }
            break;

        case R_ABS_CALL:
		/* no ABS_CALL code allowed in shared libraries */
	    if (building_shlib) {
	    	user_error (NON_PIC_IN_SHLIB,
	    	Subsp_Misc (fixup_subsp).file_name,0);
            }
	    CHECK_SUBSP_SYM(arg1);
            /* check alignment for some fixups */
            if ((branch_dot & 03) != 0)
                external_error_hex(DATA_ALIGNMENT_WRONG,fix_info->type,
				       Subsp_Misc(fixup_subsp).file_name, 0);
	    /* This is the same test used in stubs.c:check_for_stubs() */
	    if (field_sel == R_FSEL)
	        bl_seen_in_subspace = TRUE;
	    break;

    } /* switch */

    switch (fix_info->type) {
    	case R_NO_RELOCATION:
	  break;

	case R_UNINIT:
	  if (truncate_fixups) {	/* If only R_NO_RELOCATION so far... */
	      if (uninit_seen)		/* If we have seen an UNINIT, don't */
		  truncate_fixups = FALSE;  /* truncate fixups! */
	      else
		   uninit_seen = TRUE;	/* Remember that we saw an UNINIT */
	  }

	default:
	  truncate_fixups = FALSE;
          break;
    }

    return (NULL);
} /* end unwind_and_recover_fixups */

/* FORWARD DECLARATION */
Fixup *optimize_pass();
Fixup *delete_instructions();
Fixup *adjust_instructions();

optimize()
{
    int new_sp_index, sp_index;
    int old_index, subsp_index, num_subsp;
    int total_instr_deleted = 0;        /* used for addil elim */
    dense_set_type realloc_dense_set(); /* used for addil elim */
    int compute_new_sym_values();       /* used for addil elim */

    /* at this point, the unwind/recover subspaces must be set either by the
       count_unwind_recover_size above or by having been built in 
       "collect_soms". */
    assert( recover_end_subsp != UNSET );
    assert( recover_subsp != UNSET );
    assert( unwind_end_subsp != UNSET );
    assert( unwind_subsp != UNSET );

    /* MISCELLANEOUS assignment of dollar_global and milli_label */

    if (dollar_global != BAD_SYM)
        dollar_global_addr = symbol_value(dollar_global);  
					/* not defined yet if not optimizing */

    use_opt_sym_values = 0;

    elim_insts = (dense_set_type *) ecalloc(subsp_dict_size,
					  sizeof (dense_set_type));

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];

	/* for all subspaces, whether loadable or not */
	subsp_index = space_array[sp_index].subspace_index;
	num_subsp = space_array[sp_index].subspace_quantity;

	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;

    	    in_branch_table = FALSE;
    	    last_seen_brtab_end = 0;
	    addils_deleted = 0;
	    copies_deleted = 0;
	    /* new bit vector */
	    elim_insts[old_index] = NULL;

            if (Subspace_Length(old_index) != 0) /* prevent useless call */
                traverse_fixups(old_index, OPTIMIZE_PASS);

            /* ADDIL Elimination */
	    if ((copies_deleted+addils_deleted) > 0) {
	        assert(IS_LOADABLE(old_index));
                if (verbose & V_OPT1) {
		    dump_dense_set(stdout, elim_insts[old_index], 
		  		        Subsp_Misc(old_index).file_name);
		}
    
		in_branch_table = FALSE;  /* reset at end of subspace */
    	    	last_seen_brtab_end = 0;

		opt_data_offset = 0;  /* start copy at first word */
		uninit_offset = 0;    /* adjust inst_off by any uninit areas */
				      /* in subsp */
                traverse_fixups(old_index, DELETE_INSTRUCTIONS);
    
	        Subsp_Dict(old_index).subspace_length -= 
		    ((copies_deleted+addils_deleted) * WORDSIZE); 
    
		/* update total count */
		total_instr_deleted += (addils_deleted + copies_deleted);
	    } else {
	        /* Make sure we adjust constants for references to syms */
		/* in subspaces we have already seen */
                /* if (Subspace_Length(old_index) != 0)  */
                if (Subsp_Dict(old_index).initialization_length != 0) {
		    /* adjust inst_off by any uninit areas */
		    uninit_offset = 0; 
                    traverse_fixups(old_index, ADJUST_INSTRUCTIONS);
		}

	    } /* else adjust constants */

          } /* loop over subspaces */

        } /* loop over spaces */

    use_opt_sym_values = 1;   /* let symbol value know to use the deltas */

    compute_new_sym_values();

    for (num_subsp = (subsp_dict_size-1); (num_subsp >= 0) ; num_subsp--) {
        /* Adjust new subspace start field in misc record */

        /* Free up those bit vectors */
	if (elim_insts[num_subsp])
	    efree(elim_insts[num_subsp]);
     }
	
    if (verbose & V_OPT || verbose & V_OPT1) {
	fprintf(stdout, "Eliminated %d ADDIL and COPY Instructions.\n", 
							 total_instr_deleted);
    }
} /* optimize */

Fixup *optimize_pass(fix_info, fixup, arg0, arg1)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1;
{
    static Boolean decr_copy_fixup = FALSE; 
			/* was ADDIL,COPY found on the previous invocation? */

    switch (fix_info->type) {

        case R_BEGIN_BRTAB:
	    in_branch_table = TRUE;
	    break;

        case R_END_BRTAB:
	    in_branch_table = FALSE;
	    last_seen_brtab_end = (branch_dot-original_branch_dot)/WORDSIZE;
	    break;

        case R_NO_RELOCATION:
	    if(decr_copy_fixup) {
    		decr_copy_fixup = FALSE;
            	if (fix_info->len > 1 ) {
		    /* clear the bit for this inst - don't delete, as
			   would be an annotated multi-byte fixup (i.e.,
			   IS_ANNOTATABLE(R_NO_RELOCATION) == TRUE) and
			   would cause a lot of R_NO_RELOCATION's to be
			   expanded from R_PREVs unnecessarily - and is rare
			   enough to ignore for performance purposes.  */
		    remove_dense_set_item(elim_insts[fixup_subsp],
			((branch_dot-original_branch_dot)/WORDSIZE));
		    copies_deleted--;
		}
	     }
	    break;

        case R_DP_RELATIVE:
	    /* If a code subspace, in a loadable space, and addil elim*/
	    if ((Subsp_Dict(fixup_subsp).code_only) &&
		 IS_LOADABLE(fixup_subsp) && 
		 eliminating_addils && !in_branch_table) {
                arg0 += sym_bias;
                arg0 = Sym_Remap(arg0);

                /*
                ** If this is a shared global then the ADDIL cannot be 
                ** removed since it will be converted to a LDW to get 
                ** the contents of the DLT entry which will contain the
                ** address of the global data item.
                */
#ifdef TSD /* TSD */
                if (!Sym_TLS(arg0) && !Sym_SharedGlobal(arg0)) {
#else
                if (!Sym_SharedGlobal(arg0)) {          
#endif /* TSD */
    		    decr_copy_fixup = 
		        try_to_elim_inst(
                            (branch_dot-original_branch_dot)/WORDSIZE, 
                            arg0);
                }
            }
#ifdef TSD /* TSD */
	    tp_override = FALSE; /* reset */
#endif /* TSD */
	    break;
        }
    return (NULL);
} /* optimize_pass */

void do_fixups(subsp_index, subsp_data_ptr, out_som_fd, file_loc)
int subsp_index;
unsigned char *subsp_data_ptr;
int out_som_fd;
int file_loc;
{

     unsigned char actual_out_buffer[BUFF_BYTE_SIZE];
     out_buffer = actual_out_buffer;

     /* 
     ** Insert any needed align in rom space. default adjust is 0 
     */
     if (Subsp_Misc(subsp_index).rom_subsp_adjustment != 0)
          file_loc += Subsp_Misc(subsp_index).rom_subsp_adjustment;
     out_location = file_loc;
     out_limit = file_loc + Subspace_Length(subsp_index);

     state_diagram = INITIAL_STATE;

     /* starting virtual address for line number table */ 
     if (generate_aux_unwind && recover_end_subsp != BAD_SUBSP) {
          line_table_virtual_addr = 
               Subspace_Virtual_Offset(recover_end_subsp) + 
               aux_unwind_size + WORDSIZE + 
               Subsp_Misc(subsp_index).line_tbl_offset;
     }

     /* Embedded systems code */
     if (copyram_subsp != BAD_SUBSP) {
          /* index of copyram table */
          curr_copyram_index = Subsp_Misc(subsp_index).copyram_index;

	  /*
	  ** 8 bytes are added in so we can use branch_dot to find out
	  ** how big a region was described. Since branch_dot appears
	  ** 8 bytes after the present location to begin, we must also
	  ** be 8 bytes into the subspace so the length will be adjusted
	  ** correctly when we build our copyram entry
	  */
          copyram_entry_start = Subspace_Virtual_Offset(subsp_index)
					       + 2*WORDSIZE;
     }

     buff_ptr = out_buffer;
     current_subspace_start_p = subsp_data = subsp_data_ptr;
     first_time_this_subspace = (Subsp_First_Common(subsp_index) == -1);
     if (!first_time_this_subspace) {
          /* prime the output buffer with previous initialization(s) */
	  output_retrieve(buff_ptr, out_location, out_limit, BUFF_BYTE_SIZE);
     }

     applying_fixups = TRUE;
     traverse_fixups(subsp_index, APPLY_FIXUPS);
     applying_fixups = FALSE;

#if 0
     /* dont do this any more */
     if (curr_copyram_index != -1) { 
        /* flush last entry for this subspace */
        make_copyram_entry(0, FALSE, branch_dot - copyram_entry_start, 0);
     }
#endif /* 0 */
     /* Embedded systems code */
     if (copyram_subsp != BAD_SUBSP) {
          /* flush last entry for this subspace */
          make_copyram_entry(0, FALSE, branch_dot - copyram_entry_start, 0);
     }

     if ((Subsp_Dict(subsp_index).initialization_length != 0) &&
         (Subsp_Dict(subsp_index).fixup_request_quantity == 0)) {
          output_flush(subsp_data_ptr, out_location, 
		       Subspace_Length(subsp_index));
	  /* 
          ** if initialized but no fixups (e.g., created in memory by ld), 
	  ** copy entire subspace w/o relocation 
          */
     } else if (buff_ptr != out_buffer)
          output_flush(out_buffer, out_location, buff_ptr - out_buffer);
} /* do_fixups */

/* HP-UX shared library */
void bld_shlib_dreloc_rec(sym_index, location, fixup_const, dreloc_rec_type,
                          subsp_index)

int sym_index;	/* sym table index of the symbol fixup is relative to */
int location;	/* offset of location for this fixup to patch 
						(data space-relative) */
int fixup_const; /* "constant" offset from the fixup or zero */
unsigned char dreloc_rec_type;  /* type of dreloc record, CODE/DATA, INT/EXT */

int subsp_index;  /* Pass the subsp index in, now */

/* Fills in the next dynamic relocation record for an HP-UX shared library. */

{
    struct subsp_misc_record *misc;	/* ptr to $SHLIB_INFO$ subsp */
    struct dl_header *dl_hdr;		/* ptr to shlib header record */
    struct dreloc_record *dreloc_rec;	/* ptr to the current dynamic 
					   reloc record to be filled in. */
    extern struct module_entry *shlib_module;

    /* Now we use this routine for incomplete program files, too! */
    if (!mixed_mode_off) {
        assert (building_shlib || building_incomp_exec);
    }
    else {
        assert (building_shlib ||
                (building_incomp_exec && !do_data_copy &&
                 Sym_SharedGlobal (sym_index) &&
                 DR_DATA_EXT == dreloc_rec_type));
    }


#if 0
	/* this routine only used during shlib builds */
    assert(building_shlib);  
#endif /* 0 */

#ifdef DEBUG
    if ((verbose & V_NO_DATA_COPY) && building_incomp_exec) {
	printf ("bld_shlib_dreloc_rec: adding DR_DATA_EXT dreloc for ");
	printf ("\"%s\"\n", Sym_Name (sym_index));
    }
#endif /* DEBUG */

    misc = & Subsp_Misc(shlib_info_subsp_index);
    dl_hdr = (struct dl_header *) misc->subsp_data;

    /* find the next dynamic relocation record to be built */
    dreloc_rec = (struct dreloc_record *) (misc->subsp_data + 
					   dl_hdr->dreloc_loc);
    dreloc_rec += (DR_PROPAGATE_count + loader_fixup_index++);  
		/* ptr to the record to be built */
		/* also bumps running count for check in output.c */

    /* fill in fields of the dynamic relocation record */
    dreloc_rec->shlib = BAD_SUBSP;  /* not applicable when building shlib
					or PR_PLABEL dreloc records */
    dreloc_rec->location = location;  /* computed by caller */
    dreloc_rec->type = dreloc_rec_type;  /* computed by caller */
    dreloc_rec->reserved = 0;  /* don't leave uninit holes in output file */

		/* the subspace number of the data being inited - for use
		   when in output.c to relocate the address fields and 
		   (after relocation to the output subsp number) copying 
		   these records into an a.out. */
	/*   "module_index" is only 16 bits; the fixup_subsp
	** can overflow this.  Use the "shlib" field now. */
    dreloc_rec->shlib = subsp_index;  /* Now use argument, not global */
#if 0 
    dreloc_rec->module_index = fixup_subsp;
#endif /* 0 */

    if (sym_index == BAD_SYM) { /* R_RELOCATION fixup to apply */
	dreloc_rec->symbol = BAD_SYM;
	dreloc_rec->value = fixup_const;
    } else
	switch (dreloc_rec_type) {
	    case DR_PLABEL_INT:
		dreloc_rec->value = fixup_const;
		dreloc_rec->symbol = BAD_SYM;
		break;
	    case DR_DATA_INT:
		dreloc_rec->value = symbol_value(sym_index) - 
					data_offset + fixup_const;
		dreloc_rec->symbol = BAD_SYM; 
		break;
	    case DR_TEXT_INT:
		dreloc_rec->value = symbol_value(sym_index) - 
					code_offset + fixup_const;
		dreloc_rec->symbol = BAD_SYM; 
		break;
	    case DR_PLABEL_EXT:
		dreloc_rec->value = fixup_const;
		dreloc_rec->symbol = Sym_ShlImp_Indx(sym_index);
                if(dreloc_rec->symbol == elaborator_index) {
                    int mi;
		    dreloc_rec->type = DR_INVOKE;
                    mi = find_module_by_subspace (subsp_index);
#if 0
                    mi = find_module_by_subspace(dreloc_rec->module_index);
#endif /* 0 */
                    if(shlib_module != NULL)
                       shlib_module[mi].flags |= ELAB_REF;
                    }
		assert (dreloc_rec->symbol < import_entry_count);  
				/* index into the import list => has to fit */
                break;
	    case DR_DATA_EXT:
		dreloc_rec->value = fixup_const;
		dreloc_rec->symbol = Sym_ShlImp_Indx(sym_index);
		assert (dreloc_rec->symbol < import_entry_count &&
			dreloc_rec->symbol >= 0);  
			/* index into the import list => has to fit */
		break;
	    }
} /* end bld_shlib_dreloc_rec */

int find_orig_sym(sym_index)
int sym_index;  /* symbol dict index to start search for original sym */
{
    while ((sym_index != BAD_SYM) && IS_STUB(sym_index))
        sym_index = Sym_Related_Stub(sym_index);
 
    return (sym_index);
}

/************************************************************************/
/*                              APPLY FIXUPS                            */


/*
**			 FLUSH_BUFFER/flush_buffer
**
** NAME
**	flush_buffer - manages the output buffer for fixed-up results.
**
**
** DESCRIPTION
**	The macro FLUSH_BUFFER(pad) decides if the buffer must be flushed.
**	The function flush_buffer(dest, pad) writes it to the output file.
**	Using a function call here after the test cuts about 44 dead
**	    paths from our PFA coverage, as well as smaller code size.
**	The argument dest (in) is a pointer to the current destination in
**	    the output buffer.  Its updated value is also the return value, 
**	    for update of the original register copy in "apply_fixups".
**	    This gives the best code gen, allowing "dest" to stay in a reg.
**	The argument pad (in) to the macro is the minimum amount of buffer
**	    space required to remain. 
**
** RETURNS
**  updated value of "dest" - usually (always?) the beginning of "out_buffer".
**
*/

#define FLUSH_BUFFER(pad) 					\
        if (dest + (pad) >= &out_buffer[BUFF_BYTE_SIZE])       	\
		dest = flush_buffer(dest)

unsigned char *flush_buffer(dest)
unsigned char *dest;
{
    int flush_size = (dest - out_buffer);

    output_flush(dest = out_buffer, out_location, flush_size);
    out_location += flush_size;
    if (!first_time_this_subspace)
        output_retrieve(dest, out_location, out_limit, flush_size);
    return(dest);
}

#define GET_DATA_WORD(x)                        \
    ((int)source & 03 ? (x =  *source++ << 24,  \
                         x |= *source++ << 16,  \
                         x |= *source++ << 8,   \
                         x |  *source++         \
                        )                       \
                      :                         \
		        ( (source += sizeof(int)),          \
		          *((int *)(source - sizeof(int)))  \
		        )			            \
    )

/* apply_fixups
 *
 *      The main purpose of apply fixups is, of course, to transfer the
 *      subspace data from the relocatable file to the output file,
 *      applying any changes dictated by the fixups on the way.  But
 *      there are a couple of other things going on because it is most
 *      convenient to wait until this moment to do them.
 *
 *      Note that for all of these extra things, we must be told where
 *      to put the information in the file explicitly, since we will
 *      be calling this routine in ORIGINAL subspace order, rather than
 *      the actual output order in the file.  This is not true of loader
 *      fixups, since we build a table for them and explicitly sort them
 *      later, just before they are written to the file.  There are not
 *      expected to be many loader fixups.
 *
 *      1) Unwind and auxiliary unwind tables are being built:
 *              This applies to the ENTRY, ALT_ENTRY and EXIT fixups.
 *
 *              do_fixups sets state_diagram to INITIAL_STATE.
 *              init_unwind_recover_build (called from out_subspace_data)
 *              sets up the file location for the unwind table and
 *              auxiliary unwind table.
 *
 *      2) Recover tables are being built:
 *              This applies to the BEGIN_TRY and END_TRY fixups.
 *
 *              TRY_COUNT needs to be 0 initially (already checked in
 *              an earlier pass over the fixups).
 *              init_unwind_recover_build (called from out_subspace_data)
 *              sets up the file location for the recover table.
 *
 *      3) Loader fixups are being built:
 *              This applies to the RELOCATION, DATA_ONE_SYMBOL,
 *              DATA_PLABEL, and DATA_EXPR fixups.
 *
 *      4) Absolute fixups are being built:
 *              This applies to the RELOCATION, DATA_ONE_SYMBOL,
 *              DATA_PLABEL, ABS_CALL, CODE_ONE_SYMBOL and CODE_PLABEL
 *              fixups.
 *
 *              ALERT: It ought to apply to CODE_EXPR fixups as well.
 *
 *              abs_fix_base is set by out_subsp_data.
 *
 *      5) Line number table are being built
 *              This applies to unwind fixups (R_ENTRY, R_EXIT, R_ALT_ENTRY),
 *              as well as the R_STATEMENT and R_AUX_UNWIND fixups.
 *
 * 	A word out the output buffer used to flush fixups. The current
 *      code relies on cooperation amoung the various fixup cases to 
 *      maintain the output buffer and not overrun it as opposed to calling
 *      a separate routine to maintain the buffer. This direct maintenance
 *      may be faster (I doubt it) but it certainly introduces some 
 *      interesting (and duplicated) code. Things to look out for:
 *
 *      1) If you require that the destination be word aligned 
 *           If you are writing one word of data - 
 *         	you can assume the buffer will have enough room
 *           If you are writing more than one word of data, 
 *              you can assume the first word will fit, you must
 *              check for buffer overruns beyond that.
 *
 *         You must flush the buffer when done. 
 *
 *      2) If you do not require that the destination be word aligned
 *           You must check for buffer overflow for every byte written. 
 *
 *         You must flush the buffer when done. 
 *
 */

Fixup *apply_fixups(fix_info, fixup, arg0, arg1, arg2)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1, arg2;
{
    int knt, temp;
    int value, type, word;
#ifdef WW_ANNOTATIONS
    unsigned int new_flags, action, info;
#endif /* WW_ANNOTATIONS */

    unsigned char *source, *dest;
	/* Note : any case that assigns to *dest++ must "call" FLUSH_BUFFER();,
	   usually by ending in a goto FLUSH_IT;  */

    int LT_offset;  /* temp to hold Linkage table offset of current sym */
    int saved_default_mode;  /* saved value of "default_mode" for reset */
    int orig_sym_indx;  /* original symbol index for annotated fixups */
    int stub_offset;  /* byte offset of stub for annotated fixups */
    struct stub_record *stub_ptr;  /* temp ptr for finding the original fixup's
					data after annotation */

    int space_index;
    int subspace_index;
    int this_space_index;     /* used when determining if Embed Pic Code */
    int instruction;          /* used when determining if Embed Pic Code */
    int LT_ptr;               /* temp to hold Linkage table ptr va */

#ifdef TSD /* TSD */
    struct subspace_dictionary_record *subsp;
#endif /* TSD */

    dest = buff_ptr;
    source = subsp_data;

    switch (fix_info->type) {
#ifdef PA_2_0
	case R_SHORT_PCREL_MODE:
	case  R_LONG_PCREL_MODE:
#endif /* ifdef PA_2_0 */
        case R_BEGIN_BRTAB:
        case R_END_BRTAB:
        case R_FSEL:
        case R_LSEL:
        case R_RSEL:
	case R_N1SEL:
        case R_N_MODE:
        case R_S_MODE:
        case R_D_MODE:
        case R_R_MODE:
        case R_DATA_OVERRIDE:
        case R_TRANSLATED:
        case R_COMP1:
        case R_COMP2:
        case R_COMP3:
        case R_SEC_STMT:
	case R_LTP_OVERRIDE:
#ifdef TSD /* TSD */
        case R_TP_OVERRIDE:
#endif /* TSD */
	case R_R19_LDST:
	case R_INDIRECT_CALL:
       /******** INTERNAL ***********/
        case R_NEW_BLE:
	case R_EXEC_LEVEL:
            /* recognized, but ignored */
            return (NULL);

	case R_N0SEL:
	    N0_fixup_seen = TRUE;
            return (NULL);

        case R_NO_RELOCATION:
            while ( arg0 != 0 ) {
                knt = &out_buffer[BUFF_BYTE_SIZE] - dest;
                if (arg0 < knt)
                    knt = arg0;
                memcpy(dest, source, knt);
                dest += knt;
                FLUSH_BUFFER(0);
                source += knt;
                arg0 -= knt;
            }
            break;

        case R_UNINIT:
            if (!first_time_this_subspace) {
                /* skip the un-init */
                knt = &out_buffer[BUFF_BYTE_SIZE] - dest;
                if (arg0 >= knt) {
                    arg0 -= knt;
                    /* FLUSH current buffer */
                    output_flush(dest = out_buffer,
                                 out_location,
                                 BUFF_BYTE_SIZE);
                    out_location += BUFF_BYTE_SIZE;
                    /* SKIP intermediate data */
                    out_location += (arg0 & ~03);   /* keep word aligned */
                    arg0         -= (arg0 & ~03);
                    /* GET next buffer */
                    output_retrieve(dest,
                                    out_location,
				    out_limit,
                                    BUFF_BYTE_SIZE);
                }
                dest += arg0;
                break; 
            }

	    if (NOT_ALIGNED(dest)) {
                /* put zeroes until we are aligned (or done) */
                repeat {
                    FLUSH_BUFFER(0);
                    *dest++ = 0;
                }
                until (--arg0 == 0 || ALIGNED(dest));
                FLUSH_BUFFER(0);
            }
    
            while ( arg0 != 0 ) {
                knt = &out_buffer[BUFF_BYTE_SIZE] - dest;
                if (knt > arg0)
                    knt = arg0;
                arg0 -= knt;
                while ((unsigned int)knt >= sizeof(int)) {
                    /* nicely aligned zeroes */
                    *(int *)dest = 0;
                    dest += sizeof(int *);
                    knt  -= sizeof(int);
                }
                /* take care of any non-aligned filler at the end */
                while (knt != 0) {
                    *dest++ = 0;
                    knt--;
                }
                FLUSH_BUFFER(0);
            }

            break;

        case R_ZEROES:
            /* Embedded systems code */
	    if (!space_misc[Subsp_Dict(fixup_subsp).space_index].copyram_needed
              || 
	      space_misc[Subsp_Dict(fixup_subsp).space_index].no_compression) {
                /* Need to initialize region in file */
                if (NOT_ALIGNED(dest)) {
                    /* put zeroes until we are aligned (or done) */
                    repeat {
                        FLUSH_BUFFER(0);
                        *dest++ = 0;
                    }
                    until (--arg0 == 0 || ALIGNED(dest));
                    FLUSH_BUFFER(0);
                }
    
                while ( arg0 != 0 ) {
                    knt = &out_buffer[BUFF_BYTE_SIZE] - dest;
                    if (knt > arg0)
                        knt = arg0;
                    arg0 -= knt;
                    while ((unsigned int)knt >= sizeof(int)) {
                        /* nicely aligned zeroes */
                        *(int *)dest = 0;
                        dest += sizeof(int *);
                        knt  -= sizeof(int);
                    }
                    /* take care of any non-aligned filler at the end */
                    while (knt != 0) {
                        *dest++ = 0;
                        knt--;
                    }
                    FLUSH_BUFFER(0);
                }
                /* Embedded systems code */
      	    } else {
                /* else build copyram table entries for embed systems */

		/* fill in previous entry */
                make_copyram_entry(0, FALSE, 
			                  branch_dot - copyram_entry_start, 0);

                /* arg0 has the amount of zeroes needed */
                make_copyram_entry(0, TRUE, arg0, 0);

                /* set the start for the next entry */
                copyram_entry_start = branch_dot + arg0;

            }
            break;

        case R_RELOCATION:
            value = get_constant(GET_DATA_WORD(temp)) +
                    Subspace_Virtual_Offset(fixup_subsp) -
                    Subsp_Dict(fixup_subsp).subspace_start;
            *((int *)dest) = value;
	    dest += sizeof(int *);

            /* LOADER FIXUP */
            if (!relocatable &&
                gen_ldr_fixups &&
                IS_LOADABLE(fixup_subsp) &&
                IS_PRIVATE(fixup_subsp))

		if (building_shlib)
		    bld_shlib_dreloc_rec(
			BAD_SYM, 
			(branch_dot-original_branch_dot), /* subsp offset */
			value, 
			DR_DATA_INT,
                        fixup_subsp);
		else
                /* MPE loader fixup */
		   add_loader_fixup (LD_DATA_REF);

            /* ABSOLUTE FIXUP */
            if (!relocatable && !strip_fixups && mapped &&
                branch_dot < QUAD_1_BASE+2*WORDSIZE) {

                if (relinkable &&
                    unwind_subsp != BAD_SUBSP &&
                    Subsp_Misc(fixup_subsp).r_o_x >=
                        Subsp_Misc(unwind_subsp).r_o_x) {
                    external_error(UNWIND_REFERENCE, 
                                   Subsp_Misc(fixup_subsp).file_name,
                                   0);
		}
                out_one_abs_fixup(R_ABS_DATA, branch_dot-abs_fix_base);
            }

            goto FLUSH_IT;

        case R_DATA_ONE_SYMBOL:
            arg0 += sym_bias;
            /* remap necessary, since using arg0 as a simple index */
            arg0 = Sym_Remap(arg0);

            /* If target space is relocatable let user know */
            if ((subspace_index = Sym_Subsp(arg0)) != BAD_SUBSP) {
                space_index = Subsp_Dict(subspace_index).space_index;
                if (space_misc[space_index].relocatable) {
                    this_space_index = Subsp_Dict(fixup_subsp).space_index;
                    warning(REF_TO_RELOC_SPACE,
                                 space_array[this_space_index].NAME_PT,
                                 space_array[space_index].NAME_PT);
                    warning(SYM_REFERENCED_IS, Sym_Dict(arg0).NAME_PT);
                }
	    }

#ifdef TSD /* TSD */
	    /*
            ** Do sanity check for tp override, no TLS sym or no tp
	    ** override, TLS sym.  We couldn't do the check in the first
	    ** pass over the fixups because if building a shlib and
            ** we have Data Unsats, we don't know if the sym is a TLS
            ** symbol or not until we have processed all of the fixups.
	    ** If the symbol is a Data Unsat, we are building a shlib so
	    ** we just set the TLS bit so we output the correct shlib import
            ** flag.
            */

	    if (Sym_Type(arg0) == ST_DATA && Sym_Scope(arg0) == SS_UNSAT &&
	        building_shlib && tp_override) {
		Sym_TLS(arg0) = TRUE;
  	    }
            if (tp_override && !Sym_TLS(arg0)) {
	       unlink(output_name);
               external_error(BAD_FIXUP_NON_TLS,
		              "DATA_ONE_SYM",
			      Sym_Dict(arg0).name.n_name,
			      Subsp_Misc(fixup_subsp).file_name);
            } else if (!tp_override && Sym_TLS(arg0)) {
	       unlink(output_name);
	       external_error(BAD_FIXUP_TLS,
			      "DATA_ONE_SYM",
			      Sym_Dict(arg0).name.n_name,
			      Subsp_Misc(fixup_subsp).file_name);
	    }
	    /* 
	    ** .  Check for loadable space and TSD.
	    ** Emit error message and abort
	    */
	    if (tp_override) {
	        if (IS_LOADABLE(fixup_subsp)) {
		    external_error(BAD_DATA_ONE_SYM_TSD, Sym_Name(arg0), 0);
		}
	    }
#ifdef DEBUG /* DEBUG */
	    if (verbose & V_TSD) {
               if (Sym_TLS(arg0)) {
	          printf("data one sym: value 0x%x for %s\n", Sym_Value(arg0),
		         Sym_Name(arg0)); 
	       }
	    }
#endif /* DEBUG */
#endif /* TSD */
	    /* make sure that value holds the "unfixed" value since it
	       is used below */
	    value = GET_DATA_WORD(temp);

            /* HP-UX shared library processing */
#ifdef TSD /* TSD */
            if (((building_shlib && !Sym_TLS(arg0)) && 
		 (!IS_DATA(arg0))) ||
#else
	    if ((building_shlib && (!IS_DATA(arg0))) ||
#endif /* TSD */
	        (building_incomp_exec && 
	         (Sym_Dict(arg0).symbol_type == ST_STUB_IMPORT) &&
	         (Sym_Subsp(arg0) == BAD_SUBSP))) {
		/* if pure unsat, probably in (another) shlib, must use P' 
		   fixup to get a R_DATA_PLABEL instead of R_DATA_ONE_SYMBOL */
                if (IS_LOADABLE(fixup_subsp)) {
		    /* allowed in NON-loadable subsp for $DEBUG$ in shlibs */
                    user_error(DATA_ONE_SYM_FOR_PLAB, 
			   Subsp_Misc(fixup_subsp).file_name, 
			   Sym_Dict(arg0).NAME_PT, 0);
		} else {
		    /* fixing up unloadable debug info, xdb expects the addr
		       of the original code, not any stub. */
		    arg0 = find_orig_sym(arg0);
   	        }
	    }
                /* NO_DATA_COPY */
		/*   Fix up a DATA_ONE_SYM fixup to a shared
		** global with the DLT slot address for it.  Does no
		** good to throw in the address of a bogus location! 
		*/

	    if (building_incomp_exec && ! do_data_copy &&
#ifdef TSD /* TSD */
		!Sym_TLS(arg0) &&
#endif /* TSD */
		Sym_SharedGlobal (arg0)) {
		arg1 = Subspace_Virtual_Offset (DLT_subsp_index) +
			     (Sym_ShlImp_Indx (arg0) * sizeof (DLT_ENTRY)) +
			     get_constant (value);
	    } else if (ltp_override && building_shlib) {
		/*
		** When building shared libraries and the ltp_override
		** flag has been set, place an offset relative to the
		** presumed value of R19 for the specified symbol 
		** into the target subspace.  If not building a shared 
		** library just use the virtual address of the symbol.
		** The offset must be relocated using R19 before it
		** can be used to access the specified symbol.
		*/

#ifdef TSD /* TSD */
	        /* 
		*/
	        if (Sym_TLS(arg0))
                    arg1 = symbol_value(arg0) + get_constant(value);
		else
#endif /* TSD */
		arg1 = (symbol_value(arg0) + get_constant(value)) -
		    (Subspace_Virtual_Offset(DLT_subsp_index) +
		    (ltptr_DLT_entry_index * sizeof(DLT_ENTRY)));

	    } else
                arg1 = symbol_value(arg0) + get_constant(value);
	
            /* make sure there is room in buffer to store a word */
	    FLUSH_BUFFER(sizeof(int));
            if (NOT_ALIGNED(dest)) {
                *dest++ = arg1 >> 24 & 0xff;
                *dest++ = arg1 >> 16 & 0xff;
                *dest++ = arg1 >> 8 & 0xff;
                *dest++ = arg1 & 0xff;
            } else { 
                *((int *)dest) = arg1; 
	        dest += sizeof(int *);
            }

            /* LOADER FIXUP */
            /*
            ** unwind_and_recover_fixups() for data_one_sym fixups (for -H
            ** links (MPE stuff)).  We had data_one_sym fixups to data 
            ** locals in $LIT$, which isn't private.  So we ended up 
            ** not calling add_loader_fixup() for these symbols (and 
            ** we already bumped up loader_fixup_size in
            ** unwind_and_recover_fixups()).  So we get miscounted 
            ** loader fixups in output.c.  Removed the IS_PRIVATE check here.
            */
#ifdef TSD /* TSD */
	    /* No loader fixups for TLS */
	    if (Sym_TLS(arg0)) {
	       tp_override = FALSE;
	       goto FLUSH_IT;
	    }
#endif /* TSD */
            if (!ltp_override &&
		(!relocatable && gen_ldr_fixups &&
	 	 IS_LOADABLE(fixup_subsp) &&
		 (building_shlib || building_incomp_exec ||
                  (IS_LOADABLE(Sym_Subsp(arg0)))))
                || (building_incomp_exec && !do_data_copy &&
		                 IS_LOADABLE(fixup_subsp) &&
				 Sym_SharedGlobal (arg0)))

                /* HP-UX shared library */
		if ((building_shlib && IS_DATA(arg0))
                    || building_incomp_exec) {
		    /*
		    ** Do some bounds checking so we build proper dynamic
		    */
		    assert(Sym_ShlImp_Indx(arg0) >= 0); 

		    if (out_import_list[Sym_ShlImp_Indx(arg0)].type==ST_NULL) 
			arg1 = IS_PRIVATE(Sym_Subsp(arg0)) ? 
				   DR_DATA_INT : DR_TEXT_INT;
		    else 
			arg1 = DR_DATA_EXT;

		    bld_shlib_dreloc_rec(
			arg0, 
			(branch_dot-original_branch_dot), /* subsp offset */
			value,
			arg1,
                        fixup_subsp);
		} else
  		   add_loader_fixup(LD_DATA_REF);

            /* ABSOLUTE FIXUP */
            if (!relocatable && !strip_fixups && !ltp_override &&
                mapped_symbol(arg0)) {

                if (relinkable &&
                    unwind_subsp != BAD_SUBSP &&
                    Subsp_Misc(Sym_Subsp(arg0)).r_o_x >=
                        Subsp_Misc(unwind_subsp).r_o_x) {
                    external_error(UNWIND_REFERENCE,
                                   Subsp_Misc(fixup_subsp).file_name,
                                   0);
		}
                out_one_abs_fixup(R_ABS_DATA, branch_dot-abs_fix_base);
            }

            goto FLUSH_IT;

        case R_DATA_PLABEL:
            arg0 += sym_bias;
            /* remap necessary, since using arg0 as a simple index */
            arg0 = Sym_Remap(arg0);
	    word = GET_DATA_WORD(temp);
	    /* make sure there is room in buffer to store a word */
	    FLUSH_BUFFER(sizeof(int));
            /* If target space is relocatable let user know */
            if ((subspace_index = Sym_Subsp(arg0)) != BAD_SUBSP) {
                space_index = Subsp_Dict(subspace_index).space_index;
                if (space_misc[space_index].relocatable) {
                    this_space_index = Subsp_Dict(fixup_subsp).space_index;
                    warning(REF_TO_RELOC_SPACE,
                                 space_array[this_space_index].NAME_PT,
                                 space_array[space_index].NAME_PT);
                    warning(SYM_REFERENCED_IS, Sym_Dict(arg0).NAME_PT);
                }
	    }

            /* HP-UX shared library processing */
            if ((building_incomp_exec || building_shlib) &&
		                         Sym_Type (arg0) != ST_ABSOLUTE) {
		int PLT_entry_addr;   /* address of the PLT entry for "arg0" */
		int stub_sym_index;   /* index of symbol for export stub */
		int Import_sym_index; /* Import index of symbol for 
					 export stub */

		stub_sym_index = find_export_stub_sym(arg0);

		/*  Revamped the logic here slightly,
		** since both these cases have no export stubs.  Just use the
		** original symbol for the relocation value. */
		if (stub_sym_index == BAD_SYM) {

				/* long return/no reloc have no export stub */

		    /* 
		     *
		     * Long return/no relocation symbols now have a null
		     * export stub and no longer need to be handled 
		     * specially.
		     *
		     */

 		    /* unsats have no export stub */
    		    if (Sym_Dict(arg0).symbol_type == ST_STUB_IMPORT) {

			stub_sym_index = arg0;
		    }
		}

		/* should always be found */
		assert (stub_sym_index != BAD_SYM); 

		Import_sym_index = Sym_ShlImp_Indx(stub_sym_index);
		assert(Import_sym_index >= 0);

		PLT_entry_addr =
		    ((Import_sym_index - DLT_entry_count) * 
		     sizeof(struct PLT_entry)) +
		    	/* PLT_subspace-rel addr of the export stub's 
			   PLT entry */
		    Subspace_Virtual_Offset(PLT_subsp_index) + 
		    HPUX_PLABEL_BITS;

 	        if (NOT_ALIGNED(dest)) {
                    *dest++ = PLT_entry_addr >> 24 & 0xff;
                    *dest++ = PLT_entry_addr >> 16 & 0xff;
                    *dest++ = PLT_entry_addr >> 8 & 0xff;
                    *dest++ = PLT_entry_addr & 0xff;
                } else {
                    *((int *)dest) = PLT_entry_addr;
	            dest += sizeof(int *);
	        }

		/* Put out dyn relocs even if building an incomplete
		   a.out (for mix-and-match copmatibility) m */
		if (building_shlib
                    || (!mixed_mode_off && building_incomp_exec && 
                        Sym_Type (arg0) != ST_ABSOLUTE &&
                     /* not text */
                     (IS_LOADABLE(fixup_subsp) && IS_PRIVATE(fixup_subsp)))) {

		    if (out_import_list[Import_sym_index].type == ST_NULL)
		        bld_shlib_dreloc_rec(
			    stub_sym_index, 
			    (branch_dot-original_branch_dot), /* subsp offset*/
			    PLT_entry_addr - data_offset, /* data-space-rel */
			    DR_PLABEL_INT, fixup_subsp);
		    else
		        bld_shlib_dreloc_rec(
			    stub_sym_index, 
			    (branch_dot-original_branch_dot),/* subsp offset */
			    word, 
			    DR_PLABEL_EXT,
                            fixup_subsp);
 	        } /* end building_shlib */

                goto FLUSH_IT; /* don't need any of the below */

	    } /* if (building_shlib || building_incomp_exec, && not abs) */

	    /* dead code on HP-UX, but leave in for MPE/ix testing on HP-UX */
	    if (extern_plabels && Sym_Type (arg0) != ST_ABSOLUTE) {
                type = Sym_Remap_Type(arg0);
                if (type != ST_PLABEL && type != ST_STUB_IMPORT)
                    internal_error(BAD_PLABEL_FIXUP, 0);
                value = Sym_Remap_Info(arg0) + XRT_PLABEL_BITS;
            } else
                value = symbol_value(arg0);

            value = value + get_constant(word);

 	    if (NOT_ALIGNED(dest)) {
                *dest++ = value >> 24 & 0xff;
                *dest++ = value >> 16 & 0xff;
                *dest++ = value >> 8 & 0xff;
                *dest++ = value & 0xff;
            } else {
                *((int *)dest) = value;
	        dest += sizeof(int *);
            }

            /* LOADER FIXUP */
            if (!relocatable && gen_ldr_fixups && extern_plabels)
		add_loader_fixup(LD_XRT_REF);

            /* ABSOLUTE FIXUP */
            if (!relocatable &&
                !strip_fixups &&
                !extern_plabels) {

                if (relinkable &&
                    unwind_subsp != BAD_SUBSP &&
                    Subsp_Misc(Sym_Subsp(arg0)).r_o_x >=
                        Subsp_Misc(unwind_subsp).r_o_x) { 
                    external_error(UNWIND_REFERENCE, 
                                   Subsp_Misc(fixup_subsp).file_name,
				   0);
		}
                out_one_abs_fixup(R_ABS_DATA, branch_dot-abs_fix_base);
            }

            goto FLUSH_IT;

/* COMMENTED OUT
 *      case R_SPACE_REF:
 *          external_error_hex(INVALID_FIXUP, R_SPACE_REF);
 *          break;
 */

        case R_REPEATED_INIT:
            /* temp keeps track of how much of the Pattern has been moved */
            /* temp varies from 0 to PatternLength-1                      */
            temp = 0;
	    if (data_override) {
		arg0 = WORDSIZE;
		source = (unsigned char *) &data_override_value;
	    }
            while (arg1 != 0) {
                knt = &out_buffer[BUFF_BYTE_SIZE] - dest;
                /* knt is how empty the buffer is */
                /* if this is bigger than init len remaining, use that */
                if (arg1 < knt)
                    knt = arg1;
                /* if this is bigger than length remaining in data, use that */
                if (arg0-temp < knt)
                    knt = arg0-temp;
                /* do the copy */
                memcpy(dest, &source[temp], knt);
                arg1 -= knt;
                temp += knt;
                if (temp == arg0)
                    temp = 0;
                dest += knt;
                FLUSH_BUFFER(0);
            } /* while */
	    if (data_override)
		source = subsp_data;
	    else
		source += arg0;
            break;

        case R_PCREL_CALL:
            arg1 += sym_bias;
	    /* OGL support for R_INDIRECT_CALL */
	    if(dyncall_external_used){
	       dyncall_external_used = FALSE;
	       if(building_incomp_exec || building_shlib){
                  if (dyncall_external == -1) {
                      user_error(BAD_MILLI_A, 0);
                  }
	          arg1 = dyncall_external; /* dyncall_external is biased. */
	       }
	       else {
		  if(pcx_u_pa2_0){
                     /* get original instruction */
                     value = GET_DATA_WORD(temp);
		     *((int *)dest) = BVE_R22_R2;
		     dest += sizeof(int *);
                     goto FLUSH_IT;
		  }
	       }
	    }
	    arg1 = Sym_Remap(arg1);
            /* get original instruction */
            value = GET_DATA_WORD(temp);
            /* check R_NEW_BLE flag */
		/*  Don't build a BLE for
		** "funky long branch PIC PCREL form" instructions. */
            if (new_ble_flag && (GET_OP(value) == 0x3a /* BL */)) {
                /* update override stuff */
                data_override = FALSE;
                field_sel = R_FSEL;
                /* KEEP the nullify bit from the original instruction */
                /* Use BLE if link register == 31, BE if link register != 31 */
                /* (should be error if link register != 31 or 0) */
                /* use the original code for now, 
                value = (GET_LINK(value) == 31 ? BLE_SR4 : BE_SR4) |
                        (value & NULLIFY_BIT); */

		/* 
		 *  - non-standard millicode calls are NOT
 		 * millicode calls and should be made a regular function
		 * call.  No change is done to the code, but if the same
		 * problem arises again, then we should consider outputting
		 * an error message here. 
		 */
                value = BLE_SR4 | (value & NULLIFY_BIT);
            }
            if(OPTIONAL_PROC(arg1)) {
                *((int *)dest) = NOP;
	        dest += sizeof(int *);
	    } else {
  		if ((GET_OP(value) == 0x0a /* ADDIL */) ||
                    (GET_OP(value) == 0x0d /* LDO */)) {
                        /* if ADDIL or LDO, then we have a funky long branch
                           PIC PCREL form and we need to subtract branch_dot */
                    doing_pcrel = TRUE;
                    *((int *)dest) = fix_instruction(value,
                                            symbol_value(arg1),
                                            Sym_Remap_Type(arg1), RET_WORD,
                                            NULL); /* missing code from 2.27*/

                    doing_pcrel = FALSE;
		} else {
                    *((int *)dest) = fix_instruction(value, 
						 symbol_value(arg1),
                                                 Sym_Remap_Type(arg1), 
						 RET_WORD,
                                                 NULL); /* missing code 2.27 */
		}
	        dest += sizeof(int *);
		}
            goto FLUSH_IT;

	/* Defined in fixups.h now */
#if 0
#define REG_MASK	(~0x03e00000)	/* mask to zero ADDIL/LDW reg field */
#define R27_MASK	0x03600000	/* mask to set reg = DP in ADDIL/LDW */
#endif /* 0 */

        case R_PLT_REL: 
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
            value = GET_DATA_WORD(temp);
            if (GET_OP(value) == 0x0a) {  /* an ADDIL */
		if(!building_shlib) { /* building incomplete a.out: */
				      /* using $global              */
                   value = (value & REG_MASK) | R27_MASK;
                   LT_offset = (Sym_ShlImp_Indx(arg0) - DLT_entry_count) *
						    sizeof(struct PLT_entry);

                   LT_offset += Subspace_Virtual_Offset(PLT_subsp_index) -
                                    symbol_value(dollar_global);

		}
		else { /* building shlib: using R19 stead of $global */
		       /* From assign_PLT_offset():                  */
		   LT_offset = Subspace_Virtual_Offset(PLT_subsp_index) -
			       Subspace_Virtual_Offset(DLT_subsp_index) -
			       (ltptr_DLT_entry_index * sizeof(DLT_ENTRY));

                   LT_offset += ((Sym_ShlImp_Indx(arg0) - DLT_entry_count) *
				                  sizeof(struct PLT_entry));

		}
            }
            else { /* fix ldw */

		if(!building_shlib) { /* building incomplete a.out: */
				      /* using $global              */
                   LT_offset = (Sym_ShlImp_Indx(arg0) - DLT_entry_count) *
						    sizeof(struct PLT_entry);

                   LT_offset += Subspace_Virtual_Offset(PLT_subsp_index) -
                                    symbol_value(dollar_global);

		}
		else { /* building shlib: using R19 stead of $global */
		       /* From assign_PLT_offset():                  */
		   LT_offset = Subspace_Virtual_Offset(PLT_subsp_index) -
			       Subspace_Virtual_Offset(DLT_subsp_index) -
			       (ltptr_DLT_entry_index * sizeof(DLT_ENTRY));

                   LT_offset += ((Sym_ShlImp_Indx(arg0) - DLT_entry_count) *
				                  sizeof(struct PLT_entry));
	
		}
            }
            *((int *)dest) = fix_instruction(
			 value, 
			 LT_offset, 
			 ST_NULL,
                         RET_WORD,
                         NULL); /* missing code 2.27 */
            dest += sizeof(int *);
            goto FLUSH_IT;

        case R_DATA_GPREL: 
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);

            value = GET_DATA_WORD(temp);
	    if (!building_shlib) {

#ifdef MDEBUG
		fprintf(stderr, 
		  "GET_DATA_WORD(temp) = 0x%x\n", 
		  GET_DATA_WORD(temp));
		fprintf(stderr, 
		  "symbol_value(arg0) = 0x%x\n", 
		  symbol_value(arg0));
		fprintf(stderr, 
		  "symbol_value(dollar_global) = 0x%x\n", 
		  symbol_value(dollar_global));
		fprintf(stderr, 
		  "sym - dollar_global = 0x%x <----\n\n", 
		  symbol_value(arg0) - symbol_value(dollar_global));
#endif

                /* sym + addend - $global$ */
	        arg1 = symbol_value(arg0) + value -
                      symbol_value(dollar_global);
            } else {
                /* sym + addend - <address of linkage table pointer> */
	        LT_ptr = Subspace_Virtual_Offset(DLT_subsp_index) +
			(ltptr_DLT_entry_index * sizeof(DLT_ENTRY));
	        arg1 = symbol_value(arg0) + value -
                      LT_ptr;
#ifdef MDEBUG
		fprintf(stderr, "GET_DATA_WORD(temp) = 0x%x\n", 
		  GET_DATA_WORD(temp));
		fprintf(stderr, "LT ptr = 0x%x\n", LT_ptr);
		fprintf(stderr, "symbol_value(arg0) = 0x%x\n", 
		  symbol_value(arg0));
		fprintf(stderr, 
		  "sym - LT_ptr = 0x%x <----\n\n", 
		  symbol_value(arg0) - LT_ptr);
#endif
            }

            /* make sure there is room in buffer to store a word */
	    FLUSH_BUFFER(sizeof(int));
            if (NOT_ALIGNED(dest)) {
                *dest++ = arg1 >> 24 & 0xff;
                *dest++ = arg1 >> 16 & 0xff;
                *dest++ = arg1 >> 8 & 0xff;
                *dest++ = arg1 & 0xff;
            } else { 
                *((int *)dest) = arg1; 
	        dest += sizeof(int *);
            }
	    goto FLUSH_IT;

        case R_DLT_REL:
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
	    processing_DLT_REL = TRUE;  /* ugly kludge to get right err msg */
            value = GET_DATA_WORD(temp);

#ifdef TSD /* TSD */
	    /*
            ** Do sanity check for tp override, no TLS sym or no tp
	    ** override, TLS sym.  We couldn't do the check in the first
	    ** pass over the fixups because if building a shlib and
            ** we have Data Unsats, we don't know if the sym is a TLS
            ** symbol or not until we have processed all of the fixups.
	    ** If the symbol is a Data Unsat and we're building a shlib,
	    ** if TP override seen, set TLS bit.  This is to make sure we
            ** set the TLS bit in the shlib import record.
            */
	    if (Sym_Type(arg0) == ST_DATA && Sym_Scope(arg0) == SS_UNSAT &&
		tp_override && building_shlib) {
	       Sym_TLS(arg0) = TRUE;
	    }
            if (tp_override && !Sym_TLS(arg0)) { 
	       unlink(output_name);
               external_error(BAD_FIXUP_NON_TLS,
			      "DLT_REL",
			      Sym_Dict(arg0).name.n_name,
			      Subsp_Misc(fixup_subsp).file_name);
            } else if (!tp_override && Sym_TLS(arg0)) {
	       unlink(output_name);
	       external_error(BAD_FIXUP_TLS,
			      "DLT_REL",
			      Sym_Dict(arg0).name.n_name,
			      Subsp_Misc(fixup_subsp).file_name);
            }
#ifdef DEBUG /* DEBUG */
	    if (verbose & V_TSD) {
               if (Sym_TLS(arg0)) {
	          printf("dlt rel value 0x%x for %s\n", Sym_Value(arg0),
		         Sym_Name(arg0)); 
	       }
	    }
#endif /* DEBUG */
#endif /* TSD */
                /*  Now only do this when
                ** building a shared lib.  For standalone PIC, drop
                ** down below */
	    if (Sym_Scope(arg0) == SS_LOCAL &&
	        Sym_Dict(arg0).symbol_type == ST_CODE && building_shlib) {
	  	/* DLT fixup for code symbol implies a PIC code long branch
		   from within a branch table. We will branch indirect 
		   through the PLT to the given label */
		
		int target_reg;

#if 0
 	    	if (building_shlib) {
#endif /* 0 */
	            /* virtual location of PLT position */
                    LT_offset = Subspace_Virtual_Offset(PLT_subsp_index) +
                                ((Sym_ShlImp_Indx(arg0) - DLT_entry_count) *
                                 sizeof(struct PLT_entry));

		    /* adjust with virtual addr of ltptr */	
                    LT_offset -= Subspace_Virtual_Offset(DLT_subsp_index) +
			         (ltptr_DLT_entry_index * sizeof(DLT_ENTRY));
#if 0
	       	    }
		else {
	            /* byte offset into the PLT */
                    LT_offset = (Sym_ShlImp_Indx(arg0) - DLT_entry_count) *
                               sizeof(struct PLT_entry);

		    /* adjust with virtual addr of dp */
		    LT_offset += Subspace_Virtual_Offset(PLT_subsp_index) -
				 symbol_value(dollar_global);
		    }
#endif /* 0 */

		if ( OFL(LT_offset,14) )
		    external_error(BAD_LTPTR_SWTCH_REACH, 
		    		   Subsp_Misc(fixup_subsp).file_name, 0);

#define INST_FRMT_1_TARGET_MASK 0x001F0000

		/* fixup LDW inst */
		    
		target_reg = value & INST_FRMT_1_TARGET_MASK;
		value = (building_shlib ? BRTBL_PLT_R19_LDW
					: BRTBL_PLT_DP_LDW)
			    & ~INST_FRMT_1_TARGET_MASK;
		value |= target_reg;

            	*((int *)dest) = fix_instruction(value, LT_offset, ST_NULL, 
					         RET_WORD,
                                                 NULL);/* missing code 2.27 */

		dest += sizeof(int *);
#ifdef TSD /* TSD */
		tp_override = FALSE;
#endif /* TSD */

                goto FLUSH_IT;
		}

	    if (field_sel != R_FSEL) {
		/* set correct rounding mode for long-form PIC - 
		   short form always has F' override */
		saved_default_mode = default_mode;
		default_mode = R_R_MODE;
    	    }

	    if (building_shlib) {

	        assert(Sym_ShlImp_Indx(arg0) >= 0 &&
		       Sym_ShlImp_Indx(arg0) < DLT_entry_count);

            	*((int *)dest) = fix_instruction(value,
                    (Sym_ShlImp_Indx(arg0) - ltptr_DLT_entry_index) * 
		    sizeof(DLT_ENTRY),
		    ST_NULL, /* not used in this case */
                    RET_WORD,
                    NULL /* missing code from 2.27 LE */
                    );
	        dest += sizeof(int *);
	    } else {  /* STANDALONE PIC - PIC seen outside shlib */

		/* get DLT rel byte offset for symbol */ 
		LT_offset = Sym_ShlImp_Indx(arg0) * sizeof(DLT_ENTRY);

		/* convert the instruction to use DP-relative addressing to
		   fetch the actual address out of the DLT.  Works on long
		   form PIC (big tables) in ADDIL/LDIL's as well as LDW's in
		   short-form. */

		if ((field_sel == R_FSEL) || /* if not long-form PIC */
		    (GET_OP(value) == 0x0a))   /* or an ADDIL */
		    value = (value & REG_MASK) | R27_MASK;
		    	/* don't change LDW/STW in long-form PIC */

		assert( ( LT_offset +
		    	      Subspace_Virtual_Offset(DLT_subsp_index) -
		    	      symbol_value(dollar_global) ) < 0 );

            	*((int *)dest) = fix_instruction(
		    value,
                    LT_offset +
		    Subspace_Virtual_Offset(DLT_subsp_index) -
		    symbol_value(dollar_global),
		    ST_NULL, /* not used in this case */
		    RET_WORD,
                    NULL /* missing code from 2.27 LE */
                    );
	        dest += sizeof(int *);
	    }
	    processing_DLT_REL = FALSE;  

	    if (field_sel != R_FSEL) /* reset rounding mode */
		default_mode = saved_default_mode;
#ifdef TSD /* TSD */
	    tp_override = FALSE;
#endif /* TSD */
            goto FLUSH_IT;
/* #undef R27_MASK */

        case R_DP_RELATIVE:
            if (dollar_global == BAD_SYM) {
                warning(UNSATS, 0);
                warning_continue(UNSAT_DATA, dollar_global_string, 0);
                longjmp(drive, 1);
            }
            arg0 += sym_bias;
            /* remap necessary, since using arg0 as a simple index */
            arg0 = Sym_Remap(arg0);

            instruction = GET_DATA_WORD(temp);

            /* NO_DATA_COPY */
#ifdef TSD /* TSD */
	    /*
            ** Do sanity check for tp override, no TLS sym or no tp
	    ** override, TLS sym.  We couldn't do the check in the first
	    ** pass over the fixups because if building a shlib and
            ** we have Data Unsats, we don't know if the sym is a TLS
            ** symbol or not until we have processed all of the fixups.
	    ** We should never see a Data Unsat symbol here--the symbol
	    ** should be resolved by now.  If building a shlib, we can have
	    ** data unsats, but we won't have data unsats for PIC here.
            */

            if (tp_override && !Sym_TLS(arg0)) {
	       unlink(output_name);
               external_error(BAD_FIXUP_NON_TLS,
		              "DP_REL",
			      Sym_Dict(arg0).name.n_name,
			      Subsp_Misc(fixup_subsp).file_name);
            } else if (!tp_override && Sym_TLS(arg0)) {
	       unlink(output_name);
	       external_error(BAD_FIXUP_TLS,
			      "DP_REL",
			      Sym_Dict(arg0).name.n_name,
			      Subsp_Misc(fixup_subsp).file_name);
	    }
#ifdef DEBUG /* DEBUG */
	    if (verbose & V_TSD) {
               if (Sym_TLS(arg0)) {
	          printf("dp rel value 0x%x for %s\n", Sym_Value(arg0),
		         Sym_Name(arg0)); 
	       }
	    }
#endif /* DEBUG */
	    if (!do_data_copy && !Sym_TLS(arg0) &&
		Sym_SharedGlobal(arg0)) {
#else
	    if (!do_data_copy && Sym_SharedGlobal (arg0)) {
#endif /* TSD */
		* ((int *) dest) =
			   rewrite_shared_global_inst (instruction, arg0);

		dest += sizeof (int *);
		N0_fixup_seen = FALSE;
		goto FLUSH_IT;

	    } /* shared global */

	    N0_fixup_seen = FALSE;   /* reset this */

#ifdef TSD /* TSD */
	    /* 
	     tpoff is just 0 for now.  When we support
	    ** 2 subspaces in TSD, tpoff will be set to its midpoint
	    */
	    if (Sym_TLS(arg0))
	        value = symbol_value(arg0);
            else
#endif /* TSD */
	    /* this is the normal value used */
	    value = symbol_value(arg0)-symbol_value(dollar_global);

            /* Embedded systems code */
            /* Check for Embed Sys Pic code references */
	    /* If target is not $global$ space make reference absolute */
            if ((subspace_index = Sym_Subsp(arg0)) != BAD_SUBSP) 
                space_index = Subsp_Dict(subspace_index).space_index;
	    else
		space_index = dollar_global_space; /* stub symbol? no warns */

            if (space_index != dollar_global_space) {
		/* reference must be made absolute */

                /* If target space is relocatable let user know */
	        if (space_misc[space_index].relocatable) {
                    this_space_index = Subsp_Dict(fixup_subsp).space_index;
                    warning(REF_TO_RELOC_SPACE,
                                 space_array[this_space_index].NAME_PT,
                                 space_array[space_index].NAME_PT);
                    warning(SYM_REFERENCED_IS, Sym_Dict(arg0).NAME_PT);
                }
		
		/* make the addil an absolute reference */
#ifdef TSD /* TSD */
		/*   If TSD, leave value, instruction alone.
                ** We'll use whatever register code gen stuffed TP in 
                */
                if (!Sym_TLS(arg0)) {
#endif /* TSD */		   
	        value = symbol_value(arg0);
		if (GET_OP(instruction) == 0x0a) {          /* if an ADDIL */
		    /* set to addil L'sym, r0 */
		    instruction = (instruction & REG_MASK);
		}
		/* else ldw/stw is set to use r1 already */
#ifdef TSD /* TSD */
	      }
#endif /* TSD */
   	    }
/* #undef REG_MASK */
            *((int *)dest) =
                fix_instruction(instruction, value,
		    ST_NULL, /* not used in this case */
		    RET_WORD,
                    NULL /* not an abs call--missing code from 2.27 LE */
                    );
	    dest += sizeof(int *);
#ifdef TSD /* TSD */
	    tp_override = FALSE; /* reset */
#endif /* TSD */
            goto FLUSH_IT;

        case R_ABS_CALL:
	    /* OGL support for R_INDIRECT_CALL */
	    if(dyncall_external_used){
	       dyncall_external_used = FALSE;
	       if(building_incomp_exec || building_shlib){
		  /* dyncall_external is biased.               */
		  /* will be subtracted out when fall through. */

                  if (dyncall_external == -1) {
                      user_error(BAD_MILLI_A, 0);
                  }
	          arg1 = dyncall_external - sym_bias;
	       }
	    }
            arg0 = arg1;
            /* fall through to CODE_ONE_SYMBOL */
        case R_CODE_ONE_SYMBOL:
            arg0 += sym_bias;
            /* remap necessary, since using arg0 as a simple index */
            arg0 = Sym_Remap(arg0);

#ifdef TSD /* TSD */
		/* 
                ** code_one_sym fixups can never reference a TSD symbol.
		** If it does, code gen  up so give a fatal error here
                ** and quit.
                */
		if (Sym_TLS(arg0)) {
                   external_error(CODE_ONE_SYM_TSD,
				  Sym_Name(arg0),
				  Subsp_Misc(fixup_subsp).file_name,
				  0);
		}
#endif /* TSD */

            /* If target space is relocatable let user know */
            if ((subspace_index = Sym_Subsp(arg0)) != BAD_SUBSP) {
                space_index = Subsp_Dict(subspace_index).space_index;
                if (space_misc[space_index].relocatable) {
                    this_space_index = Subsp_Dict(fixup_subsp).space_index;
                    warning(REF_TO_RELOC_SPACE,
                                 space_array[this_space_index].NAME_PT,
                                 space_array[space_index].NAME_PT);
                    warning(SYM_REFERENCED_IS, Sym_Dict(arg0).NAME_PT);
                }
 	    }

                /* NO_DATA_COPY */
		/*   If we have a reference to a LIT shared
		** global, it will have a CODE_ONE_SYM fixup on it.  We
		** need to rewrite the instruction to go through the DLT
		** just as for a DP_REL instruction. */
	    if (!do_data_copy && Sym_SharedGlobal (arg0)) {
		instruction = GET_DATA_WORD (temp);
		* ((int *) dest) =
			   rewrite_shared_global_inst (instruction, arg0);

		dest += sizeof (int *);
		goto FLUSH_IT;

	    } /* shared global */

	    N0_fixup_seen = FALSE;   /* reset this */

            if(OPTIONAL_PROC(arg0)) {
                *((int *)dest) = NOP;
	        dest += sizeof(int *);
	    } else {
                *((int *)dest)
                   = fix_instruction (GET_DATA_WORD (temp),
                                      symbol_value (arg0),
			              Sym_Remap_Type (arg0), 
				      RET_WORD,
                                      fix_info->type);
                        
	        dest += sizeof(int *);
	    }
            /* ABSOLUTE FIXUP */

            if (!relocatable &&
                !strip_fixups &&
                !(OPTIONAL_PROC(arg0)) &&
                mapped_symbol(arg0)) {

                if (relinkable &&
                    unwind_subsp != BAD_SUBSP &&
                    Subsp_Misc(Sym_Subsp(arg0)).r_o_x >=
                        Subsp_Misc(unwind_subsp).r_o_x) {
                    external_error(UNWIND_REFERENCE, 
				   Subsp_Misc(fixup_subsp).file_name,
                                   0);
		}

                out_one_abs_fixup(R_ABS_CODE, branch_dot-abs_fix_base);
            }

            goto FLUSH_IT;

        case R_MILLI_REL:
            arg0 += sym_bias;
	    arg0 = Sym_Remap(arg0);

 	    /* if milli_label not in data syms and target is not ext milli*/
            if ((milli_label == BAD_SYM) &&
                                      (Sym_Remap_Type(arg0) != ST_MILLI_EXT)) {
                warning(UNSATS, 0);
                warning_continue(UNSAT_DATA, milli_label_string, 0);
                longjmp(drive, 1);
            }
            
	    if (field_sel == NO_OVERRIDE)
                field_sel = R_FSEL;

 	    if (Sym_Remap_Type(arg0) == ST_MILLI_EXT) {
                /* 
		** fix instruction to branch to external millicode directly 
                ** this means we do not need milli_label so it can be BAD_SYM
		*/
                *((int *)dest) =
                    fix_instruction(GET_DATA_WORD(temp),
                        symbol_value(arg0),
                        ST_MILLI_EXT, /* we are external milli; change sr */
			RET_WORD,
                        NULL /* not abs call --missing code from 2.27 LE */
                        );
            } else {
                /* fix so we branch to some offset off of milli_label */
                /* Here we use milli_label so it better be a valid symbol */
                *((int *)dest) =
                    fix_instruction(GET_DATA_WORD(temp),
                        symbol_value(arg0)-symbol_value(milli_label),
                        ST_NULL, /* we lie so sr field won't get modified */
			RET_WORD,
                        NULL /* missing code from 2.27 LE */
                        );
                }
	    dest += sizeof(int *);
            goto FLUSH_IT;

        case R_CODE_PLABEL:
            arg0 += sym_bias;
            /* remap necessary, since using arg0 as a simple index */
            arg0 = Sym_Remap(arg0);

            /* If target space is relocatable let user know */
            if ((subspace_index = Sym_Subsp(arg0)) != BAD_SUBSP) {
                space_index = Subsp_Dict(subspace_index).space_index;
                if (space_misc[space_index].relocatable) {
                    this_space_index = Subsp_Dict(fixup_subsp).space_index;
                    warning(REF_TO_RELOC_SPACE,
                                 space_array[this_space_index].NAME_PT,
                                 space_array[space_index].NAME_PT);
                    warning(SYM_REFERENCED_IS, Sym_Dict(arg0).NAME_PT);
                }
	    }

            if (OPTIONAL_PROC (arg0)) {
                external_error (BAD_OPTPROC_REF, 
				Subsp_Misc(fixup_subsp).file_name,
				0);
            }

            /* HP-UX shared library support */
            if ((building_incomp_exec || building_shlib) &&
		                         Sym_Type (arg0) != ST_ABSOLUTE) {
    		int ltoff;  /* ltptr-relative offset of the PLT entry */
                int value;  /* contents of the instruction being patched */

		assert(indx_of_code_plab_DLT_entry(arg0) != BAD_SYM);  
							/* must be found */

		value = GET_DATA_WORD(temp);

#define LDO_TARGET_MASK		0x001F0000
#define LDO_BASE_MASK		0x03E00000
#define LDIL_TARGET_MASK	0x03E00000

		if (building_shlib) {
		   /* the following gives an index into the DLT that 
		      corresponds to the DLT entry for a code plabel. The 
		      code plabel DLTs are originally located at the end of 
		      the DLT. */

                    ltoff = (
			    /* total DLT len, including code plabel entries */
		        (DLT_entry_count - 1) -           
			    /* code plabel entries that were added */ 
		        (code_plab_DLT_entry_count-1) + 
			    /* index into code plabel DLT array */
		        indx_of_code_plab_DLT_entry(arg0) 
		        );
		    /* shlibs use lt-rel addressing, get offset from ltptr */ 
		    field_sel = R_FSEL;  /* full offset only */
		    ltoff = (ltoff - ltptr_DLT_entry_index) * sizeof(DLT_ENTRY);

		    /* change LDIL/LDO pattern to LDI of word offset in DLT,
		      followed by LDWX of actual value from CODE PLAB DLT
		      entry (address of corresponding PLT entry) - gets four
		      times as much range as LDW of byte offset (8K entries
		      instead of 2K) */

                    if (GET_OP(value) == 0x08 /* LDIL */) {
		    	int ldi_target_reg = (value & LDIL_TARGET_MASK) >> 5;
					/* extract temp register used and
					** shift into position as LDI target */

		    	assert((ltoff & 0x3) == 0);  /* must be word offset */

		    	*((int*)dest) = fix_instruction(LDI | ldi_target_reg, 
						  	ltoff/4, /* word indx */
						  	ST_NULL, /* not used */
						  	RET_WORD,
                                                  	NULL); 

		    } else if (GET_OP(value) == 0x0d  /* LDO */) {
		    	int temp_reg = (value & LDO_BASE_MASK) >> 5;
					/* extract temp register used and shift 
					   into LDWX index reg position */
		    	int target_reg = (value & LDO_TARGET_MASK) >> 16;
					/* extract target reg used and shift 
					   into LDWX target reg position */
		    	*((int*)dest) = PLAB_PLT_R19_LDWX
			    	    	| temp_reg | target_reg;
		    } else
			internal_error (BAD_PLABEL_FIXUP, 0); /* wrong inst */

		} else {  /* building_incomp_exec */

		    /* execs use full virtual addr - compute it at link time */ 

		    arg1 = find_export_stub_sym(arg0);
		    if (arg1 == BAD_SYM)
			arg1 = arg0;  /* only export stub if routine defined */
				      /* by incomplete executable            */

		    assert(Sym_ShlImp_Indx(arg1) >= DLT_entry_count &&
		           Sym_ShlImp_Indx(arg1) <  import_entry_count);

#ifdef DEBUG
		    arg2 = out_import_list[Sym_ShlImp_Indx(arg1)].name;
		    assert((arg2 == -1) || 
			   (arg2 > 0 && arg2 < next_shlstr_table_indx));
		    if ((arg2 != -1) && 
			strcmp(arg2+out_shlstr_table,Sym_Name(arg1))) 
		    {
			  fprintf(stderr,
				  ld_gets(1, 
					  1123, 
					  "Wrong plabel found for symbol %s\n"),
				  Sym_Name(arg1));
			  fprintf(stderr,
				  ld_gets(1, 1124, "Found %s\n"),
				  arg2+out_shlstr_table);
		    }
#endif /* DEBUG */
	            /* byte offset into the PLT */
                    ltoff = (Sym_ShlImp_Indx(arg1) - DLT_entry_count) *
                               sizeof(struct PLT_entry);
		    /* adjust with virtual addr of the PLT */
		    ltoff += Subspace_Virtual_Offset(PLT_subsp_index);
		    /* set flag bit that this is an incomplete a.out plabel */
                    ltoff += HPUX_PLABEL_BITS;

		    assert((ltoff & 0x3) == HPUX_PLABEL_BITS);  
						/* must be plabel */

		    /* stay with LDIL/LDO - but assemble the PLT entry addr */
		    *((int *) dest) = fix_instruction (value, 
						       ltoff,
						       ST_NULL, /* not used */
						       RET_WORD,
                                                       NULL); 
		}

	    } else { /* building_shlib || incomp exec, not abs sym */
	       /* dead code on HP-UX, leave in for MPE/ix testing on HP-UX */
                if (extern_plabels && Sym_Type (arg0) != ST_ABSOLUTE) {
                    type = Sym_Remap_Type(arg0);
                    if (type != ST_PLABEL && type != ST_STUB_IMPORT)
                        internal_error(BAD_PLABEL_FIXUP, 0);
                    value = Sym_Remap_Info(arg0) + XRT_PLABEL_BITS;
                } else
                    value = symbol_value(arg0);
		
            	*((int *) dest) = fix_instruction (GET_DATA_WORD(temp),
				                   value,
				                   ST_NULL, /* not used */
				                   RET_WORD,
                                                   NULL);

	    }

	    dest += sizeof(int *);

            /* ABSOLUTE FIXUP */
            if (!relocatable && !strip_fixups && !extern_plabels) {

                if (relinkable &&
                    unwind_subsp != BAD_SUBSP &&
                    Subsp_Misc(Sym_Subsp(arg0)).r_o_x >=
                        Subsp_Misc(unwind_subsp).r_o_x) {
                    external_error(UNWIND_REFERENCE, 
				   Subsp_Misc(fixup_subsp).file_name,
				   0);
		}

                out_one_abs_fixup(R_ABS_CODE, branch_dot-abs_fix_base);
            }

FLUSH_IT:
            FLUSH_BUFFER(0);
            break;

        case R_BREAKPOINT:
            value = get_constant(GET_DATA_WORD(temp));

            /*  Uncomment if this code is really needed.
            if (!strip_debug)
               *((int *)dest) = (O_S != OS_HPUX &&
                             !lm_should_skip_subspace(fixup_subsp)
                             ? value : NOP;
            else
            */

            *((int *)dest) = (O_S != OS_HPUX && !strip_debug) ? value : NOP;
	    dest += sizeof(int *);
            goto FLUSH_IT;

        case R_ENTRY:
            if (state_diagram == NO_ENTRY_STATE ||
                state_diagram == INITIAL_STATE) {
                /* unwindable hole here, just set unwind_branch_dot */
                unwind_branch_dot = branch_dot;
            } else {
                make_unwind_region(NOT_EXIT);
            }

#ifdef WW_ANNOTATIONS_REMOVED
            new_flags=0;
            if (arg0 & HP_COMPILED_UNWIND_INFO)
              new_flags |= HP_COMPILED;
            if (arg1 & SERIALIZE_UNWIND_INFO)
              new_flags |= SERIALIZE;
	    /* Clear these two bits in the unwind descriptor now */
	    arg0 = arg0 & ~HP_COMPILED_UNWIND_INFO;
	    arg1 = arg1 & ~SERIALIZE_UNWIND_INFO;
#endif /* WW_ANNOTATIONS */

            /* new UNWIND INFO */
            unwind_bits = arg0 &~ REGION_MASK;
            frame_size = arg1;
            /* initialization for AUX_UNWIND info */
            curr_aux_unwind.cu_name = 0;
            curr_aux_unwind.scope_name = 0;
            curr_aux_unwind.scope_kind = 0;
            curr_aux_unwind.line_number_tbl = 0;
            aux_unwind_seen = FALSE;
            state_diagram = ENTRY_STATE;

#ifdef WW_ANNOTATIONS_REMOVED
            flush_current_annotations(fixup_subsp,branch_dot-2*WORDSIZE,
				      FLUSH_MODE);
            out_annotation(ENTRY_HEADER,fixup_subsp,branch_dot-2*WORDSIZE,
			   0,0,new_flags);
#endif /* WW_ANNOTATIONS */
            break;

        case R_ALT_ENTRY:
            if (state_diagram == INITIAL_STATE)
                external_error(INVALID_FIXUP, "R_ALT_ENTRY",
				Subsp_Misc(fixup_subsp).file_name, 0);
            make_unwind_region(state_diagram == NO_ENTRY_STATE ?
                                NOT_ENTRY+NOT_EXIT : NOT_EXIT);
            state_diagram = ENTRY_STATE;
            break;

        case R_AUX_UNWIND:
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
            aux_unwind_seen = TRUE;
            curr_aux_unwind.cu_name    = arg0 ?
				         (char *)  symbol_value (arg0)
				         : (char *) arg0; 
            curr_aux_unwind.scope_name = arg0 ? 
					 (char *) (symbol_value (arg0) + arg1)
					 : (char *) arg1; 
            curr_aux_unwind.scope_kind = arg2; 
            break;

        case R_EXIT:
            if (state_diagram == INITIAL_STATE)
                external_error(INVALID_FIXUP, "R_EXIT",
				Subsp_Misc(fixup_subsp).file_name, 0);
            make_unwind_region(state_diagram == NO_ENTRY_STATE ?
                                NOT_ENTRY : 0);
            state_diagram = NO_ENTRY_STATE;
            break;

        case R_BEGIN_TRY:
            push_try(branch_dot);
            TRY_COUNT++;
            break;

        case R_END_TRY:
            if (TRY_COUNT < 1)
                external_error(INVALID_FIXUP, "R_END_TRY",
				Subsp_Misc(fixup_subsp).file_name, 0);
            TRY_COUNT--;
            arg0 *= 4;
            recover_branch_dot = pop_try();
            make_recover_region(arg0);
            break;

        case R_LINETAB:
	    if (doc_enabled) {
	        arg1 += sym_bias;
	        arg1 = Sym_Remap(arg1);
                doc_gen_new((unsigned char) arg0, 
	    		    (unsigned int) arg1, 
			    (int) arg2);
            }
            break;

        case R_LINETAB_ESC:
	    if (doc_enabled) {
                doc_gen_escape((unsigned char) arg0, (unsigned int) arg1);
            }
            break;

        case R_STATEMENT:
	    if (doc_enabled)
		doc_gen_entry((unsigned int) ((branch_dot-8)/WORDSIZE),
		              (unsigned int) arg0);
            else if (aux_unwind_seen) {
                make_line_tbl_entry((branch_dot-8)/WORDSIZE, arg0, 
                                      sec_stmt_override);
            }
            break;

#ifdef WW_ANNOTATIONS
        case R_COMMENT:

#ifdef WW_ANNOTATIONS_REMOVED
            action=(arg0 >> 5) & 0x7;
            info=(arg0 & 0x1f);
            switch (action) {
                case R_COMMENT_COPY_BITS:
                    out_annotation(COPY_BITS,fixup_subsp,branch_dot-2*WORDSIZE,
				   info,arg1,0);
                    break;
                case R_COMMENT_SYM_ADDR_LOOKUP:
		    CHECK_SUBSP_SYM(arg1 & 0xFFFFFFF);
                    out_annotation(SYM_ADDR_LOOKUP,fixup_subsp,
				   branch_dot-2*WORDSIZE,(info & 0xf),
				   arg1,0);
                    break;
                default:
#ifdef DEBUG
                    /* Unknown annotation action type */
                    fprintf(stderr,
		       "Annotation error: Unknown annotation action type=%d\n",
		       action);
#endif /* DEBUG */
		    stop_annotations();
                    break;
                }
#endif /* WW_ANNOTATIONS_REMOVED */

	    break;
#endif /* WW_ANNOTATIONS */

        case R_DATA_EXPR:
            /* the value of the expression is in arg0 */
            /* the type of the expression is in arg1 */
            temp = *((int *)dest) = arg0 + get_constant(GET_DATA_WORD(temp));
	    dest += sizeof(int *);

            /* initialized DATA pointer? */
            if (!relocatable &&
                gen_ldr_fixups &&
                arg1 == RELOCATABLE &&
                ! same_quadrant(0, arg0)) {

                if (! same_quadrant(arg0, temp)) {

                   warning(QUADRANT_CHANGE, Subsp_Dict(fixup_subsp)
                      .NAME_PT, source - current_subspace_start_p,
                      Subsp_Misc(fixup_subsp).file_name);
		}
		add_loader_fixup(LD_DATA_REF);
            }

            goto FLUSH_IT;

        case R_CODE_EXPR:
            /* The value of the expression is in arg0.              */
            /* The type of the expression is in arg1.               */
            /* In PIC code, the expression will be an absolute expr */
            /* and therefore the source quad must be used.          */

            *((int *)dest) = fix_instruction(GET_DATA_WORD(temp),
				 arg0,
				 /* assume not MILLI_EXT! */
                                 ((arg1 == RELOCATABLE) ? ST_CODE 
				     : ST_ABSOLUTE),
	    		          RET_WORD,   /* return instruction */
                                  NULL /*not abs call --missing code 2.27 LE */
					 );
	    dest += sizeof(int *);
            goto FLUSH_IT;

        /******** INTERNAL ***********/

        case R_PCREL_TO_STUB:
	    dyncall_external_used = FALSE;
            /* stub offset is arg0 */
	    arg0 = arg0<<2; /*Convert arg0 from word pointer to byte pointer*/

            stub_offset = arg0 + Subspace_Virtual_Offset(fixup_subsp);
                
 	    stub_ptr = find_stub_at_offset(fixup_subsp, arg0); 
	    orig_sym_indx = (stub_ptr == NULL ? BAD_SYM 
					      : stub_ptr->stub_symbol);

            /* we were either a BLE, BE or BL */
            /* get original instruction */
            value = GET_DATA_WORD(temp);

            /* KEEP the nullify bit from the original instruction */
            if (GET_OP(value) == 0x38)          /* BE, originally */
                value = B_DISP + (value & NULLIFY_BIT);
            else if (GET_OP(value) == 0x39)     /* BLE, originally */
                value = BL_DISP_31 + (value & NULLIFY_BIT);
  	    else if ((GET_OP(value) == 0x0a /* ADDIL */) ||
                    (GET_OP(value) == 0x0d /* LDO */)) {
                        /* if ADDIL or LDO, then we have a funky long branch
                           PIC PCREL form and we need to subtract branch_dot.
			   Would have done this in check_for_stubs(), but 
			   needed the type of instruction to tell that we 
			   didn't need the actual long branch stub.  */
                    doing_pcrel = TRUE;
                    *((int *)dest) = fix_instruction(value,
                                            symbol_value(orig_sym_indx),
                                            Sym_Remap_Type(orig_sym_indx), 
					    RET_WORD,
                                        NULL);

                    doing_pcrel = FALSE;
	    	    dest += sizeof(int *);
            	    goto FLUSH_IT;
	    }
            /* else we were a BL originally */

            else if (GET_LINK(value) == 0) {
		char *sym_name;
		/* If the linkage register is r0 we have a BL,0 which is
		   equivalent to a B. We warn the user that r1 will be used
		   by the long branch stub since they may not expect it. 
		   If we have a BL with any other linkage register we 
		   assume we can use r1 as a scratch register. */

		assert(GET_OP(value) == 0x3a /* BL */);

                /*  only emit this information warning
                   if verbose is set.  This is just a warning for assembly
                   language programmers. 
                   */
                if (verbose & V_WHY) {
                    if (orig_sym_indx == BAD_SYM)
                        sym_name = "";
                    else
                        sym_name = Sym_Dict(orig_sym_indx).NAME_PT; 

		    warning(STUB_KILLS_R1, sym_name, 
                            Subsp_Misc(fixup_subsp).file_name, 0);
	        }
	    }
#ifdef DEBUG
	    else assert(GET_OP(value) == 0x3a /* BL */);
#endif /* DEBUG */

            *((int *)dest) = fix_instruction(value, stub_offset,
					ST_NULL, /* not used */
					RET_WORD,
                                       NULL /* not abs call--missing 2.27 LE */
					);
	    dest += sizeof(int *);
            goto FLUSH_IT;

        default:
            external_error_hex(INVALID_FIXUP, fix_info->type,
	    			Subsp_Misc(fixup_subsp).file_name);
    }

    if (dest >= &out_buffer[BUFF_BYTE_SIZE])
        internal_error(BUFFER_OVERRUN, 0);
    buff_ptr = dest;
    subsp_data = source;

    return (NULL);
} /* end apply_fixups */


/*
**	rewrite_shared_global_inst.  Called from apply_fixups() to return
**	the instruction needed for shared global rewrites.
**	Take care of both 2-inst and 3-inst sequences, for both
**	DP_REL and CODE_ONE_SYM cases, for all possible instructions.
*/

#define R1_VALUE     0x00010000  /* gr1 target for LDW */

static int rewrite_shared_global_inst (int instruction, int sym)
{
      int LT_offset, address, value;
      int import_index = Sym_ShlImp_Indx (sym);
      int new_inst;
      int opcode = GET_OP (instruction);
      int RV;
   assert (-1 != import_index);

	/* For 1st, or 2nd of 3, get DLT slot address here: */
   if (opcode == 0x0a ||  /* ADDIL */
       opcode == 0x08 ||  /* LDIL */
       R_N1SEL == field_sel) {

      value = data_override ? data_override_value : GET21 (instruction);

	/*  Now reset this so fix_instruction() doesn't
	** see it. */
      data_override = 0;
      if (FIXUP_ROUND (value))
	 LT_offset = get_sym_multiple_slot (sym, value, 1, import_index);
      else
	 LT_offset = import_index * sizeof (DLT_ENTRY);

      address  = LT_offset + Subspace_Virtual_Offset (DLT_subsp_index) -
		    	                  symbol_value (dollar_global);
   }

	/* 1st instruction of either 2-inst or 3-inst sequence */
   if (opcode == 0x0a /* ADDIL */ || opcode == 0x08 /* LDIL */ ) {

      if (N0_fixup_seen) {     /* 3-inst sequence present */
	 assert (opcode == 0x0a);  /* must be ADDIL! */

         /* NO_DATA_COPY */
	 if (address > 8191 || address < -8191) { /* Need "ADDIL LT'foo,DP" */
	    field_sel = NO_OVERRIDE;
	    new_inst = ADDIL_DP;
	 } else {                                /* Need "LDW T'foo(DP),r1" */
	    field_sel = R_FSEL;   /* To get all offset bits */
	    new_inst = LDW_R0_R0 | R27_MASK | R1_VALUE;
	 }
      } else {  /* Only 2-inst sequence present */

         /* NO_DATA_COPY */
	 if (address > 8191 || address < -8191) {  
	    warning (THREE_INST_SEQ_NEEDED, Sym_Name (sym),
                     Subsp_Misc(fixup_subsp).file_name);
	    bad_fixups = TRUE;   /* Results in failed link */
	 }

	 field_sel = R_FSEL;   /* To not change offset */
	 if (opcode == 0x0a)  {  /* ADDIL */
	    new_inst = LDW_R0_R0 | R27_MASK | R1_VALUE;
	 } else {                /* LDIL */
		/* Need to get the target register for the LDIL, and use it
		** as the target for the new LDW: */
	    new_inst = LDW_R0_R0 | R27_MASK | ((instruction & 0x3e00000) >> 5);
	 }
      }
      RV = fix_instruction (new_inst, address, ST_NULL, RET_WORD, NULL);

   } else if (R_N1SEL == field_sel) {  /* 2nd of 3-inst seq. */
      assert (opcode == 0x0d); /* must be LDO! */
      /* NO_DATA_COPY */
      if (address > 8191 || address < -8191) {
	 field_sel = NO_OVERRIDE;   /* Need "LDW RT'" */
		/* This gets the <base,target> regs from
		** the "LDO" into the LDW" instruction */
	 new_inst = LDW_R0_R0 | (instruction & 0x3ff0000);
      } else {
	 new_inst = instruction;  /* Don't change it */
	 address = 0;
      }

      RV = fix_instruction (new_inst, address, ST_NULL, RET_WORD, NULL);

   } else {   /* 3rd of 3-inst, or 2nd of 2-inst seq. */

	/* Account for "multiple slots":  get the difference between the
	** override value and the address that the used DLT slot represents */
      value = data_override ? data_override_value :
			      GET14 (instruction);
	/* If we can round up to a non-zero value, look at the value/slot
	** combination more intently: */
      if (FIXUP_ROUND (value))
	 value = get_sym_multiple_slot (sym, value, 3, import_index);

	/* Just call fix_format() here because the field_sel can mess up
	** fix_field(): we calculate the exact contant value to be used
	** above in get_sym_multiple_slot(). 
        */
      RV = fix_format (instruction, value, i_exp14, SR_IS_VALID);
   }
   return RV;
}

#undef R1_VALUE

add_loader_fixup (type)
int type;
{
    int i;

    i = loader_fixup_index++;

    if (i > loader_fixup_size)
	internal_error (WRNG_LODR_FXP_COUNT, 0);
    loader_fixup_array[i].fixup_type = type;
    loader_fixup_array[i].space_index = Subsp_Dict (fixup_subsp).space_index;
    loader_fixup_array[i].space_offset = branch_dot - 2*WORDSIZE;
    loader_fixup_array[i].constant =
        (type == LD_DATA_REF ? new_som_header.presumed_dp : 0);
}

int get_prefix(int expected, int override)
{
    if (override != NO_OVERRIDE)
        expected = override;
    if (expected == R_FSEL)
        return (e_fsel);
    if (expected == R_N1SEL)
        return (e_nsel);
    switch (default_mode) {
        case R_N_MODE:
            return ((expected == R_RSEL) ? e_rsel  : e_lsel);
        case R_D_MODE:
            return ((expected == R_RSEL) ? e_rdsel : e_ldsel);
        case R_S_MODE:
            return ((expected == R_RSEL) ? e_rssel : e_lssel);
        case R_R_MODE:
            return ((expected == R_RSEL) ? e_rrsel : e_lrsel);
    }
    /* NOT REACHED */
    abort();
    return 0;
} /* end get_prefix */

get_constant(maybe)
int maybe;
{
    if (data_override)
        return (data_override_value);
    if (old_format_file)
        return (0);
    return (maybe);
}

void align_warning(inst_name)
char *inst_name;
    /* generate alignment message - not done inline in "fix_instruction" to 
       keep buffer local on stack */
{
    char tempstr[MAXPATHLEN+20];
    sprintf(tempstr, "%s(0x%x)",
		 Subsp_Misc(fixup_subsp).file_name,
		 branch_dot - 2*WORDSIZE -
			(Subspace_Virtual_Offset(fixup_subsp) +
			Subsp_Stubs_Size(fixup_subsp)) +
			Subsp_Dict(fixup_subsp).subspace_start );

    warning (NONALIGNED_DATA, inst_name, tempstr, 0);
} /* align_warning */

int fix_instruction(word, expr, target_type, return_value, info_type)
int word, expr, target_type;
int return_value;           /* Tells what to return: constant, expr, or word */
int info_type;              /* missing code from 2.27 LE */
{
    static char *inst_name[] = { "LDH", "LDW", "LDWM", 
				NULL, NULL, NULL, NULL, NULL, 
			   	"STH", "STW", "STWM" };
    int constant;
    int expected_prefix, expected_format;
    int target_quad;
    int opcode;  /* temp to hold opcode for easier debugging, error report */

    target_quad = SR_IS_VALID;
    opcode = GET_OP(word);
    switch (opcode) {
        case 0x24:  /* COMICLR      */
        case 0x25:  /* SUBI/SUBIO   */
        case 0x2c:  /* ADDIT/ADDITO */
        case 0x2d:  /* ADDI/ADDIO   */
            constant = GET11(word);
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp11;
            break;

        case 0x11:  /* LDH    */
        case 0x19:  /* STH    */
            constant = GET14(word);
	    if ((expr + constant) & 1) /* if not half-word aligned */
		align_warning(inst_name[opcode-0x11]);
	    /* fall through */
        case 0x0d:  /* LDO    */
        case 0x10:  /* LDB    */
        case 0x18:  /* STB    */
            constant = GET14(word);
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14;
	    if(doing_pcrel) expr -= branch_dot;
            break;

        case 0x12:  /* LDW    */
        case 0x13:  /* LDWM   */
        case 0x1a:  /* STW    */
        case 0x1b:  /* STWM   */
            constant = GET14(word);
	    if ((expr + constant) & (WORDSIZE-1))
		align_warning(inst_name[opcode-0x11]);
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14;
	    if(doing_pcrel) expr -= branch_dot;
            break;

#ifdef PA_2_0
        case 0x14:  /* LDD FLDD */
            constant = GET14LONGDISPDBL(word);
	    if ((expr + constant) & ((2*WORDSIZE)-1)) {
		if (GET_BIT30(word))
		    align_warning("FLDD");
		else
		    align_warning("LDD");
	    }
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14longdispdbl;
	    if(doing_pcrel) expr -= branch_dot;
            break;

	case 0x1c:  /* STD FSTD */
            constant = GET14LONGDISPDBL(word);
	    if ((expr + constant) & ((2*WORDSIZE)-1)) {
		if (GET_BIT30(word))
		    align_warning("FSTD");
		else
		    align_warning("STD");
	    }
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14longdispdbl;
	    if(doing_pcrel) expr -= branch_dot;
            break;

	case 0x16:  /* FLDWM */
            constant = GET14LONGDISP(word);
	    if ((expr + constant) & (WORDSIZE-1)) {
		align_warning("FLDWM");
	    }
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14longdisp;
	    if(doing_pcrel) expr -= branch_dot;
            break;

	case 0x1e:  /* FSTWM */
            constant = GET14LONGDISP(word);
	    if ((expr + constant) & (WORDSIZE-1)) {
		align_warning("FSTWM");
	    }
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14longdisp;
	    if(doing_pcrel) expr -= branch_dot;
            break;


	case 0x17:  /* LDWMC FLDW */
            constant = GET14LONGDISP(word);
	    if ((expr + constant) & (WORDSIZE-1)) {
		if (GET_BIT29(word))
		    align_warning("LDWMC");
		else
		    align_warning("FLDW");
	    }
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14longdisp;
	    if(doing_pcrel) expr -= branch_dot;
            break;

	case 0x1f:  /* FSTW STWMC */
            constant = GET14LONGDISP(word);
	    if ((expr + constant) & (WORDSIZE-1)) {
		if (GET_BIT29(word))
		    align_warning("STWMC");
		else
		    align_warning("FSTW");
	    }
            expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_exp14longdisp;
	    if(doing_pcrel) expr -= branch_dot;
            break;
#endif /* ifdef PA_2_0 */

        case 0x3a:  /* BL and GATE (and PA2.0 BLL) */
#ifdef PA_2_0
	    /* For a PA2.0 BLL instruction, the extension bits are 5.
	    ** BLL has a 22 bit immediate instead of 17 bits.
	    */
	    if ((GET_EXT3(word) == 5)) {
		constant = GET22(word);
		expected_format = i_rel22;
	    } else
#endif /* ifdef PA_2_0 */
	    {
		constant = GET17(word);
		expected_format = i_rel17;
	    }
	    expected_prefix = get_prefix(R_FSEL, field_sel);
	    expr -= branch_dot;
            break;

        case 0x08:  /* LDIL  */
        case 0x0a:  /* ADDIL */
            constant = GET21(word);
            /* the next 5 lines of code are from 2.27 LE */
	    /* assume L' if was an abs_call */  
	    if (((info_type == R_ABS_CALL) && !rnd_mode_override)
		      && ((field_sel == e_lsel) || (field_sel == NO_OVERRIDE)))       
	       expected_prefix = e_lsel;
            else /* find prefix based on rounding mode */
	       expected_prefix = get_prefix(R_LSEL, field_sel);

            expected_format = i_exp21;
	    if(doing_pcrel) expr -= branch_dot;
            break;

        case 0x38:  /* BE  */
        case 0x39:  /* BLE */
            constant = GET17(word);
            /* missing code from 2.27 LE -- next 5 lines of code*/
	    /* assume R' if no mode override given */
	    if (!rnd_mode_override 
		      && ((field_sel == e_rsel) || (field_sel == NO_OVERRIDE)))
	        expected_prefix = e_rsel;
	    else  /* find prefix based on rounding mode */
	        expected_prefix = get_prefix(R_RSEL, field_sel);
            expected_format = i_abs17;
	    if (target_type == ST_MILLI_EXT) {
	       expected_format = i_milli;
	       target_quad = 3;
	       }	
	    else if (target_type == ST_ABSOLUTE)
	       target_quad = SR_IS_SOURCE;
	    else if (target_type != ST_NULL)
	       target_quad = GET_QUAD(expr);
            break;

#ifdef PA_2_0
	case 0x27: case 0x3b: case 0x2f:	/* COMDT COMDIB COMBDF*/
#endif
        case 0x20: case 0x21: case 0x22: case 0x23:     /* COMB */
        case 0x28: case 0x29: case 0x2a: case 0x2b:     /* ADDB */
        case 0x30: case 0x31: case 0x32: case 0x33:     /* BB   */
            constant = GET12(word);
            expected_prefix = get_prefix(R_FSEL, field_sel);
            expected_format = i_rel12;
            expr -= branch_dot;
            break;

        default:
	    diagnose_fixup(INVALID_INSTRUCTION, fixup_subsp);
            return (word);
        }
    constant = get_constant(constant);
    /* use this in fix_format for i_milli */
    full_expression = expr + constant;  
    expr = fix_field(expr, constant, expected_prefix);

    if (return_value == RET_CONSTANT) 
	 /* return just the constant */
         return (constant);
    else if (return_value == RET_EXPRESSION)
	 /* return just the expression */
         return (expr);

    /* else return the fixed up word (RET_WORD)*/
    expr = fix_format(word, expr, expected_format, target_quad);
    return (expr);
} /* end fix_instruction */

int fix_field(expr, constant, prefix)
int expr, constant, prefix;
/* rearranges and extends the bits in the word according to fixup_field */
{
    register int val, t;

    val = expr + constant;

    switch (prefix) {
    	case e_fsel:
            break;
	case e_rsel:
            val &= 0x7FF;
            break;
	case e_lsel:
            val = (val >> 11) & 0x1FFFFF;
            break;
	case e_rdsel:
            val = val | 0xFFFFF800;
            break;
	case e_ldsel:
            t = val - (val | 0xFFFFF800);
            t = t>>11;
            val = t & 0x100000? t | 0xFFE00000 : t & 0xFFFFF;
            break;
	case e_rssel:
            val = val & 0x400? val | 0xFFFFF800 : val & 0x3FF;
            break;
	case e_lssel:
            t = val - (val & 0x400? val | 0xFFFFF800 : val & 0x3FF);
            t = t>>11;
            val = t & 0x100000? t | 0xFFE00000 : t & 0xFFFFF;
            break;
	case e_lrsel:
            val = expr + FIXUP_ROUND(constant);
            val = (val >> 11) & 0x1FFFFF;
            break;
	case e_rrsel:
            val = expr + FIXUP_ROUND(constant);
            val =  (val & 0x7FF) +
	           (constant - FIXUP_ROUND(constant));
            break;
	case e_nsel:
            val = 0;
	    break;
        default:
            diagnose_fixup(BAD_FIELD_SELECTOR, 
			   fixup_subsp);
    }
    return (val);
} /* end fix_field */


int fix_format (word, value, format, target_quad)
register int word, value, format, target_quad;

/* shuffles and puts back in tiny pieces bits in instruction */
{
    int	sr, source_quad;

    switch (format) {
	case i_data:
	    return (value);

        case i_exp14:	/* ldw, stw */
            if (!relocatable && OFL (value, 14))
        	diagnose_fixup(_14_BIT_OFLO, fixup_subsp);
            return (word & mask_exp14 | EXP14(value));

#ifdef PA_2_0
	case i_exp14longdisp: /* PA2.0: fldw fstw ldwmc stwmc fldwm fstwm */
	    if (!relocatable && OFL (value, 14))
		diagnose_fixup(_14_BIT_OFLO, fixup_subsp);

	    /* Alignment is checked in fix_instruction, not here. */
            return (word & mask_exp14longdisp | EXP14LONGDISP(value));

	case i_exp14longdispdbl: /* PA2.0: ldd, std, fldd, fstd */
	    if (!relocatable && OFL (value, 14))
		diagnose_fixup(_14_BIT_OFLO, fixup_subsp);

	    /* Alignment is checked in fix_instruction, not here. */
            return (word & mask_exp14longdispdbl | EXP14LONGDISPDBL(value));

#endif /* ifdef PA_2_0 */

        case i_exp21:	/* ldil, addil */
            return (word & mask_exp21 | EXP21(value));

        case i_exp11:	/* addi, subi */
            return (word & mask_exp11 | EXP11(value));

        case i_rel12:	/* addib{t,f}, comb{t,f} */
            if (!relocatable && OFL (value, 14))
        	diagnose_fixup(_12_BIT_OFLO, fixup_subsp);
            return (word & mask_rel12 | REL12(value));

        case i_rel17:	/* bl */
            if (!relocatable && OFL (value, 19))
        	diagnose_fixup(_17_BIT_OFLO_BL, fixup_subsp);
            return (word & mask_rel17 | REL17(value));

#ifdef PA_2_0
        case i_rel22:	/* PA2.0 bll */
            if (!relocatable && OFL (value, 24))
        	diagnose_fixup(_22_BIT_OFLO_BLL, fixup_subsp);
            return (word & mask_rel22 | REL22(value));
#endif /* ifdef PA_2_0 */

        case i_abs17:	/* be, ble */
        case i_milli:	/* ble for millicode -- patch SR field */

            /* Get existing sr field from instruction */
            sr = ((word >> 14) & 03) | ((word >> 11) & 04);

	    /* Adjust sr field for quadrant of target                      */
	    /* (target_quad is set to SR_IS_VALID for ST_MILLI_EXT         */
	    /* targets and R_MILLI_REL fixups and inter-quad stubs).       */
            /* target quad is set to ST_IS_SOURCE for BLE's with absolute  */
            /* expressions (i.e. PIC code). If the expression is absolute  */
            /* then target quad is  the quad for branch-dot (the sr can't  */
            /* be obtained from the expression since it could be negative).*/
	    /* Adjust only BE and BLE instructions that originally         */
	    /* specified sr4 (otherwise we assume the programmer knew      */
	    /* what he was doing!).                                        */

	    if (target_quad != SR_IS_VALID && sr == 4) {
		source_quad = GET_QUAD(Subspace_Virtual_Offset(fixup_subsp));
                if (target_quad == SR_IS_SOURCE) {
		    target_quad = source_quad; 
                } else if ((source_quad != target_quad) && 
			   (format != i_milli)) {
  		    /* no warning if external millicode is used */
		    warning(QUADRANT_MISMATCH,
			    Subsp_Misc(fixup_subsp).file_name, 0);
                }
		sr = target_quad + 4;
    	    }

            if (!relocatable && OFL (value, 19))
        	diagnose_fixup(_17_BIT_OFLO_BLE, fixup_subsp);

            /* full_expression is set in fix_instruction */
            if ((format == i_milli) && !OFL(full_expression, 19)) {
                /* 
		** Change base register for external millicode to 0 to ensure
		** Cobol does not use it's base register 
                ** Note if we do zero base reg then an LDIL might be dead code
		*/
                word &= ~(31 << 21);    /*zero out b field */
                value = full_expression; /* use whole expression in BLE */
            }

            value = (word & mask_abs17 & ~(07 << 13)
			    | REL17(value)
                            | EXT_DEP(sr,31,17,2)           /* s field */
                            | EXT_DEP(sr,29,18,1));         /* s field */

            return (value);

        default:
            diagnose_fixup(BAD_FMT_SELECTOR, fixup_subsp);
            return (0);
    }
    /*NOTREACHED*/
} /* end fix_format */

#if 0
/* Currently unused */
Boolean valid_fixup_sym(old_index)
int	old_index;
    {
    int	    index;
    register struct symbol_dictionary_record *sym;

    if (old_index == BAD_SYM)
        return (TRUE);

    index = Sym_Remap(old_index);
    sym = &Sym_Dict(index);
    if ((sym->symbol_scope == SS_UNIVERSAL ||
		sym->symbol_scope == SS_EXTERNAL ||
		sym->symbol_scope == SS_GLOBAL) &&
		sym->symbol_type != ST_NULL &&
		sym->symbol_type != ST_SYM_EXT &&
		sym->symbol_type != ST_ARG_EXT &&
		sym->symbol_info != (unsigned int)-1)
	return (TRUE);
    if (relocatable && sym->symbol_scope == SS_UNSAT)
	return (TRUE);
    return (FALSE);
    }
#endif /* 0 */

/* dump symbol and subspace info for tracing invalid fixups.
   Reset validity flag before exiting */

void diagnose_fixup(msgnum, subspace_idx)
int msgnum;
int subspace_idx;
{
    char *fname;
    char tempstr[MAXPATHLEN+20];

    if (subspace_idx == BAD_SUBSP) {
        warning(msgnum, cur_name, 0);
        warning_continue(FIX_POINT_OF_CALL, cur_name, 0);
        external_error(INVALID_FIXUPS, 0);
        return;
    }

    fname = Subsp_Misc(subspace_idx).file_name;

    /* HP-UX shared library error msg */
    if ((msgnum == _14_BIT_OFLO) && processing_DLT_REL)
	if (!building_shlib)
            external_error(DLT_OVERFLOW, fname, 0); 
	else
	    msgnum = DLT_OVERFLOW;  /* issue msg about recompiling with +Z */

    warning(msgnum, fname, 0);
    sprintf(tempstr, "%s(0x%x)",
	    fname,
            branch_dot - 2*WORDSIZE -
		(Subspace_Virtual_Offset(subspace_idx) +
				    Subsp_Stubs_Size(subspace_idx)) +
		Subsp_Dict(subspace_idx).subspace_start);

    warning_continue(FIX_POINT_OF_CALL, tempstr, 0);
    bad_fixups = TRUE;
    bad_obj = TRUE;
    return;
} /* end diagnose_fixup */

int same_quadrant(a, b)
int a, b;
{
    a >>= 30;
    b >>= 30;
    return (a == b);
}

int push_try(br_dot)
int br_dot; /* branch_dot address at BEGIN_TRY fixup */
{
  int *new_stack;

    if (try_stack.values == 0) {  /* the first call, so allocate the stack */
        try_stack.values = (int *) ecalloc(TRY_STACK_SIZE, sizeof(int));
        try_stack.size = TRY_STACK_SIZE;
    }

    /* stack overflow - allocate more */
    if (++try_stack.top >= try_stack.size) {
        try_stack.size += TRY_STACK_SIZE;
        new_stack =(int *)erealloc((char *) try_stack.values,
				   try_stack.size*sizeof(int));
        try_stack.values = new_stack;
    }

    try_stack.values[try_stack.top] = br_dot;
} /* end push_try */

/* pop_try returns the branch-dot address stored on the try-recover stack */
int pop_try()
{
    if(try_stack.top < 0) { 
        external_error(TRY_STACK_UNDERFLOW, 0); 
    }
    return(try_stack.values[try_stack.top--]);
}


/************************************************************************/
/*                      INITIALIZATION of FIXUPS                        */
/* this routine is last so we know that all statics have been defined */

void fixups_initialize()
{
    FILE *f;
    unsigned int i;
    int j, begin;
    static Boolean been_here_before = FALSE;

    loader_fixup_index = 0;
    loader_fixup_size = 0;
    fixup_file_offset = 0;

    /* initialize statics - for linkedit interactive mode */
    out_location = 0;
    TRY_COUNT = 0;
    new_ble_flag = FALSE;
    latest_one = NULL;
    size_left = 0;
    TOS = NULL;
    free_exprs = NULL;
    annotate_last_misc = NULL;
    annotate_last_annot = NULL;
    find_last_misc = NULL;
    find_last_annot = NULL;
    try_stack.values = 0;
    try_stack.top = -1;
    try_stack.size = 0;
    aux_unwind_seen = FALSE;
    generate_aux_unwind = FALSE;

    if (save_fixups) {
	/* open temporary fixups file to store fixups */
	if (fixup_fildes == -1) {
	    fixup_file = tempnam(DEFAULT_TEMP_DIR, "LDF");
	    f = efopen(fixup_file,"w+",CANT_OP_TMP_FXP_FL);
	    fixup_fildes = fileno(f);
    	}
	if (subsp_fixup_area == NULL)
	    subsp_fixup_area =
                (Fixup *) emalloc(subsp_fixup_area_max * sizeof(Fixup));
    }

    if (!been_here_before) {
        /* initialize fixup_index table to a special illegal index */
        for (j = 0; j < 256; j++)
            fixup_index[j] = NEW_FIX_TAB_SIZE;

        /* the variable "begin" is the beginning of the next range of fixups */
        begin = 0;
        for (i = 0; i < NEW_FIX_TAB_SIZE; i++) {
            if (begin <= new_fix_table[i].type) {
                /* new entry here */
                begin = new_fix_table[i].type;
            } else {
                /* continuation of an old entry */
                /* "begin" picks up where previous left off */
                assert(new_fix_table[i].type == 0);
                /* this is a "compilation" error, not a run-time error */
                new_fix_table[i].type = new_fix_table[i-1].type;
            }

            for (j = 0; j < new_fix_table[i].knt; j++) {
                fixup_index[begin+j] = i;
            }
            begin += new_fix_table[i].knt;
        }
    }

    /* initialize the R_PREV fixup "priority queue" */
    /* the "order" array is always a permutation of 0 .. PSZ-1 */
    for (i = 0; i < PSZ; i++) {
        order[i] = i;
    }

    been_here_before = TRUE;
} /* fixups_initialize */


