/*=====================================================================
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  

   File: fe_error.c

   Purpose: 
	This function displays the error message issued by the linker
	in case the SLLIC malloc package fails to allocate memory.
	We do not need to do anything fancy regarding libcomp library
	in here, as 32bit linker does not shl_load that library, but 
	instead exec()s it.


 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
=====================================================================*/

#include <stdlib.h>
#include "errors.h"
#include "std.h"
#include "util.h"

/*=====================================================================

   Function: fe_error

   Purpose:  Print out of memory error message.

   Parameters:  
      The parameters come from the real fe_error routine and are only
      used to call that routine.

=====================================================================*/

void fe_error(err_num, lineno, procname, s1, s2, s3, s4)
int err_num;
int lineno; 
char * procname;
char * s1;
char * s2; 
char * s3; 
char * s4;
{
   external_error(OUT_OF_MEM, 0);
} /* end fe_error() */
