/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
*  Dense Bit Vector definitions and typedefs
*
*/

/* declarations and macros for dense sets. */

struct dense_set_rec {
   unsigned size;   /* size of the set */
   unsigned *end_ptr; /* a pointer to the word after the last data word. */
   unsigned data[1]; /* dummy place holder for the data array. */
};

typedef struct dense_set_rec *dense_set_type ;

extern dense_set_type realloc_dense_set ();
extern dense_set_type get_dense_set ();
extern unsigned int next_dense_set_item ();
extern void dump_dense_set ();
extern unsigned int num_elements ();

#define DENSE_NEXT_ITEM_INIT (unsigned)0xffffffff
#define DENSE_NEXT_ITEM_END  (unsigned)0xfffffffe

#define test_dense_set_item(set,n) \
    ((((set)->data [(n) >> 5]) >> ((n) & 31)) & 1)

#define add_dense_set_item(set,n) \
    assert((set)->size >= n && n >= 0); \
    ((set)->data [(n) >> 5] |= (1 << ((n) & 31)))

#define remove_dense_set_item(set,n) \
    assert((set)->size >= n && n >= 0); \
    ((set)->data [(n) >> 5] &= ~(1 << ((n) & 31)))

#define FOR_EACH_DENSE_SET_ITEM(set,n) \
    for (n = next_dense_set_item (set, DENSE_NEXT_ITEM_INIT); \
 	 n != DENSE_NEXT_ITEM_END; \
	 n = next_dense_set_item (set, n))


/* an inline version of the FOR_EACH_DENSE_SET_ITEM macro. It does not make
   any procedure calls, but does require the use of the M_END_DENSE_FOR
   macro at the end of the for loop.
*/
#define M_FOR_EACH_DENSE_SET_ITEM(set,n) \
{   register unsigned ik; \
    register unsigned *pk, *pl; \
    pk = & ((set)->data [0]); \
    pl = (set)->end_ptr; \
    n = 0; \
    for (; pk != pl; ) { \
	if ((ik = *pk++) == 0) { n = n + 32; continue;} \
	for (; ik != 0; ik >>= 1, n++) { \
	    if ((ik & 1) == 0) continue;

#define M_END_DENSE_FOR(n) \
	} \
	(n) = ((n) + 31) & ~31; \
    } \
}


#define empty_dense_set(set) \
{   register unsigned *pk, *l; \
    pk = & ((set)->data [0]); \
    l  = (set)->end_ptr; \
    do { *pk++ = 0; } while (pk != l); \
}

#define deallocate_dense_set(set) (free (set))

/* 
    ASSUMPTIONS:

	- the sets are of the same size.
	- the sets have already been allocated.
*/

#define copy_dense_set(set1,set2) \
{   register unsigned *s1, *s2, *l; \
    s1 = & ((set1)->data [0]); \
    s2 = & ((set2)->data [0]); \
    l  = (set1)->end_ptr; \
    do { *s2++ = *s1++; } while (s1 != l); \
}

/* this macro OR's the two sets and puts the result into 'set2'. */
#define or_into_2_dense_set(set1,set2) \
{   register unsigned *s1, *s2, *l; \
    s1 = & ((set1)->data [0]); \
    s2 = & ((set2)->data [0]); \
    l  = (set1)->end_ptr; \
    do { *s2++ |= *s1++; } while (s1 != l); \
}
