/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999  
 *
***************************************************************************
**
** File:         annotate.h
**
** Description:  Support for WW annotations
**
**
***************************************************************************
*/

/* Annotations magic and version number */
#define ANNOTATIONS_HEADER 0xbd100001

/* Defines for space and subspace sort keys */
#define ANS_SORTKEY 64
#define CI_SORTKEY  16

/* Types to pass to out_anntation() */
#define STUBS_HEADER	1
#define ENTRY_HEADER	2
#define COPY_BITS	3
#define SYM_ADDR_LOOKUP	4
#define START_OF_TEXT   5

/* defines for R_COMMENT fixup */
#define R_COMMENT_COPY_BITS 		0
#define R_COMMENT_SYM_ADDR_LOOKUP	1

/* defines for annotation flags */
#define HP_COMPILED	0x1
#define SERIALIZE	0x2

/* defines for annotation header */
#define ANNOT_MORE    0x1
#define ANNOT_PAD_LSB 0x2
#define ANNOT_IS_STUB 0x4

/* defines for annotation opcodes */
#define ANNOT_GFLAGS 0
#define ANNOT_CONT   2
#define ANNOT_PAD    3
#define ANNOT_END    4

/* defines for annotation flags passed in unwind descriptor of R_ENTRY fixup */
#define HP_COMPILED_UNWIND_INFO 0x20	/* Apply to arg0 of fixup */
#define SERIALIZE_UNWIND_INFO	0x08000000 /* Apply to arg1 of fixup */

/* structure definitions */
struct annotation_rec {
  char type;
  unsigned char info;
  unsigned char new_flags;
  char reserved1;
  int subsp;
  int addr;
  unsigned int value;
};

/* declarations of externally visible interfaces */
extern int annotations_size_bits;

extern int annot_subsp_index;

extern int do_ww_annotations;
extern int annotations_killed_at_startup;

extern void init_annotations(void);

extern void init_annotation_subsp(void);

extern void out_annotation(int type, int subsp, int addr, unsigned int info,
			   unsigned int value, unsigned int new_flags);

extern void reset_annotation_buffer(void);

extern void stop_annotations(void);

#define COUNT_MODE 0
#define FLUSH_MODE 1
extern void flush_current_annotations(int subsp_index, unsigned int new_addr, int mode);
