/*
 *  HP 9000 Series 800 Linker, Copyright Hewlett-Packard Co. 1985-1999     
 *  Relocation and Address Assignment Routines
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <sys/times.h>
#ifndef DEBUG
#define NDEBUG
#endif  /* DEBUG */
#include <assert.h>
#include "filehdr.h"
#include "aouthdr.h"
#include "spacehdr.h"
#include "scnhdr.h"
#include "initptr.h"
#include "compunit.h"
#include "reloc.h"
#include "syms.h"

#include "std.h"
#include "ldlimits.h"
#include "allocate.h"
#include "driver.h"
#include "errors.h"
#include "embed.h"
#include "fixups.h"
#include "libraries.h"
#include "linker.h"
#include "o2n_tally.h"
#include "output.h"
#include "spaces.h"
#include "ld_strings.h"
#include "stubs.h"
#include "subspaces.h"
#include "symbols.h"
#include "util.h"
#ifdef WW_ANNOTATIONS
#include "annotate.h"
#endif /* WW_ANNOTATIONS */
#include "dead_proc.h"
#include "comdat.h"

#ifdef ESOM
#include "cnx_aout.h"

extern Boolean esom_is_parallel;
extern struct cnx_option_header *opt_hdr;
#endif /* ESOM */

/* doom support */
#include "ld_linkmap.h"

/* Globals */

int init_array_size = 0;
int load_subsp = 0;
int out_symbol_total = 0;
int abs_fixup_total = 0;
int first_time = 2; /* 2=Start; 1=First Pass (True); 0=2-n Passes (False)*/
int total_code_size = 0;	/* Count of how much code we have seen */

extern int unwind_subsp;
extern int unwind_end_subsp;
extern Boolean bl_seen_in_aout;

/* File Locals */
static int num_out_spaces;    /* count_subspaces sets this for assign_space */
static int out_symstr_size = 0;

/* flag for MPE non-page-aligned data problem */
static int adjust_file_loc = FALSE; 

extern int align();

/*
** "unpad a.out"
** These two variables are used in the removal of padding between the
** SOM header and TEXT. unpad_after_header is defined even in the HPE
** case so that it can be used in the same checks in HPE and HP-UX.
** However, it will always be false in HPE.
*/
int unpad_after_header     = 0;  /* remove padding between SOM header 
				    and TEXT?, and if so, how much? */
static int total_TEXT_size = 0;  /* total size of the TEXT space */

/* "unpad .sl"
** These are two similar variables for removing the padding before the
** $PRIVATE$ (data) space, which is typically after the $TEXT$ space.
*/
int unpad_before_private   = 0;  /* remove padding before $PRIVATE$ space,
				    and if so, how much? */
static int total_PRIVATE_size = 0; /* total size of the $PRIVATE$ space */

void relocate_subspaces()
{
    extern void assign_virtual_addresses();
    extern void assign_file_locations();
    extern void count_symbols();
    extern void count_stub_unwind_desc();
    extern void set_copyram_size();
    extern void optimize();
    extern void set_elaborator();
    extern int count_subspaces();
    extern int count_init_ptrs();
    struct fru_list *fru; 

    clock_t rstart,rstop;
    struct tms pstart,pstop;
    long clk_tck;

    /* Reset to allow for reentrancy */
    first_time = 2; /* 2=Start; 1=First Pass (True); 0=2-n Passes (False)*/

    /*
    ** If dead procedure elimination is enabled then make a pre-pass over
    ** the fixups and remove any subspaces which are not referenced.
    */
    initial_fixup_pass = TRUE;
    if (delete_dead_procs) {
        do_dead_proc_elim();
        initial_fixup_pass = FALSE;
    }

    /* Only get clk_tck if we will use it */
    if (verbose & V_TIMES)
	clk_tck=sysconf(_SC_CLK_TCK);
    TIME_START(rstart,pstart);

    count_unwind_recover_size();

    TIME_STOP(rstart,
	      rstop,
	      pstart,
	      pstop,
	      ld_gets(1, 1100, "count_unwind_recover_size:"),
	      clk_tck);

    /* HP-UX shared library support */
    if (building_shlib)
        set_elaborator(); /* has to be done here since shlib_import_index 
			     isn't set until after count_unwind_recover_size */

    if (eliminating_addils) {
	/* we have another pass due to subspace lengths changing within */
	/* count_unwind_recover_size(). Especially DLT and PLT tables! */

	assign_virtual_addresses();  /* pre-assign data subspaces so that
					ld -O can decide if ADDILs needed. */
	optimize();
    }

    TIME_START(rstart,pstart);
    repeat {
	if (first_time)    /* Distinguish between 1st and subsequent passes */
	   --first_time;    

	if (!first_time) {
	    TIME_STOP(rstart,
		      rstop,
		      pstart,
		      pstop,
		      ld_gets(1, 1101, "Stubs_added loop:"),
		      clk_tck);
	    /* Set up values for next iteration */
	    if (verbose & V_TIMES) {
	        rstart=rstop;
	        pstart=pstop;
	    }
	}

    	count_symbols();
	count_stub_unwind_desc();
	new_subsp_dict_size = count_subspaces();
	assign_virtual_addresses();
	init_array_size = count_init_ptrs();

	if (copyram_subsp != BAD_SUBSP)
            set_copyram_size();
        if (relocatable)
            build_relocatable_fixups();

	assign_file_locations();

	/* This call to assign_virt_addr is redundant in the UX case only */
	/* Only after code to set origin is incorporated into assign file */
	/* locations will this assign_virt_addr call become useless */

	/*
	** "unpad a.out"
	** this is no longer redundant in the UX case
	** because assign_file_locations() may decide that it is a win to
	** remove the padding between the SOM header and TEXT space during
	** a -s (strip) link. In that case, the virtual addresses will all
	** change because we will have a bunch of junk (the SOM header) at
	** the start of TEXT in memory.
	*/

	assign_virtual_addresses();
	/* If total_code_size if <256K, we are guaranteed that another
	   call to long_reach_stubs_added is unnecesary */
	/* Also only need to do this once for relocatable links 
           Not valid on MPE--so leave in old code for MPE where we break
           only if relocatable*/
        /* For annotations use the simple relocatable check, because
           we need to make one pass where we don't generate stubs while we
           try to count them */
/* No longer generate PA annotations. */
#ifdef WW_ANNOTATIONS_REMOVED
        if (relocatable)
#else
	if (relocatable || (!first_time && total_code_size < 262144) ||
	    (!first_time && !bl_seen_in_aout))
#endif /* !WW_ANNOTATIONS */
	    break;

/* No longer generate PA annotations. */
#ifdef WW_ANNOTATIONS_REMOVED
	reset_annotation_buffer();
#endif /* WW_ANNOTATIONS */
    }
    until (!long_reach_stubs_added());

    TIME_STOP(rstart,
	      rstop,
	      pstart,
	      pstop,
	      ld_gets(1, 1102, "Stubs_added loop:"),
	      clk_tck);

/* No longer generate PA annotations.  * do_ww_annotations is always FALSE.  */
#ifdef WW_ANNOTATIONS_REMOVED
    if (do_ww_annotations)
      init_annotation_subsp();
#endif /* WW_ANNOTATIONS */

    /* this code used to be #ifdef LINKEDIT but we need to run fru tests on
       HP-UX so we uncomment it for the fru_list part. */
    if (first_time) {        /* count again so we get an accurate */
	count_symbols();     /* lst_sym and string count */
			     /* else we already counted again on the 2nd 
                                pass */
        fru = fru_list;      /* go through the assign routines again if we 
				nullified symbols.  */
        if (fru != NULL) 
          assign_file_locations();
    }
/* No longer generate PA annotations.  * do_ww_annotations is always FALSE.  */
#ifdef WW_ANNOTATIONS_REMOVED
     /* We need to assign our new space we just built a place in the file */
    if (do_ww_annotations) {
	assign_file_locations();
    }
#endif /* WW_ANNOTATIONS */
    
       /* We should now recompute the value of these symbols, since
        * subspaces could have grown during long_reach_stubs_added().
        * However, these must not change after this since, apply_fixups()
        * and relocate_shlib_info() will expect an invariant value.
       */
        if (!building_shlib && base_file_name == NULL) {
            /* set addr for special symbols (after last storage allocated) */
            /* Only set the address if
            ** the special symbol was added above in add_predef_syms() */
            /* or resolved in unsat_resolve_special() */
            if (special_syms_added & S_S_ETEXT)
                set_spec_sym_addr("etext", text_subsp);
            if (special_syms_added & S_S_EDATA)
                set_spec_sym_addr("edata", data_subsp);
            if (special_syms_added & S_S_END)
                set_spec_sym_addr("end", last_subsp);

            /*
            ** Only set the address of these symbols if the 
            ** linker created these symbols.  Otherwise, if dld ever defined
            ** these (it has to define _end for 10. now), we'd mess up
            ** the address of it here.
            */
            set_spec_sym_addr("_etext", text_subsp);
            set_spec_sym_addr("_edata", data_subsp);
            if (building_incomp_exec) {
	       set_spec_sym_addr("_end", last_subsp);
	    }
        }
} /* end relocate_subspaces */

/* Used to signify when subspaces which need to be copyram'd are seen */
/* BEFORE the actual copyram subspace is seen */
Boolean copyram_not_first = FALSE;

void assign_file_locations()
{
    int new_sp_index, sp_index;
    int next_file_loc;
    struct  space_dictionary_record *space;
    struct  space_misc_record *sp_misc;
    int copyram_needed = 0;          /* do we need to worry about copyram? */
    int text_is_first = TRUE;  /* set to false in first (all) iterations
				  of loop over spaces */

    extern int assign_aux();
    extern int assign_space();
    extern int assign_subsp();
    extern int assign_init();
    extern int assign_ldrfix();
    extern int assign_spstr();
    extern int assign_sym();
    extern int assign_fixup();
    extern int assign_symstr();
    extern int assign_compunit();

    /* Assign file locations to SOM data structures. */
    next_file_loc = sizeof(struct header);

    if (!delay_aux)      next_file_loc = assign_aux(next_file_loc);
    if (!delay_space)    next_file_loc = assign_space(next_file_loc);
    if (!delay_subsp)    next_file_loc = assign_subsp(next_file_loc);
    if (!delay_init)     next_file_loc = assign_init(next_file_loc);
    if (!delay_ldrfix)   next_file_loc = assign_ldrfix(next_file_loc);
    if (!delay_spstr)    next_file_loc = assign_spstr(next_file_loc);
    if (!delay_sym)      next_file_loc = assign_sym(next_file_loc);
    if (!delay_fixup)    next_file_loc = assign_fixup(next_file_loc);
                         next_file_loc = round(next_file_loc, WORDSIZE);
    if (!delay_symstr)   next_file_loc = assign_symstr(next_file_loc);
    if (!delay_compunit) next_file_loc = assign_compunit(next_file_loc);

    /* Assign locations to loadable subspace initialization blocks. */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	space = &space_array[sp_index];
	sp_misc = &space_misc[sp_index];

        /* Determine if ANY space will need copyram */
	if (sp_misc->copyram_needed) {
	    copyram_needed = TRUE;

	    /* ensure before we get into assign space file that subsp exists */
	    if (copyram_subsp == BAD_SUBSP)
	        external_error(CANT_FIND_COPYRAM, 0);
	}

	if (!space->is_loadable)
            continue;
	if (delay_code && !space->is_private)
            continue;

	/*
	** We want to remove the padding between the SOM header and the
	** TEXT space when it is a win. We only can do this when we are
	** building an a.out, it is a -s (strip) link, and the amount of
	** padding removed won't just be replaced with padding at the end
	** of TEXT. That last statement is important -- without that check
	** it is possible that no disk space would be saved and one extra
	** page of VM would be needed for TEXT. We also need to make sure
	** that TEXT begins on the proper alignment, so that when we adjust
	** later with unpad_after_header the exec aux header has both 
	** exec_tmem and exec_tfile page-aligned.
	**
	** Allow the unpadding for shared libraries.  This requires
	** the dl_header_offset field of the file header to find the 
	** dl_header.
	*/

	assert(space->is_loadable);                    /* guaranteed above */

	if (!space->is_private && text_is_first) {
	    /* This is TEXT space, and it follows the SOM header stuff */

	    /* Do the unpadding for an executable if it is a dash-s link
	    ** and for a shared library if do_text_unpadding is TRUE
	    */
	    if (!relocatable 
		&& (   (!building_shlib && strip_symbols && strip_debug) 
		    || (building_shlib && do_text_unpadding)) &&
		((round(next_file_loc, sp_misc->space_align) % page_size + 
		  total_TEXT_size % page_size) < page_size) &&  /* it wins */
		base_file_name == NULL) {          /* don't break FRU & -A */

	        next_file_loc = round(next_file_loc, sp_misc->space_align);
		unpad_after_header = next_file_loc % page_size;
	    } else {
	        unpad_after_header = 0;
	    }
	}

	/* whether or not text was first, it can't be now */
	text_is_first = FALSE;

	/* 
	** If requested, get rid of the padding before the $PRIVATE$ (data)
	** space.
	*/
	if (space->is_private
#ifdef TSD
            && !space->is_tspecific
#endif
           ) 
	 {
	    /* This is $PRIVATE$ space */

	    if (do_private_unpadding &&  /* building a shared library and
					 ** no incompatible options */
		((round(next_file_loc, sp_misc->space_align) % page_size + 
		  total_PRIVATE_size % page_size) < page_size) &&  /* it wins */
		base_file_name == NULL) {          /* don't break FRU & -A */

	        next_file_loc = round(next_file_loc, sp_misc->space_align);
		unpad_before_private = next_file_loc % page_size;
		data_offset = data_mmap_addr + unpad_before_private;
	    } else {
	        unpad_before_private = 0;
		data_offset = data_mmap_addr;
	    }
	} /* If this is $PRIVATE$ space */

        /* set this flag so that assign_space_file_locations will know that 
           it needs to adjust the next_file_loc due to non-page-aligned data
	   Use data_mmap_addr instead of data_offset.
        */
        if (data_mmap_addr != -1 && space->is_private) adjust_file_loc = TRUE;
        next_file_loc = assign_space_file_locations(space, sp_misc, 
							next_file_loc,FALSE);
    }

    /* pad loadable data to a page boundary */
    /* Don't need to pad out file for -r links. */
    /* ** So as not to use up a whole page for annotations, we don't do
    ** a page break after the loadable data for shared libraries
    ** if do_unloadable_unpadding is TRUE.
    */
    if (!relocatable && !do_unloadable_unpadding) {
        next_file_loc = round(next_file_loc, page_size);
    }

    /* Assign locations to delayed subspace initialization blocks. */
    if (delay_code) {
        for (new_sp_index = 0;
        	 new_sp_index < cur_space_total;
		 new_sp_index++) {
    	    sp_index = sp_remap[new_sp_index];
	    space = &space_array[sp_index];
	    if (!space->is_loadable)
                continue;
	    if (space->is_private)
                continue;

	    sp_misc = &space_misc[sp_index];

            next_file_loc = assign_space_file_locations(space, sp_misc, 
							 next_file_loc,FALSE);
	}
    }

    /* Don't need to pad out file for -r links. */
    /* ** So as not to use up a whole page for annotations, we don't do
    ** a page break after the loadable data for shared libraries
    ** if do_unloadable_unpadding is TRUE.
    */
    if (!relocatable && !do_unloadable_unpadding)
        next_file_loc = round(next_file_loc, page_size);

    /* Assign locations to delayed SOM data structures */
    if (delay_aux)      next_file_loc = assign_aux(next_file_loc);
    if (delay_space)    next_file_loc = assign_space(next_file_loc);
    if (delay_subsp)    next_file_loc = assign_subsp(next_file_loc);
    if (delay_init)     next_file_loc = assign_init(next_file_loc);
    if (delay_ldrfix)   next_file_loc = assign_ldrfix(next_file_loc);
    if (delay_spstr)    next_file_loc = assign_spstr(next_file_loc);
    if (delay_sym)      next_file_loc = assign_sym(next_file_loc);
    if (delay_fixup)    next_file_loc = assign_fixup(next_file_loc);
                        next_file_loc = round(next_file_loc, WORDSIZE);
    if (delay_symstr)   next_file_loc = assign_symstr(next_file_loc);
    if (delay_compunit) next_file_loc = assign_compunit(next_file_loc);

/* No longer generate PA annotations.  */
#ifdef WW_ANNOTATIONS_REMOVED
    if (strip_debug && !copyram_needed && annot_subsp_index == BAD_SUBSP) {
#else /* WW_ANNOTATIONS */
    if (strip_debug && !copyram_needed) {
#endif /* WW_ANNOTATIONS */
	new_som_header.unloadable_sp_size = 0;
	new_som_header.som_length = next_file_loc;
	return;
    }

    /* Assign locations to unloadable subspace initialization blocks. */
    new_som_header.unloadable_sp_location = next_file_loc;
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	space = &space_array[sp_index];
	if (space->is_loadable)
            continue;

        sp_misc = &space_misc[sp_index];
#ifdef WW_ANNOTATIONS_REMOVED
	/* If stripping, and we are not on the annotations space,
	   skip this space.  Also, if copyram_needed, don't skip any spaces. */

        /* strip_debug has precedence over doom stripping */
        if (!strip_debug) {
	   /* doom support */
           if (lm_should_skip_space(sp_index) && !copyram_needed)
	      continue;
        } else
           if (strip_debug && !copyram_needed &&
               strcmp(space->name.n_name,"$ANS$"))
	       continue;
#endif /* WW_ANNOTATIONS */

        next_file_loc = assign_space_file_locations(space, sp_misc, 
							next_file_loc,FALSE);
    }

    new_som_header.unloadable_sp_size = next_file_loc -
                                        new_som_header.unloadable_sp_location;
    new_som_header.som_length = next_file_loc;

    /* if the copyram subspace does not live before the subspaces which */
    /* need to go in it, then the space file locations up to the copyram */
    /* subspace are 0 based (since the address of the copyram subspace is */
    /* not known till we assign it!). Because of this a final pass over the */
    /* spaces are made and only copyram'd subspaces are assigned new */
    /* addresses which are relative to the actual copyram subspace location */
    /* Note this will only get done if this chicken before egg problem */
    /* arises! */
    if (copyram_needed && copyram_not_first) {
        /* Assign locations to loadable subspace initialization blocks. */
        for (new_sp_index = 0; new_sp_index < cur_space_total; 
							  new_sp_index++) {
	    sp_index = sp_remap[new_sp_index];
	    space = &space_array[sp_index];
	    sp_misc = &space_misc[sp_index];
    
            /* next_file_loc is not used for copyram'd subspaces; true */
	    /* signifies quick pass up to copyram subspace */
            next_file_loc = assign_space_file_locations(space, sp_misc, 
						        next_file_loc,TRUE);
        }
    }
} /* assign_file_locations */

int assign_space_file_locations(space, sp_misc, next_file_loc, copyram_only)
struct space_dictionary_record *space;
struct space_misc_record *sp_misc;
int next_file_loc;
Boolean copyram_only;      /* Only touch copyram'd subspaces; get out early*/
{
    int old_index, subsp_index, num_subsp;
    struct  subspace_dictionary_record *prev_subsp, *subsp;
    struct  subsp_misc_record *misc;
    int i;
    int sp_index;
    int last_file_loc;        /* save next_file_loc */
    int align_size;           /* size of ram alignment */
    Boolean do_page_alignment;

    /* Save file_loc */
    if (sp_misc->copyram_needed)
	last_file_loc = next_file_loc;

    subsp_index = space->subspace_index;
    num_subsp  = space->subspace_quantity;

    /* For each of its subspaces */
    prev_subsp = NULL;
    for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
        old_index = Subsp_Misc(subsp_index).r_n_x;
        subsp = &Subsp_Dict(old_index);
        misc  = &Subsp_Misc(old_index);

	if (copyram_only) {
	    /* This is only executed if the quick copyram passed is needed*/
	    if (old_index == copyram_subsp) {
	        /* Get out - the rest of the copyram file loc's should be ok*/
	        /* since they used a valid offset to compute (see above) */
	        return(last_file_loc);
	    }

	    if (!sp_misc->copyram_needed)
		continue;       /* only look at copyram'd subspaces */
        }

        if (sp_misc->copyram_needed) {
	    /* Set flag if these are not file loc's but only offsets into */
	    /* the copyram table. The offsets are corrected at the end of */
	    /* assign_file_locations. */
	    if (Subsp_Misc(copyram_subsp).exec_file_offset == 0)
	        copyram_not_first = TRUE;

 	    next_file_loc = Subsp_Misc(copyram_subsp).exec_file_offset +
                            misc->rom_subspace_start -
               			    Subspace_Virtual_Offset(copyram_subsp);
	}

        /* If misc->stubs_file_loc is non-zero (see     */
        /* count_subspaces()), then the subspace needs  */
        /* to be initialized by the linker.             */
        /* Otherwise, if the subspace is uninitialized, */
        /* we can avoid allocating file space for it.   */

        if (subsp->initialization_length == 0 &&
	    subsp->fixup_request_quantity == 0 &&
    	    misc->stubs_file_loc == 0 &&
	    subsp->access_control_bits != 0  &&
	    misc->input_subsp_only != 2) 
            continue;

	/* doom support */
        if (!strip_debug && lm_should_skip_subspace(old_index))
            continue;

        /*
        ** If doing ld -r with dupe common symbols,
        ** do NOT output more than one subspace--only output the first
        ** one.  We will explicitly set subspace_length, symbol_count,
        ** init length, fixup_request_quantity to zero in 
        ** delete_dup_common() in subspaces.c so we can check for these
        ** conditions when determining if we can omit dumping the subspace
        ** to the output file.
        */
        if (relocatable &&
            subsp->subspace_length == 0 &&
            subsp->initialization_length == 0 &&
            subsp->dup_common &&
            subsp->fixup_request_quantity == 0 &&
            misc->symbol_count == 0) 
            continue;

	/* If this is an overlayed common block initialization, */
	/* the space in the file has already been allocated, so */
	/* we can skip this subspace.				*/
	if (misc->first_common_def != -1) {
	    misc->stubs_file_loc =
		Subsp_Misc(misc->first_common_def).stubs_file_loc;
	    misc->exec_file_offset =
		Subsp_Misc(misc->first_common_def).exec_file_offset;
	    continue;
	}

        if (old_index < fru_subsp_count) {
            /* FRU RELINK */

            /* we have an original subspace */
            /* now, there is a potential problem with stubs, in that the  */
            /* original took these into account when figuring the next    */
            /* file location, but we don't have that info any more. So    */
            /* what we do is see if the original location matches the     */
            /* alignment.  If NOT, then we must adjust the offset by the  */
            /* non-match, in order to get the main part of the subspace   */
            /* to match. We set the misc->next_stub_offset field to the   */
            /* stub-slop because align() will use this to account for the */
            /* stubs. This field is safe to use since we are dealing with */
            /* original subspaces (which do not have new stubs). The misc */
            /* next_stub_offset is reset after align call. We let align   */
            /* take care of the slop since align also takes care of the   */
            /* page alignment required by a change in access rights (we   */
            /* don't want the slop counted when align takes care of page  */
            /* alignment - so we don't add it in to next_file_loc prior to*/
            /* the align call.						  */ 

            /* note, too, that we don't have to check the subspace_length */
            /* and symbol count (good- because the latter is not set), */
            /* since this subspace made it out to the final executable */

            i = subsp->subspace_start % subsp->alignment;
            if (i != 0) {
                /* i will be the amount of slop before the "True" alignment */
                i = subsp->alignment - i;
            }
            /* align uses the next_stub_offset to account for the stubs */
            misc->next_stub_offset = i;

            next_file_loc = align(next_file_loc, prev_subsp, 
				  subsp, misc, TRUE);
            /* reset since it was just for temporary use during alignment */
            misc->next_stub_offset = 0;
        } else {
            /* 
	    ** round relocatable next_file_loc in case previous subspaces was 
            ** an odd length (this is so fixups will point to a word boundary)
            ** But ONLY do this for subspaces that won't be merged.
            */
	    if (relocatable && subsp->alignment >= 4 && prev_subsp != NULL &&
                strcmp(prev_subsp->name.n_name, subsp->name.n_name)!=0)
                next_file_loc = round(next_file_loc, WORDSIZE);

	    if (!relocatable &&
	        (subsp->subspace_length != 0 || misc->symbol_count > 0 ||
		 misc->input_subsp_only == 2)) {

                if (!sp_misc->copyram_needed) {

		    /*
		    ** The last argument means: force a page break 
		    ** before the first subspace in the space if we 
		    ** are not removing the padding between the header
		    ** and TEXT or the space is not TEXT and we would 
		    ** have put the break in before.
		    **
		    ** For $TEXT$ we need to pay attention to unpad_after_header
		    ** but for $PRIVATE$ we need to pay attention to
		    ** unpad_before_private.  For $TSPECIFIC$ we always
		    ** do the page break because it was done before.  There
		    ** may be another opportunity to squeeze out a page for
		    ** programs using threads.
		    */

		    do_page_alignment = FALSE;
		    if (!space->is_loadable) {
		       do_page_alignment = TRUE;
		    } else if (!space->is_private) {
		       /* This is $TEXT space. */
		       do_page_alignment = !unpad_after_header;
		    } else {
		       /* space->is_private is TRUE. */
#ifdef TSD /* TSD */
		       if (!space->is_tspecific) {
#endif /* TSD */
			  /* This is $PRAVATE$ space. */
			  do_page_alignment = !unpad_before_private;
#ifdef TSD /* TSD */
		       } else {
			  /* This is $TSPECIFIC$ space */
			  do_page_alignment = TRUE;
		       }
#endif /* TSD */
		    }

		    next_file_loc = align(next_file_loc,
					  prev_subsp, 
					  subsp,
					  misc, 
					  do_page_alignment);
	        }

                /*            
                ** On MPE the data_mmap_addr is not on a page boundary -- so 
		** mimic that fact in the file locations as well, so there 
		** won't be problems when an init_ptr is shared between data 
		** and bss. Here I use data offset and QUAD_1_BASE to 
		** determine the excess, rather than a check for which OS I 
		** am on (for cross-developement security).
                ** NOTE: we only want to do this for the first non-zero data 
                ** subspace.
		*/

               if (adjust_file_loc && subsp->subspace_length != 0 && 
                    !relinkable) {
                    next_file_loc += (data_mmap_addr%page_size); 
                    adjust_file_loc = FALSE;
               }  
            } /* !relocatable */
        } /* else not fru relink */

        /* Only set when stubs_file_loc is non-zero so BSS stays BSS! */
        if (misc->stubs_file_loc)
            misc->stubs_file_loc = next_file_loc;
	if (sp_misc->copyram_needed)
            misc->exec_file_offset = next_file_loc;
        else
            misc->exec_file_offset = next_file_loc +
				    misc->next_stub_offset;

        /* Eventually, we'll have to handle the case where  */
        /* a subspace is partially-initialized, and we want */
        /* to allocate space in the file only for the       */
        /* initialized portion.			            */
        /* Now, we allocate file space for the whole thing. */

        if (relocatable) {
            next_file_loc += subsp->initialization_length;
	} else if (!sp_misc->copyram_needed) {
            next_file_loc += subsp->subspace_length;
	}

        if (subsp->subspace_length != 0)
            prev_subsp = subsp;
    } /* for num subspaces */

    if (sp_misc->copyram_needed)
        return (last_file_loc);   /* return where we started from */
    else 
        return (next_file_loc);

} /* assign_space_file_locations */

int assign_aux(next_file_loc)
int next_file_loc;
{
    new_som_header.aux_header_location = next_file_loc;
    if (relocatable) {
	new_som_header.aux_header_size	= aux_area_size;
#ifdef ESOM
	if ( esom_is_parallel || opt_hdr != NULL )
		new_som_header.aux_header_size += 
			sizeof(struct cnx_option_header);
#endif /* ESOM */
    } else if (ipl)
	new_som_header.aux_header_size = aux_area_size +
			sizeof(struct ipl_aux_hdr);
#if 0
    else if (O_S == OS_HPOSF)
	new_som_header.aux_header_size = aux_area_size +
			sizeof(struct hposf_auxhdr);
#endif /* 0 */
    else if (O_S == OS_HPUX)
#ifndef ESOM
	new_som_header.aux_header_size = aux_area_size +
			sizeof(struct som_exec_auxhdr);
#else
	new_som_header.aux_header_size = aux_area_size +
			sizeof(struct som_exec_auxhdr) +
			sizeof(struct cnx_option_header);
    else if (O_S == OS_MPPOS)
	new_som_header.aux_header_size = aux_area_size +
			sizeof(struct som_exec_auxhdr) +
			sizeof(struct cnx_option_header);
#endif /* ESOM */
    else /* if (O_S == OS_HPE_NEW) */
	new_som_header.aux_header_size = aux_area_size +
			sizeof(struct mpe_som_aux_hdr);
    new_som_header.aux_header_size += sizeof(struct linker_footprint);
    if (product_key_size > 0) {
        new_som_header.aux_header_size += (sizeof(struct aux_id) +
                                           product_key_size);
    }
    return (next_file_loc + round(new_som_header.aux_header_size, DBLWORD));

} /* assign_aux */

int assign_space(next_file_loc)
int next_file_loc;
{
#if 0
    if (strip_debug)
	new_som_header.space_total = load_spaces;
    else 
#endif /* 0 */
	new_som_header.space_total = num_out_spaces;
    new_som_header.space_location  = next_file_loc;
    return (next_file_loc +
	new_som_header.space_total * sizeof(struct space_dictionary_record));
} /* assign_space */

int assign_subsp(next_file_loc)
int next_file_loc;
{
    if (strip_debug)
	new_som_header.subspace_total = load_subsp;
    else
	new_som_header.subspace_total = new_subsp_dict_size;
    new_som_header.subspace_location = next_file_loc;
    return (next_file_loc +
		new_som_header.subspace_total *
		  sizeof(struct subspace_dictionary_record));
} /* assign_subsp */

int assign_init(next_file_loc)
int next_file_loc;
{
    new_som_header.init_array_total = init_array_size;
    new_som_header.init_array_location = next_file_loc;
#ifndef ESOM
    return (next_file_loc +
	new_som_header.init_array_total * sizeof(struct init_pointer_record));
#else
    return (next_file_loc +
	new_som_header.init_array_total * CNX_INITPTRSZ);
#endif /* ESOM */
} /* assign_init */

int assign_ldrfix(next_file_loc)
int next_file_loc;
{
    /* HP-UX shared library support */
    if (building_shlib || building_incomp_exec) {
	/* the HP-UX version of loader fixups are called dynamic relocation
	   records and are handled differently - search for "dreloc" */
    	new_som_header.loader_fixup_total = 0;
    	new_som_header.loader_fixup_location = next_file_loc;
    	return (next_file_loc);
    }
    new_som_header.loader_fixup_total = loader_fixup_size;
    new_som_header.loader_fixup_location = next_file_loc;
    return (next_file_loc +
	new_som_header.loader_fixup_total * sizeof(struct loader_fixup));
} /* assign_ldrfix */

int assign_spstr(next_file_loc)
int next_file_loc;
{
    new_som_header.space_strings_size = sizeof_string_table(&space_strings);
    new_som_header.space_strings_location = next_file_loc;
    return (next_file_loc + round(new_som_header.space_strings_size, DBLWORD));
} /* assign_spstr */

/*
 ***************************************************************************
 **
 ** count_symbols()
 **
 ** On MPE, we should be counting symbols for 3 reasons:
 ** 1) to calculate the size of the LST string table 2) to count the non 
 ** LOCAL symbols in the symbol dictionary 3) to count the symbols that 
 ** will be included in the LST symbol dictionary (i.e. exports and imports).
 **
 ** In a link command, we need to count the symbols that will end up in the
 ** LST because we allocate just enough room (with padding) for the strings
 ** in the LST string area.  We cannot undercount but we don't want to 
 ** overcount and allocate too much space either.  alloc_som_space() in
 ** alloc_space.p allocates our LST string table according to our count.
 **
 ** We must not count hidden symbols.  We don't want to allocate LST string
 ** space for qualified symbols if we're doing an addxl--because we can
 ** point to the som string table for these symbols so we don't take up too
 ** much LST string space.
 **
 ***************************************************************************
*/
void count_symbols()
{
    int i, j, t, cnt, strsize, need;
    Boolean seen_before;  /* "variable constant" 0 or 1, whichever 
				means 'seen before in this search' */
    struct symbol_dictionary_record *sym;

    if (!relocatable && strip_symbols) {
	out_symbol_total = 0;
	out_symstr_size = 0;
	return;
    }

    cnt = 0;
    strsize = 0;

    if (sym_dict_size > 0) /* If no symbols, don't dereference a bad pointer */
        seen_before = !Sym_Misc(0).checked; /* inverse of value from 
                                               last search*/
    for (i = 0; i < sym_dict_size; i++) {

	/* if this entry was previously visited, don't count it again */
	if (Sym_Misc(i).checked == seen_before)
	    continue;
	/* If this symbol has extension records, but they are not following
	   this symbol, skip it WITHOUT setting the checked bit, since
	   the extension records follow another index and we will deal with
	   the symbol and the extension records then. */
	if (i+1 < sym_dict_size) { /* Don't index past the end of the array! */
	    if (Sym_Misc(i).has_ext_recs && Sym_Type(i+1) != ST_SYM_EXT)
	        continue;
	}
        /* toggle all bits for next search */
	Sym_Misc(i).checked = seen_before; 

	sym = &Sym_Dict(i);
	if (sym->symbol_type == ST_NULL || (OPTIONAL_PROC(i) && !relocatable))
	    continue;
 	if ((Sym_Dict(i).symbol_type == ST_MILLI_EXT)
                  && !Sym_Misc(i).referenced)
            continue;     /* do not count unreferenced external milli syms */

	/* 
	** remove and do not count symbols pointing into 
	** nullified comdat subspaces 
	*/

	if ((Sym_Scope(i) != SS_UNSAT) &&
	    (Sym_Subsp(i) != BAD_SUBSP) &&
	    comdat_is_nullified(Sym_Subsp(i))) {
	    comdat_nullify_symbol(i);
	    continue;
	}
	
	/*
	** remove the is_comdat bit, if set 
	*/

	if (!relocatable && Sym_Dict(i).is_comdat) {
	    Sym_Dict(i).is_comdat = 0;
	}

	if (strip_local_symbols &&
		sym->symbol_type != ST_SYM_EXT &&
		sym->symbol_type != ST_ARG_EXT &&
		sym->symbol_scope == SS_LOCAL) {
	    /* strip all extension records too! */
	    for (j = i+1; j < sym_dict_size; j++) {
		t = Sym_Dict(j).symbol_type;
		if (t != ST_SYM_EXT && t != ST_ARG_EXT)
		    break;
		/**
		*** Only set seen_before if it is an ext. record.
		***/
		Sym_Misc(j).checked = seen_before; /* toggle for next search */
	    }
	    i = j-1;
	    continue;
	}

	Sym_Out_Remap(i) = cnt++;
    	if (sym->symbol_type == ST_SYM_EXT) {
	    continue;
	}
	if (sym->symbol_type == ST_ARG_EXT)
	    continue;
    }

    out_symbol_total = cnt;  /* number of symbols in symbol dictionary */
    out_symstr_size = sizeof_string_table(&sym_strings);  /* SOM string table*/

} /* count_symbols */

int assign_sym(next_file_loc)
int next_file_loc;
{
    new_som_header.symbol_total = out_symbol_total;
    new_som_header.symbol_location  = next_file_loc;
    return (next_file_loc +
	new_som_header.symbol_total * sizeof(struct symbol_dictionary_record));
} /* assign_sym*/

int assign_fixup(next_file_loc)
int next_file_loc;
{
    new_som_header.fixup_request_location = next_file_loc;
    if (relocatable)
        new_som_header.fixup_request_total = new_fixup_size;
    else
        new_som_header.fixup_request_total = abs_fixup_total;
    return (next_file_loc + new_som_header.fixup_request_total);
} /* assign_fixup */

int assign_symstr(next_file_loc)
int next_file_loc;
{
    new_som_header.symbol_strings_size = out_symstr_size;
    new_som_header.symbol_strings_location = next_file_loc;
    return (next_file_loc +
	    round(new_som_header.symbol_strings_size, DBLWORD));
} /* assign_symstr */

int assign_compunit(next_file_loc)
int next_file_loc;
{
    if (!relocatable && strip_symbols)
	new_som_header.compiler_total = 0;
    else
	new_som_header.compiler_total = compiler_dict_total;
    new_som_header.compiler_location	    = next_file_loc;
    return (next_file_loc +
	    new_som_header.compiler_total * sizeof(struct compilation_unit));
} /* assign_compunit */

void count_stub_unwind_desc()
{
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp;
    unsigned int prev_type;
    struct  subspace_dictionary_record	    *subsp;
    struct  subsp_misc_record		    *misc;
    struct  stub_record			    *stub;
    int    stub_desc_cnt;

	/*  New 10.0 functionality, "-Fw". */
    if (suppress_unwind)
	return;

    stub_desc_cnt = 0;
    if (relocatable || no_stub_unwind)
	return;

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	if (space_array[sp_index].is_loadable) {
	    /* for all subspaces */
	    subsp_index = space_array[sp_index].subspace_index;
	    num_subsp  = space_array[sp_index].subspace_quantity;
	    for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
		prev_type = 0;
		old_index = Subsp_Misc(subsp_index).r_n_x;
		subsp = &Subsp_Dict(old_index);
		misc  = &Subsp_Misc(old_index);
	        /* for all stubs */
		for (stub = misc->stub_list;
                     stub != NULL;
                     stub = stub->next_stub) {
		    if (stub->type == LOCAL_RELOC_STUB ||
    			stub->type == EXPORT_RELOC_STUB ||
		        stub->type != prev_type) {
 		        prev_type = stub->type;
 		        stub_desc_cnt++;
		    }
		} /* for stubs */
	    } /* for num subsp */
	} /* space is loadable */
    } /* for spaces */

    /* set subspace_length and initialization_length */
    /* for unwind_end_subsp */
    if (unwind_end_subsp == BAD_SUBSP)
	external_error(CANT_FIND_UNWIND_END, 0);
    subsp = &Subsp_Dict(unwind_end_subsp);

    stub_desc_cnt += fru_stub_unwind_count;

    subsp->subspace_length = stub_desc_cnt * sizeof(struct stub_desc);
    if (verbose & V_DEBUG) {
	printf(ld_gets(1, 1108, "stubs_desc_cnt=%d\n"), stub_desc_cnt);
	printf(ld_gets(1, 1109, "unwind_end_subsp_len = 0x%0x \n"),
			subsp->subspace_length);
    }
} /* end count_unwind_stub_desc */
 
void set_copyram_size()
{
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp;
    struct  subspace_dictionary_record	    *subsp;
    register struct  subsp_misc_record		    *misc;
    register int copyram_subsp_size;
    register unsigned int copyram_subsp_start;

    /* 
    ** set the size of copyram based on the size of the initialized data 
    ** regions as well as any alignments they need, and the size of the 
    ** copyram table 
    ** get the size of the copyram table 
    ** copyram_subsp_size = Subsp_Dict(copyram_subsp).subspace_length; 
    */
    copyram_subsp_size = copyram_count * sizeof(union copyram_desc);
    copyram_subsp_start = Subspace_Virtual_Offset(copyram_subsp);

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];

        /* Only for a copyram space...*/
        if (space_misc[sp_index].copyram_needed) {

	    /* for all subspaces */
	    subsp_index = space_array[sp_index].subspace_index;
	    num_subsp  = space_array[sp_index].subspace_quantity;
	    for ( ; num_subsp > 0; num_subsp--, subsp_index++) {

	        old_index = Subsp_Misc(subsp_index).r_n_x;
	        subsp = &Subsp_Dict(old_index);
	        misc  = &Subsp_Misc(old_index);

                /* Update where in copyram subspace this subspaces initdata */
		/* will be placed - just after everything that is there */
	        misc->rom_subspace_start = copyram_subsp_start +
							 copyram_subsp_size;

                /* don't add in bss like subspaces (or alignments) */
		if (subsp->initialization_length == 0 &&
		                  misc->stubs_file_loc == 0)
		    continue;

	        /* Add in subspace's initialized data size (include aligns) */
	        copyram_subsp_size += misc->rom_subsp_length +
				      misc->rom_subsp_adjustment;
    	    } /* for subspaces */
        } /* copyram_needed */
    } /* for spaces */

    /* set subspace_length and initialization_length */
    /* for copyram subsp */

    subsp = &Subsp_Dict(copyram_subsp);
    subsp->subspace_length = copyram_subsp_size;

    if (verbose & V_DEBUG) {
	printf(ld_gets(1, 1110, "copyram_subsp_len = 0x%0x \n"),
			subsp->subspace_length);
    }
} /* end set_copyram_size */

#if PRE_EMBED
void assign_virtual_addresses()
    {
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp;
    unsigned int origin;
    struct  subspace_dictionary_record	    *prev_subsp = NULL, *subsp;
    struct  subsp_misc_record		    *misc;
    Boolean sharable_space;
    static Boolean seen_TEXT = FALSE;

    /* For each space */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	sharable_space = FALSE;

	/* Compute space origin. */
	if (space_array[sp_index].is_loadable &&
		    !space_array[sp_index].is_private) {
	    sharable_space = TRUE;
	    origin = code_offset;
	    seen_TEXT = TRUE;
	    }
	else if (space_array[sp_index].is_loadable &&
		     space_array[sp_index].is_private) {
	    if (data_mmap_addr == -1) {
		/* -N flag -- set data following TEXT */
		origin = round(origin, page_size);
		if (!seen_TEXT)
		    external_error(BAD_SPC_ORDER_FOR_M, 0);
		}
	    else
                origin = data_offset;
	    new_som_header.presumed_dp = origin;
	    }
	else
	    origin = 0;

	subsp_index = space_array[sp_index].subspace_index;
	num_subsp  = space_array[sp_index].subspace_quantity;

	/* For each of its subspaces */
	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
	    subsp = &Subsp_Dict(old_index);
	    misc = &Subsp_Misc(old_index);

	    /* If this is an overlayed common block initialization, */
	    /* we should assign the same virtual address as the	    */
	    /* original subspace.				    */
	    if (misc->first_common_def != -1) {
		misc->new_subspace_start =
		    Subsp_Misc(misc->first_common_def).new_subspace_start;
		continue;
		}

	    if (subsp->subspace_length != 0 || misc->symbol_count > 0) {
	        if (mapped && !relocatable && sharable_space)
	            origin = code_offset + misc->stubs_file_loc;
	        else if (origin != new_som_header.presumed_dp)
	            /* on MPE XL, dp starts 8 bytes into the page */
	            origin = align(origin, prev_subsp, subsp, misc, TRUE);
		}

	    if (old_index < dynamic_load_subsp_count)
                /* so that original symbols in dynamic loading have */
                /* their old values...  */
		subsp->subspace_start = origin;

	    misc->new_subspace_start = origin;
	    origin += subsp->subspace_length;
	    if (subsp->subspace_length != 0)
		prev_subsp = subsp;
	    }
	}
    }
#endif /* PRE_EMBED */

static Boolean check_for_access_change = TRUE;

void assign_virtual_addresses()
{
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp, origin;
    struct  subspace_dictionary_record	    *prev_subsp = NULL, *subsp;
    struct  subsp_misc_record		    *prev_misc = NULL, *misc;
    Boolean sharable_space;
    Boolean using_existing_origin;
    static Boolean seen_TEXT = FALSE;
    unsigned int new_origin;  
    unsigned int next_unreserved_address();
#ifdef ESOM
    Boolean is_TEXT;
    unsigned int last_text_address = 0;
#endif /* ESOM */

    Boolean do_page_alignment;
    struct  space_dictionary_record *space;

    /* Initialize */
    origin = 0;
    check_for_access_change = FALSE;
    total_code_size = 0;	/* Reset */

    /* For each space */
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];
	space = &space_array[sp_index];
	sharable_space = FALSE;
        using_existing_origin = FALSE;
#ifdef ESOM
	is_TEXT = FALSE;
#endif

	/* Compute space origin. */
	if (space_array[sp_index].is_loadable &&
		    !space_array[sp_index].is_private) {
	    sharable_space = TRUE;
#ifdef ESOM
	    is_TEXT = TRUE;
#endif

            /* has code_mmap_addr been set yet? */
	    if (code_mmap_addr == UNSET_OFFSET) {
		code_mmap_addr = origin;
		code_offset = code_mmap_addr;
	        using_existing_origin = TRUE;
	    } else if (space_misc[sp_index].start_addr_specified) {
	        /*
		** If we remove the padding between the SOM header and TEXT,
		** we need to take into account that there will be some junk,
		** namely the SOM header, at the start of TEXT in memory. We
		** need to relocate everything to skip over this.
		*/
	        origin = space_misc[sp_index].start_virt_addr +
		         unpad_after_header;
	    } else
 	        /* else let this space follow the last - use previous origin */
		using_existing_origin = TRUE;

	    /* maybe we should have a default align?! */
	    seen_TEXT = TRUE;
	} else if (space_array[sp_index].is_loadable &&
#ifdef TSD /* TSD*/
		   /*  Don't include $TSPECIFIC$ here. */
		   !space_array[sp_index].is_tspecific &&
#endif /* TSD */
		   space_array[sp_index].is_private) {

	    /* if -N, OSF, or specified in cmd file without an address */
	    if (data_on_page_after_text || data_mmap_addr == UNSET_OFFSET) {
		if (data_on_page_after_text) {
		    /* set data on next page following TEXT */

		    origin = round(origin, page_size); 
		    if (!seen_TEXT)
		        external_error(BAD_SPC_ORDER_FOR_M, 0);
		}

#ifndef ESOM
		data_offset = origin;
		data_mmap_addr = data_offset & ~(page_size -1);
	        using_existing_origin = TRUE;
#else
		if ( origin == 0 && last_text_address != 0 ) {
		    data_offset = round(last_text_address, page_size);
		    origin = data_offset;
		    using_existing_origin = FALSE;
		}
		else {
		    data_offset = origin;
	            using_existing_origin = TRUE;
		}
#endif /* ESOM */
	    } else {
	        if (space_misc[sp_index].start_addr_specified)  {
		    /*
		    ** Like $TEXT$ above, if we remove the padding before
		    ** $PRIVATE$, we need to adjust the addresses to account
		    ** for the stuff before it on the first page.  We 
		    ** need to relocate everything to skip over this.
		    */
	            origin =   space_misc[sp_index].start_virt_addr 
			     + unpad_before_private;
                } else {         /* else let origin be whatever it was */
	   	    using_existing_origin = TRUE;
		}
     	    }

	    new_som_header.presumed_dp = origin;

        } else {   /* unloadable space or $TSPECIFIC$ space */
	    if (space_misc[sp_index].embed_unloadable) {
		/* embed sys unloadable space */
	        if (space_misc[sp_index].start_addr_specified) 
	            origin = space_misc[sp_index].start_virt_addr;
		else        /* else let origin be whatever it was */
	            using_existing_origin = TRUE;
    	    } else  /* 
		    ** normal unloadable space (like debug) 
		    ** Could be loadable space, $TSPECIFIC$
		    */
		    origin = 0;
	}

        origin = round(origin, space_misc[sp_index].space_align);

        /* if no address was specified use next unreserved address */
	if (using_existing_origin) {
            origin = round(next_unreserved_address(origin), 
					    space_misc[sp_index].space_align);
	}
        /* If user didn't specify AT qualifier with COPYRAM */
        if (space_misc[sp_index].copyram_needed &&
            !space_misc[sp_index].start_addr_specified)
              space_misc[sp_index].ram_location=origin;

	subsp_index = space_array[sp_index].subspace_index;
	num_subsp  = space_array[sp_index].subspace_quantity;

	/* For each of its subspaces */
	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
	    subsp = &Subsp_Dict(old_index);
	    misc = &Subsp_Misc(old_index);

	    /* If this is an overlayed common block initialization, */
	    /* we should assign the same virtual address as the	    */
	    /* original subspace.				    */
	    if (misc->first_common_def != -1) {
		misc->new_subspace_start =
		    Subsp_Misc(misc->first_common_def).new_subspace_start;
		continue;
	    }

            /* 2 is output subspace */
	    if (subsp->subspace_length != 0 || misc->symbol_count > 0 ||
		  misc->input_subsp_only == 2) {  
	        if (mapped && !relocatable && sharable_space)
	            origin = code_offset + misc->stubs_file_loc;
	        else if (origin != new_som_header.presumed_dp) {

	            /* on MPE XL, dp starts 8 bytes into the page */
		    /* For shared global data, need to change if origin
                       test since we will have a DP-negative area */
	            /*  origin = align(origin, prev_subsp, subsp, misc);*/

		    if (old_index < fru_subsp_count && 
                       ((old_index < unwind_subsp) ||
                        (space_array[sp_index].space_number != 0))){
                        new_origin = subsp->subspace_start;
	            } else {
		        /*
		        ** The last argument means: force a page break 
			** before the first subspace in the space if we 
			** are not removing the padding between the header
			** and TEXT or the space is not TEXT and we would 
			** have put the break in before.
			**
			** For making a page alignment for $TEXT$ we pay
			** attention to unpad_after_header.  For making
			** a page alignment for $PRIVATE$ we pay attention 
			** to unpad_before_private.
		        */

			do_page_alignment = FALSE;
			if (!space->is_loadable) {
			   do_page_alignment = TRUE;
			} else if (!space->is_private) {
			   /* This is $TEXT space. */
			   do_page_alignment = !unpad_after_header;
			} else {
			   /* space->is_private is TRUE. */
#ifdef TSD /* TSD */
			   if (!space_array[sp_index].is_tspecific) {
#endif /* TSD */
			      /* This is $PRAVATE$ space. */
			      do_page_alignment = !unpad_before_private;
#ifdef TSD /* TSD */
			   } else {
			      /* This is $TSPECIFIC$ space */
			      do_page_alignment = TRUE;
			   }
#endif /* TSD */
			}
		        new_origin = align(origin,
					   prev_subsp,
					   subsp,
					   misc,
					   do_page_alignment);
		    }

	            if (space_misc[sp_index].copyram_needed) {
		         /* save off align size used in ram */
		         misc->rom_subsp_adjustment = new_origin - origin;
		    }

		    origin = new_origin;  /* this is aligned origin! */
		}
	    }
	    /* Count the total size of spaces that contain any BL's */
	    if (space_misc[sp_index].bl_seen) {
	        total_code_size += subsp->subspace_length;
	    }
	      
	    if (old_index < dynamic_load_subsp_count)
                /* so that original symbols in dynamic loading have */
                /* their old values...  */
		subsp->subspace_start = origin;

	    /* set ram (normal) subspace start */
	    misc->new_subspace_start = origin;
	    origin += subsp->subspace_length;
#ifdef ESOM
	    if ( is_TEXT )
		last_text_address = origin;
#endif /* ESOM */

	    if (subsp->subspace_length != 0) {
		prev_subsp = subsp;
		prev_misc = misc;
	    }
	}
    }
    check_for_access_change = TRUE;
} /* end assign_virtual_addresses */

int align(next_off, prev, cur, misc, force_page_for_first)
int    next_off;
struct	subspace_dictionary_record	*prev, *cur;
struct	subsp_misc_record *misc;
Boolean force_page_for_first; /* force a page break before the first 
				 subspace (i.e. when prev == NULL) ? */
{
	int prev_acb, cur_acb;
	int prev_sp, cur_sp;

        /* if access rights change, force a new page */
	/* Note that a wildcard will match any access and no page is forced */
	/* If subspace has no length do NOT do page_align, only align */
	/* needed on subspace */

        if (cur->is_loadable && 
	    (cur->subspace_length != 0 || adjust_file_loc ||
	     (prev==NULL && force_page_for_first))) {

	   /* check_for_access_change)  */
	    prev_acb = (prev == NULL) ? -1 : prev->access_control_bits;
	    cur_acb = cur->access_control_bits;

	    /*
	    ** If we don't want a page break before the first subspace
	    ** in the space, we can hack this by setting the access
	    ** control bits of the previous (non-existent) subspacce
	    ** to WILDCARD (0) instead of -1. This will force the
	    ** condition in the if statement below to be false.
	    */

	    if (prev == NULL && !force_page_for_first)
	        prev_acb = WILDCARD_ACCESS;

	    /* check for same space */
	    prev_sp = (prev == NULL) ? -1 : prev->space_index;
	    cur_sp = (prev == NULL) ? -1 : cur->space_index;

	    if (prev_acb != cur_acb  &&
	         prev_acb != WILDCARD_ACCESS && 
	         cur_acb != WILDCARD_ACCESS &&
		 (prev_sp == cur_sp || adjust_file_loc) /* &&
		 !space_misc[cur->space_index].start_addr_specified*/ ) {

	        next_off = round(next_off, page_size);
	    }
    }

    /* align to next requested boundary, taking stubs into account */
    next_off = round(next_off+misc->next_stub_offset, cur->alignment) -
    		misc->next_stub_offset;
    return (next_off);
} /* end align */

int count_subspaces()
{
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp, new_num_subsp;
    struct  subspace_dictionary_record	    *prev_subsp, *subsp;
    struct  subsp_misc_record	    *prev_misc, *misc;
    struct  space_dictionary_record *space;
    extern int count_abs_fixups();
    Boolean last_was_uninit;
    int space_length;

    abs_fixup_total = 0;

    if (verbose & V_DEBUG)
        printf(ld_gets(1, 1111, "count_subspaces:\n"));

    /* For each space */
    new_num_subsp = 0;
    num_out_spaces = 0;
    load_subsp = 0;
    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];

	space = &space_array[sp_index];
	subsp_index = space_array[sp_index].subspace_index;
	num_subsp  = space_array[sp_index].subspace_quantity;

	space_length = 0;

#ifdef TSD /* TSD */
        if (space->is_tspecific) {
           /* 
           */
           if (base_file_name == NULL && tbss_size == 0 && !relocatable) {
              continue;
	   } else {
              space_length = tbss_size;
	   }
	}
#endif /* TSD */

	/* doom support */
        if (!strip_debug && lm_should_skip_space(sp_index))
           continue;
        else
#ifdef WW_ANNOTATIONS_REMOVED
	if ((strip_debug && !space->is_loadable &&
	    strcmp(space->name.n_name,"$ANS$")) ||
#else /* WW_ANNOTATIONS */
	if ((strip_debug && !space->is_loadable) ||
#endif /* WW_ANNOTATIONS */
	     ((space_array[sp_index].subspace_quantity == 0) &&
	      (space_array[sp_index].loader_fix_quantity == 0) &&
	      (space_array[sp_index].init_pointer_quantity == 0)))
	    /* don't count subspaces (or fixups) for a space we are removing */
	    continue; 

        /* Count output spaces as well */
	num_out_spaces++;

	/* For each of its subspaces */
        last_was_uninit = FALSE;
	prev_subsp = NULL;
	prev_misc = NULL;

	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
	    subsp = &Subsp_Dict(old_index);
	    misc = &Subsp_Misc(old_index);
            /*
	    **  Do not count deleted comdat subspaces
	    **
            ** If doing ld -r with dupe common symbols,
            ** do NOT output more than one subspace--only output the first
            ** one.  We will explicitly set subspace_length, symbol_count,
            ** init length, fixup_request_quantity to zero in 
            ** delete_dup_common() in subspaces.c so we can check for these
            ** conditions when determining if we can omit dumping the subspace
            ** to the output file.
            **
            ** If the delete_subspace bit is set, we don't want to output
            ** the subspace--so we shouldn't count it!
            */

            if (misc->delete_subspace ||
		(subsp->is_comdat && misc->comdat_nulled) ||
	       /* doom support */ 
               (!strip_debug && lm_should_skip_subspace(old_index)) ||
               (relocatable &&
                subsp->subspace_length == 0 &&
                subsp->initialization_length == 0 &&
                subsp->dup_common &&
                subsp->fixup_request_quantity == 0 &&
                misc->symbol_count == 0))
                 continue;

#ifdef TSD /* TSD */
	    /*
            ** Overload code_only bit for $TBSS$ 
            ** since it will never have code symbols.  We check this bit if 
            ** we do a regular link later on a -r'd object file to set the tls
            ** addresses correctly.  
            */
	    if (subsp->is_tspecific && relocatable) {
	        subsp->code_only = 1;
	    } else if (!subsp->is_tspecific) 
#endif /* TSD */
	    space_length += subsp->subspace_length;

	    /* If this is an overlayed common block initialization, */
	    /* we can skip this subspace.			    */
	    if (misc->first_common_def != -1)
		continue;

	    if (subsp->initialization_length == 0 &&
		subsp->fixup_request_quantity == 0) {
	
	        /* Determine if this subspace is uninitialized */
	        /* but needs to be initialized by the linker.  */
	        /* If so, we set misc->stubs_file_loc to an    */
	        /* arbitrary non-zero value; assign_file_loc() */
	        /* will later assign the correct value.        */

	        if (!relocatable) {
	            /* 
		    ** We can avoid allocating file space when the    
	            ** subspace isn't initialized only if:	      
	            ** (1) We're on HPUX and in BSS; or               
 		    ** (2) We're on HPUX and in TBSS;
                    ** Temporarily modified so that we must be in BSS 
		    ** Also true for TBSS
		    */
#if 0

	            if ((O_S == OS_HPUX && subsp->sort_key >= 80) ||
			     (O_S != OS_HPUX && space->is_private) ||
			     (O_S != OS_HPUX && !mapped))
		    /* Changed so we check if this is a subsp which uses the */
		    /* name $BSS$. The check is done by pointer comparison   */
		    /* find_subspace ensures they will be the same           */
		    if (space->is_private &&
                        subsp->sort_key >= 80 &&
                        old_index >= fru_subsp_count)
		
		    if ((subsp->NAME_PT == Subsp_Dict(bss_subsp).NAME_PT) &&
			 old_index >= fru_subsp_count)
#endif /* 0 */

#ifdef TSD /* TSD */
		    if (space->is_tspecific) {
		        misc->stubs_file_loc = 0;
                        last_was_uninit = TRUE;
		    } else 
#endif /* TSD */			
                    /* if BSS subsp */
                    if (space->is_private &&
#if 0
			/* "subspace_length" is unsigned; it's ** ALWAYS >= 0!! */
		        (subsp->subspace_length >= 0 && 
#endif /* 0 */
                         (subsp->sort_key >= 80       &&
		         old_index >= fru_subsp_count)  ||
 
		        /* suppress BSS expansion in embedded-systems cases */
		        ((subsp->subspace_length > 0) &&
		           space_misc[sp_index].copyram_needed &&
                           old_index != unwind_subsp &&
                           old_index != unwind_end_subsp &&
                           old_index != recover_subsp &&
                           old_index != copyram_subsp &&
		           old_index >= fru_subsp_count &&
                           old_index != recover_end_subsp) ||

#if 0 /* 0 */
                          (!space->is_private &&
		          (subsp->subspace_length == 0) && 
		          (old_index >= fru_subsp_count)) ||
#endif /* 0 */
		         
			 ((subsp->subspace_length == 0) && 
		          last_was_uninit && 
		          (old_index >= fru_subsp_count))) {

			misc->stubs_file_loc = 0;
                        last_was_uninit = TRUE;
                    } else {
		        misc->stubs_file_loc = 1;
                        last_was_uninit = FALSE;
                    }
  	        } /* !relocatable */
 	    } else { /* length = 0 */
		/* subspace either has non-zero init length or has    */
		/* fixups, either way it must be written to the file  */
	        misc->stubs_file_loc = 1;
	    }

            /* if FRU RELINK subspace, then we know a priori we need it */
            if (old_index < fru_subsp_count) {
                misc->abs_fixup_index = abs_fixup_total;
                /* Skip the count_abs_fixups call */
                /* instead, just count existing fixups */
	        misc->abs_fixup_count = subsp->fixup_request_quantity;
	        abs_fixup_total += misc->abs_fixup_count;
                goto NEED_NEW_SUBSPACE;
            }

            misc->abs_fixup_index = abs_fixup_total;
	    misc->abs_fixup_count = count_abs_fixups (old_index);
	    abs_fixup_total += misc->abs_fixup_count;

/* Count all $TBSS$ subspaces if tbss_size > 0; 
 * subspace_length might be zero if $TBSS$ only has TLS common (TSTORAGE). 
 * In consistent with out_subsp_records() in outputting subspaces.
 */
	    if (subsp->subspace_length == 0 &&
		    misc->symbol_count == 0 &&
		    subsp->is_loadable &&
		    !relocatable &&
#ifdef TSD
		    !(subsp->is_tspecific && tbss_size > 0) &&
#endif /* TSD */
		    (misc->input_subsp_only != 2))
		continue;

	    if (need_new_subsp(prev_subsp, subsp, prev_misc, misc)) {
               NEED_NEW_SUBSPACE:
		if (verbose & V_DEBUG)
		    dump_subsp(subsp, misc, "new");
#ifdef WW_ANNOTATIONS_REMOVED
                   if (!(strip_debug && !space_array[sp_index].is_loadable &&
                       strcmp(space_array[sp_index].name.n_name,"$ANS$"))) {
#else /* WW_ANNOTATIONS */
                   if (!(strip_debug && !space_array[sp_index].is_loadable)) {
#endif
		      load_subsp++;
                   }

		/* doom support - assign compressed subspace index here */
		misc->r_c_x = new_num_subsp++;
	    } else {
		if (verbose & V_DEBUG)
		    dump_subsp(subsp, misc, "ext");
		/* doom support - assign compressed subspace index here */
		misc->r_c_x = prev_misc->r_c_x;
	    }
	    prev_subsp = subsp;
	    prev_misc = misc;
	}
	/*
	** If this is TEXT, stash away the total size of the space.
	** This is not the same as the global total_code_size also
	** used in this file.
	*/
	if (space_array[sp_index].is_loadable &&
#ifdef TSD /* TSD */
	    !space_array[sp_index].is_tspecific &&
#endif /* TSD */
	    !space_array[sp_index].is_private)
	    total_TEXT_size = space_length;

        /* ** If this is data ($PRIVATE$ space), save the total size
	** for unpadding between $TEXT$ and $PRIVATE$
	*/

	if (space_array[sp_index].is_loadable &&
	    space_array[sp_index].is_private
#ifdef TSD /* TSD */
            && !space_array[sp_index].is_tspecific
#endif /* TSD */
	   ) {

	   total_PRIVATE_size = space_length;
	} /* If $PRIVATE$ space */
    }
    return (new_num_subsp);
} /* end count_subspaces */

/*
***************************************************************************
**
** need_new_subsp()  
**
** This routine determines if the previous and current subspaces can be
** merged.
** 
***************************************************************************
*/
#define HALF_BRANCH_DIST	(0x20000)

Boolean need_new_subsp(struct subspace_dictionary_record *prev, 
		       struct subspace_dictionary_record *cur, 
		       struct subsp_misc_record *prev_misc, 
		       struct subsp_misc_record *cur_misc)
{
    Boolean prev_has_data, cur_has_data;
    static int accum_length;

    /* always return TRUE (No merge) for */
    /* data relocatable HPUX only.       */
    if (prev == NULL || (relocatable &&
                         space_array[cur->space_index].is_private &&
                         space_array[prev->space_index].is_private)) {
	accum_length = cur->subspace_length;
        return (TRUE);
    }

    /*
    **  COMDAT subspaces should NEVER be merged in relocatable
    **              links, because we want the COMDAT behavior to stick
    **              around in the output relocatable file.
    */

    if (relocatable && (prev->is_comdat || cur->is_comdat ||
			(cur->dup_common && cur->code_only && !cur->is_common))) {
       accum_length = cur->subspace_length;
       return (TRUE);
    }

    if (cur_misc->input_subsp_only == 1) {
	accum_length += cur->subspace_length;
        return (FALSE);
    }

    if (strcmp(prev->NAME_PT, cur->NAME_PT) != 0 ||
	(prev->access_control_bits != cur->access_control_bits
	 && prev->access_control_bits != WILDCARD_ACCESS
	 && cur->access_control_bits != WILDCARD_ACCESS) ||
	 prev->memory_resident != cur->memory_resident 
	 || prev->initially_frozen != cur->initially_frozen) {
	accum_length = cur->subspace_length;
	return (TRUE);
    }
    prev_has_data = (prev->initialization_length != 0 ||
		     prev->fixup_request_quantity != 0 ||
		     prev_misc->stubs_file_loc > 0) ? TRUE : FALSE;
    cur_has_data = (cur->initialization_length != 0 ||
		    cur->fixup_request_quantity != 0 ||
		    cur_misc->stubs_file_loc > 0) ? TRUE : FALSE;
    if (prev_has_data != cur_has_data) {
	accum_length = cur->subspace_length;
	return (TRUE);
    }

    if (relocatable) {
	if (cur->alignment > prev->alignment ||
	    (prev->subspace_length % cur->alignment) != 0) {
	    accum_length = cur->subspace_length;
	    return (TRUE);
	}
	/* 
	** do not merge COMMON blocks, as the first one may be expanded by a 
	** storage request later, requiring all later syms to be moved down. 
	**
	** Initialized common items cannot have the subspaces merged under
	** any conditions. Added check for current subspace also.
	*/
	if (prev->is_common || cur->is_common) {
	    accum_length = cur->subspace_length;
	    return (TRUE);
	}
    }

    if (cur->is_loadable && !space_array[cur->space_index].is_private && 
	(relocatable   /* don't limit the size of non-code subspaces */
	|| building_shlib || building_incomp_exec)) {
 	/* stubs for plabels built very late, could overflow */

	if ((accum_length + cur->subspace_length >= HALF_BRANCH_DIST)
            /*
            ** don't merge subsp if -r on ISOMs (or even on SOMs if -P is on),
            ** so procedures can be
            ** positioned during final a.out link (regardless of size)
            */
            || (relocatable && (do_fdp_position || ld_after_be_process))) {
	    /* 
	    ** don't let subspaces expand beyond half the distance a short
	    ** branch to a stub can reach - used to be 250000, failed when
	    ** many shlib stubs were built after a -r link -  
	    */
	    accum_length = cur->subspace_length;
	    return (TRUE);
	}
    }

    accum_length += cur->subspace_length;
    return (FALSE);
} /* end need_new_subsp */

int abs_fixup_count;

int count_abs_fixups(subsp_index)
int subsp_index;
{
    struct subsp_misc_record *misc;
    struct stub_record *stub;
    extern Fixup *check_for_abs_fixup();

    if (relocatable || strip_fixups)
	return (0);

    misc = &Subsp_Misc(subsp_index);

    abs_fixup_count = 0;

    /* loop through fixup requests in stubs */
    for (stub = misc->stub_list; stub != NULL; stub = stub->next_stub) {
	if (stub->type == LONG_BRANCH_STUB ||
            stub->type == INTERQUAD_IMPORT_STUB ||
	    stub->type == MILLILONG_BRANCH_STUB) {
            /* two five byte fixups for stubs */
	    abs_fixup_count += 10;
	}
    }

    /* note that the number of abs fixups in non-stub code may be altered */
    /* as we change stubs. so we need to recount every time we go through */
    /* long branch checking                                               */

    traverse_fixups(subsp_index, CHECK_FOR_ABS_FIXUP);

    return (abs_fixup_count);
} /* end count_abs_fixups */

Fixup *check_for_abs_fixup(fix_info, fixup, arg0, arg1)
struct fix_desc *fix_info;
Fixup *fixup;
int arg0, arg1;
{
    switch (fix_info->type) {
	case R_RELOCATION:
	    if (branch_dot < QUAD_1_BASE + 2*WORDSIZE)
		abs_fixup_count += 5;
	    break;
	case R_DATA_ONE_SYMBOL:
	    if (mapped_symbol(arg0+sym_bias))
		abs_fixup_count += 5;
	    break;
	case R_ABS_CALL:
            /* LDIL fixups to UNSAT code symbols (such as $UNWIND_START) */
            /* are going to look like ABS_CALL fixups                    */
            arg0 = arg1;
             /* fall through to CODE_ONE_SYMBOL */
	case R_CODE_ONE_SYMBOL:
            arg0 += sym_bias;
            arg0 = Sym_Remap(arg0);
	    if (mapped_symbol(arg0))
		abs_fixup_count += 5;
	    break;
	case R_DATA_PLABEL:
	case R_CODE_PLABEL:
	    if (!extern_plabels)
		abs_fixup_count += 5;
	    break;
    }
    return (NULL);
} /* end check_for_abs_fixup */

Boolean mapped_symbol(oldindex)
int oldindex;
{
    register int index, scope, type;
    register struct symbol_dictionary_record *sym;

    index = Sym_Remap(oldindex);
    sym = &Sym_Dict(index);
    scope = sym->symbol_scope;
    type = sym->symbol_type;

    if ((type != ST_ABSOLUTE && type != ST_MILLI_EXT) &&
        (sym->symbol_value < QUAD_1_BASE || (!sharable)))
	return (TRUE);
    return (FALSE);
} /* end mapped_symbol */


/*
 * count_init_ptrs() makes a pass through the subspace dictionary
 * to determine in advance how many initialization pointers will
 * be required in the output file.  The particular algorithm here
 * uses the same two routines (need_new_init_ptr() and
 * combine_init_ptrs()) that are used in build_init_array() in
 * output.c.  The basic approach is to keep a current and a previous
 * init pointer (in init_temp[]), and for each non-empty subspace,
 * determine whether a new init pointer is needed, or whether it
 * can be included with the current init pointer (by extending the
 * range of the current one).  Because of the details of extending
 * an init pointer (see need_new_init_ptr()), it is possible that
 * after extending the current one, it can be coalesced with the
 * previous one.  The coalescing is done by combine_init_ptrs().
 */

int count_init_ptrs()
{
    int    new_sp_index, sp_index;
    int    old_index, subsp_index, num_subsp, num_init_ptrs;
    int    origin;
    struct  subspace_dictionary_record	    *subsp, *prev_subsp;
    struct  subsp_misc_record		    *misc;
#ifndef ESOM
    struct  init_pointer_record		    *init, *prev_init, *new_init;
    struct  init_pointer_record		    init_temp[2];
#else
    struct  cnx_init_pointer_record	    *init, *prev_init, *new_init;
    struct  cnx_init_pointer_record	    init_temp[2];
    int is_private = 0;
#endif
    char    *sp_name;
    int i;
    extern Boolean res_look_ahead();

    Boolean sharable_space = FALSE;
    Boolean seen_TEXT = FALSE;
    unsigned int temp_subsp_start;      /* save orig for copyram */
    unsigned int temp_subsp_len;        /* save orig for copyram */


    if (relocatable)
	return (0);

    prev_init = init = NULL;
    new_init = init_temp;
    num_init_ptrs = 0;
    prev_subsp = NULL;

    if (verbose & V_ALLDEBUG)
        printf(ld_gets(1, 1112, "count_init_ptrs:\n"));

    /* New_subspace_start field is set by assign_virtual_addresses() which */
    /* should have been called before this routine was called */

    for (new_sp_index = 0; new_sp_index < cur_space_total; new_sp_index++) {
	sp_index = sp_remap[new_sp_index];

	if (!space_array[sp_index].is_loadable || 
		   space_misc[sp_index].copyram_needed)
            continue;

	sp_name = space_array[sp_index].NAME_PT;
#ifdef ESOM
	is_private = space_array[sp_index].is_private;
#endif /* ESOM */

        sharable_space = FALSE;

        /* Compute space origin. */
        if (space_array[sp_index].is_loadable &&
                    !space_array[sp_index].is_private) {
            sharable_space = TRUE;

            if (space_misc[sp_index].start_addr_specified) {
                origin = space_misc[sp_index].start_virt_addr;
            }
            /* else let this space follow the last - use previous origin */

            /* maybe we should have a default align?! */
            seen_TEXT = TRUE;
        } else if (space_array[sp_index].is_loadable &&
#ifdef TSD /* TSD */
		   !space_array[sp_index].is_tspecific &&
#endif /* TSD */
                   space_array[sp_index].is_private) {
            if (data_mmap_addr == -1) {
                /* -N flag -- set data following TEXT */
                origin = round(origin, page_size);
                if (!seen_TEXT)
                    external_error(BAD_SPC_ORDER_FOR_M, 0);
            } else {
                if (space_misc[sp_index].start_addr_specified) {
                    origin = space_misc[sp_index].start_virt_addr;
                }
                /* else let origin be whatever it was */
            }

            /*  **** set this when space misc is set (in embed.c?) */
            ;
        } else {
	    /*
            ** unloadable spaces 
	    ** Could be loadable space, $TSPECIFIC$
	    */
            origin = 0;
        }

        origin = round(origin, space_misc[sp_index].space_align);

	/* For each of its subspaces */
	/* count the init pointers */

	subsp_index = space_array[sp_index].subspace_index;
	num_subsp  = space_array[sp_index].subspace_quantity;
	for ( ; num_subsp > 0; num_subsp--, subsp_index++) {
	    old_index = Subsp_Misc(subsp_index).r_n_x;
	    subsp = &Subsp_Dict(old_index);
	    misc = &Subsp_Misc(old_index);

	    /* ignore zero-length subspaces */
	    if (subsp->subspace_length == 0)
		continue;
#ifdef TSD /* TSD */
	    /* Ignore init pointers for TSD */
	    if (subsp->is_tspecific) {
	        continue;
	    }
#endif /* TSD */

            /*
            ** Set new subspace start depending on whether it is copyram or not
	    */
            if (space_misc[sp_index].copyram_needed) {
                temp_subsp_start = misc->new_subspace_start;
                temp_subsp_len = subsp->subspace_length;
                /* set actual rom address and length of copyram'd subspace */
                misc->new_subspace_start = misc->rom_subspace_start;
                subsp->subspace_length = misc->rom_subsp_length;
            }

	    /* ignore overlayed common initializations */
	    if (misc->first_common_def != -1)
		continue;

	    if (verbose & V_ALLDEBUG)
	       printf("%3d %-20s %02x %c%c%c %08x %08x:  ",
			      subsp_index, subsp->NAME_PT,
			      subsp->access_control_bits,
			      subsp->initialization_length? 'H':'.',
			      subsp->memory_resident? 'R':'.',
			      subsp->initially_frozen? 'F':'.',
			      misc->new_subspace_start,
			      subsp->subspace_length);

	    /* skip small non-resident subspaces when a resident */
	    /* subspace begins later on the same page */
	    if (mr_seen &&  /* faster to not try if no resident seen  */
		res_look_ahead(subsp, misc, subsp_index, num_subsp, init)) {
    		if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1113, "skip\n"));
    		init->initially_frozen |= subsp->initially_frozen;
    		init->initialization_length =
				    misc->new_subspace_start +
				    subsp->subspace_length -
				    init->space_offset;
        	continue;
 	    }

    	    /* update current init ptr and/or make new one */
#ifndef ESOM
    	    if (need_new_init_ptr(subsp, misc, init, new_init)) {
#else
    	    if (need_new_init_ptr(subsp, misc, init, new_init, is_private)) {
#endif /* ESOM */
    		if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1114, "new"));
    		num_init_ptrs++;
    		prev_init = init;
    		init = new_init;
    		if (new_init == init_temp)
    		    new_init++;
    		else
    		    new_init--;
    	    } else if (combine_init_ptrs(prev_init, init)) {
      	        /* combine with previous init ptr if possible */
    		if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1115, "com"));
	        num_init_ptrs--;
    		new_init = init;
    		init = prev_init;
    		prev_init = NULL;
            } else {
                if (verbose & V_ALLDEBUG)
                    printf(ld_gets(1, 1116, "ext"));
            }

    	    if (verbose & V_ALLDEBUG)
                printf(" %08x %08x\n",
    			    init->space_offset,
    			    init->initialization_length);

            /* reset fields so we don't mess up rest of link */
            if (space_misc[sp_index].copyram_needed) {
                misc->new_subspace_start = temp_subsp_start;
                subsp->subspace_length = temp_subsp_len;
            }
	}
    }

    if (verbose & V_ALLDEBUG)
        printf(ld_gets(1, 1117, "Total init pointers:  %d\n"), num_init_ptrs);

    return (num_init_ptrs);
} /* end count_init_ptrs */

/*
 * res_look_ahead() looks down the subspace list for a resident subspace
 * that shares a page with the current subspace.  If one is found, then
 * there is no need to consider the current subspace, since the resident
 * subspace will cause the init pointer to include the entire page.
 * This look-ahead is meaningful only when the current subspace does not
 * overlap a page boundary.
 */

Boolean res_look_ahead(subsp, misc, subsp_index, num_subsp, init)
register struct subspace_dictionary_record *subsp;
register struct subsp_misc_record *misc;
register int subsp_index, num_subsp;
#ifndef ESOM
struct init_pointer_record *init;
#else
struct cnx_init_pointer_record *init;
#endif /* ESOM */
{
    register int old_index;
    register int page_end;

    if (subsp->memory_resident)
	return (FALSE);

    if (init == NULL ||
	    init->space_index != subsp->space_index ||
	    init->access_control_bits != subsp->access_control_bits)
	return (FALSE);

    page_end = round(misc->new_subspace_start, page_size);
    if (misc->new_subspace_start + subsp->subspace_length >= page_end)
	return (FALSE);

    for (subsp_index++, num_subsp--; num_subsp > 0;
	     subsp_index++, num_subsp--) {
	old_index = Subsp_Misc(subsp_index).r_n_x;
	subsp = &Subsp_Dict(old_index);
	misc = &Subsp_Misc(old_index);
	if (subsp->subspace_length == 0)
	    continue;
	if (misc->new_subspace_start >= page_end)
	    return (FALSE);
	if (subsp->memory_resident)
	    return (TRUE);
    }

    /* no resident pages were found on the same page */
    return (FALSE);
} /* end res_look_ahead */

/*
 * need_new_init_ptr() compares the attributes of the current subspace
 * with the current initialization pointer, and either extends the
 * current init pointer (returning FALSE), or builds a new init pointer
 * in new_init (returning TRUE).  The rather severe complications in
 * this code arise from the treatment of the memory_resident and
 * initially_frozen flags -- two adjacent subspaces may have different
 * flags, but the boundary between the two subspaces is not necessarily
 * on a page boundary.  In this case, the page shared by the two subspaces
 * is included wholly within the "more important" init pointer, by adjusting
 * the lengths and addresses of the current and new init pointers.  (The
 * more important init pointer is the one that is memory_resident and/or
 * initially_frozen.)  It is also sometimes possible for a short subspace
 * that is non-resident to be absorbed entirely into a resident page, or
 * for a short resident subspace to force part or all of a non-resident
 * subspace to become resident.  Similar complications arise for adjacent
 * initialized and non-initialized subspaces.  A new init pointer is also
 * created between two non-resident subspaces that belong to different
 * locality sets.
 */

#ifndef ESOM
Boolean need_new_init_ptr(subsp, misc, init, new_init)
struct subspace_dictionary_record *subsp;
struct subsp_misc_record *misc;
struct init_pointer_record *init, *new_init;
#else
Boolean need_new_init_ptr(subsp, misc, init, new_init, is_private)
struct subspace_dictionary_record *subsp;
struct subsp_misc_record *misc;
struct cnx_init_pointer_record *init, *new_init;
int is_private;
#endif
{
    int init_start, init_end, subsp_end, init_end_r;
    int cur_has_data, prev_has_data;
    int cur_mr_if, prev_mr_if;
    Boolean access_changed;
    Boolean need_to_adjust;
    static char *prev_locality;
    extern void make_new_init();
    extern Boolean same_locality();
#ifdef ESOM
    int memory_changed;
    int memory_type;

    memory_type = get_memory_type(subsp->name.n_name, is_private);
#endif /* ESOM */

    if (init == NULL)
	prev_locality = NULL;

    /* access didn't change if Wildcards were used */
    if (init != NULL) {
       access_changed = (init->access_control_bits != 
			 subsp->access_control_bits
	       && init->access_control_bits != WILDCARD_ACCESS
	       && subsp->access_control_bits != WILDCARD_ACCESS
	       && init->space_index == subsp->space_index);

        /* If copyram, then adjusting an init ptr with bss is NOT wanted */
        need_to_adjust = (!space_misc[subsp->space_index].copyram_needed);
#ifdef ESOM
       memory_changed = (init->memory_type != memory_type);
#endif /* ESOM */
    } else {
       access_changed = FALSE;
       need_to_adjust = FALSE;
#ifdef ESOM
       memory_changed = FALSE;
#endif /* ESOM */
    }

    /* need a new init pointer if this is the first */
    /* or if space index is different */
    /* or if access rights are different */
    if (init == NULL ||
#ifdef ESOM
	memory_changed ||
#endif /* ESOM */
        init->space_index != subsp->space_index || access_changed) {
#ifndef ESOM
	make_new_init(subsp, misc, new_init, prev_locality);
#else
	make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif

        /* Only do this if access rights change and we are NOT using
	** wildcards! This implies we are doing an embedded systems link 
	** as opposed to an MPE XL link. Embedded Systems do NOT want
	** the page alignment to take place 
	*/
	if (new_init->space_offset != data_offset && access_changed &&
						   need_to_adjust) {
	    init_start = new_init->space_offset & ~(page_size-1);
	    new_init->initialization_length +=
			    new_init->space_offset - init_start;
	    if (new_init->has_data)
		new_init->file_loc_init_value -=
			    new_init->space_offset - init_start;
	    new_init->space_offset = init_start;
        }
	prev_locality = subsp->NAME_PT;
	return (TRUE);
    }

    init_end = init->space_offset + init->initialization_length;
    init_end_r = round(init_end, page_size);
    subsp_end = round(misc->new_subspace_start + subsp->subspace_length,
		      WORDSIZE);
    /*
    ** round to maintain invariant of byte lengths actually
    ** being integral words 
    **
    ** need a new init pointer if has_data status changes 
    ** adjust init pointers to page boundaries 
    */
    prev_has_data = init->has_data;
    cur_has_data = (subsp->initialization_length != 0 ||
			subsp->fixup_request_quantity != 0 ||
			misc->stubs_file_loc > 0) ? TRUE : FALSE;

    /* 
    ** if do_unloadable_unpadding is TRUE, then we need a new initialization
    ** when we cross from data to bss.
    */
    if (prev_has_data > cur_has_data &&
	    (subsp_end > init_end_r || do_unloadable_unpadding)) {
	/* data -> bss */
#ifndef ESOM
	make_new_init(subsp, misc, new_init, prev_locality);
#else
	make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif
	/* adjust init pointers if a page is partially bss */
	if ((new_init->space_offset < init_end_r) && need_to_adjust) {
	    /* for safety, if the bss is resident, make sure */
	    /* the data is too when a page is shared */
	    /* [this is overkill, but easy!] */
	    init->memory_resident |= new_init->memory_resident;
	    init->initially_frozen |= new_init->initially_frozen;
	    if (!do_unloadable_unpadding) {
		init->initialization_length += init_end_r - init_end;
		new_init->initialization_length -=
				init_end_r - new_init->space_offset;
		new_init->space_offset = init_end_r;
	    } /* adjust length if not unpadding unloadble spaces. */
	}
	prev_locality = subsp->NAME_PT;
	return (TRUE);
    }

    if (prev_has_data < cur_has_data) {
        /* bss -> data */
        if ((misc->new_subspace_start & ~(page_size-1)) > init->space_offset) {
	    /* the bss spans a page boundary */
#ifndef ESOM
	    make_new_init(subsp, misc, new_init, prev_locality);
#else
	    make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif /* ESOM */
	    /* adjust init pointers if a page is partially bss */
	    if ((new_init->space_offset < init_end_r) && need_to_adjust) {
	        /* for safety, if the bss is resident, make sure */
	        /* the data is too when a page is shared */
	        /* [this is overkill, but easy!] */
	        new_init->memory_resident |= init->memory_resident;
	        new_init->initially_frozen |= init->initially_frozen;
	        init_end_r = init_end & ~(page_size-1);
	        init->initialization_length -= init_end - init_end_r;
	        new_init->initialization_length +=
			    new_init->space_offset - init_end_r;
	        new_init->file_loc_init_value -=
			    new_init->space_offset - init_end_r;
	        new_init->space_offset = init_end_r;
	    }
	    prev_locality = subsp->NAME_PT;
	    return (TRUE);
	} else {
	    /* the bss will vanish when combined with the data */
	    /* change current bss init pointer to has_data */
	    init_end_r = init_end & ~(page_size-1);
	    init->has_data = 1;
	    init->memory_resident |= subsp->memory_resident;
	    init->initially_frozen |= subsp->initially_frozen;
	    init->initialization_length = subsp_end - init->space_offset;
	    init->file_loc_init_value = subsp->file_loc_init_value -
				(init->space_offset - init_end_r);
	    init->space_offset = init_end_r;
	    prev_locality = subsp->NAME_PT;
	    return (FALSE);
	}
    }

    /* 
    ** need a new init pointer if memory_resident bit changes (of if 
    ** (initially_frozen bit changes) and we cross a page boundary
    ** also adjust the init pointers to the appropriate page boundary
    */
    if (align_on_if_flag) {
        prev_mr_if = (init->memory_resident << 1) | init->initially_frozen;
        cur_mr_if = (subsp->memory_resident << 1) | subsp->initially_frozen;
    } else {
        prev_mr_if = init->memory_resident;
        cur_mr_if = subsp->memory_resident;
    }

    if (prev_mr_if > cur_mr_if && subsp_end > init_end_r) {
	/* resident -> non-resident */
#ifndef ESOM
	make_new_init(subsp, misc, new_init, prev_locality);
#else
	make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif /* ESOM */
	/* adjust init pointers if a page is partially resident */
	if (new_init->space_offset < init_end_r) {
	    init->initialization_length += init_end_r - init_end;
	    new_init->initialization_length -=
			    init_end_r - new_init->space_offset;
	    if (new_init->has_data)
		new_init->file_loc_init_value +=
			    init_end_r - new_init->space_offset;
	    new_init->space_offset = init_end_r;
	}
	new_init->new_locality = 1;
	prev_locality = subsp->NAME_PT;
	return (TRUE);
    }

    if (prev_mr_if < cur_mr_if &&
	(misc->new_subspace_start & ~(page_size-1)) > init->space_offset) {
	/* non-resident -> resident */
#ifndef ESOM
	make_new_init(subsp, misc, new_init, prev_locality);
#else
	make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif /* ESOM */
	/* adjust init pointers if a page is partially resident */
	if (new_init->space_offset < init_end_r) {
	    init_end_r = init_end & ~(page_size-1);
	    init->initialization_length -= init_end - init_end_r;
	    new_init->initialization_length +=
			    new_init->space_offset - init_end_r;
	    if (new_init->has_data)
		new_init->file_loc_init_value -=
			    new_init->space_offset - init_end_r;
	    new_init->space_offset = init_end_r;
	}
	prev_locality = subsp->NAME_PT;
	return (TRUE);
    }

    /* need a new init pointer if non-resident and new locality */
    /* (all other things being equal) */
    if (locality_flag &&
	    prev_has_data == cur_has_data &&
	    prev_mr_if == cur_mr_if &&
	    !subsp->memory_resident &&
	    !same_locality(prev_locality, subsp->NAME_PT)) {
#ifndef ESOM
	make_new_init(subsp, misc, new_init, prev_locality);
#else
	make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif /* ESOM */
	prev_locality = subsp->NAME_PT;
	return (TRUE);
    }

    /* if non-aligned init pointers for initially_frozen subspaces */
    /* are allowed, then check for that now */
    if (!align_on_if_flag &&
	    prev_has_data == cur_has_data &&
	    prev_mr_if == cur_mr_if &&
	    !subsp->memory_resident &&
	    init->initially_frozen != subsp->initially_frozen) {
#ifndef ESOM
	make_new_init(subsp, misc, new_init, prev_locality);
#else
	make_new_init(subsp, misc, new_init, prev_locality, memory_type);
#endif /* ESOM */
	prev_locality = subsp->NAME_PT;
	return (TRUE);
    }

    /* don't need a new init pointer -- just update current one */
    init->memory_resident |= subsp->memory_resident;
    init->initially_frozen |= subsp->initially_frozen;
    init->initialization_length = subsp_end - init->space_offset;
    prev_locality = subsp->NAME_PT;
    return (FALSE);
} /* end need_new_init_ptr */

#ifndef ESOM
void make_new_init(subsp, misc, init, prev_locality)
struct	subspace_dictionary_record	*subsp;
struct	subsp_misc_record		*misc;
struct	init_pointer_record		*init;
char	*prev_locality;
#else
void make_new_init(subsp, misc, init, prev_locality, memory_type)
struct	subspace_dictionary_record	*subsp;
struct	subsp_misc_record		*misc;
struct	cnx_init_pointer_record		*init;
char	*prev_locality;
int     memory_type;
#endif /* ESOM */
{
    extern Boolean same_locality();

    init->space_index = subsp->space_index;
    init->access_control_bits = subsp->access_control_bits;
    init->has_data = (subsp->initialization_length != 0 ||
			  subsp->fixup_request_quantity != 0 ||
			  misc->stubs_file_loc > 0) ? TRUE : FALSE;
    init->memory_resident = subsp->memory_resident;
    init->initially_frozen = subsp->initially_frozen;
    if (same_locality(prev_locality, subsp->NAME_PT))
	init->new_locality = FALSE;
    else
	init->new_locality = TRUE;
#ifndef ESOM
    init->reserved = 0;
#else
    init->memory_type = memory_type;
    init->reserved1 = 0;
    init->reserved2 = 0;
#endif /* ESOM */
    init->file_loc_init_value = (init->has_data) ?
		misc->stubs_file_loc : subsp->file_loc_init_value;
    init->initialization_length = round(subsp->subspace_length, WORDSIZE);
       /* round init length to maintain invariant of byte lengths actually
			     being integral words */
    init->space_offset = misc->new_subspace_start;
} /* end make_new_init */

Boolean combine_init_ptrs(prev_init, init)
#ifndef ESOM
struct	init_pointer_record *prev_init, *init;
#else
struct	cnx_init_pointer_record *prev_init, *init;
#endif /* ESOM */
{
    if (prev_init == NULL ||
	    prev_init->space_index != init->space_index ||
	    (prev_init->access_control_bits != init->access_control_bits 
	       && init->access_control_bits != WILDCARD_ACCESS
	       && prev_init->access_control_bits != WILDCARD_ACCESS) ||
	    prev_init->has_data != init->has_data ||
	    prev_init->memory_resident != init->memory_resident ||
	    prev_init->initially_frozen != init->initially_frozen ||
#ifdef ESOM
	    prev_init->memory_type != init->memory_type ||
#endif /* ESOM */
	    (!init->memory_resident && init->new_locality))
	return (FALSE);

    prev_init->initialization_length = init->space_offset +
		init->initialization_length - prev_init->space_offset;
    return (TRUE);
} /* combine_init_ptrs */

/*
 * To Determine whether two subspaces belong to the locality set,
 * some rather distasteful examination of the subspace names must
 * be performed.  Today's definition of "same locality" lumps all
 * of the unwind and recover tables into one locality, all data
 * and bss into one locality, and individual code and literal
 * subspaces belong to the same locality if the trailing part
 * of their names are the same (so $LIT$A$, $LIT20$A$, $CODE$A$,
 * and $CODE20$A$ are in the same locality -- "A").  The routine
 * get_locality() extracts the significant part of the locality
 * name, and a simple string compare yeilds the answer.
 */

Boolean same_locality(name1, name2)
char *name1, *name2;
{
    char *loc1, *loc2;
    extern char *get_locality();

    if (name1 == NULL)
	return (FALSE);
    loc1 = get_locality(name1);
    loc2 = get_locality(name2);
    if (strcmp(loc1, loc2) == 0)
	return (TRUE);
    return (FALSE);
} /* end same_locality */

/*****************************************************************************
** Determine if we can group things together in the same locality set.
** We now have more than just the standard $LIT$, $CODE$ etc prefixes;
**
** $junk$name$ needs to work and the locality returned should be name$,
** irregardless of the prefix if it's not one of the special case ones
** we check for below. Also added new prefixes $STATICDATA$, 
** $SHORTSTATICDATA$.
*****************************************************************************/
char *get_locality (name)
char *name;
{
    int x, name_len;

    if      (prefix("$LIT$",        name)) return (name+5);
    else if (prefix("$LIT",         name)) return (name+7);
    else if (prefix("$LITSTATIC$",  name)) return (name+11);
    else if (prefix("$LITSTATIC",   name)) return (name+13);
    else if (prefix("$CODE$",       name)) return (name+6);
    else if (prefix("$CODE",        name)) return (name+8);
    else if (prefix("$UNWIND",      name) || 
             prefix("$RECOVER",     name)) return ("$UNWIND$");
    else if (prefix("$GLOBAL$",     name) ||
             prefix("$DATA$",       name) ||
             prefix("$SHORTDATA$",  name) ||
             prefix("$PFA_COUNTER", name) ||
             prefix("$BSS$",        name) ||
             prefix("$SHORTBSS$",   name) ||
             prefix("$SHORTSTATICDATA$", name) ||
             prefix("$STATICDATA$", name)) return ("$DATA$");
    /*
    ** subspaces with strange names are assumed to be code subspaces 
    ** without the "$CODE" prefix (e.g., $REAL$, $MILLICODE$).
    ** Names with $junk$name$ will return name$ as the locality name.
    ** To support block TLB code for MPE/iX. 
    */
    else if (name[0] == '$') {
	     /* Stren() doesnot contain \0 character at the end. */
             name_len = strlen (name);             
             for (x = 1; x <= name_len; x++) 
                  if (name[x] == '$' && x != name_len)
                      return (name + x+1);
             return (name + 1);
    } else
       return (name);
} /* end get_locality */
