#include <klib.h>
#include <command.h>
#include <arch/extern.h>
#include "config.h"

#define lentitle 40

extern int crashtool_debug;
extern int verbose_set;
extern int old_fashion_flag;
extern int resave_set;
extern int chunk_max;
extern int compression_flag;

extern uint64_t def_iter_threshold;   /* used when following pointers to */
extern uint64_t iter_threshold;       /* avoid endless loops */

/* COUNT must occur once in macro, ohterwise trouble with increment etc.  */
#define CHECK_ITER_THRESHOLD(COUNT)\
( ((iter_threshold == 0) || ((int64_t) COUNT < (int64_t) iter_threshold))\
  ? 1 : 0)

#define ITER_THRESHOLD_MSG(OFP, COUNTER)\
do{\
	if(!(CHECK_ITER_THRESHOLD(COUNTER))){\
		fprintf(OFP, "\nWARNING: Iteration threshold reached. "\
			"Current threshold: %llu.\n         "\
			"Use \"-i\" to change threshold.\n", iter_threshold);\
	}\
}while(0)


#define	NEW_UTSNAME     "new_utsname"
#define BLKSZ		4096    /* maximum block size */
#define LCRASH_OPT_MAX   256    /* maximum argument size */

#ifndef FALSE
#define FALSE		   0		
#endif
#ifndef TRUE
#define TRUE		   1		
#endif

#define ADDR64(X) ((uint64_t)((kaddr_t)X))
#define INT64(X) ((int64_t)((int32_t)X))
#define UINT64(X) ((uint64_t)((uint32_t)X))

/* #define ADDR_FLG        1 */
/* #define HEX_FLG         2 */
/* #define OCTAL_FLG       3 */
/* #define SIGNED_FLG      4 */
/* #define UNSIGNED_FLG    5 */
/* #define CHAR_FLG        6 */
#define ADDR_FLG        0x01
#define HEX_FLG         0x02
#define OCTAL_FLG       0x04
#define SIGNED_FLG      0x08
#define UNSIGNED_FLG    0x10
#define CHAR_FLG        0x20

/* Function prototypes
 */
void print_banner(FILE *, char *, int);
void print_value(FILE *, char *, uint64_t, int, int);
void mm_struct_banner(FILE *, int);
void print_mm_struct(kaddr_t, void *, int, FILE *);
void page_banner(FILE *, int);
void print_page(kaddr_t, void *, int, FILE *);
void task_struct_banner(FILE *, int);
void print_task_struct(kaddr_t, void *, int, FILE *);
int  print_active_tasks(int, FILE *);
void vm_area_struct_banner(FILE *, int);
void print_vm_area_struct(kaddr_t, void *, int, FILE *);
void module_banner(FILE *, int);
void print_module(kaddr_t, void *, int, FILE *);
void print_modsyms(void *, FILE *);
void print_modrefs(void *, char *, FILE *);
int  get_module(char *, void **, kaddr_t *);
void init_liballoc(int, int, int);
int  arch_init(FILE *);
void dump_memory(kaddr_t, uint64_t, int, FILE *);
void free_temp_blocks(void);
int  get_string(char *, int);
void dump_instr(kaddr_t, uint64_t, int, FILE *);
void *free_block(void *);
int  is_temp_block(void *);
int  init_mempool(int, int, int);
void print_log_buf(FILE *);
void list_instructions(FILE *);
int  print_instr(kaddr_t, FILE *, int);
void init_sial(char *, char *);
char *get_utsname(void);
void savecrash_gentitle(char *, int);
