#  HMat-OSS (HMatrix library, open source software)
#
#  Copyright (C) 2014-2015 Airbus Group SAS
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
#  http://github.com/jeromerobert/hmat-oss

# - Config file for the HMAT package

# This configuration file used to provide HMAT_INCLUDE_DIRS
# HMAT_LIBRARY_DIRS and HMAT_LIBRARIES variables; now it
# defines an HMAT::hmat target, and CMake automatically knows
# how to use it.
#
# If you want to support both modes, you can write something like:
#
# find_package(HMAT REQUIRED)
# if(TARGET HMAT::hmat)
#     set(hmat_target "HMAT::hmat")
# else()
#     include_directories(${HMAT_INCLUDE_DIRS})
#     set(hmat_target ${HMAT_LIBRARIES})
# endif()
# target_link_libraries(mylib ${hmat_target})

# Deprecated variables, they will be removed later.
# Use dependency on target HMAT::hmat instead.
set(HMAT_INCLUDE_DIRS /usr/include)
set(HMAT_LIBRARY_DIRS /usr/lib/hppa-linux-gnu)
set(HMAT_CONFIG_FILE "${CMAKE_CURRENT_LIST_FILE}")

if(NOT TARGET HMAT::hmat)
    include("${CMAKE_CURRENT_LIST_DIR}/HMATTargets.cmake")

    if(OFF)
        add_library(HMAT::jemalloc UNKNOWN IMPORTED GLOBAL)
        set_target_properties(HMAT::jemalloc PROPERTIES
            IMPORTED_LINK_INTERFACE_LANGUAGES "C"
            INTERFACE_INCLUDE_DIRECTORIES ""
            IMPORTED_LOCATION "")
    endif()

    # Deprecated variable, it will be removed later.
    set(HMAT_LIBRARIES HMAT::hmat)
endif()
